/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticinference.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of an Elastic Inference Accelerator type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AcceleratorType implements SdkPojo, Serializable, ToCopyableBuilder<AcceleratorType.Builder, AcceleratorType> {
    private static final SdkField<String> ACCELERATOR_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("acceleratorTypeName").getter(getter(AcceleratorType::acceleratorTypeName))
            .setter(setter(Builder::acceleratorTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acceleratorTypeName").build())
            .build();

    private static final SdkField<MemoryInfo> MEMORY_INFO_FIELD = SdkField.<MemoryInfo> builder(MarshallingType.SDK_POJO)
            .memberName("memoryInfo").getter(getter(AcceleratorType::memoryInfo)).setter(setter(Builder::memoryInfo))
            .constructor(MemoryInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryInfo").build()).build();

    private static final SdkField<List<KeyValuePair>> THROUGHPUT_INFO_FIELD = SdkField
            .<List<KeyValuePair>> builder(MarshallingType.LIST)
            .memberName("throughputInfo")
            .getter(getter(AcceleratorType::throughputInfo))
            .setter(setter(Builder::throughputInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("throughputInfo").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KeyValuePair> builder(MarshallingType.SDK_POJO)
                                            .constructor(KeyValuePair::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCELERATOR_TYPE_NAME_FIELD,
            MEMORY_INFO_FIELD, THROUGHPUT_INFO_FIELD));

    private static final long serialVersionUID = 1L;

    private final String acceleratorTypeName;

    private final MemoryInfo memoryInfo;

    private final List<KeyValuePair> throughputInfo;

    private AcceleratorType(BuilderImpl builder) {
        this.acceleratorTypeName = builder.acceleratorTypeName;
        this.memoryInfo = builder.memoryInfo;
        this.throughputInfo = builder.throughputInfo;
    }

    /**
     * <p>
     * The name of the Elastic Inference Accelerator type.
     * </p>
     * 
     * @return The name of the Elastic Inference Accelerator type.
     */
    public String acceleratorTypeName() {
        return acceleratorTypeName;
    }

    /**
     * <p>
     * The memory information of the Elastic Inference Accelerator type.
     * </p>
     * 
     * @return The memory information of the Elastic Inference Accelerator type.
     */
    public MemoryInfo memoryInfo() {
        return memoryInfo;
    }

    /**
     * Returns true if the ThroughputInfo property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasThroughputInfo() {
        return throughputInfo != null && !(throughputInfo instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The throughput information of the Elastic Inference Accelerator type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasThroughputInfo()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The throughput information of the Elastic Inference Accelerator type.
     */
    public List<KeyValuePair> throughputInfo() {
        return throughputInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(acceleratorTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(memoryInfo());
        hashCode = 31 * hashCode + Objects.hashCode(hasThroughputInfo() ? throughputInfo() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceleratorType)) {
            return false;
        }
        AcceleratorType other = (AcceleratorType) obj;
        return Objects.equals(acceleratorTypeName(), other.acceleratorTypeName())
                && Objects.equals(memoryInfo(), other.memoryInfo()) && hasThroughputInfo() == other.hasThroughputInfo()
                && Objects.equals(throughputInfo(), other.throughputInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AcceleratorType").add("AcceleratorTypeName", acceleratorTypeName())
                .add("MemoryInfo", memoryInfo()).add("ThroughputInfo", hasThroughputInfo() ? throughputInfo() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "acceleratorTypeName":
            return Optional.ofNullable(clazz.cast(acceleratorTypeName()));
        case "memoryInfo":
            return Optional.ofNullable(clazz.cast(memoryInfo()));
        case "throughputInfo":
            return Optional.ofNullable(clazz.cast(throughputInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AcceleratorType, T> g) {
        return obj -> g.apply((AcceleratorType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AcceleratorType> {
        /**
         * <p>
         * The name of the Elastic Inference Accelerator type.
         * </p>
         * 
         * @param acceleratorTypeName
         *        The name of the Elastic Inference Accelerator type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorTypeName(String acceleratorTypeName);

        /**
         * <p>
         * The memory information of the Elastic Inference Accelerator type.
         * </p>
         * 
         * @param memoryInfo
         *        The memory information of the Elastic Inference Accelerator type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memoryInfo(MemoryInfo memoryInfo);

        /**
         * <p>
         * The memory information of the Elastic Inference Accelerator type.
         * </p>
         * This is a convenience that creates an instance of the {@link MemoryInfo.Builder} avoiding the need to create
         * one manually via {@link MemoryInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link MemoryInfo.Builder#build()} is called immediately and its result
         * is passed to {@link #memoryInfo(MemoryInfo)}.
         * 
         * @param memoryInfo
         *        a consumer that will call methods on {@link MemoryInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #memoryInfo(MemoryInfo)
         */
        default Builder memoryInfo(Consumer<MemoryInfo.Builder> memoryInfo) {
            return memoryInfo(MemoryInfo.builder().applyMutation(memoryInfo).build());
        }

        /**
         * <p>
         * The throughput information of the Elastic Inference Accelerator type.
         * </p>
         * 
         * @param throughputInfo
         *        The throughput information of the Elastic Inference Accelerator type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder throughputInfo(Collection<KeyValuePair> throughputInfo);

        /**
         * <p>
         * The throughput information of the Elastic Inference Accelerator type.
         * </p>
         * 
         * @param throughputInfo
         *        The throughput information of the Elastic Inference Accelerator type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder throughputInfo(KeyValuePair... throughputInfo);

        /**
         * <p>
         * The throughput information of the Elastic Inference Accelerator type.
         * </p>
         * This is a convenience that creates an instance of the {@link List<KeyValuePair>.Builder} avoiding the need to
         * create one manually via {@link List<KeyValuePair>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<KeyValuePair>.Builder#build()} is called immediately and its
         * result is passed to {@link #throughputInfo(List<KeyValuePair>)}.
         * 
         * @param throughputInfo
         *        a consumer that will call methods on {@link List<KeyValuePair>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #throughputInfo(List<KeyValuePair>)
         */
        Builder throughputInfo(Consumer<KeyValuePair.Builder>... throughputInfo);
    }

    static final class BuilderImpl implements Builder {
        private String acceleratorTypeName;

        private MemoryInfo memoryInfo;

        private List<KeyValuePair> throughputInfo = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AcceleratorType model) {
            acceleratorTypeName(model.acceleratorTypeName);
            memoryInfo(model.memoryInfo);
            throughputInfo(model.throughputInfo);
        }

        public final String getAcceleratorTypeName() {
            return acceleratorTypeName;
        }

        @Override
        public final Builder acceleratorTypeName(String acceleratorTypeName) {
            this.acceleratorTypeName = acceleratorTypeName;
            return this;
        }

        public final void setAcceleratorTypeName(String acceleratorTypeName) {
            this.acceleratorTypeName = acceleratorTypeName;
        }

        public final MemoryInfo.Builder getMemoryInfo() {
            return memoryInfo != null ? memoryInfo.toBuilder() : null;
        }

        @Override
        public final Builder memoryInfo(MemoryInfo memoryInfo) {
            this.memoryInfo = memoryInfo;
            return this;
        }

        public final void setMemoryInfo(MemoryInfo.BuilderImpl memoryInfo) {
            this.memoryInfo = memoryInfo != null ? memoryInfo.build() : null;
        }

        public final Collection<KeyValuePair.Builder> getThroughputInfo() {
            if (throughputInfo instanceof SdkAutoConstructList) {
                return null;
            }
            return throughputInfo != null ? throughputInfo.stream().map(KeyValuePair::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder throughputInfo(Collection<KeyValuePair> throughputInfo) {
            this.throughputInfo = ThroughputInfoListCopier.copy(throughputInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder throughputInfo(KeyValuePair... throughputInfo) {
            throughputInfo(Arrays.asList(throughputInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder throughputInfo(Consumer<KeyValuePair.Builder>... throughputInfo) {
            throughputInfo(Stream.of(throughputInfo).map(c -> KeyValuePair.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setThroughputInfo(Collection<KeyValuePair.BuilderImpl> throughputInfo) {
            this.throughputInfo = ThroughputInfoListCopier.copyFromBuilder(throughputInfo);
        }

        @Override
        public AcceleratorType build() {
            return new AcceleratorType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
