/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticinference.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticinference.model.ElasticInferenceAccelerator;
import software.amazon.awssdk.services.elasticinference.model.ElasticInferenceAcceleratorSetCopier;
import software.amazon.awssdk.services.elasticinference.model.ElasticInferenceResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAcceleratorsResponse
extends ElasticInferenceResponse
implements ToCopyableBuilder<Builder, DescribeAcceleratorsResponse> {
    private static final SdkField<List<ElasticInferenceAccelerator>> ACCELERATOR_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("acceleratorSet").getter(DescribeAcceleratorsResponse.getter(DescribeAcceleratorsResponse::acceleratorSet)).setter(DescribeAcceleratorsResponse.setter(Builder::acceleratorSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acceleratorSet").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ElasticInferenceAccelerator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeAcceleratorsResponse.getter(DescribeAcceleratorsResponse::nextToken)).setter(DescribeAcceleratorsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCELERATOR_SET_FIELD, NEXT_TOKEN_FIELD));
    private final List<ElasticInferenceAccelerator> acceleratorSet;
    private final String nextToken;

    private DescribeAcceleratorsResponse(BuilderImpl builder) {
        super(builder);
        this.acceleratorSet = builder.acceleratorSet;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAcceleratorSet() {
        return this.acceleratorSet != null && !(this.acceleratorSet instanceof SdkAutoConstructList);
    }

    public final List<ElasticInferenceAccelerator> acceleratorSet() {
        return this.acceleratorSet;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAcceleratorSet() ? this.acceleratorSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAcceleratorsResponse)) {
            return false;
        }
        DescribeAcceleratorsResponse other = (DescribeAcceleratorsResponse)((Object)obj);
        return this.hasAcceleratorSet() == other.hasAcceleratorSet() && Objects.equals(this.acceleratorSet(), other.acceleratorSet()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAcceleratorsResponse").add("AcceleratorSet", this.hasAcceleratorSet() ? this.acceleratorSet() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "acceleratorSet": {
                return Optional.ofNullable(clazz.cast(this.acceleratorSet()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAcceleratorsResponse, T> g) {
        return obj -> g.apply((DescribeAcceleratorsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticInferenceResponse.BuilderImpl
    implements Builder {
        private List<ElasticInferenceAccelerator> acceleratorSet = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAcceleratorsResponse model) {
            super(model);
            this.acceleratorSet(model.acceleratorSet);
            this.nextToken(model.nextToken);
        }

        public final Collection<ElasticInferenceAccelerator.Builder> getAcceleratorSet() {
            if (this.acceleratorSet instanceof SdkAutoConstructList) {
                return null;
            }
            return this.acceleratorSet != null ? (Collection)this.acceleratorSet.stream().map(ElasticInferenceAccelerator::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder acceleratorSet(Collection<ElasticInferenceAccelerator> acceleratorSet) {
            this.acceleratorSet = ElasticInferenceAcceleratorSetCopier.copy(acceleratorSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceleratorSet(ElasticInferenceAccelerator ... acceleratorSet) {
            this.acceleratorSet(Arrays.asList(acceleratorSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceleratorSet(Consumer<ElasticInferenceAccelerator.Builder> ... acceleratorSet) {
            this.acceleratorSet(Stream.of(acceleratorSet).map(c -> (ElasticInferenceAccelerator)((ElasticInferenceAccelerator.Builder)ElasticInferenceAccelerator.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAcceleratorSet(Collection<ElasticInferenceAccelerator.BuilderImpl> acceleratorSet) {
            this.acceleratorSet = ElasticInferenceAcceleratorSetCopier.copyFromBuilder(acceleratorSet);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeAcceleratorsResponse build() {
            return new DescribeAcceleratorsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticInferenceResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAcceleratorsResponse> {
        public Builder acceleratorSet(Collection<ElasticInferenceAccelerator> var1);

        public Builder acceleratorSet(ElasticInferenceAccelerator ... var1);

        public Builder acceleratorSet(Consumer<ElasticInferenceAccelerator.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

