/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticinference.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of an Elastic Inference Accelerator.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ElasticInferenceAccelerator implements SdkPojo, Serializable,
        ToCopyableBuilder<ElasticInferenceAccelerator.Builder, ElasticInferenceAccelerator> {
    private static final SdkField<ElasticInferenceAcceleratorHealth> ACCELERATOR_HEALTH_FIELD = SdkField
            .<ElasticInferenceAcceleratorHealth> builder(MarshallingType.SDK_POJO).memberName("acceleratorHealth")
            .getter(getter(ElasticInferenceAccelerator::acceleratorHealth)).setter(setter(Builder::acceleratorHealth))
            .constructor(ElasticInferenceAcceleratorHealth::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acceleratorHealth").build()).build();

    private static final SdkField<String> ACCELERATOR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("acceleratorType").getter(getter(ElasticInferenceAccelerator::acceleratorType))
            .setter(setter(Builder::acceleratorType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acceleratorType").build()).build();

    private static final SdkField<String> ACCELERATOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("acceleratorId").getter(getter(ElasticInferenceAccelerator::acceleratorId))
            .setter(setter(Builder::acceleratorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acceleratorId").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("availabilityZone").getter(getter(ElasticInferenceAccelerator::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()).build();

    private static final SdkField<String> ATTACHED_RESOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("attachedResource").getter(getter(ElasticInferenceAccelerator::attachedResource))
            .setter(setter(Builder::attachedResource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachedResource").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCELERATOR_HEALTH_FIELD,
            ACCELERATOR_TYPE_FIELD, ACCELERATOR_ID_FIELD, AVAILABILITY_ZONE_FIELD, ATTACHED_RESOURCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final ElasticInferenceAcceleratorHealth acceleratorHealth;

    private final String acceleratorType;

    private final String acceleratorId;

    private final String availabilityZone;

    private final String attachedResource;

    private ElasticInferenceAccelerator(BuilderImpl builder) {
        this.acceleratorHealth = builder.acceleratorHealth;
        this.acceleratorType = builder.acceleratorType;
        this.acceleratorId = builder.acceleratorId;
        this.availabilityZone = builder.availabilityZone;
        this.attachedResource = builder.attachedResource;
    }

    /**
     * <p>
     * The health of the Elastic Inference Accelerator.
     * </p>
     * 
     * @return The health of the Elastic Inference Accelerator.
     */
    public final ElasticInferenceAcceleratorHealth acceleratorHealth() {
        return acceleratorHealth;
    }

    /**
     * <p>
     * The type of the Elastic Inference Accelerator.
     * </p>
     * 
     * @return The type of the Elastic Inference Accelerator.
     */
    public final String acceleratorType() {
        return acceleratorType;
    }

    /**
     * <p>
     * The ID of the Elastic Inference Accelerator.
     * </p>
     * 
     * @return The ID of the Elastic Inference Accelerator.
     */
    public final String acceleratorId() {
        return acceleratorId;
    }

    /**
     * <p>
     * The availability zone where the Elastic Inference Accelerator is present.
     * </p>
     * 
     * @return The availability zone where the Elastic Inference Accelerator is present.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The ARN of the resource that the Elastic Inference Accelerator is attached to.
     * </p>
     * 
     * @return The ARN of the resource that the Elastic Inference Accelerator is attached to.
     */
    public final String attachedResource() {
        return attachedResource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(acceleratorHealth());
        hashCode = 31 * hashCode + Objects.hashCode(acceleratorType());
        hashCode = 31 * hashCode + Objects.hashCode(acceleratorId());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(attachedResource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElasticInferenceAccelerator)) {
            return false;
        }
        ElasticInferenceAccelerator other = (ElasticInferenceAccelerator) obj;
        return Objects.equals(acceleratorHealth(), other.acceleratorHealth())
                && Objects.equals(acceleratorType(), other.acceleratorType())
                && Objects.equals(acceleratorId(), other.acceleratorId())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(attachedResource(), other.attachedResource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ElasticInferenceAccelerator").add("AcceleratorHealth", acceleratorHealth())
                .add("AcceleratorType", acceleratorType()).add("AcceleratorId", acceleratorId())
                .add("AvailabilityZone", availabilityZone()).add("AttachedResource", attachedResource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "acceleratorHealth":
            return Optional.ofNullable(clazz.cast(acceleratorHealth()));
        case "acceleratorType":
            return Optional.ofNullable(clazz.cast(acceleratorType()));
        case "acceleratorId":
            return Optional.ofNullable(clazz.cast(acceleratorId()));
        case "availabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "attachedResource":
            return Optional.ofNullable(clazz.cast(attachedResource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ElasticInferenceAccelerator, T> g) {
        return obj -> g.apply((ElasticInferenceAccelerator) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ElasticInferenceAccelerator> {
        /**
         * <p>
         * The health of the Elastic Inference Accelerator.
         * </p>
         * 
         * @param acceleratorHealth
         *        The health of the Elastic Inference Accelerator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorHealth(ElasticInferenceAcceleratorHealth acceleratorHealth);

        /**
         * <p>
         * The health of the Elastic Inference Accelerator.
         * </p>
         * This is a convenience that creates an instance of the {@link ElasticInferenceAcceleratorHealth.Builder}
         * avoiding the need to create one manually via {@link ElasticInferenceAcceleratorHealth#builder()}.
         *
         * When the {@link Consumer} completes, {@link ElasticInferenceAcceleratorHealth.Builder#build()} is called
         * immediately and its result is passed to {@link #acceleratorHealth(ElasticInferenceAcceleratorHealth)}.
         * 
         * @param acceleratorHealth
         *        a consumer that will call methods on {@link ElasticInferenceAcceleratorHealth.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #acceleratorHealth(ElasticInferenceAcceleratorHealth)
         */
        default Builder acceleratorHealth(Consumer<ElasticInferenceAcceleratorHealth.Builder> acceleratorHealth) {
            return acceleratorHealth(ElasticInferenceAcceleratorHealth.builder().applyMutation(acceleratorHealth).build());
        }

        /**
         * <p>
         * The type of the Elastic Inference Accelerator.
         * </p>
         * 
         * @param acceleratorType
         *        The type of the Elastic Inference Accelerator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorType(String acceleratorType);

        /**
         * <p>
         * The ID of the Elastic Inference Accelerator.
         * </p>
         * 
         * @param acceleratorId
         *        The ID of the Elastic Inference Accelerator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorId(String acceleratorId);

        /**
         * <p>
         * The availability zone where the Elastic Inference Accelerator is present.
         * </p>
         * 
         * @param availabilityZone
         *        The availability zone where the Elastic Inference Accelerator is present.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The ARN of the resource that the Elastic Inference Accelerator is attached to.
         * </p>
         * 
         * @param attachedResource
         *        The ARN of the resource that the Elastic Inference Accelerator is attached to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachedResource(String attachedResource);
    }

    static final class BuilderImpl implements Builder {
        private ElasticInferenceAcceleratorHealth acceleratorHealth;

        private String acceleratorType;

        private String acceleratorId;

        private String availabilityZone;

        private String attachedResource;

        private BuilderImpl() {
        }

        private BuilderImpl(ElasticInferenceAccelerator model) {
            acceleratorHealth(model.acceleratorHealth);
            acceleratorType(model.acceleratorType);
            acceleratorId(model.acceleratorId);
            availabilityZone(model.availabilityZone);
            attachedResource(model.attachedResource);
        }

        public final ElasticInferenceAcceleratorHealth.Builder getAcceleratorHealth() {
            return acceleratorHealth != null ? acceleratorHealth.toBuilder() : null;
        }

        @Override
        public final Builder acceleratorHealth(ElasticInferenceAcceleratorHealth acceleratorHealth) {
            this.acceleratorHealth = acceleratorHealth;
            return this;
        }

        public final void setAcceleratorHealth(ElasticInferenceAcceleratorHealth.BuilderImpl acceleratorHealth) {
            this.acceleratorHealth = acceleratorHealth != null ? acceleratorHealth.build() : null;
        }

        public final String getAcceleratorType() {
            return acceleratorType;
        }

        @Override
        public final Builder acceleratorType(String acceleratorType) {
            this.acceleratorType = acceleratorType;
            return this;
        }

        public final void setAcceleratorType(String acceleratorType) {
            this.acceleratorType = acceleratorType;
        }

        public final String getAcceleratorId() {
            return acceleratorId;
        }

        @Override
        public final Builder acceleratorId(String acceleratorId) {
            this.acceleratorId = acceleratorId;
            return this;
        }

        public final void setAcceleratorId(String acceleratorId) {
            this.acceleratorId = acceleratorId;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getAttachedResource() {
            return attachedResource;
        }

        @Override
        public final Builder attachedResource(String attachedResource) {
            this.attachedResource = attachedResource;
            return this;
        }

        public final void setAttachedResource(String attachedResource) {
            this.attachedResource = attachedResource;
        }

        @Override
        public ElasticInferenceAccelerator build() {
            return new ElasticInferenceAccelerator(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
