/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticinference.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAcceleratorsResponse extends ElasticInferenceResponse implements
        ToCopyableBuilder<DescribeAcceleratorsResponse.Builder, DescribeAcceleratorsResponse> {
    private static final SdkField<List<ElasticInferenceAccelerator>> ACCELERATOR_SET_FIELD = SdkField
            .<List<ElasticInferenceAccelerator>> builder(MarshallingType.LIST)
            .memberName("acceleratorSet")
            .getter(getter(DescribeAcceleratorsResponse::acceleratorSet))
            .setter(setter(Builder::acceleratorSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acceleratorSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ElasticInferenceAccelerator> builder(MarshallingType.SDK_POJO)
                                            .constructor(ElasticInferenceAccelerator::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeAcceleratorsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCELERATOR_SET_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ElasticInferenceAccelerator> acceleratorSet;

    private final String nextToken;

    private DescribeAcceleratorsResponse(BuilderImpl builder) {
        super(builder);
        this.acceleratorSet = builder.acceleratorSet;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the AcceleratorSet property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAcceleratorSet() {
        return acceleratorSet != null && !(acceleratorSet instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The details of the Elastic Inference Accelerators.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAcceleratorSet()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The details of the Elastic Inference Accelerators.
     */
    public final List<ElasticInferenceAccelerator> acceleratorSet() {
        return acceleratorSet;
    }

    /**
     * <p>
     * A token to specify where to start paginating. This is the NextToken from a previously truncated response.
     * </p>
     * 
     * @return A token to specify where to start paginating. This is the NextToken from a previously truncated response.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAcceleratorSet() ? acceleratorSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAcceleratorsResponse)) {
            return false;
        }
        DescribeAcceleratorsResponse other = (DescribeAcceleratorsResponse) obj;
        return hasAcceleratorSet() == other.hasAcceleratorSet() && Objects.equals(acceleratorSet(), other.acceleratorSet())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAcceleratorsResponse")
                .add("AcceleratorSet", hasAcceleratorSet() ? acceleratorSet() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "acceleratorSet":
            return Optional.ofNullable(clazz.cast(acceleratorSet()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAcceleratorsResponse, T> g) {
        return obj -> g.apply((DescribeAcceleratorsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticInferenceResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAcceleratorsResponse> {
        /**
         * <p>
         * The details of the Elastic Inference Accelerators.
         * </p>
         * 
         * @param acceleratorSet
         *        The details of the Elastic Inference Accelerators.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorSet(Collection<ElasticInferenceAccelerator> acceleratorSet);

        /**
         * <p>
         * The details of the Elastic Inference Accelerators.
         * </p>
         * 
         * @param acceleratorSet
         *        The details of the Elastic Inference Accelerators.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorSet(ElasticInferenceAccelerator... acceleratorSet);

        /**
         * <p>
         * The details of the Elastic Inference Accelerators.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ElasticInferenceAccelerator>.Builder}
         * avoiding the need to create one manually via {@link List<ElasticInferenceAccelerator>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ElasticInferenceAccelerator>.Builder#build()} is called
         * immediately and its result is passed to {@link #acceleratorSet(List<ElasticInferenceAccelerator>)}.
         * 
         * @param acceleratorSet
         *        a consumer that will call methods on {@link List<ElasticInferenceAccelerator>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #acceleratorSet(List<ElasticInferenceAccelerator>)
         */
        Builder acceleratorSet(Consumer<ElasticInferenceAccelerator.Builder>... acceleratorSet);

        /**
         * <p>
         * A token to specify where to start paginating. This is the NextToken from a previously truncated response.
         * </p>
         * 
         * @param nextToken
         *        A token to specify where to start paginating. This is the NextToken from a previously truncated
         *        response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ElasticInferenceResponse.BuilderImpl implements Builder {
        private List<ElasticInferenceAccelerator> acceleratorSet = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAcceleratorsResponse model) {
            super(model);
            acceleratorSet(model.acceleratorSet);
            nextToken(model.nextToken);
        }

        public final List<ElasticInferenceAccelerator.Builder> getAcceleratorSet() {
            List<ElasticInferenceAccelerator.Builder> result = ElasticInferenceAcceleratorSetCopier
                    .copyToBuilder(this.acceleratorSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder acceleratorSet(Collection<ElasticInferenceAccelerator> acceleratorSet) {
            this.acceleratorSet = ElasticInferenceAcceleratorSetCopier.copy(acceleratorSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceleratorSet(ElasticInferenceAccelerator... acceleratorSet) {
            acceleratorSet(Arrays.asList(acceleratorSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceleratorSet(Consumer<ElasticInferenceAccelerator.Builder>... acceleratorSet) {
            acceleratorSet(Stream.of(acceleratorSet).map(c -> ElasticInferenceAccelerator.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAcceleratorSet(Collection<ElasticInferenceAccelerator.BuilderImpl> acceleratorSet) {
            this.acceleratorSet = ElasticInferenceAcceleratorSetCopier.copyFromBuilder(acceleratorSet);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeAcceleratorsResponse build() {
            return new DescribeAcceleratorsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
