/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticinference.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAcceleratorTypesResponse extends ElasticInferenceResponse implements
        ToCopyableBuilder<DescribeAcceleratorTypesResponse.Builder, DescribeAcceleratorTypesResponse> {
    private static final SdkField<List<AcceleratorType>> ACCELERATOR_TYPES_FIELD = SdkField
            .<List<AcceleratorType>> builder(MarshallingType.LIST)
            .memberName("acceleratorTypes")
            .getter(getter(DescribeAcceleratorTypesResponse::acceleratorTypes))
            .setter(setter(Builder::acceleratorTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acceleratorTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AcceleratorType> builder(MarshallingType.SDK_POJO)
                                            .constructor(AcceleratorType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCELERATOR_TYPES_FIELD));

    private final List<AcceleratorType> acceleratorTypes;

    private DescribeAcceleratorTypesResponse(BuilderImpl builder) {
        super(builder);
        this.acceleratorTypes = builder.acceleratorTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the AcceleratorTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAcceleratorTypes() {
        return acceleratorTypes != null && !(acceleratorTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The available accelerator types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAcceleratorTypes} method.
     * </p>
     * 
     * @return The available accelerator types.
     */
    public final List<AcceleratorType> acceleratorTypes() {
        return acceleratorTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAcceleratorTypes() ? acceleratorTypes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAcceleratorTypesResponse)) {
            return false;
        }
        DescribeAcceleratorTypesResponse other = (DescribeAcceleratorTypesResponse) obj;
        return hasAcceleratorTypes() == other.hasAcceleratorTypes()
                && Objects.equals(acceleratorTypes(), other.acceleratorTypes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAcceleratorTypesResponse")
                .add("AcceleratorTypes", hasAcceleratorTypes() ? acceleratorTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "acceleratorTypes":
            return Optional.ofNullable(clazz.cast(acceleratorTypes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAcceleratorTypesResponse, T> g) {
        return obj -> g.apply((DescribeAcceleratorTypesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticInferenceResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAcceleratorTypesResponse> {
        /**
         * <p>
         * The available accelerator types.
         * </p>
         * 
         * @param acceleratorTypes
         *        The available accelerator types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorTypes(Collection<AcceleratorType> acceleratorTypes);

        /**
         * <p>
         * The available accelerator types.
         * </p>
         * 
         * @param acceleratorTypes
         *        The available accelerator types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorTypes(AcceleratorType... acceleratorTypes);

        /**
         * <p>
         * The available accelerator types.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<AcceleratorType>.Builder} avoiding
         * the need to create one manually via {@link List<AcceleratorType>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AcceleratorType>.Builder#build()} is called immediately and
         * its result is passed to {@link #acceleratorTypes(List<AcceleratorType>)}.
         * 
         * @param acceleratorTypes
         *        a consumer that will call methods on {@link List<AcceleratorType>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #acceleratorTypes(List<AcceleratorType>)
         */
        Builder acceleratorTypes(Consumer<AcceleratorType.Builder>... acceleratorTypes);
    }

    static final class BuilderImpl extends ElasticInferenceResponse.BuilderImpl implements Builder {
        private List<AcceleratorType> acceleratorTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAcceleratorTypesResponse model) {
            super(model);
            acceleratorTypes(model.acceleratorTypes);
        }

        public final List<AcceleratorType.Builder> getAcceleratorTypes() {
            List<AcceleratorType.Builder> result = AcceleratorTypeListCopier.copyToBuilder(this.acceleratorTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAcceleratorTypes(Collection<AcceleratorType.BuilderImpl> acceleratorTypes) {
            this.acceleratorTypes = AcceleratorTypeListCopier.copyFromBuilder(acceleratorTypes);
        }

        @Override
        public final Builder acceleratorTypes(Collection<AcceleratorType> acceleratorTypes) {
            this.acceleratorTypes = AcceleratorTypeListCopier.copy(acceleratorTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceleratorTypes(AcceleratorType... acceleratorTypes) {
            acceleratorTypes(Arrays.asList(acceleratorTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceleratorTypes(Consumer<AcceleratorType.Builder>... acceleratorTypes) {
            acceleratorTypes(Stream.of(acceleratorTypes).map(c -> AcceleratorType.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeAcceleratorTypesResponse build() {
            return new DescribeAcceleratorTypesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
