/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticinference;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.elasticinference.model.DescribeAcceleratorOfferingsRequest;
import software.amazon.awssdk.services.elasticinference.model.DescribeAcceleratorOfferingsResponse;
import software.amazon.awssdk.services.elasticinference.model.DescribeAcceleratorTypesRequest;
import software.amazon.awssdk.services.elasticinference.model.DescribeAcceleratorTypesResponse;
import software.amazon.awssdk.services.elasticinference.model.DescribeAcceleratorsRequest;
import software.amazon.awssdk.services.elasticinference.model.DescribeAcceleratorsResponse;
import software.amazon.awssdk.services.elasticinference.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.elasticinference.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.elasticinference.model.TagResourceRequest;
import software.amazon.awssdk.services.elasticinference.model.TagResourceResponse;
import software.amazon.awssdk.services.elasticinference.model.UntagResourceRequest;
import software.amazon.awssdk.services.elasticinference.model.UntagResourceResponse;
import software.amazon.awssdk.services.elasticinference.paginators.DescribeAcceleratorsPublisher;

/**
 * Service client for accessing Amazon Elastic Inference asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * Elastic Inference public APIs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ElasticInferenceAsyncClient extends SdkClient {
    String SERVICE_NAME = "elastic-inference";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "api.elastic-inference";

    /**
     * <p>
     * Describes the locations in which a given accelerator type or set of types is present in a given region.
     * </p>
     *
     * @param describeAcceleratorOfferingsRequest
     * @return A Java Future containing the result of the DescribeAcceleratorOfferings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Raised when a malformed input has been provided to the API.</li>
     *         <li>ResourceNotFoundException Raised when the requested resource cannot be found.</li>
     *         <li>InternalServerException Raised when an unexpected error occurred during request processing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticInferenceException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticInferenceAsyncClient.DescribeAcceleratorOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elastic-inference-2017-07-25/DescribeAcceleratorOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAcceleratorOfferingsResponse> describeAcceleratorOfferings(
            DescribeAcceleratorOfferingsRequest describeAcceleratorOfferingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the locations in which a given accelerator type or set of types is present in a given region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAcceleratorOfferingsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAcceleratorOfferingsRequest#builder()}
     * </p>
     *
     * @param describeAcceleratorOfferingsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAcceleratorOfferingsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeAcceleratorOfferings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Raised when a malformed input has been provided to the API.</li>
     *         <li>ResourceNotFoundException Raised when the requested resource cannot be found.</li>
     *         <li>InternalServerException Raised when an unexpected error occurred during request processing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticInferenceException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticInferenceAsyncClient.DescribeAcceleratorOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elastic-inference-2017-07-25/DescribeAcceleratorOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAcceleratorOfferingsResponse> describeAcceleratorOfferings(
            Consumer<DescribeAcceleratorOfferingsRequest.Builder> describeAcceleratorOfferingsRequest) {
        return describeAcceleratorOfferings(DescribeAcceleratorOfferingsRequest.builder()
                .applyMutation(describeAcceleratorOfferingsRequest).build());
    }

    /**
     * <p>
     * Describes the accelerator types available in a given region, as well as their characteristics, such as memory and
     * throughput.
     * </p>
     *
     * @param describeAcceleratorTypesRequest
     * @return A Java Future containing the result of the DescribeAcceleratorTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Raised when an unexpected error occurred during request processing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticInferenceException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticInferenceAsyncClient.DescribeAcceleratorTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elastic-inference-2017-07-25/DescribeAcceleratorTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAcceleratorTypesResponse> describeAcceleratorTypes(
            DescribeAcceleratorTypesRequest describeAcceleratorTypesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the accelerator types available in a given region, as well as their characteristics, such as memory and
     * throughput.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAcceleratorTypesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeAcceleratorTypesRequest#builder()}
     * </p>
     *
     * @param describeAcceleratorTypesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAcceleratorTypesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeAcceleratorTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Raised when an unexpected error occurred during request processing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticInferenceException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticInferenceAsyncClient.DescribeAcceleratorTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elastic-inference-2017-07-25/DescribeAcceleratorTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAcceleratorTypesResponse> describeAcceleratorTypes(
            Consumer<DescribeAcceleratorTypesRequest.Builder> describeAcceleratorTypesRequest) {
        return describeAcceleratorTypes(DescribeAcceleratorTypesRequest.builder().applyMutation(describeAcceleratorTypesRequest)
                .build());
    }

    /**
     * <p>
     * Describes information over a provided set of accelerators belonging to an account.
     * </p>
     *
     * @param describeAcceleratorsRequest
     * @return A Java Future containing the result of the DescribeAccelerators operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Raised when a malformed input has been provided to the API.</li>
     *         <li>ResourceNotFoundException Raised when the requested resource cannot be found.</li>
     *         <li>InternalServerException Raised when an unexpected error occurred during request processing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticInferenceException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticInferenceAsyncClient.DescribeAccelerators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elastic-inference-2017-07-25/DescribeAccelerators"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAcceleratorsResponse> describeAccelerators(
            DescribeAcceleratorsRequest describeAcceleratorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes information over a provided set of accelerators belonging to an account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAcceleratorsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeAcceleratorsRequest#builder()}
     * </p>
     *
     * @param describeAcceleratorsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAcceleratorsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeAccelerators operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Raised when a malformed input has been provided to the API.</li>
     *         <li>ResourceNotFoundException Raised when the requested resource cannot be found.</li>
     *         <li>InternalServerException Raised when an unexpected error occurred during request processing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticInferenceException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticInferenceAsyncClient.DescribeAccelerators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elastic-inference-2017-07-25/DescribeAccelerators"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAcceleratorsResponse> describeAccelerators(
            Consumer<DescribeAcceleratorsRequest.Builder> describeAcceleratorsRequest) {
        return describeAccelerators(DescribeAcceleratorsRequest.builder().applyMutation(describeAcceleratorsRequest).build());
    }

    /**
     * <p>
     * Describes information over a provided set of accelerators belonging to an account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAccelerators(software.amazon.awssdk.services.elasticinference.model.DescribeAcceleratorsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticinference.paginators.DescribeAcceleratorsPublisher publisher = client.describeAcceleratorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticinference.paginators.DescribeAcceleratorsPublisher publisher = client.describeAcceleratorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticinference.model.DescribeAcceleratorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticinference.model.DescribeAcceleratorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAccelerators(software.amazon.awssdk.services.elasticinference.model.DescribeAcceleratorsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeAcceleratorsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Raised when a malformed input has been provided to the API.</li>
     *         <li>ResourceNotFoundException Raised when the requested resource cannot be found.</li>
     *         <li>InternalServerException Raised when an unexpected error occurred during request processing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticInferenceException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticInferenceAsyncClient.DescribeAccelerators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elastic-inference-2017-07-25/DescribeAccelerators"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAcceleratorsPublisher describeAcceleratorsPaginator(DescribeAcceleratorsRequest describeAcceleratorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes information over a provided set of accelerators belonging to an account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAccelerators(software.amazon.awssdk.services.elasticinference.model.DescribeAcceleratorsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticinference.paginators.DescribeAcceleratorsPublisher publisher = client.describeAcceleratorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticinference.paginators.DescribeAcceleratorsPublisher publisher = client.describeAcceleratorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticinference.model.DescribeAcceleratorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticinference.model.DescribeAcceleratorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAccelerators(software.amazon.awssdk.services.elasticinference.model.DescribeAcceleratorsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAcceleratorsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeAcceleratorsRequest#builder()}
     * </p>
     *
     * @param describeAcceleratorsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAcceleratorsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Raised when a malformed input has been provided to the API.</li>
     *         <li>ResourceNotFoundException Raised when the requested resource cannot be found.</li>
     *         <li>InternalServerException Raised when an unexpected error occurred during request processing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticInferenceException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticInferenceAsyncClient.DescribeAccelerators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elastic-inference-2017-07-25/DescribeAccelerators"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAcceleratorsPublisher describeAcceleratorsPaginator(
            Consumer<DescribeAcceleratorsRequest.Builder> describeAcceleratorsRequest) {
        return describeAcceleratorsPaginator(DescribeAcceleratorsRequest.builder().applyMutation(describeAcceleratorsRequest)
                .build());
    }

    /**
     * <p>
     * Returns all tags of an Elastic Inference Accelerator.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Raised when a malformed input has been provided to the API.</li>
     *         <li>ResourceNotFoundException Raised when the requested resource cannot be found.</li>
     *         <li>InternalServerException Raised when an unexpected error occurred during request processing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticInferenceException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticInferenceAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elastic-inference-2017-07-25/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns all tags of an Elastic Inference Accelerator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Raised when a malformed input has been provided to the API.</li>
     *         <li>ResourceNotFoundException Raised when the requested resource cannot be found.</li>
     *         <li>InternalServerException Raised when an unexpected error occurred during request processing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticInferenceException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticInferenceAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elastic-inference-2017-07-25/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Adds the specified tags to an Elastic Inference Accelerator.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Raised when a malformed input has been provided to the API.</li>
     *         <li>ResourceNotFoundException Raised when the requested resource cannot be found.</li>
     *         <li>InternalServerException Raised when an unexpected error occurred during request processing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticInferenceException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticInferenceAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elastic-inference-2017-07-25/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds the specified tags to an Elastic Inference Accelerator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Raised when a malformed input has been provided to the API.</li>
     *         <li>ResourceNotFoundException Raised when the requested resource cannot be found.</li>
     *         <li>InternalServerException Raised when an unexpected error occurred during request processing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticInferenceException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticInferenceAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elastic-inference-2017-07-25/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes the specified tags from an Elastic Inference Accelerator.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Raised when a malformed input has been provided to the API.</li>
     *         <li>ResourceNotFoundException Raised when the requested resource cannot be found.</li>
     *         <li>InternalServerException Raised when an unexpected error occurred during request processing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticInferenceException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticInferenceAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elastic-inference-2017-07-25/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified tags from an Elastic Inference Accelerator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Raised when a malformed input has been provided to the API.</li>
     *         <li>ResourceNotFoundException Raised when the requested resource cannot be found.</li>
     *         <li>InternalServerException Raised when an unexpected error occurred during request processing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticInferenceException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticInferenceAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elastic-inference-2017-07-25/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * Create a {@link ElasticInferenceAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ElasticInferenceAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ElasticInferenceAsyncClient}.
     */
    static ElasticInferenceAsyncClientBuilder builder() {
        return new DefaultElasticInferenceAsyncClientBuilder();
    }
}
