/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticinference.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LocationType {
    REGION("region"),
    AVAILABILITY_ZONE("availability-zone"),
    AVAILABILITY_ZONE_ID("availability-zone-id"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LocationType> VALUE_MAP;
    private final String value;

    private LocationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LocationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LocationType> knownValues() {
        EnumSet<LocationType> knownValues = EnumSet.allOf(LocationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LocationType.class, LocationType::toString);
    }
}

