/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output for DescribeInstanceHealth.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeInstanceHealthResponse extends ElasticLoadBalancingResponse implements
        ToCopyableBuilder<DescribeInstanceHealthResponse.Builder, DescribeInstanceHealthResponse> {
    private static final SdkField<List<InstanceState>> INSTANCE_STATES_FIELD = SdkField
            .<List<InstanceState>> builder(MarshallingType.LIST)
            .memberName("InstanceStates")
            .getter(getter(DescribeInstanceHealthResponse::instanceStates))
            .setter(setter(Builder::instanceStates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceStates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InstanceState> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceState::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_STATES_FIELD));

    private final List<InstanceState> instanceStates;

    private DescribeInstanceHealthResponse(BuilderImpl builder) {
        super(builder);
        this.instanceStates = builder.instanceStates;
    }

    /**
     * Returns true if the InstanceStates property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasInstanceStates() {
        return instanceStates != null && !(instanceStates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the health of the instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInstanceStates()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the health of the instances.
     */
    public final List<InstanceState> instanceStates() {
        return instanceStates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceStates() ? instanceStates() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceHealthResponse)) {
            return false;
        }
        DescribeInstanceHealthResponse other = (DescribeInstanceHealthResponse) obj;
        return hasInstanceStates() == other.hasInstanceStates() && Objects.equals(instanceStates(), other.instanceStates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeInstanceHealthResponse")
                .add("InstanceStates", hasInstanceStates() ? instanceStates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceStates":
            return Optional.ofNullable(clazz.cast(instanceStates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInstanceHealthResponse, T> g) {
        return obj -> g.apply((DescribeInstanceHealthResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticLoadBalancingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeInstanceHealthResponse> {
        /**
         * <p>
         * Information about the health of the instances.
         * </p>
         * 
         * @param instanceStates
         *        Information about the health of the instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceStates(Collection<InstanceState> instanceStates);

        /**
         * <p>
         * Information about the health of the instances.
         * </p>
         * 
         * @param instanceStates
         *        Information about the health of the instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceStates(InstanceState... instanceStates);

        /**
         * <p>
         * Information about the health of the instances.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InstanceState>.Builder} avoiding the need
         * to create one manually via {@link List<InstanceState>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InstanceState>.Builder#build()} is called immediately and
         * its result is passed to {@link #instanceStates(List<InstanceState>)}.
         * 
         * @param instanceStates
         *        a consumer that will call methods on {@link List<InstanceState>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceStates(List<InstanceState>)
         */
        Builder instanceStates(Consumer<InstanceState.Builder>... instanceStates);
    }

    static final class BuilderImpl extends ElasticLoadBalancingResponse.BuilderImpl implements Builder {
        private List<InstanceState> instanceStates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstanceHealthResponse model) {
            super(model);
            instanceStates(model.instanceStates);
        }

        public final List<InstanceState.Builder> getInstanceStates() {
            List<InstanceState.Builder> result = InstanceStatesCopier.copyToBuilder(this.instanceStates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder instanceStates(Collection<InstanceState> instanceStates) {
            this.instanceStates = InstanceStatesCopier.copy(instanceStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceStates(InstanceState... instanceStates) {
            instanceStates(Arrays.asList(instanceStates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceStates(Consumer<InstanceState.Builder>... instanceStates) {
            instanceStates(Stream.of(instanceStates).map(c -> InstanceState.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setInstanceStates(Collection<InstanceState.BuilderImpl> instanceStates) {
            this.instanceStates = InstanceStatesCopier.copyFromBuilder(instanceStates);
        }

        @Override
        public DescribeInstanceHealthResponse build() {
            return new DescribeInstanceHealthResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
