/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for CreateLoadBalancer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLoadBalancerRequest extends ElasticLoadBalancingRequest implements
        ToCopyableBuilder<CreateLoadBalancerRequest.Builder, CreateLoadBalancerRequest> {
    private static final SdkField<String> LOAD_BALANCER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LoadBalancerName").getter(getter(CreateLoadBalancerRequest::loadBalancerName))
            .setter(setter(Builder::loadBalancerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerName").build()).build();

    private static final SdkField<List<Listener>> LISTENERS_FIELD = SdkField
            .<List<Listener>> builder(MarshallingType.LIST)
            .memberName("Listeners")
            .getter(getter(CreateLoadBalancerRequest::listeners))
            .setter(setter(Builder::listeners))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Listeners").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Listener> builder(MarshallingType.SDK_POJO)
                                            .constructor(Listener::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AvailabilityZones")
            .getter(getter(CreateLoadBalancerRequest::availabilityZones))
            .setter(setter(Builder::availabilityZones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SUBNETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Subnets")
            .getter(getter(CreateLoadBalancerRequest::subnets))
            .setter(setter(Builder::subnets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subnets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroups")
            .getter(getter(CreateLoadBalancerRequest::securityGroups))
            .setter(setter(Builder::securityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SCHEME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Scheme")
            .getter(getter(CreateLoadBalancerRequest::scheme)).setter(setter(Builder::scheme))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scheme").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateLoadBalancerRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_BALANCER_NAME_FIELD,
            LISTENERS_FIELD, AVAILABILITY_ZONES_FIELD, SUBNETS_FIELD, SECURITY_GROUPS_FIELD, SCHEME_FIELD, TAGS_FIELD));

    private final String loadBalancerName;

    private final List<Listener> listeners;

    private final List<String> availabilityZones;

    private final List<String> subnets;

    private final List<String> securityGroups;

    private final String scheme;

    private final List<Tag> tags;

    private CreateLoadBalancerRequest(BuilderImpl builder) {
        super(builder);
        this.loadBalancerName = builder.loadBalancerName;
        this.listeners = builder.listeners;
        this.availabilityZones = builder.availabilityZones;
        this.subnets = builder.subnets;
        this.securityGroups = builder.securityGroups;
        this.scheme = builder.scheme;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the load balancer.
     * </p>
     * <p>
     * This name must be unique within your set of load balancers for the region, must have a maximum of 32 characters,
     * must contain only alphanumeric characters or hyphens, and cannot begin or end with a hyphen.
     * </p>
     * 
     * @return The name of the load balancer.</p>
     *         <p>
     *         This name must be unique within your set of load balancers for the region, must have a maximum of 32
     *         characters, must contain only alphanumeric characters or hyphens, and cannot begin or end with a hyphen.
     */
    public final String loadBalancerName() {
        return loadBalancerName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Listeners property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasListeners() {
        return listeners != null && !(listeners instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The listeners.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-listener-config.html">Listeners for
     * Your Classic Load Balancer</a> in the <i>Classic Load Balancers Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasListeners} method.
     * </p>
     * 
     * @return The listeners.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-listener-config.html">Listeners
     *         for Your Classic Load Balancer</a> in the <i>Classic Load Balancers Guide</i>.
     */
    public final List<Listener> listeners() {
        return listeners;
    }

    /**
     * For responses, this returns true if the service returned a value for the AvailabilityZones property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAvailabilityZones() {
        return availabilityZones != null && !(availabilityZones instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more Availability Zones from the same region as the load balancer.
     * </p>
     * <p>
     * You must specify at least one Availability Zone.
     * </p>
     * <p>
     * You can add more Availability Zones after you create the load balancer using
     * <a>EnableAvailabilityZonesForLoadBalancer</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAvailabilityZones} method.
     * </p>
     * 
     * @return One or more Availability Zones from the same region as the load balancer.</p>
     *         <p>
     *         You must specify at least one Availability Zone.
     *         </p>
     *         <p>
     *         You can add more Availability Zones after you create the load balancer using
     *         <a>EnableAvailabilityZonesForLoadBalancer</a>.
     */
    public final List<String> availabilityZones() {
        return availabilityZones;
    }

    /**
     * For responses, this returns true if the service returned a value for the Subnets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnets() {
        return subnets != null && !(subnets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the subnets in your VPC to attach to the load balancer. Specify one subnet per Availability Zone
     * specified in <code>AvailabilityZones</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnets} method.
     * </p>
     * 
     * @return The IDs of the subnets in your VPC to attach to the load balancer. Specify one subnet per Availability
     *         Zone specified in <code>AvailabilityZones</code>.
     */
    public final List<String> subnets() {
        return subnets;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroups() {
        return securityGroups != null && !(securityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the security groups to assign to the load balancer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroups} method.
     * </p>
     * 
     * @return The IDs of the security groups to assign to the load balancer.
     */
    public final List<String> securityGroups() {
        return securityGroups;
    }

    /**
     * <p>
     * The type of a load balancer. Valid only for load balancers in a VPC.
     * </p>
     * <p>
     * By default, Elastic Load Balancing creates an Internet-facing load balancer with a DNS name that resolves to
     * public IP addresses. For more information about Internet-facing and Internal load balancers, see <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/userguide/how-elastic-load-balancing-works.html#load-balancer-scheme"
     * >Load Balancer Scheme</a> in the <i>Elastic Load Balancing User Guide</i>.
     * </p>
     * <p>
     * Specify <code>internal</code> to create a load balancer with a DNS name that resolves to private IP addresses.
     * </p>
     * 
     * @return The type of a load balancer. Valid only for load balancers in a VPC.</p>
     *         <p>
     *         By default, Elastic Load Balancing creates an Internet-facing load balancer with a DNS name that resolves
     *         to public IP addresses. For more information about Internet-facing and Internal load balancers, see <a
     *         href=
     *         "https://docs.aws.amazon.com/elasticloadbalancing/latest/userguide/how-elastic-load-balancing-works.html#load-balancer-scheme"
     *         >Load Balancer Scheme</a> in the <i>Elastic Load Balancing User Guide</i>.
     *         </p>
     *         <p>
     *         Specify <code>internal</code> to create a load balancer with a DNS name that resolves to private IP
     *         addresses.
     */
    public final String scheme() {
        return scheme;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tags to assign to the load balancer.
     * </p>
     * <p>
     * For more information about tagging your load balancer, see <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/add-remove-tags.html">Tag Your Classic Load
     * Balancer</a> in the <i>Classic Load Balancers Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of tags to assign to the load balancer.</p>
     *         <p>
     *         For more information about tagging your load balancer, see <a
     *         href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/add-remove-tags.html">Tag Your
     *         Classic Load Balancer</a> in the <i>Classic Load Balancers Guide</i>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerName());
        hashCode = 31 * hashCode + Objects.hashCode(hasListeners() ? listeners() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAvailabilityZones() ? availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnets() ? subnets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroups() ? securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(scheme());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLoadBalancerRequest)) {
            return false;
        }
        CreateLoadBalancerRequest other = (CreateLoadBalancerRequest) obj;
        return Objects.equals(loadBalancerName(), other.loadBalancerName()) && hasListeners() == other.hasListeners()
                && Objects.equals(listeners(), other.listeners()) && hasAvailabilityZones() == other.hasAvailabilityZones()
                && Objects.equals(availabilityZones(), other.availabilityZones()) && hasSubnets() == other.hasSubnets()
                && Objects.equals(subnets(), other.subnets()) && hasSecurityGroups() == other.hasSecurityGroups()
                && Objects.equals(securityGroups(), other.securityGroups()) && Objects.equals(scheme(), other.scheme())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateLoadBalancerRequest").add("LoadBalancerName", loadBalancerName())
                .add("Listeners", hasListeners() ? listeners() : null)
                .add("AvailabilityZones", hasAvailabilityZones() ? availabilityZones() : null)
                .add("Subnets", hasSubnets() ? subnets() : null)
                .add("SecurityGroups", hasSecurityGroups() ? securityGroups() : null).add("Scheme", scheme())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LoadBalancerName":
            return Optional.ofNullable(clazz.cast(loadBalancerName()));
        case "Listeners":
            return Optional.ofNullable(clazz.cast(listeners()));
        case "AvailabilityZones":
            return Optional.ofNullable(clazz.cast(availabilityZones()));
        case "Subnets":
            return Optional.ofNullable(clazz.cast(subnets()));
        case "SecurityGroups":
            return Optional.ofNullable(clazz.cast(securityGroups()));
        case "Scheme":
            return Optional.ofNullable(clazz.cast(scheme()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLoadBalancerRequest, T> g) {
        return obj -> g.apply((CreateLoadBalancerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticLoadBalancingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateLoadBalancerRequest> {
        /**
         * <p>
         * The name of the load balancer.
         * </p>
         * <p>
         * This name must be unique within your set of load balancers for the region, must have a maximum of 32
         * characters, must contain only alphanumeric characters or hyphens, and cannot begin or end with a hyphen.
         * </p>
         * 
         * @param loadBalancerName
         *        The name of the load balancer.</p>
         *        <p>
         *        This name must be unique within your set of load balancers for the region, must have a maximum of 32
         *        characters, must contain only alphanumeric characters or hyphens, and cannot begin or end with a
         *        hyphen.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerName(String loadBalancerName);

        /**
         * <p>
         * The listeners.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-listener-config.html">Listeners for
         * Your Classic Load Balancer</a> in the <i>Classic Load Balancers Guide</i>.
         * </p>
         * 
         * @param listeners
         *        The listeners.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-listener-config.html"
         *        >Listeners for Your Classic Load Balancer</a> in the <i>Classic Load Balancers Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listeners(Collection<Listener> listeners);

        /**
         * <p>
         * The listeners.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-listener-config.html">Listeners for
         * Your Classic Load Balancer</a> in the <i>Classic Load Balancers Guide</i>.
         * </p>
         * 
         * @param listeners
         *        The listeners.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-listener-config.html"
         *        >Listeners for Your Classic Load Balancer</a> in the <i>Classic Load Balancers Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listeners(Listener... listeners);

        /**
         * <p>
         * The listeners.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-listener-config.html">Listeners for
         * Your Classic Load Balancer</a> in the <i>Classic Load Balancers Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Listener>.Builder} avoiding the need
         * to create one manually via {@link List<Listener>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Listener>.Builder#build()} is called immediately and its
         * result is passed to {@link #listeners(List<Listener>)}.
         * 
         * @param listeners
         *        a consumer that will call methods on {@link List<Listener>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listeners(List<Listener>)
         */
        Builder listeners(Consumer<Listener.Builder>... listeners);

        /**
         * <p>
         * One or more Availability Zones from the same region as the load balancer.
         * </p>
         * <p>
         * You must specify at least one Availability Zone.
         * </p>
         * <p>
         * You can add more Availability Zones after you create the load balancer using
         * <a>EnableAvailabilityZonesForLoadBalancer</a>.
         * </p>
         * 
         * @param availabilityZones
         *        One or more Availability Zones from the same region as the load balancer.</p>
         *        <p>
         *        You must specify at least one Availability Zone.
         *        </p>
         *        <p>
         *        You can add more Availability Zones after you create the load balancer using
         *        <a>EnableAvailabilityZonesForLoadBalancer</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(Collection<String> availabilityZones);

        /**
         * <p>
         * One or more Availability Zones from the same region as the load balancer.
         * </p>
         * <p>
         * You must specify at least one Availability Zone.
         * </p>
         * <p>
         * You can add more Availability Zones after you create the load balancer using
         * <a>EnableAvailabilityZonesForLoadBalancer</a>.
         * </p>
         * 
         * @param availabilityZones
         *        One or more Availability Zones from the same region as the load balancer.</p>
         *        <p>
         *        You must specify at least one Availability Zone.
         *        </p>
         *        <p>
         *        You can add more Availability Zones after you create the load balancer using
         *        <a>EnableAvailabilityZonesForLoadBalancer</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(String... availabilityZones);

        /**
         * <p>
         * The IDs of the subnets in your VPC to attach to the load balancer. Specify one subnet per Availability Zone
         * specified in <code>AvailabilityZones</code>.
         * </p>
         * 
         * @param subnets
         *        The IDs of the subnets in your VPC to attach to the load balancer. Specify one subnet per Availability
         *        Zone specified in <code>AvailabilityZones</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnets(Collection<String> subnets);

        /**
         * <p>
         * The IDs of the subnets in your VPC to attach to the load balancer. Specify one subnet per Availability Zone
         * specified in <code>AvailabilityZones</code>.
         * </p>
         * 
         * @param subnets
         *        The IDs of the subnets in your VPC to attach to the load balancer. Specify one subnet per Availability
         *        Zone specified in <code>AvailabilityZones</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnets(String... subnets);

        /**
         * <p>
         * The IDs of the security groups to assign to the load balancer.
         * </p>
         * 
         * @param securityGroups
         *        The IDs of the security groups to assign to the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<String> securityGroups);

        /**
         * <p>
         * The IDs of the security groups to assign to the load balancer.
         * </p>
         * 
         * @param securityGroups
         *        The IDs of the security groups to assign to the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(String... securityGroups);

        /**
         * <p>
         * The type of a load balancer. Valid only for load balancers in a VPC.
         * </p>
         * <p>
         * By default, Elastic Load Balancing creates an Internet-facing load balancer with a DNS name that resolves to
         * public IP addresses. For more information about Internet-facing and Internal load balancers, see <a href=
         * "https://docs.aws.amazon.com/elasticloadbalancing/latest/userguide/how-elastic-load-balancing-works.html#load-balancer-scheme"
         * >Load Balancer Scheme</a> in the <i>Elastic Load Balancing User Guide</i>.
         * </p>
         * <p>
         * Specify <code>internal</code> to create a load balancer with a DNS name that resolves to private IP
         * addresses.
         * </p>
         * 
         * @param scheme
         *        The type of a load balancer. Valid only for load balancers in a VPC.</p>
         *        <p>
         *        By default, Elastic Load Balancing creates an Internet-facing load balancer with a DNS name that
         *        resolves to public IP addresses. For more information about Internet-facing and Internal load
         *        balancers, see <a href=
         *        "https://docs.aws.amazon.com/elasticloadbalancing/latest/userguide/how-elastic-load-balancing-works.html#load-balancer-scheme"
         *        >Load Balancer Scheme</a> in the <i>Elastic Load Balancing User Guide</i>.
         *        </p>
         *        <p>
         *        Specify <code>internal</code> to create a load balancer with a DNS name that resolves to private IP
         *        addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheme(String scheme);

        /**
         * <p>
         * A list of tags to assign to the load balancer.
         * </p>
         * <p>
         * For more information about tagging your load balancer, see <a
         * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/add-remove-tags.html">Tag Your Classic
         * Load Balancer</a> in the <i>Classic Load Balancers Guide</i>.
         * </p>
         * 
         * @param tags
         *        A list of tags to assign to the load balancer.</p>
         *        <p>
         *        For more information about tagging your load balancer, see <a
         *        href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/add-remove-tags.html">Tag Your
         *        Classic Load Balancer</a> in the <i>Classic Load Balancers Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of tags to assign to the load balancer.
         * </p>
         * <p>
         * For more information about tagging your load balancer, see <a
         * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/add-remove-tags.html">Tag Your Classic
         * Load Balancer</a> in the <i>Classic Load Balancers Guide</i>.
         * </p>
         * 
         * @param tags
         *        A list of tags to assign to the load balancer.</p>
         *        <p>
         *        For more information about tagging your load balancer, see <a
         *        href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/add-remove-tags.html">Tag Your
         *        Classic Load Balancer</a> in the <i>Classic Load Balancers Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of tags to assign to the load balancer.
         * </p>
         * <p>
         * For more information about tagging your load balancer, see <a
         * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/add-remove-tags.html">Tag Your Classic
         * Load Balancer</a> in the <i>Classic Load Balancers Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Tag>.Builder} avoiding the need to
         * create one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticLoadBalancingRequest.BuilderImpl implements Builder {
        private String loadBalancerName;

        private List<Listener> listeners = DefaultSdkAutoConstructList.getInstance();

        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();

        private List<String> subnets = DefaultSdkAutoConstructList.getInstance();

        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();

        private String scheme;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLoadBalancerRequest model) {
            super(model);
            loadBalancerName(model.loadBalancerName);
            listeners(model.listeners);
            availabilityZones(model.availabilityZones);
            subnets(model.subnets);
            securityGroups(model.securityGroups);
            scheme(model.scheme);
            tags(model.tags);
        }

        public final String getLoadBalancerName() {
            return loadBalancerName;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final List<Listener.Builder> getListeners() {
            List<Listener.Builder> result = ListenersCopier.copyToBuilder(this.listeners);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setListeners(Collection<Listener.BuilderImpl> listeners) {
            this.listeners = ListenersCopier.copyFromBuilder(listeners);
        }

        @Override
        public final Builder listeners(Collection<Listener> listeners) {
            this.listeners = ListenersCopier.copy(listeners);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listeners(Listener... listeners) {
            listeners(Arrays.asList(listeners));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listeners(Consumer<Listener.Builder>... listeners) {
            listeners(Stream.of(listeners).map(c -> Listener.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getAvailabilityZones() {
            if (availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return availabilityZones;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String... availabilityZones) {
            availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final Collection<String> getSubnets() {
            if (subnets instanceof SdkAutoConstructList) {
                return null;
            }
            return subnets;
        }

        public final void setSubnets(Collection<String> subnets) {
            this.subnets = SubnetsCopier.copy(subnets);
        }

        @Override
        public final Builder subnets(Collection<String> subnets) {
            this.subnets = SubnetsCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(String... subnets) {
            subnets(Arrays.asList(subnets));
            return this;
        }

        public final Collection<String> getSecurityGroups() {
            if (securityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroups;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final String getScheme() {
            return scheme;
        }

        public final void setScheme(String scheme) {
            this.scheme = scheme;
        }

        @Override
        public final Builder scheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLoadBalancerRequest build() {
            return new CreateLoadBalancerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
