/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The policies enabled for a listener.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListenerDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<ListenerDescription.Builder, ListenerDescription> {
    private static final SdkField<Listener> LISTENER_FIELD = SdkField.<Listener> builder(MarshallingType.SDK_POJO)
            .memberName("Listener").getter(getter(ListenerDescription::listener)).setter(setter(Builder::listener))
            .constructor(Listener::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Listener").build()).build();

    private static final SdkField<List<String>> POLICY_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PolicyNames")
            .getter(getter(ListenerDescription::policyNames))
            .setter(setter(Builder::policyNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LISTENER_FIELD,
            POLICY_NAMES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Listener listener;

    private final List<String> policyNames;

    private ListenerDescription(BuilderImpl builder) {
        this.listener = builder.listener;
        this.policyNames = builder.policyNames;
    }

    /**
     * <p>
     * The listener.
     * </p>
     * 
     * @return The listener.
     */
    public final Listener listener() {
        return listener;
    }

    /**
     * For responses, this returns true if the service returned a value for the PolicyNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPolicyNames() {
        return policyNames != null && !(policyNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The policies. If there are no policies enabled, the list is empty.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPolicyNames} method.
     * </p>
     * 
     * @return The policies. If there are no policies enabled, the list is empty.
     */
    public final List<String> policyNames() {
        return policyNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(listener());
        hashCode = 31 * hashCode + Objects.hashCode(hasPolicyNames() ? policyNames() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListenerDescription)) {
            return false;
        }
        ListenerDescription other = (ListenerDescription) obj;
        return Objects.equals(listener(), other.listener()) && hasPolicyNames() == other.hasPolicyNames()
                && Objects.equals(policyNames(), other.policyNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListenerDescription").add("Listener", listener())
                .add("PolicyNames", hasPolicyNames() ? policyNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Listener":
            return Optional.ofNullable(clazz.cast(listener()));
        case "PolicyNames":
            return Optional.ofNullable(clazz.cast(policyNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListenerDescription, T> g) {
        return obj -> g.apply((ListenerDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListenerDescription> {
        /**
         * <p>
         * The listener.
         * </p>
         * 
         * @param listener
         *        The listener.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listener(Listener listener);

        /**
         * <p>
         * The listener.
         * </p>
         * This is a convenience method that creates an instance of the {@link Listener.Builder} avoiding the need to
         * create one manually via {@link Listener#builder()}.
         *
         * When the {@link Consumer} completes, {@link Listener.Builder#build()} is called immediately and its result is
         * passed to {@link #listener(Listener)}.
         * 
         * @param listener
         *        a consumer that will call methods on {@link Listener.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listener(Listener)
         */
        default Builder listener(Consumer<Listener.Builder> listener) {
            return listener(Listener.builder().applyMutation(listener).build());
        }

        /**
         * <p>
         * The policies. If there are no policies enabled, the list is empty.
         * </p>
         * 
         * @param policyNames
         *        The policies. If there are no policies enabled, the list is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyNames(Collection<String> policyNames);

        /**
         * <p>
         * The policies. If there are no policies enabled, the list is empty.
         * </p>
         * 
         * @param policyNames
         *        The policies. If there are no policies enabled, the list is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyNames(String... policyNames);
    }

    static final class BuilderImpl implements Builder {
        private Listener listener;

        private List<String> policyNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListenerDescription model) {
            listener(model.listener);
            policyNames(model.policyNames);
        }

        public final Listener.Builder getListener() {
            return listener != null ? listener.toBuilder() : null;
        }

        public final void setListener(Listener.BuilderImpl listener) {
            this.listener = listener != null ? listener.build() : null;
        }

        @Override
        public final Builder listener(Listener listener) {
            this.listener = listener;
            return this;
        }

        public final Collection<String> getPolicyNames() {
            if (policyNames instanceof SdkAutoConstructList) {
                return null;
            }
            return policyNames;
        }

        public final void setPolicyNames(Collection<String> policyNames) {
            this.policyNames = PolicyNamesCopier.copy(policyNames);
        }

        @Override
        public final Builder policyNames(Collection<String> policyNames) {
            this.policyNames = PolicyNamesCopier.copy(policyNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyNames(String... policyNames) {
            policyNames(Arrays.asList(policyNames));
            return this;
        }

        @Override
        public ListenerDescription build() {
            return new ListenerDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
