/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for CreateLoadBalancerPolicy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLoadBalancerPolicyRequest extends ElasticLoadBalancingRequest implements
        ToCopyableBuilder<CreateLoadBalancerPolicyRequest.Builder, CreateLoadBalancerPolicyRequest> {
    private static final SdkField<String> LOAD_BALANCER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LoadBalancerName").getter(getter(CreateLoadBalancerPolicyRequest::loadBalancerName))
            .setter(setter(Builder::loadBalancerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerName").build()).build();

    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyName").getter(getter(CreateLoadBalancerPolicyRequest::policyName))
            .setter(setter(Builder::policyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyName").build()).build();

    private static final SdkField<String> POLICY_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyTypeName").getter(getter(CreateLoadBalancerPolicyRequest::policyTypeName))
            .setter(setter(Builder::policyTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyTypeName").build()).build();

    private static final SdkField<List<PolicyAttribute>> POLICY_ATTRIBUTES_FIELD = SdkField
            .<List<PolicyAttribute>> builder(MarshallingType.LIST)
            .memberName("PolicyAttributes")
            .getter(getter(CreateLoadBalancerPolicyRequest::policyAttributes))
            .setter(setter(Builder::policyAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PolicyAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(PolicyAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_BALANCER_NAME_FIELD,
            POLICY_NAME_FIELD, POLICY_TYPE_NAME_FIELD, POLICY_ATTRIBUTES_FIELD));

    private final String loadBalancerName;

    private final String policyName;

    private final String policyTypeName;

    private final List<PolicyAttribute> policyAttributes;

    private CreateLoadBalancerPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.loadBalancerName = builder.loadBalancerName;
        this.policyName = builder.policyName;
        this.policyTypeName = builder.policyTypeName;
        this.policyAttributes = builder.policyAttributes;
    }

    /**
     * <p>
     * The name of the load balancer.
     * </p>
     * 
     * @return The name of the load balancer.
     */
    public final String loadBalancerName() {
        return loadBalancerName;
    }

    /**
     * <p>
     * The name of the load balancer policy to be created. This name must be unique within the set of policies for this
     * load balancer.
     * </p>
     * 
     * @return The name of the load balancer policy to be created. This name must be unique within the set of policies
     *         for this load balancer.
     */
    public final String policyName() {
        return policyName;
    }

    /**
     * <p>
     * The name of the base policy type. To get the list of policy types, use <a>DescribeLoadBalancerPolicyTypes</a>.
     * </p>
     * 
     * @return The name of the base policy type. To get the list of policy types, use
     *         <a>DescribeLoadBalancerPolicyTypes</a>.
     */
    public final String policyTypeName() {
        return policyTypeName;
    }

    /**
     * For responses, this returns true if the service returned a value for the PolicyAttributes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPolicyAttributes() {
        return policyAttributes != null && !(policyAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The policy attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPolicyAttributes} method.
     * </p>
     * 
     * @return The policy attributes.
     */
    public final List<PolicyAttribute> policyAttributes() {
        return policyAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerName());
        hashCode = 31 * hashCode + Objects.hashCode(policyName());
        hashCode = 31 * hashCode + Objects.hashCode(policyTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(hasPolicyAttributes() ? policyAttributes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLoadBalancerPolicyRequest)) {
            return false;
        }
        CreateLoadBalancerPolicyRequest other = (CreateLoadBalancerPolicyRequest) obj;
        return Objects.equals(loadBalancerName(), other.loadBalancerName()) && Objects.equals(policyName(), other.policyName())
                && Objects.equals(policyTypeName(), other.policyTypeName())
                && hasPolicyAttributes() == other.hasPolicyAttributes()
                && Objects.equals(policyAttributes(), other.policyAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateLoadBalancerPolicyRequest").add("LoadBalancerName", loadBalancerName())
                .add("PolicyName", policyName()).add("PolicyTypeName", policyTypeName())
                .add("PolicyAttributes", hasPolicyAttributes() ? policyAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LoadBalancerName":
            return Optional.ofNullable(clazz.cast(loadBalancerName()));
        case "PolicyName":
            return Optional.ofNullable(clazz.cast(policyName()));
        case "PolicyTypeName":
            return Optional.ofNullable(clazz.cast(policyTypeName()));
        case "PolicyAttributes":
            return Optional.ofNullable(clazz.cast(policyAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLoadBalancerPolicyRequest, T> g) {
        return obj -> g.apply((CreateLoadBalancerPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticLoadBalancingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateLoadBalancerPolicyRequest> {
        /**
         * <p>
         * The name of the load balancer.
         * </p>
         * 
         * @param loadBalancerName
         *        The name of the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerName(String loadBalancerName);

        /**
         * <p>
         * The name of the load balancer policy to be created. This name must be unique within the set of policies for
         * this load balancer.
         * </p>
         * 
         * @param policyName
         *        The name of the load balancer policy to be created. This name must be unique within the set of
         *        policies for this load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyName(String policyName);

        /**
         * <p>
         * The name of the base policy type. To get the list of policy types, use
         * <a>DescribeLoadBalancerPolicyTypes</a>.
         * </p>
         * 
         * @param policyTypeName
         *        The name of the base policy type. To get the list of policy types, use
         *        <a>DescribeLoadBalancerPolicyTypes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyTypeName(String policyTypeName);

        /**
         * <p>
         * The policy attributes.
         * </p>
         * 
         * @param policyAttributes
         *        The policy attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyAttributes(Collection<PolicyAttribute> policyAttributes);

        /**
         * <p>
         * The policy attributes.
         * </p>
         * 
         * @param policyAttributes
         *        The policy attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyAttributes(PolicyAttribute... policyAttributes);

        /**
         * <p>
         * The policy attributes.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PolicyAttribute>.Builder} avoiding the need
         * to create one manually via {@link List<PolicyAttribute>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PolicyAttribute>.Builder#build()} is called immediately and
         * its result is passed to {@link #policyAttributes(List<PolicyAttribute>)}.
         * 
         * @param policyAttributes
         *        a consumer that will call methods on {@link List<PolicyAttribute>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policyAttributes(List<PolicyAttribute>)
         */
        Builder policyAttributes(Consumer<PolicyAttribute.Builder>... policyAttributes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticLoadBalancingRequest.BuilderImpl implements Builder {
        private String loadBalancerName;

        private String policyName;

        private String policyTypeName;

        private List<PolicyAttribute> policyAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLoadBalancerPolicyRequest model) {
            super(model);
            loadBalancerName(model.loadBalancerName);
            policyName(model.policyName);
            policyTypeName(model.policyTypeName);
            policyAttributes(model.policyAttributes);
        }

        public final String getLoadBalancerName() {
            return loadBalancerName;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        @Override
        @Transient
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final String getPolicyName() {
            return policyName;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @Override
        @Transient
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final String getPolicyTypeName() {
            return policyTypeName;
        }

        public final void setPolicyTypeName(String policyTypeName) {
            this.policyTypeName = policyTypeName;
        }

        @Override
        @Transient
        public final Builder policyTypeName(String policyTypeName) {
            this.policyTypeName = policyTypeName;
            return this;
        }

        public final List<PolicyAttribute.Builder> getPolicyAttributes() {
            List<PolicyAttribute.Builder> result = PolicyAttributesCopier.copyToBuilder(this.policyAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPolicyAttributes(Collection<PolicyAttribute.BuilderImpl> policyAttributes) {
            this.policyAttributes = PolicyAttributesCopier.copyFromBuilder(policyAttributes);
        }

        @Override
        @Transient
        public final Builder policyAttributes(Collection<PolicyAttribute> policyAttributes) {
            this.policyAttributes = PolicyAttributesCopier.copy(policyAttributes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder policyAttributes(PolicyAttribute... policyAttributes) {
            policyAttributes(Arrays.asList(policyAttributes));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder policyAttributes(Consumer<PolicyAttribute.Builder>... policyAttributes) {
            policyAttributes(Stream.of(policyAttributes).map(c -> PolicyAttribute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLoadBalancerPolicyRequest build() {
            return new CreateLoadBalancerPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
