/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeLoadBalancers.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeLoadBalancersResponse extends ElasticLoadBalancingResponse implements
        ToCopyableBuilder<DescribeLoadBalancersResponse.Builder, DescribeLoadBalancersResponse> {
    private static final SdkField<List<LoadBalancerDescription>> LOAD_BALANCER_DESCRIPTIONS_FIELD = SdkField
            .<List<LoadBalancerDescription>> builder(MarshallingType.LIST)
            .memberName("LoadBalancerDescriptions")
            .getter(getter(DescribeLoadBalancersResponse::loadBalancerDescriptions))
            .setter(setter(Builder::loadBalancerDescriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerDescriptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LoadBalancerDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(LoadBalancerDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextMarker").getter(getter(DescribeLoadBalancersResponse::nextMarker))
            .setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LOAD_BALANCER_DESCRIPTIONS_FIELD, NEXT_MARKER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("LoadBalancerDescriptions", LOAD_BALANCER_DESCRIPTIONS_FIELD);
                    put("NextMarker", NEXT_MARKER_FIELD);
                }
            });

    private final List<LoadBalancerDescription> loadBalancerDescriptions;

    private final String nextMarker;

    private DescribeLoadBalancersResponse(BuilderImpl builder) {
        super(builder);
        this.loadBalancerDescriptions = builder.loadBalancerDescriptions;
        this.nextMarker = builder.nextMarker;
    }

    /**
     * For responses, this returns true if the service returned a value for the LoadBalancerDescriptions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLoadBalancerDescriptions() {
        return loadBalancerDescriptions != null && !(loadBalancerDescriptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the load balancers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLoadBalancerDescriptions} method.
     * </p>
     * 
     * @return Information about the load balancers.
     */
    public final List<LoadBalancerDescription> loadBalancerDescriptions() {
        return loadBalancerDescriptions;
    }

    /**
     * <p>
     * The marker to use when requesting the next set of results. If there are no additional results, the string is
     * empty.
     * </p>
     * 
     * @return The marker to use when requesting the next set of results. If there are no additional results, the string
     *         is empty.
     */
    public final String nextMarker() {
        return nextMarker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLoadBalancerDescriptions() ? loadBalancerDescriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLoadBalancersResponse)) {
            return false;
        }
        DescribeLoadBalancersResponse other = (DescribeLoadBalancersResponse) obj;
        return hasLoadBalancerDescriptions() == other.hasLoadBalancerDescriptions()
                && Objects.equals(loadBalancerDescriptions(), other.loadBalancerDescriptions())
                && Objects.equals(nextMarker(), other.nextMarker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeLoadBalancersResponse")
                .add("LoadBalancerDescriptions", hasLoadBalancerDescriptions() ? loadBalancerDescriptions() : null)
                .add("NextMarker", nextMarker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LoadBalancerDescriptions":
            return Optional.ofNullable(clazz.cast(loadBalancerDescriptions()));
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLoadBalancersResponse, T> g) {
        return obj -> g.apply((DescribeLoadBalancersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticLoadBalancingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeLoadBalancersResponse> {
        /**
         * <p>
         * Information about the load balancers.
         * </p>
         * 
         * @param loadBalancerDescriptions
         *        Information about the load balancers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerDescriptions(Collection<LoadBalancerDescription> loadBalancerDescriptions);

        /**
         * <p>
         * Information about the load balancers.
         * </p>
         * 
         * @param loadBalancerDescriptions
         *        Information about the load balancers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerDescriptions(LoadBalancerDescription... loadBalancerDescriptions);

        /**
         * <p>
         * Information about the load balancers.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticloadbalancing.model.LoadBalancerDescription.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.elasticloadbalancing.model.LoadBalancerDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticloadbalancing.model.LoadBalancerDescription.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #loadBalancerDescriptions(List<LoadBalancerDescription>)}.
         * 
         * @param loadBalancerDescriptions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticloadbalancing.model.LoadBalancerDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loadBalancerDescriptions(java.util.Collection<LoadBalancerDescription>)
         */
        Builder loadBalancerDescriptions(Consumer<LoadBalancerDescription.Builder>... loadBalancerDescriptions);

        /**
         * <p>
         * The marker to use when requesting the next set of results. If there are no additional results, the string is
         * empty.
         * </p>
         * 
         * @param nextMarker
         *        The marker to use when requesting the next set of results. If there are no additional results, the
         *        string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);
    }

    static final class BuilderImpl extends ElasticLoadBalancingResponse.BuilderImpl implements Builder {
        private List<LoadBalancerDescription> loadBalancerDescriptions = DefaultSdkAutoConstructList.getInstance();

        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLoadBalancersResponse model) {
            super(model);
            loadBalancerDescriptions(model.loadBalancerDescriptions);
            nextMarker(model.nextMarker);
        }

        public final List<LoadBalancerDescription.Builder> getLoadBalancerDescriptions() {
            List<LoadBalancerDescription.Builder> result = LoadBalancerDescriptionsCopier
                    .copyToBuilder(this.loadBalancerDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLoadBalancerDescriptions(Collection<LoadBalancerDescription.BuilderImpl> loadBalancerDescriptions) {
            this.loadBalancerDescriptions = LoadBalancerDescriptionsCopier.copyFromBuilder(loadBalancerDescriptions);
        }

        @Override
        public final Builder loadBalancerDescriptions(Collection<LoadBalancerDescription> loadBalancerDescriptions) {
            this.loadBalancerDescriptions = LoadBalancerDescriptionsCopier.copy(loadBalancerDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerDescriptions(LoadBalancerDescription... loadBalancerDescriptions) {
            loadBalancerDescriptions(Arrays.asList(loadBalancerDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerDescriptions(Consumer<LoadBalancerDescription.Builder>... loadBalancerDescriptions) {
            loadBalancerDescriptions(Stream.of(loadBalancerDescriptions)
                    .map(c -> LoadBalancerDescription.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        @Override
        public DescribeLoadBalancersResponse build() {
            return new DescribeLoadBalancersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
