/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for CreateLBCookieStickinessPolicy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLbCookieStickinessPolicyRequest extends ElasticLoadBalancingRequest implements
        ToCopyableBuilder<CreateLbCookieStickinessPolicyRequest.Builder, CreateLbCookieStickinessPolicyRequest> {
    private static final SdkField<String> LOAD_BALANCER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LoadBalancerName").getter(getter(CreateLbCookieStickinessPolicyRequest::loadBalancerName))
            .setter(setter(Builder::loadBalancerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerName").build()).build();

    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyName").getter(getter(CreateLbCookieStickinessPolicyRequest::policyName))
            .setter(setter(Builder::policyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyName").build()).build();

    private static final SdkField<Long> COOKIE_EXPIRATION_PERIOD_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("CookieExpirationPeriod").getter(getter(CreateLbCookieStickinessPolicyRequest::cookieExpirationPeriod))
            .setter(setter(Builder::cookieExpirationPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CookieExpirationPeriod").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_BALANCER_NAME_FIELD,
            POLICY_NAME_FIELD, COOKIE_EXPIRATION_PERIOD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("LoadBalancerName", LOAD_BALANCER_NAME_FIELD);
                    put("PolicyName", POLICY_NAME_FIELD);
                    put("CookieExpirationPeriod", COOKIE_EXPIRATION_PERIOD_FIELD);
                }
            });

    private final String loadBalancerName;

    private final String policyName;

    private final Long cookieExpirationPeriod;

    private CreateLbCookieStickinessPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.loadBalancerName = builder.loadBalancerName;
        this.policyName = builder.policyName;
        this.cookieExpirationPeriod = builder.cookieExpirationPeriod;
    }

    /**
     * <p>
     * The name of the load balancer.
     * </p>
     * 
     * @return The name of the load balancer.
     */
    public final String loadBalancerName() {
        return loadBalancerName;
    }

    /**
     * <p>
     * The name of the policy being created. Policy names must consist of alphanumeric characters and dashes (-). This
     * name must be unique within the set of policies for this load balancer.
     * </p>
     * 
     * @return The name of the policy being created. Policy names must consist of alphanumeric characters and dashes
     *         (-). This name must be unique within the set of policies for this load balancer.
     */
    public final String policyName() {
        return policyName;
    }

    /**
     * <p>
     * The time period, in seconds, after which the cookie should be considered stale. If you do not specify this
     * parameter, the default value is 0, which indicates that the sticky session should last for the duration of the
     * browser session.
     * </p>
     * 
     * @return The time period, in seconds, after which the cookie should be considered stale. If you do not specify
     *         this parameter, the default value is 0, which indicates that the sticky session should last for the
     *         duration of the browser session.
     */
    public final Long cookieExpirationPeriod() {
        return cookieExpirationPeriod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerName());
        hashCode = 31 * hashCode + Objects.hashCode(policyName());
        hashCode = 31 * hashCode + Objects.hashCode(cookieExpirationPeriod());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLbCookieStickinessPolicyRequest)) {
            return false;
        }
        CreateLbCookieStickinessPolicyRequest other = (CreateLbCookieStickinessPolicyRequest) obj;
        return Objects.equals(loadBalancerName(), other.loadBalancerName()) && Objects.equals(policyName(), other.policyName())
                && Objects.equals(cookieExpirationPeriod(), other.cookieExpirationPeriod());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateLbCookieStickinessPolicyRequest").add("LoadBalancerName", loadBalancerName())
                .add("PolicyName", policyName()).add("CookieExpirationPeriod", cookieExpirationPeriod()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LoadBalancerName":
            return Optional.ofNullable(clazz.cast(loadBalancerName()));
        case "PolicyName":
            return Optional.ofNullable(clazz.cast(policyName()));
        case "CookieExpirationPeriod":
            return Optional.ofNullable(clazz.cast(cookieExpirationPeriod()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateLbCookieStickinessPolicyRequest, T> g) {
        return obj -> g.apply((CreateLbCookieStickinessPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticLoadBalancingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateLbCookieStickinessPolicyRequest> {
        /**
         * <p>
         * The name of the load balancer.
         * </p>
         * 
         * @param loadBalancerName
         *        The name of the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerName(String loadBalancerName);

        /**
         * <p>
         * The name of the policy being created. Policy names must consist of alphanumeric characters and dashes (-).
         * This name must be unique within the set of policies for this load balancer.
         * </p>
         * 
         * @param policyName
         *        The name of the policy being created. Policy names must consist of alphanumeric characters and dashes
         *        (-). This name must be unique within the set of policies for this load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyName(String policyName);

        /**
         * <p>
         * The time period, in seconds, after which the cookie should be considered stale. If you do not specify this
         * parameter, the default value is 0, which indicates that the sticky session should last for the duration of
         * the browser session.
         * </p>
         * 
         * @param cookieExpirationPeriod
         *        The time period, in seconds, after which the cookie should be considered stale. If you do not specify
         *        this parameter, the default value is 0, which indicates that the sticky session should last for the
         *        duration of the browser session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cookieExpirationPeriod(Long cookieExpirationPeriod);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticLoadBalancingRequest.BuilderImpl implements Builder {
        private String loadBalancerName;

        private String policyName;

        private Long cookieExpirationPeriod;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLbCookieStickinessPolicyRequest model) {
            super(model);
            loadBalancerName(model.loadBalancerName);
            policyName(model.policyName);
            cookieExpirationPeriod(model.cookieExpirationPeriod);
        }

        public final String getLoadBalancerName() {
            return loadBalancerName;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final String getPolicyName() {
            return policyName;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final Long getCookieExpirationPeriod() {
            return cookieExpirationPeriod;
        }

        public final void setCookieExpirationPeriod(Long cookieExpirationPeriod) {
            this.cookieExpirationPeriod = cookieExpirationPeriod;
        }

        @Override
        public final Builder cookieExpirationPeriod(Long cookieExpirationPeriod) {
            this.cookieExpirationPeriod = cookieExpirationPeriod;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLbCookieStickinessPolicyRequest build() {
            return new CreateLbCookieStickinessPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
