/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for SetLoadBalancePoliciesOfListener.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetLoadBalancerPoliciesOfListenerRequest extends ElasticLoadBalancingRequest implements
        ToCopyableBuilder<SetLoadBalancerPoliciesOfListenerRequest.Builder, SetLoadBalancerPoliciesOfListenerRequest> {
    private static final SdkField<String> LOAD_BALANCER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LoadBalancerName").getter(getter(SetLoadBalancerPoliciesOfListenerRequest::loadBalancerName))
            .setter(setter(Builder::loadBalancerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerName").build()).build();

    private static final SdkField<Integer> LOAD_BALANCER_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("LoadBalancerPort").getter(getter(SetLoadBalancerPoliciesOfListenerRequest::loadBalancerPort))
            .setter(setter(Builder::loadBalancerPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerPort").build()).build();

    private static final SdkField<List<String>> POLICY_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PolicyNames")
            .getter(getter(SetLoadBalancerPoliciesOfListenerRequest::policyNames))
            .setter(setter(Builder::policyNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_BALANCER_NAME_FIELD,
            LOAD_BALANCER_PORT_FIELD, POLICY_NAMES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("LoadBalancerName", LOAD_BALANCER_NAME_FIELD);
                    put("LoadBalancerPort", LOAD_BALANCER_PORT_FIELD);
                    put("PolicyNames", POLICY_NAMES_FIELD);
                }
            });

    private final String loadBalancerName;

    private final Integer loadBalancerPort;

    private final List<String> policyNames;

    private SetLoadBalancerPoliciesOfListenerRequest(BuilderImpl builder) {
        super(builder);
        this.loadBalancerName = builder.loadBalancerName;
        this.loadBalancerPort = builder.loadBalancerPort;
        this.policyNames = builder.policyNames;
    }

    /**
     * <p>
     * The name of the load balancer.
     * </p>
     * 
     * @return The name of the load balancer.
     */
    public final String loadBalancerName() {
        return loadBalancerName;
    }

    /**
     * <p>
     * The external port of the load balancer.
     * </p>
     * 
     * @return The external port of the load balancer.
     */
    public final Integer loadBalancerPort() {
        return loadBalancerPort;
    }

    /**
     * For responses, this returns true if the service returned a value for the PolicyNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPolicyNames() {
        return policyNames != null && !(policyNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of the policies. This list must include all policies to be enabled. If you omit a policy that is
     * currently enabled, it is disabled. If the list is empty, all current policies are disabled.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPolicyNames} method.
     * </p>
     * 
     * @return The names of the policies. This list must include all policies to be enabled. If you omit a policy that
     *         is currently enabled, it is disabled. If the list is empty, all current policies are disabled.
     */
    public final List<String> policyNames() {
        return policyNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerName());
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerPort());
        hashCode = 31 * hashCode + Objects.hashCode(hasPolicyNames() ? policyNames() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetLoadBalancerPoliciesOfListenerRequest)) {
            return false;
        }
        SetLoadBalancerPoliciesOfListenerRequest other = (SetLoadBalancerPoliciesOfListenerRequest) obj;
        return Objects.equals(loadBalancerName(), other.loadBalancerName())
                && Objects.equals(loadBalancerPort(), other.loadBalancerPort()) && hasPolicyNames() == other.hasPolicyNames()
                && Objects.equals(policyNames(), other.policyNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SetLoadBalancerPoliciesOfListenerRequest").add("LoadBalancerName", loadBalancerName())
                .add("LoadBalancerPort", loadBalancerPort()).add("PolicyNames", hasPolicyNames() ? policyNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LoadBalancerName":
            return Optional.ofNullable(clazz.cast(loadBalancerName()));
        case "LoadBalancerPort":
            return Optional.ofNullable(clazz.cast(loadBalancerPort()));
        case "PolicyNames":
            return Optional.ofNullable(clazz.cast(policyNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SetLoadBalancerPoliciesOfListenerRequest, T> g) {
        return obj -> g.apply((SetLoadBalancerPoliciesOfListenerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticLoadBalancingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, SetLoadBalancerPoliciesOfListenerRequest> {
        /**
         * <p>
         * The name of the load balancer.
         * </p>
         * 
         * @param loadBalancerName
         *        The name of the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerName(String loadBalancerName);

        /**
         * <p>
         * The external port of the load balancer.
         * </p>
         * 
         * @param loadBalancerPort
         *        The external port of the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerPort(Integer loadBalancerPort);

        /**
         * <p>
         * The names of the policies. This list must include all policies to be enabled. If you omit a policy that is
         * currently enabled, it is disabled. If the list is empty, all current policies are disabled.
         * </p>
         * 
         * @param policyNames
         *        The names of the policies. This list must include all policies to be enabled. If you omit a policy
         *        that is currently enabled, it is disabled. If the list is empty, all current policies are disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyNames(Collection<String> policyNames);

        /**
         * <p>
         * The names of the policies. This list must include all policies to be enabled. If you omit a policy that is
         * currently enabled, it is disabled. If the list is empty, all current policies are disabled.
         * </p>
         * 
         * @param policyNames
         *        The names of the policies. This list must include all policies to be enabled. If you omit a policy
         *        that is currently enabled, it is disabled. If the list is empty, all current policies are disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyNames(String... policyNames);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticLoadBalancingRequest.BuilderImpl implements Builder {
        private String loadBalancerName;

        private Integer loadBalancerPort;

        private List<String> policyNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SetLoadBalancerPoliciesOfListenerRequest model) {
            super(model);
            loadBalancerName(model.loadBalancerName);
            loadBalancerPort(model.loadBalancerPort);
            policyNames(model.policyNames);
        }

        public final String getLoadBalancerName() {
            return loadBalancerName;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final Integer getLoadBalancerPort() {
            return loadBalancerPort;
        }

        public final void setLoadBalancerPort(Integer loadBalancerPort) {
            this.loadBalancerPort = loadBalancerPort;
        }

        @Override
        public final Builder loadBalancerPort(Integer loadBalancerPort) {
            this.loadBalancerPort = loadBalancerPort;
            return this;
        }

        public final Collection<String> getPolicyNames() {
            if (policyNames instanceof SdkAutoConstructList) {
                return null;
            }
            return policyNames;
        }

        public final void setPolicyNames(Collection<String> policyNames) {
            this.policyNames = PolicyNamesCopier.copy(policyNames);
        }

        @Override
        public final Builder policyNames(Collection<String> policyNames) {
            this.policyNames = PolicyNamesCopier.copy(policyNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyNames(String... policyNames) {
            policyNames(Arrays.asList(policyNames));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetLoadBalancerPoliciesOfListenerRequest build() {
            return new SetLoadBalancerPoliciesOfListenerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
