/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LBCookieStickinessPolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LBCookieStickinessPolicy> {
    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyName").getter(LBCookieStickinessPolicy.getter(LBCookieStickinessPolicy::policyName)).setter(LBCookieStickinessPolicy.setter(Builder::policyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyName").build()}).build();
    private static final SdkField<Long> COOKIE_EXPIRATION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("CookieExpirationPeriod").getter(LBCookieStickinessPolicy.getter(LBCookieStickinessPolicy::cookieExpirationPeriod)).setter(LBCookieStickinessPolicy.setter(Builder::cookieExpirationPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CookieExpirationPeriod").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_NAME_FIELD, COOKIE_EXPIRATION_PERIOD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("PolicyName", POLICY_NAME_FIELD);
            this.put("CookieExpirationPeriod", COOKIE_EXPIRATION_PERIOD_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String policyName;
    private final Long cookieExpirationPeriod;

    private LBCookieStickinessPolicy(BuilderImpl builder) {
        this.policyName = builder.policyName;
        this.cookieExpirationPeriod = builder.cookieExpirationPeriod;
    }

    public final String policyName() {
        return this.policyName;
    }

    public final Long cookieExpirationPeriod() {
        return this.cookieExpirationPeriod;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.cookieExpirationPeriod());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LBCookieStickinessPolicy)) {
            return false;
        }
        LBCookieStickinessPolicy other = (LBCookieStickinessPolicy)obj;
        return Objects.equals(this.policyName(), other.policyName()) && Objects.equals(this.cookieExpirationPeriod(), other.cookieExpirationPeriod());
    }

    public final String toString() {
        return ToString.builder((String)"LBCookieStickinessPolicy").add("PolicyName", (Object)this.policyName()).add("CookieExpirationPeriod", (Object)this.cookieExpirationPeriod()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyName": {
                return Optional.ofNullable(clazz.cast(this.policyName()));
            }
            case "CookieExpirationPeriod": {
                return Optional.ofNullable(clazz.cast(this.cookieExpirationPeriod()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LBCookieStickinessPolicy, T> g) {
        return obj -> g.apply((LBCookieStickinessPolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String policyName;
        private Long cookieExpirationPeriod;

        private BuilderImpl() {
        }

        private BuilderImpl(LBCookieStickinessPolicy model) {
            this.policyName(model.policyName);
            this.cookieExpirationPeriod(model.cookieExpirationPeriod);
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final Long getCookieExpirationPeriod() {
            return this.cookieExpirationPeriod;
        }

        public final void setCookieExpirationPeriod(Long cookieExpirationPeriod) {
            this.cookieExpirationPeriod = cookieExpirationPeriod;
        }

        @Override
        public final Builder cookieExpirationPeriod(Long cookieExpirationPeriod) {
            this.cookieExpirationPeriod = cookieExpirationPeriod;
            return this;
        }

        public LBCookieStickinessPolicy build() {
            return new LBCookieStickinessPolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LBCookieStickinessPolicy> {
        public Builder policyName(String var1);

        public Builder cookieExpirationPeriod(Long var1);
    }
}

