/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeLoadBalancerPolicyTypes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeLoadBalancerPolicyTypesRequest extends ElasticLoadBalancingRequest implements
        ToCopyableBuilder<DescribeLoadBalancerPolicyTypesRequest.Builder, DescribeLoadBalancerPolicyTypesRequest> {
    private static final SdkField<List<String>> POLICY_TYPE_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PolicyTypeNames")
            .getter(getter(DescribeLoadBalancerPolicyTypesRequest::policyTypeNames))
            .setter(setter(Builder::policyTypeNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyTypeNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_TYPE_NAMES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> policyTypeNames;

    private DescribeLoadBalancerPolicyTypesRequest(BuilderImpl builder) {
        super(builder);
        this.policyTypeNames = builder.policyTypeNames;
    }

    /**
     * For responses, this returns true if the service returned a value for the PolicyTypeNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPolicyTypeNames() {
        return policyTypeNames != null && !(policyTypeNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of the policy types. If no names are specified, describes all policy types defined by Elastic Load
     * Balancing.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPolicyTypeNames} method.
     * </p>
     * 
     * @return The names of the policy types. If no names are specified, describes all policy types defined by Elastic
     *         Load Balancing.
     */
    public final List<String> policyTypeNames() {
        return policyTypeNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPolicyTypeNames() ? policyTypeNames() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLoadBalancerPolicyTypesRequest)) {
            return false;
        }
        DescribeLoadBalancerPolicyTypesRequest other = (DescribeLoadBalancerPolicyTypesRequest) obj;
        return hasPolicyTypeNames() == other.hasPolicyTypeNames() && Objects.equals(policyTypeNames(), other.policyTypeNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeLoadBalancerPolicyTypesRequest")
                .add("PolicyTypeNames", hasPolicyTypeNames() ? policyTypeNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyTypeNames":
            return Optional.ofNullable(clazz.cast(policyTypeNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PolicyTypeNames", POLICY_TYPE_NAMES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeLoadBalancerPolicyTypesRequest, T> g) {
        return obj -> g.apply((DescribeLoadBalancerPolicyTypesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticLoadBalancingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeLoadBalancerPolicyTypesRequest> {
        /**
         * <p>
         * The names of the policy types. If no names are specified, describes all policy types defined by Elastic Load
         * Balancing.
         * </p>
         * 
         * @param policyTypeNames
         *        The names of the policy types. If no names are specified, describes all policy types defined by
         *        Elastic Load Balancing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyTypeNames(Collection<String> policyTypeNames);

        /**
         * <p>
         * The names of the policy types. If no names are specified, describes all policy types defined by Elastic Load
         * Balancing.
         * </p>
         * 
         * @param policyTypeNames
         *        The names of the policy types. If no names are specified, describes all policy types defined by
         *        Elastic Load Balancing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyTypeNames(String... policyTypeNames);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticLoadBalancingRequest.BuilderImpl implements Builder {
        private List<String> policyTypeNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLoadBalancerPolicyTypesRequest model) {
            super(model);
            policyTypeNames(model.policyTypeNames);
        }

        public final Collection<String> getPolicyTypeNames() {
            if (policyTypeNames instanceof SdkAutoConstructList) {
                return null;
            }
            return policyTypeNames;
        }

        public final void setPolicyTypeNames(Collection<String> policyTypeNames) {
            this.policyTypeNames = PolicyTypeNamesCopier.copy(policyTypeNames);
        }

        @Override
        public final Builder policyTypeNames(Collection<String> policyTypeNames) {
            this.policyTypeNames = PolicyTypeNamesCopier.copy(policyTypeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyTypeNames(String... policyTypeNames) {
            policyTypeNames(Arrays.asList(policyTypeNames));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeLoadBalancerPolicyTypesRequest build() {
            return new DescribeLoadBalancerPolicyTypesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
