/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.elasticloadbalancing.ElasticLoadBalancingAsyncClient;
import software.amazon.awssdk.services.elasticloadbalancing.ElasticLoadBalancingServiceClientConfiguration;
import software.amazon.awssdk.services.elasticloadbalancing.internal.ElasticLoadBalancingServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.elasticloadbalancing.model.AddTagsRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.AddTagsResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.AttachLoadBalancerToSubnetsRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.AttachLoadBalancerToSubnetsResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.CertificateNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancing.model.ConfigureHealthCheckRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.ConfigureHealthCheckResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateAppCookieStickinessPolicyRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateAppCookieStickinessPolicyResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateLbCookieStickinessPolicyRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateLbCookieStickinessPolicyResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerListenersRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerListenersResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerPolicyRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerPolicyResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DeleteLoadBalancerListenersRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DeleteLoadBalancerListenersResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DeleteLoadBalancerPolicyRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DeleteLoadBalancerPolicyResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DeleteLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DeleteLoadBalancerResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DependencyThrottleException;
import software.amazon.awssdk.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeAccountLimitsRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeAccountLimitsResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeInstanceHealthRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeInstanceHealthResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerAttributesRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerAttributesResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerPoliciesRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerPoliciesResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancersRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancersResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeTagsRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeTagsResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DetachLoadBalancerFromSubnetsRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DetachLoadBalancerFromSubnetsResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DuplicateListenerException;
import software.amazon.awssdk.services.elasticloadbalancing.model.DuplicateLoadBalancerNameException;
import software.amazon.awssdk.services.elasticloadbalancing.model.DuplicatePolicyNameException;
import software.amazon.awssdk.services.elasticloadbalancing.model.DuplicateTagKeysException;
import software.amazon.awssdk.services.elasticloadbalancing.model.ElasticLoadBalancingException;
import software.amazon.awssdk.services.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.InvalidConfigurationRequestException;
import software.amazon.awssdk.services.elasticloadbalancing.model.InvalidInstanceException;
import software.amazon.awssdk.services.elasticloadbalancing.model.InvalidSchemeException;
import software.amazon.awssdk.services.elasticloadbalancing.model.InvalidSecurityGroupException;
import software.amazon.awssdk.services.elasticloadbalancing.model.InvalidSubnetException;
import software.amazon.awssdk.services.elasticloadbalancing.model.ListenerNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancing.model.LoadBalancerAttributeNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancing.model.LoadBalancerNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancing.model.ModifyLoadBalancerAttributesRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.ModifyLoadBalancerAttributesResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.OperationNotPermittedException;
import software.amazon.awssdk.services.elasticloadbalancing.model.PolicyNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancing.model.PolicyTypeNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.RemoveTagsRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.RemoveTagsResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.SetLoadBalancerListenerSslCertificateRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.SetLoadBalancerListenerSslCertificateResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.SetLoadBalancerPoliciesForBackendServerRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.SetLoadBalancerPoliciesForBackendServerResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.SubnetNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancing.model.TooManyLoadBalancersException;
import software.amazon.awssdk.services.elasticloadbalancing.model.TooManyPoliciesException;
import software.amazon.awssdk.services.elasticloadbalancing.model.TooManyTagsException;
import software.amazon.awssdk.services.elasticloadbalancing.model.UnsupportedProtocolException;
import software.amazon.awssdk.services.elasticloadbalancing.transform.AddTagsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.ApplySecurityGroupsToLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.AttachLoadBalancerToSubnetsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.ConfigureHealthCheckRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.CreateAppCookieStickinessPolicyRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.CreateLbCookieStickinessPolicyRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.CreateLoadBalancerListenersRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.CreateLoadBalancerPolicyRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.CreateLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DeleteLoadBalancerListenersRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DeleteLoadBalancerPolicyRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DeleteLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DeregisterInstancesFromLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DescribeAccountLimitsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DescribeInstanceHealthRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DescribeLoadBalancerAttributesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DescribeLoadBalancerPoliciesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DescribeLoadBalancerPolicyTypesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DescribeLoadBalancersRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DescribeTagsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DetachLoadBalancerFromSubnetsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DisableAvailabilityZonesForLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.EnableAvailabilityZonesForLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.ModifyLoadBalancerAttributesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.RegisterInstancesWithLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.RemoveTagsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.SetLoadBalancerListenerSslCertificateRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.SetLoadBalancerPoliciesForBackendServerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.SetLoadBalancerPoliciesOfListenerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.waiters.ElasticLoadBalancingAsyncWaiter;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultElasticLoadBalancingAsyncClient
implements ElasticLoadBalancingAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultElasticLoadBalancingAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.QUERY).build();
    private final AsyncClientHandler clientHandler;
    private final AwsQueryProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final ScheduledExecutorService executorService;

    protected DefaultElasticLoadBalancingAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Elastic_Load_Balancing#2.33.x").build();
        this.protocolFactory = this.init();
        this.executorService = (ScheduledExecutorService)clientConfiguration.option((ClientOption)SdkClientOption.SCHEDULED_EXECUTOR_SERVICE);
    }

    @Override
    public CompletableFuture<AddTagsResponse> addTags(AddTagsRequest addTagsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingAsyncClient.resolveMetricPublishers(clientConfiguration, addTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddTags");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AddTagsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddTags").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AddTagsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)addTagsRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultElasticLoadBalancingAsyncClient.lambda$addTags$1(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingAsyncClient.lambda$addTags$2((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ApplySecurityGroupsToLoadBalancerResponse> applySecurityGroupsToLoadBalancer(ApplySecurityGroupsToLoadBalancerRequest applySecurityGroupsToLoadBalancerRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)applySecurityGroupsToLoadBalancerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingAsyncClient.resolveMetricPublishers(clientConfiguration, applySecurityGroupsToLoadBalancerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ApplySecurityGroupsToLoadBalancer");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ApplySecurityGroupsToLoadBalancerResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ApplySecurityGroupsToLoadBalancer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ApplySecurityGroupsToLoadBalancerRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)applySecurityGroupsToLoadBalancerRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultElasticLoadBalancingAsyncClient.lambda$applySecurityGroupsToLoadBalancer$4(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingAsyncClient.lambda$applySecurityGroupsToLoadBalancer$5((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AttachLoadBalancerToSubnetsResponse> attachLoadBalancerToSubnets(AttachLoadBalancerToSubnetsRequest attachLoadBalancerToSubnetsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)attachLoadBalancerToSubnetsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingAsyncClient.resolveMetricPublishers(clientConfiguration, attachLoadBalancerToSubnetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AttachLoadBalancerToSubnets");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AttachLoadBalancerToSubnetsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AttachLoadBalancerToSubnets").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AttachLoadBalancerToSubnetsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)attachLoadBalancerToSubnetsRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultElasticLoadBalancingAsyncClient.lambda$attachLoadBalancerToSubnets$7(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingAsyncClient.lambda$attachLoadBalancerToSubnets$8((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ConfigureHealthCheckResponse> configureHealthCheck(ConfigureHealthCheckRequest configureHealthCheckRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)configureHealthCheckRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingAsyncClient.resolveMetricPublishers(clientConfiguration, configureHealthCheckRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ConfigureHealthCheck");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ConfigureHealthCheckResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ConfigureHealthCheck").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ConfigureHealthCheckRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)configureHealthCheckRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultElasticLoadBalancingAsyncClient.lambda$configureHealthCheck$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingAsyncClient.lambda$configureHealthCheck$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateAppCookieStickinessPolicyResponse> createAppCookieStickinessPolicy(CreateAppCookieStickinessPolicyRequest createAppCookieStickinessPolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createAppCookieStickinessPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingAsyncClient.resolveMetricPublishers(clientConfiguration, createAppCookieStickinessPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAppCookieStickinessPolicy");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateAppCookieStickinessPolicyResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAppCookieStickinessPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateAppCookieStickinessPolicyRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createAppCookieStickinessPolicyRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultElasticLoadBalancingAsyncClient.lambda$createAppCookieStickinessPolicy$13(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingAsyncClient.lambda$createAppCookieStickinessPolicy$14((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateLbCookieStickinessPolicyResponse> createLBCookieStickinessPolicy(CreateLbCookieStickinessPolicyRequest createLbCookieStickinessPolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createLbCookieStickinessPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingAsyncClient.resolveMetricPublishers(clientConfiguration, createLbCookieStickinessPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateLBCookieStickinessPolicy");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateLbCookieStickinessPolicyResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLBCookieStickinessPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateLbCookieStickinessPolicyRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createLbCookieStickinessPolicyRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultElasticLoadBalancingAsyncClient.lambda$createLBCookieStickinessPolicy$16(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingAsyncClient.lambda$createLBCookieStickinessPolicy$17((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateLoadBalancerResponse> createLoadBalancer(CreateLoadBalancerRequest createLoadBalancerRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createLoadBalancerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingAsyncClient.resolveMetricPublishers(clientConfiguration, createLoadBalancerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateLoadBalancer");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateLoadBalancerResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLoadBalancer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateLoadBalancerRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createLoadBalancerRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultElasticLoadBalancingAsyncClient.lambda$createLoadBalancer$19(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingAsyncClient.lambda$createLoadBalancer$20((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateLoadBalancerListenersResponse> createLoadBalancerListeners(CreateLoadBalancerListenersRequest createLoadBalancerListenersRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createLoadBalancerListenersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingAsyncClient.resolveMetricPublishers(clientConfiguration, createLoadBalancerListenersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateLoadBalancerListeners");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateLoadBalancerListenersResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLoadBalancerListeners").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateLoadBalancerListenersRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createLoadBalancerListenersRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultElasticLoadBalancingAsyncClient.lambda$createLoadBalancerListeners$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingAsyncClient.lambda$createLoadBalancerListeners$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateLoadBalancerPolicyResponse> createLoadBalancerPolicy(CreateLoadBalancerPolicyRequest createLoadBalancerPolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createLoadBalancerPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingAsyncClient.resolveMetricPublishers(clientConfiguration, createLoadBalancerPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateLoadBalancerPolicy");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateLoadBalancerPolicyResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLoadBalancerPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateLoadBalancerPolicyRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createLoadBalancerPolicyRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultElasticLoadBalancingAsyncClient.lambda$createLoadBalancerPolicy$25(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingAsyncClient.lambda$createLoadBalancerPolicy$26((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteLoadBalancerResponse> deleteLoadBalancer(DeleteLoadBalancerRequest deleteLoadBalancerRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteLoadBalancerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingAsyncClient.resolveMetricPublishers(clientConfiguration, deleteLoadBalancerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteLoadBalancer");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteLoadBalancerResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLoadBalancer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteLoadBalancerRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteLoadBalancerRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultElasticLoadBalancingAsyncClient.lambda$deleteLoadBalancer$28(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingAsyncClient.lambda$deleteLoadBalancer$29((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteLoadBalancerListenersResponse> deleteLoadBalancerListeners(DeleteLoadBalancerListenersRequest deleteLoadBalancerListenersRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteLoadBalancerListenersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingAsyncClient.resolveMetricPublishers(clientConfiguration, deleteLoadBalancerListenersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteLoadBalancerListeners");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteLoadBalancerListenersResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLoadBalancerListeners").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteLoadBalancerListenersRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteLoadBalancerListenersRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultElasticLoadBalancingAsyncClient.lambda$deleteLoadBalancerListeners$31(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingAsyncClient.lambda$deleteLoadBalancerListeners$32((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteLoadBalancerPolicyResponse> deleteLoadBalancerPolicy(DeleteLoadBalancerPolicyRequest deleteLoadBalancerPolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteLoadBalancerPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingAsyncClient.resolveMetricPublishers(clientConfiguration, deleteLoadBalancerPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteLoadBalancerPolicy");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteLoadBalancerPolicyResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLoadBalancerPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteLoadBalancerPolicyRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteLoadBalancerPolicyRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultElasticLoadBalancingAsyncClient.lambda$deleteLoadBalancerPolicy$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingAsyncClient.lambda$deleteLoadBalancerPolicy$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeregisterInstancesFromLoadBalancerResponse> deregisterInstancesFromLoadBalancer(DeregisterInstancesFromLoadBalancerRequest deregisterInstancesFromLoadBalancerRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deregisterInstancesFromLoadBalancerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingAsyncClient.resolveMetricPublishers(clientConfiguration, deregisterInstancesFromLoadBalancerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeregisterInstancesFromLoadBalancer");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeregisterInstancesFromLoadBalancerResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeregisterInstancesFromLoadBalancer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeregisterInstancesFromLoadBalancerRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deregisterInstancesFromLoadBalancerRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultElasticLoadBalancingAsyncClient.lambda$deregisterInstancesFromLoadBalancer$37(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingAsyncClient.lambda$deregisterInstancesFromLoadBalancer$38((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeAccountLimitsResponse> describeAccountLimits(DescribeAccountLimitsRequest describeAccountLimitsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeAccountLimitsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingAsyncClient.resolveMetricPublishers(clientConfiguration, describeAccountLimitsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAccountLimits");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeAccountLimitsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAccountLimits").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeAccountLimitsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeAccountLimitsRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultElasticLoadBalancingAsyncClient.lambda$describeAccountLimits$40(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingAsyncClient.lambda$describeAccountLimits$41((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeInstanceHealthResponse> describeInstanceHealth(DescribeInstanceHealthRequest describeInstanceHealthRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeInstanceHealthRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingAsyncClient.resolveMetricPublishers(clientConfiguration, describeInstanceHealthRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeInstanceHealth");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeInstanceHealthResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeInstanceHealth").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeInstanceHealthRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeInstanceHealthRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultElasticLoadBalancingAsyncClient.lambda$describeInstanceHealth$43(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingAsyncClient.lambda$describeInstanceHealth$44((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeLoadBalancerAttributesResponse> describeLoadBalancerAttributes(DescribeLoadBalancerAttributesRequest describeLoadBalancerAttributesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeLoadBalancerAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingAsyncClient.resolveMetricPublishers(clientConfiguration, describeLoadBalancerAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeLoadBalancerAttributes");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeLoadBalancerAttributesResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLoadBalancerAttributes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeLoadBalancerAttributesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeLoadBalancerAttributesRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultElasticLoadBalancingAsyncClient.lambda$describeLoadBalancerAttributes$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingAsyncClient.lambda$describeLoadBalancerAttributes$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeLoadBalancerPoliciesResponse> describeLoadBalancerPolicies(DescribeLoadBalancerPoliciesRequest describeLoadBalancerPoliciesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeLoadBalancerPoliciesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingAsyncClient.resolveMetricPublishers(clientConfiguration, describeLoadBalancerPoliciesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeLoadBalancerPolicies");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeLoadBalancerPoliciesResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLoadBalancerPolicies").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeLoadBalancerPoliciesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeLoadBalancerPoliciesRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultElasticLoadBalancingAsyncClient.lambda$describeLoadBalancerPolicies$49(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingAsyncClient.lambda$describeLoadBalancerPolicies$50((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeLoadBalancerPolicyTypesResponse> describeLoadBalancerPolicyTypes(DescribeLoadBalancerPolicyTypesRequest describeLoadBalancerPolicyTypesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeLoadBalancerPolicyTypesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingAsyncClient.resolveMetricPublishers(clientConfiguration, describeLoadBalancerPolicyTypesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeLoadBalancerPolicyTypes");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeLoadBalancerPolicyTypesResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLoadBalancerPolicyTypes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeLoadBalancerPolicyTypesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeLoadBalancerPolicyTypesRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultElasticLoadBalancingAsyncClient.lambda$describeLoadBalancerPolicyTypes$52(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingAsyncClient.lambda$describeLoadBalancerPolicyTypes$53((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeLoadBalancersResponse> describeLoadBalancers(DescribeLoadBalancersRequest describeLoadBalancersRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeLoadBalancersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingAsyncClient.resolveMetricPublishers(clientConfiguration, describeLoadBalancersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeLoadBalancers");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeLoadBalancersResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLoadBalancers").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeLoadBalancersRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeLoadBalancersRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultElasticLoadBalancingAsyncClient.lambda$describeLoadBalancers$55(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingAsyncClient.lambda$describeLoadBalancers$56((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeTagsResponse> describeTags(DescribeTagsRequest describeTagsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingAsyncClient.resolveMetricPublishers(clientConfiguration, describeTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTags");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeTagsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTags").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeTagsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeTagsRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultElasticLoadBalancingAsyncClient.lambda$describeTags$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingAsyncClient.lambda$describeTags$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DetachLoadBalancerFromSubnetsResponse> detachLoadBalancerFromSubnets(DetachLoadBalancerFromSubnetsRequest detachLoadBalancerFromSubnetsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)detachLoadBalancerFromSubnetsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingAsyncClient.resolveMetricPublishers(clientConfiguration, detachLoadBalancerFromSubnetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetachLoadBalancerFromSubnets");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DetachLoadBalancerFromSubnetsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetachLoadBalancerFromSubnets").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DetachLoadBalancerFromSubnetsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)detachLoadBalancerFromSubnetsRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultElasticLoadBalancingAsyncClient.lambda$detachLoadBalancerFromSubnets$61(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingAsyncClient.lambda$detachLoadBalancerFromSubnets$62((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DisableAvailabilityZonesForLoadBalancerResponse> disableAvailabilityZonesForLoadBalancer(DisableAvailabilityZonesForLoadBalancerRequest disableAvailabilityZonesForLoadBalancerRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disableAvailabilityZonesForLoadBalancerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingAsyncClient.resolveMetricPublishers(clientConfiguration, disableAvailabilityZonesForLoadBalancerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableAvailabilityZonesForLoadBalancer");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DisableAvailabilityZonesForLoadBalancerResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableAvailabilityZonesForLoadBalancer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DisableAvailabilityZonesForLoadBalancerRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)disableAvailabilityZonesForLoadBalancerRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultElasticLoadBalancingAsyncClient.lambda$disableAvailabilityZonesForLoadBalancer$64(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingAsyncClient.lambda$disableAvailabilityZonesForLoadBalancer$65((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<EnableAvailabilityZonesForLoadBalancerResponse> enableAvailabilityZonesForLoadBalancer(EnableAvailabilityZonesForLoadBalancerRequest enableAvailabilityZonesForLoadBalancerRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)enableAvailabilityZonesForLoadBalancerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingAsyncClient.resolveMetricPublishers(clientConfiguration, enableAvailabilityZonesForLoadBalancerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableAvailabilityZonesForLoadBalancer");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(EnableAvailabilityZonesForLoadBalancerResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableAvailabilityZonesForLoadBalancer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new EnableAvailabilityZonesForLoadBalancerRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)enableAvailabilityZonesForLoadBalancerRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultElasticLoadBalancingAsyncClient.lambda$enableAvailabilityZonesForLoadBalancer$67(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingAsyncClient.lambda$enableAvailabilityZonesForLoadBalancer$68((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifyLoadBalancerAttributesResponse> modifyLoadBalancerAttributes(ModifyLoadBalancerAttributesRequest modifyLoadBalancerAttributesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)modifyLoadBalancerAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingAsyncClient.resolveMetricPublishers(clientConfiguration, modifyLoadBalancerAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyLoadBalancerAttributes");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyLoadBalancerAttributesResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyLoadBalancerAttributes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ModifyLoadBalancerAttributesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)modifyLoadBalancerAttributesRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultElasticLoadBalancingAsyncClient.lambda$modifyLoadBalancerAttributes$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingAsyncClient.lambda$modifyLoadBalancerAttributes$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RegisterInstancesWithLoadBalancerResponse> registerInstancesWithLoadBalancer(RegisterInstancesWithLoadBalancerRequest registerInstancesWithLoadBalancerRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)registerInstancesWithLoadBalancerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingAsyncClient.resolveMetricPublishers(clientConfiguration, registerInstancesWithLoadBalancerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterInstancesWithLoadBalancer");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RegisterInstancesWithLoadBalancerResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterInstancesWithLoadBalancer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RegisterInstancesWithLoadBalancerRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)registerInstancesWithLoadBalancerRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultElasticLoadBalancingAsyncClient.lambda$registerInstancesWithLoadBalancer$73(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingAsyncClient.lambda$registerInstancesWithLoadBalancer$74((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RemoveTagsResponse> removeTags(RemoveTagsRequest removeTagsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)removeTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingAsyncClient.resolveMetricPublishers(clientConfiguration, removeTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveTags");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RemoveTagsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveTags").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RemoveTagsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)removeTagsRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultElasticLoadBalancingAsyncClient.lambda$removeTags$76(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingAsyncClient.lambda$removeTags$77((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SetLoadBalancerListenerSslCertificateResponse> setLoadBalancerListenerSSLCertificate(SetLoadBalancerListenerSslCertificateRequest setLoadBalancerListenerSslCertificateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)setLoadBalancerListenerSslCertificateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingAsyncClient.resolveMetricPublishers(clientConfiguration, setLoadBalancerListenerSslCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetLoadBalancerListenerSSLCertificate");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetLoadBalancerListenerSslCertificateResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetLoadBalancerListenerSSLCertificate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new SetLoadBalancerListenerSslCertificateRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)setLoadBalancerListenerSslCertificateRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultElasticLoadBalancingAsyncClient.lambda$setLoadBalancerListenerSSLCertificate$79(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingAsyncClient.lambda$setLoadBalancerListenerSSLCertificate$80((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SetLoadBalancerPoliciesForBackendServerResponse> setLoadBalancerPoliciesForBackendServer(SetLoadBalancerPoliciesForBackendServerRequest setLoadBalancerPoliciesForBackendServerRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)setLoadBalancerPoliciesForBackendServerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingAsyncClient.resolveMetricPublishers(clientConfiguration, setLoadBalancerPoliciesForBackendServerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetLoadBalancerPoliciesForBackendServer");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetLoadBalancerPoliciesForBackendServerResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetLoadBalancerPoliciesForBackendServer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new SetLoadBalancerPoliciesForBackendServerRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)setLoadBalancerPoliciesForBackendServerRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultElasticLoadBalancingAsyncClient.lambda$setLoadBalancerPoliciesForBackendServer$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingAsyncClient.lambda$setLoadBalancerPoliciesForBackendServer$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SetLoadBalancerPoliciesOfListenerResponse> setLoadBalancerPoliciesOfListener(SetLoadBalancerPoliciesOfListenerRequest setLoadBalancerPoliciesOfListenerRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)setLoadBalancerPoliciesOfListenerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingAsyncClient.resolveMetricPublishers(clientConfiguration, setLoadBalancerPoliciesOfListenerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetLoadBalancerPoliciesOfListener");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetLoadBalancerPoliciesOfListenerResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetLoadBalancerPoliciesOfListener").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new SetLoadBalancerPoliciesOfListenerRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)setLoadBalancerPoliciesOfListenerRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultElasticLoadBalancingAsyncClient.lambda$setLoadBalancerPoliciesOfListener$85(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingAsyncClient.lambda$setLoadBalancerPoliciesOfListener$86((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ElasticLoadBalancingAsyncWaiter waiter() {
        return ElasticLoadBalancingAsyncWaiter.builder().client(this).scheduledExecutorService(this.executorService).build();
    }

    @Override
    public final ElasticLoadBalancingServiceClientConfiguration serviceClientConfiguration() {
        return new ElasticLoadBalancingServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "elasticloadbalancing";
    }

    private AwsQueryProtocolFactory init() {
        return AwsQueryProtocolFactory.builder().registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedProtocol").exceptionBuilderSupplier(UnsupportedProtocolException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LoadBalancerAttributeNotFound").exceptionBuilderSupplier(LoadBalancerAttributeNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LoadBalancerNotFound").exceptionBuilderSupplier(LoadBalancerNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyLoadBalancers").exceptionBuilderSupplier(TooManyLoadBalancersException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidConfigurationRequest").exceptionBuilderSupplier(InvalidConfigurationRequestException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidSecurityGroup").exceptionBuilderSupplier(InvalidSecurityGroupException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DuplicateLoadBalancerName").exceptionBuilderSupplier(DuplicateLoadBalancerNameException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DependencyThrottle").exceptionBuilderSupplier(DependencyThrottleException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OperationNotPermitted").exceptionBuilderSupplier(OperationNotPermittedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PolicyNotFound").exceptionBuilderSupplier(PolicyNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CertificateNotFound").exceptionBuilderSupplier(CertificateNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DuplicateTagKeys").exceptionBuilderSupplier(DuplicateTagKeysException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyTags").exceptionBuilderSupplier(TooManyTagsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ListenerNotFound").exceptionBuilderSupplier(ListenerNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyPolicies").exceptionBuilderSupplier(TooManyPoliciesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DuplicatePolicyName").exceptionBuilderSupplier(DuplicatePolicyNameException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SubnetNotFound").exceptionBuilderSupplier(SubnetNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DuplicateListener").exceptionBuilderSupplier(DuplicateListenerException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidScheme").exceptionBuilderSupplier(InvalidSchemeException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PolicyTypeNotFound").exceptionBuilderSupplier(PolicyTypeNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidSubnet").exceptionBuilderSupplier(InvalidSubnetException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidInstance").exceptionBuilderSupplier(InvalidInstanceException::builder).httpStatusCode(Integer.valueOf(400)).build()).clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(ElasticLoadBalancingException::builder).build();
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        ElasticLoadBalancingServiceClientConfigurationBuilder serviceConfigBuilder = new ElasticLoadBalancingServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$setLoadBalancerPoliciesOfListener$86(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$setLoadBalancerPoliciesOfListener$85(List metricPublishers, MetricCollector apiCallMetricCollector, SetLoadBalancerPoliciesOfListenerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$setLoadBalancerPoliciesForBackendServer$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$setLoadBalancerPoliciesForBackendServer$82(List metricPublishers, MetricCollector apiCallMetricCollector, SetLoadBalancerPoliciesForBackendServerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$setLoadBalancerListenerSSLCertificate$80(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$setLoadBalancerListenerSSLCertificate$79(List metricPublishers, MetricCollector apiCallMetricCollector, SetLoadBalancerListenerSslCertificateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$removeTags$77(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$removeTags$76(List metricPublishers, MetricCollector apiCallMetricCollector, RemoveTagsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$registerInstancesWithLoadBalancer$74(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$registerInstancesWithLoadBalancer$73(List metricPublishers, MetricCollector apiCallMetricCollector, RegisterInstancesWithLoadBalancerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$modifyLoadBalancerAttributes$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifyLoadBalancerAttributes$70(List metricPublishers, MetricCollector apiCallMetricCollector, ModifyLoadBalancerAttributesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$enableAvailabilityZonesForLoadBalancer$68(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$enableAvailabilityZonesForLoadBalancer$67(List metricPublishers, MetricCollector apiCallMetricCollector, EnableAvailabilityZonesForLoadBalancerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$disableAvailabilityZonesForLoadBalancer$65(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disableAvailabilityZonesForLoadBalancer$64(List metricPublishers, MetricCollector apiCallMetricCollector, DisableAvailabilityZonesForLoadBalancerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$detachLoadBalancerFromSubnets$62(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detachLoadBalancerFromSubnets$61(List metricPublishers, MetricCollector apiCallMetricCollector, DetachLoadBalancerFromSubnetsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeTags$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTags$58(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeTagsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeLoadBalancers$56(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeLoadBalancers$55(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeLoadBalancersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeLoadBalancerPolicyTypes$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeLoadBalancerPolicyTypes$52(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeLoadBalancerPolicyTypesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeLoadBalancerPolicies$50(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeLoadBalancerPolicies$49(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeLoadBalancerPoliciesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeLoadBalancerAttributes$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeLoadBalancerAttributes$46(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeLoadBalancerAttributesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeInstanceHealth$44(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeInstanceHealth$43(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeInstanceHealthResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeAccountLimits$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAccountLimits$40(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeAccountLimitsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deregisterInstancesFromLoadBalancer$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deregisterInstancesFromLoadBalancer$37(List metricPublishers, MetricCollector apiCallMetricCollector, DeregisterInstancesFromLoadBalancerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteLoadBalancerPolicy$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteLoadBalancerPolicy$34(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteLoadBalancerPolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteLoadBalancerListeners$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteLoadBalancerListeners$31(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteLoadBalancerListenersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteLoadBalancer$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteLoadBalancer$28(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteLoadBalancerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createLoadBalancerPolicy$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createLoadBalancerPolicy$25(List metricPublishers, MetricCollector apiCallMetricCollector, CreateLoadBalancerPolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createLoadBalancerListeners$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createLoadBalancerListeners$22(List metricPublishers, MetricCollector apiCallMetricCollector, CreateLoadBalancerListenersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createLoadBalancer$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createLoadBalancer$19(List metricPublishers, MetricCollector apiCallMetricCollector, CreateLoadBalancerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createLBCookieStickinessPolicy$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createLBCookieStickinessPolicy$16(List metricPublishers, MetricCollector apiCallMetricCollector, CreateLbCookieStickinessPolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createAppCookieStickinessPolicy$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAppCookieStickinessPolicy$13(List metricPublishers, MetricCollector apiCallMetricCollector, CreateAppCookieStickinessPolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$configureHealthCheck$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$configureHealthCheck$10(List metricPublishers, MetricCollector apiCallMetricCollector, ConfigureHealthCheckResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$attachLoadBalancerToSubnets$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$attachLoadBalancerToSubnets$7(List metricPublishers, MetricCollector apiCallMetricCollector, AttachLoadBalancerToSubnetsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$applySecurityGroupsToLoadBalancer$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$applySecurityGroupsToLoadBalancer$4(List metricPublishers, MetricCollector apiCallMetricCollector, ApplySecurityGroupsToLoadBalancerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$addTags$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addTags$1(List metricPublishers, MetricCollector apiCallMetricCollector, AddTagsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

