/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for SetLoadBalancerListenerSSLCertificate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetLoadBalancerListenerSslCertificateRequest extends ElasticLoadBalancingRequest implements
        ToCopyableBuilder<SetLoadBalancerListenerSslCertificateRequest.Builder, SetLoadBalancerListenerSslCertificateRequest> {
    private static final SdkField<String> LOAD_BALANCER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LoadBalancerName").getter(getter(SetLoadBalancerListenerSslCertificateRequest::loadBalancerName))
            .setter(setter(Builder::loadBalancerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerName").build()).build();

    private static final SdkField<Integer> LOAD_BALANCER_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("LoadBalancerPort").getter(getter(SetLoadBalancerListenerSslCertificateRequest::loadBalancerPort))
            .setter(setter(Builder::loadBalancerPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerPort").build()).build();

    private static final SdkField<String> SSL_CERTIFICATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SSLCertificateId").getter(getter(SetLoadBalancerListenerSslCertificateRequest::sslCertificateId))
            .setter(setter(Builder::sslCertificateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SSLCertificateId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_BALANCER_NAME_FIELD,
            LOAD_BALANCER_PORT_FIELD, SSL_CERTIFICATE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String loadBalancerName;

    private final Integer loadBalancerPort;

    private final String sslCertificateId;

    private SetLoadBalancerListenerSslCertificateRequest(BuilderImpl builder) {
        super(builder);
        this.loadBalancerName = builder.loadBalancerName;
        this.loadBalancerPort = builder.loadBalancerPort;
        this.sslCertificateId = builder.sslCertificateId;
    }

    /**
     * <p>
     * The name of the load balancer.
     * </p>
     * 
     * @return The name of the load balancer.
     */
    public final String loadBalancerName() {
        return loadBalancerName;
    }

    /**
     * <p>
     * The port that uses the specified SSL certificate.
     * </p>
     * 
     * @return The port that uses the specified SSL certificate.
     */
    public final Integer loadBalancerPort() {
        return loadBalancerPort;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the SSL certificate.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the SSL certificate.
     */
    public final String sslCertificateId() {
        return sslCertificateId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerName());
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerPort());
        hashCode = 31 * hashCode + Objects.hashCode(sslCertificateId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetLoadBalancerListenerSslCertificateRequest)) {
            return false;
        }
        SetLoadBalancerListenerSslCertificateRequest other = (SetLoadBalancerListenerSslCertificateRequest) obj;
        return Objects.equals(loadBalancerName(), other.loadBalancerName())
                && Objects.equals(loadBalancerPort(), other.loadBalancerPort())
                && Objects.equals(sslCertificateId(), other.sslCertificateId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SetLoadBalancerListenerSslCertificateRequest").add("LoadBalancerName", loadBalancerName())
                .add("LoadBalancerPort", loadBalancerPort()).add("SSLCertificateId", sslCertificateId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LoadBalancerName":
            return Optional.ofNullable(clazz.cast(loadBalancerName()));
        case "LoadBalancerPort":
            return Optional.ofNullable(clazz.cast(loadBalancerPort()));
        case "SSLCertificateId":
            return Optional.ofNullable(clazz.cast(sslCertificateId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LoadBalancerName", LOAD_BALANCER_NAME_FIELD);
        map.put("LoadBalancerPort", LOAD_BALANCER_PORT_FIELD);
        map.put("SSLCertificateId", SSL_CERTIFICATE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SetLoadBalancerListenerSslCertificateRequest, T> g) {
        return obj -> g.apply((SetLoadBalancerListenerSslCertificateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ElasticLoadBalancingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, SetLoadBalancerListenerSslCertificateRequest> {
        /**
         * <p>
         * The name of the load balancer.
         * </p>
         * 
         * @param loadBalancerName
         *        The name of the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerName(String loadBalancerName);

        /**
         * <p>
         * The port that uses the specified SSL certificate.
         * </p>
         * 
         * @param loadBalancerPort
         *        The port that uses the specified SSL certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerPort(Integer loadBalancerPort);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the SSL certificate.
         * </p>
         * 
         * @param sslCertificateId
         *        The Amazon Resource Name (ARN) of the SSL certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sslCertificateId(String sslCertificateId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticLoadBalancingRequest.BuilderImpl implements Builder {
        private String loadBalancerName;

        private Integer loadBalancerPort;

        private String sslCertificateId;

        private BuilderImpl() {
        }

        private BuilderImpl(SetLoadBalancerListenerSslCertificateRequest model) {
            super(model);
            loadBalancerName(model.loadBalancerName);
            loadBalancerPort(model.loadBalancerPort);
            sslCertificateId(model.sslCertificateId);
        }

        public final String getLoadBalancerName() {
            return loadBalancerName;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final Integer getLoadBalancerPort() {
            return loadBalancerPort;
        }

        public final void setLoadBalancerPort(Integer loadBalancerPort) {
            this.loadBalancerPort = loadBalancerPort;
        }

        @Override
        public final Builder loadBalancerPort(Integer loadBalancerPort) {
            this.loadBalancerPort = loadBalancerPort;
            return this;
        }

        public final String getSslCertificateId() {
            return sslCertificateId;
        }

        public final void setSslCertificateId(String sslCertificateId) {
            this.sslCertificateId = sslCertificateId;
        }

        @Override
        public final Builder sslCertificateId(String sslCertificateId) {
            this.sslCertificateId = sslCertificateId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetLoadBalancerListenerSslCertificateRequest build() {
            return new SetLoadBalancerListenerSslCertificateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
