/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AddListenerCertificatesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AddListenerCertificatesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AddTagsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AddTagsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AllocationIdNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AvailabilityZoneNotSupportedException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CertificateNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateListenerRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateListenerResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateLoadBalancerResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateRuleRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateRuleResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateTargetGroupRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateTargetGroupResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteListenerRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteListenerResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteLoadBalancerResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteRuleRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteRuleResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteTargetGroupRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteTargetGroupResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeregisterTargetsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeregisterTargetsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeAccountLimitsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeAccountLimitsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenerCertificatesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenerCertificatesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancerAttributesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancerAttributesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeRulesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeRulesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeSslPoliciesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeSslPoliciesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTagsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTagsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupAttributesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupAttributesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetHealthRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetHealthResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DuplicateListenerException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DuplicateLoadBalancerNameException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DuplicateTagKeysException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DuplicateTargetGroupNameException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Exception;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Request;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.HealthUnavailableException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.IncompatibleProtocolsException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.InvalidConfigurationRequestException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.InvalidLoadBalancerActionException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.InvalidSchemeException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.InvalidSecurityGroupException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.InvalidSubnetException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.InvalidTargetException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ListenerNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyListenerRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyListenerResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyLoadBalancerAttributesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyLoadBalancerAttributesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyRuleRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyRuleResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTargetGroupAttributesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTargetGroupAttributesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTargetGroupRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTargetGroupResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.OperationNotPermittedException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.PriorityInUseException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RegisterTargetsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RegisterTargetsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveListenerCertificatesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveListenerCertificatesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveTagsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveTagsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ResourceInUseException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RuleNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetIpAddressTypeRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetIpAddressTypeResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetRulePrioritiesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetRulePrioritiesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSecurityGroupsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSecurityGroupsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSubnetsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSubnetsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SslPolicyNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SubnetNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupAssociationLimitException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyActionsException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyCertificatesException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyListenersException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyLoadBalancersException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyRegistrationsForTargetIdException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyRulesException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyTagsException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyTargetGroupsException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyTargetsException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyUniqueTargetGroupsPerLoadBalancerException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.UnsupportedProtocolException;
import software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeListenersPublisher;
import software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeLoadBalancersPublisher;
import software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeTargetGroupsPublisher;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.AddListenerCertificatesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.AddTagsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.CreateListenerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.CreateLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.CreateRuleRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.CreateTargetGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DeleteListenerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DeleteLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DeleteRuleRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DeleteTargetGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DeregisterTargetsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeAccountLimitsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeListenerCertificatesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeListenersRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeLoadBalancerAttributesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeLoadBalancersRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeRulesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeSslPoliciesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeTagsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeTargetGroupAttributesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeTargetGroupsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeTargetHealthRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.ModifyListenerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.ModifyLoadBalancerAttributesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.ModifyRuleRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.ModifyTargetGroupAttributesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.ModifyTargetGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.RegisterTargetsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.RemoveListenerCertificatesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.RemoveTagsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.SetIpAddressTypeRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.SetRulePrioritiesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.SetSecurityGroupsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.SetSubnetsRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link ElasticLoadBalancingV2AsyncClient}.
 *
 * @see ElasticLoadBalancingV2AsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultElasticLoadBalancingV2AsyncClient implements ElasticLoadBalancingV2AsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultElasticLoadBalancingV2AsyncClient.class);

    private final AsyncClientHandler clientHandler;

    private final AwsQueryProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultElasticLoadBalancingV2AsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Adds the specified SSL server certificate to the certificate list for the specified HTTPS or TLS listener.
     * </p>
     * <p>
     * If the certificate in already in the certificate list, the call is successful but the certificate is not added
     * again.
     * </p>
     * <p>
     * To get the certificate list for a listener, use <a>DescribeListenerCertificates</a>. To remove certificates from
     * the certificate list for a listener, use <a>RemoveListenerCertificates</a>. To replace the default certificate
     * for a listener, use <a>ModifyListener</a>.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#https-listener-certificates"
     * >SSL Certificates</a> in the <i>Application Load Balancers Guide</i>.
     * </p>
     *
     * @param addListenerCertificatesRequest
     * @return A Java Future containing the result of the AddListenerCertificates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ListenerNotFoundException The specified listener does not exist.</li>
     *         <li>TooManyCertificatesException You've reached the limit on the number of certificates per load
     *         balancer.</li>
     *         <li>CertificateNotFoundException The specified certificate does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.AddListenerCertificates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/AddListenerCertificates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AddListenerCertificatesResponse> addListenerCertificates(
            AddListenerCertificatesRequest addListenerCertificatesRequest) {
        try {

            HttpResponseHandler<AddListenerCertificatesResponse> responseHandler = protocolFactory
                    .createResponseHandler(AddListenerCertificatesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AddListenerCertificatesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AddListenerCertificatesRequest, AddListenerCertificatesResponse>()
                            .withOperationName("AddListenerCertificates")
                            .withMarshaller(new AddListenerCertificatesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(addListenerCertificatesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds the specified tags to the specified Elastic Load Balancing resource. You can tag your Application Load
     * Balancers, Network Load Balancers, and your target groups.
     * </p>
     * <p>
     * Each tag consists of a key and an optional value. If a resource already has a tag with the same key,
     * <code>AddTags</code> updates its value.
     * </p>
     * <p>
     * To list the current tags for your resources, use <a>DescribeTags</a>. To remove tags from your resources, use
     * <a>RemoveTags</a>.
     * </p>
     *
     * @param addTagsRequest
     * @return A Java Future containing the result of the AddTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DuplicateTagKeysException A tag key was specified more than once.</li>
     *         <li>TooManyTagsException You've reached the limit on the number of tags per load balancer.</li>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.AddTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/AddTags" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<AddTagsResponse> addTags(AddTagsRequest addTagsRequest) {
        try {

            HttpResponseHandler<AddTagsResponse> responseHandler = protocolFactory
                    .createResponseHandler(AddTagsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AddTagsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AddTagsRequest, AddTagsResponse>().withOperationName("AddTags")
                            .withMarshaller(new AddTagsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(addTagsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a listener for the specified Application Load Balancer or Network Load Balancer.
     * </p>
     * <p>
     * To update a listener, use <a>ModifyListener</a>. When you are finished with a listener, you can delete it using
     * <a>DeleteListener</a>. If you are finished with both the listener and the load balancer, you can delete them both
     * using <a>DeleteLoadBalancer</a>.
     * </p>
     * <p>
     * This operation is idempotent, which means that it completes at most one time. If you attempt to create multiple
     * listeners with the same settings, each call succeeds.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html">Listeners
     * for Your Application Load Balancers</a> in the <i>Application Load Balancers Guide</i> and <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-listeners.html">Listeners for
     * Your Network Load Balancers</a> in the <i>Network Load Balancers Guide</i>.
     * </p>
     *
     * @param createListenerRequest
     * @return A Java Future containing the result of the CreateListener operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DuplicateListenerException A listener with the specified port already exists.</li>
     *         <li>TooManyListenersException You've reached the limit on the number of listeners per load balancer.</li>
     *         <li>TooManyCertificatesException You've reached the limit on the number of certificates per load
     *         balancer.</li>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>TargetGroupAssociationLimitException You've reached the limit on the number of load balancers per
     *         target group.</li>
     *         <li>InvalidConfigurationRequestException The requested configuration is not valid.</li>
     *         <li>IncompatibleProtocolsException The specified configuration is not valid with this protocol.</li>
     *         <li>SslPolicyNotFoundException The specified SSL policy does not exist.</li>
     *         <li>CertificateNotFoundException The specified certificate does not exist.</li>
     *         <li>UnsupportedProtocolException The specified protocol is not supported.</li>
     *         <li>TooManyRegistrationsForTargetIdException You've reached the limit on the number of times a target can
     *         be registered with a load balancer.</li>
     *         <li>TooManyTargetsException You've reached the limit on the number of targets.</li>
     *         <li>TooManyActionsException You've reached the limit on the number of actions per rule.</li>
     *         <li>InvalidLoadBalancerActionException The requested action is not valid.</li>
     *         <li>TooManyUniqueTargetGroupsPerLoadBalancerException You've reached the limit on the number of unique
     *         target groups per load balancer across all listeners. If a target group is used by multiple actions for a
     *         load balancer, it is counted as only one use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.CreateListener
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/CreateListener"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateListenerResponse> createListener(CreateListenerRequest createListenerRequest) {
        try {

            HttpResponseHandler<CreateListenerResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateListenerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateListenerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateListenerRequest, CreateListenerResponse>()
                            .withOperationName("CreateListener")
                            .withMarshaller(new CreateListenerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createListenerRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an Application Load Balancer or a Network Load Balancer.
     * </p>
     * <p>
     * When you create a load balancer, you can specify security groups, public subnets, IP address type, and tags.
     * Otherwise, you could do so later using <a>SetSecurityGroups</a>, <a>SetSubnets</a>, <a>SetIpAddressType</a>, and
     * <a>AddTags</a>.
     * </p>
     * <p>
     * To create listeners for your load balancer, use <a>CreateListener</a>. To describe your current load balancers,
     * see <a>DescribeLoadBalancers</a>. When you are finished with a load balancer, you can delete it using
     * <a>DeleteLoadBalancer</a>.
     * </p>
     * <p>
     * For limit information, see <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-limits.html">Limits for
     * Your Application Load Balancer</a> in the <i>Application Load Balancers Guide</i> and <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-limits.html">Limits for Your
     * Network Load Balancer</a> in the <i>Network Load Balancers Guide</i>.
     * </p>
     * <p>
     * This operation is idempotent, which means that it completes at most one time. If you attempt to create multiple
     * load balancers with the same settings, each call succeeds.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/application-load-balancers.html"
     * >Application Load Balancers</a> in the <i>Application Load Balancers Guide</i> and <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html">Network Load
     * Balancers</a> in the <i>Network Load Balancers Guide</i>.
     * </p>
     *
     * @param createLoadBalancerRequest
     * @return A Java Future containing the result of the CreateLoadBalancer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DuplicateLoadBalancerNameException A load balancer with the specified name already exists.</li>
     *         <li>TooManyLoadBalancersException You've reached the limit on the number of load balancers for your AWS
     *         account.</li>
     *         <li>InvalidConfigurationRequestException The requested configuration is not valid.</li>
     *         <li>SubnetNotFoundException The specified subnet does not exist.</li>
     *         <li>InvalidSubnetException The specified subnet is out of available addresses.</li>
     *         <li>InvalidSecurityGroupException The specified security group does not exist.</li>
     *         <li>InvalidSchemeException The requested scheme is not valid.</li>
     *         <li>TooManyTagsException You've reached the limit on the number of tags per load balancer.</li>
     *         <li>DuplicateTagKeysException A tag key was specified more than once.</li>
     *         <li>ResourceInUseException A specified resource is in use.</li>
     *         <li>AllocationIdNotFoundException The specified allocation ID does not exist.</li>
     *         <li>AvailabilityZoneNotSupportedException The specified Availability Zone is not supported.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.CreateLoadBalancer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/CreateLoadBalancer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateLoadBalancerResponse> createLoadBalancer(CreateLoadBalancerRequest createLoadBalancerRequest) {
        try {

            HttpResponseHandler<CreateLoadBalancerResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateLoadBalancerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateLoadBalancerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateLoadBalancerRequest, CreateLoadBalancerResponse>()
                            .withOperationName("CreateLoadBalancer")
                            .withMarshaller(new CreateLoadBalancerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createLoadBalancerRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a rule for the specified listener. The listener must be associated with an Application Load Balancer.
     * </p>
     * <p>
     * Rules are evaluated in priority order, from the lowest value to the highest value. When the conditions for a rule
     * are met, its actions are performed. If the conditions for no rules are met, the actions for the default rule are
     * performed. For more information, see <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#listener-rules"
     * >Listener Rules</a> in the <i>Application Load Balancers Guide</i>.
     * </p>
     * <p>
     * To view your current rules, use <a>DescribeRules</a>. To update a rule, use <a>ModifyRule</a>. To set the
     * priorities of your rules, use <a>SetRulePriorities</a>. To delete a rule, use <a>DeleteRule</a>.
     * </p>
     *
     * @param createRuleRequest
     * @return A Java Future containing the result of the CreateRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PriorityInUseException The specified priority is in use.</li>
     *         <li>TooManyTargetGroupsException You've reached the limit on the number of target groups for your AWS
     *         account.</li>
     *         <li>TooManyRulesException You've reached the limit on the number of rules per load balancer.</li>
     *         <li>TargetGroupAssociationLimitException You've reached the limit on the number of load balancers per
     *         target group.</li>
     *         <li>IncompatibleProtocolsException The specified configuration is not valid with this protocol.</li>
     *         <li>ListenerNotFoundException The specified listener does not exist.</li>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>InvalidConfigurationRequestException The requested configuration is not valid.</li>
     *         <li>TooManyRegistrationsForTargetIdException You've reached the limit on the number of times a target can
     *         be registered with a load balancer.</li>
     *         <li>TooManyTargetsException You've reached the limit on the number of targets.</li>
     *         <li>UnsupportedProtocolException The specified protocol is not supported.</li>
     *         <li>TooManyActionsException You've reached the limit on the number of actions per rule.</li>
     *         <li>InvalidLoadBalancerActionException The requested action is not valid.</li>
     *         <li>TooManyUniqueTargetGroupsPerLoadBalancerException You've reached the limit on the number of unique
     *         target groups per load balancer across all listeners. If a target group is used by multiple actions for a
     *         load balancer, it is counted as only one use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.CreateRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/CreateRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateRuleResponse> createRule(CreateRuleRequest createRuleRequest) {
        try {

            HttpResponseHandler<CreateRuleResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateRuleRequest, CreateRuleResponse>().withOperationName("CreateRule")
                            .withMarshaller(new CreateRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createRuleRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a target group.
     * </p>
     * <p>
     * To register targets with the target group, use <a>RegisterTargets</a>. To update the health check settings for
     * the target group, use <a>ModifyTargetGroup</a>. To monitor the health of targets in the target group, use
     * <a>DescribeTargetHealth</a>.
     * </p>
     * <p>
     * To route traffic to the targets in a target group, specify the target group in an action using
     * <a>CreateListener</a> or <a>CreateRule</a>.
     * </p>
     * <p>
     * To delete a target group, use <a>DeleteTargetGroup</a>.
     * </p>
     * <p>
     * This operation is idempotent, which means that it completes at most one time. If you attempt to create multiple
     * target groups with the same settings, each call succeeds.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html"
     * >Target Groups for Your Application Load Balancers</a> in the <i>Application Load Balancers Guide</i> or <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html">Target
     * Groups for Your Network Load Balancers</a> in the <i>Network Load Balancers Guide</i>.
     * </p>
     *
     * @param createTargetGroupRequest
     * @return A Java Future containing the result of the CreateTargetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DuplicateTargetGroupNameException A target group with the specified name already exists.</li>
     *         <li>TooManyTargetGroupsException You've reached the limit on the number of target groups for your AWS
     *         account.</li>
     *         <li>InvalidConfigurationRequestException The requested configuration is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.CreateTargetGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/CreateTargetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTargetGroupResponse> createTargetGroup(CreateTargetGroupRequest createTargetGroupRequest) {
        try {

            HttpResponseHandler<CreateTargetGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateTargetGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateTargetGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTargetGroupRequest, CreateTargetGroupResponse>()
                            .withOperationName("CreateTargetGroup")
                            .withMarshaller(new CreateTargetGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createTargetGroupRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified listener.
     * </p>
     * <p>
     * Alternatively, your listener is deleted when you delete the load balancer to which it is attached, using
     * <a>DeleteLoadBalancer</a>.
     * </p>
     *
     * @param deleteListenerRequest
     * @return A Java Future containing the result of the DeleteListener operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ListenerNotFoundException The specified listener does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DeleteListener
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DeleteListener"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteListenerResponse> deleteListener(DeleteListenerRequest deleteListenerRequest) {
        try {

            HttpResponseHandler<DeleteListenerResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteListenerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteListenerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteListenerRequest, DeleteListenerResponse>()
                            .withOperationName("DeleteListener")
                            .withMarshaller(new DeleteListenerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteListenerRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified Application Load Balancer or Network Load Balancer and its attached listeners.
     * </p>
     * <p>
     * You can't delete a load balancer if deletion protection is enabled. If the load balancer does not exist or has
     * already been deleted, the call succeeds.
     * </p>
     * <p>
     * Deleting a load balancer does not affect its registered targets. For example, your EC2 instances continue to run
     * and are still registered to their target groups. If you no longer need these EC2 instances, you can stop or
     * terminate them.
     * </p>
     *
     * @param deleteLoadBalancerRequest
     * @return A Java Future containing the result of the DeleteLoadBalancer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>ResourceInUseException A specified resource is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DeleteLoadBalancer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DeleteLoadBalancer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteLoadBalancerResponse> deleteLoadBalancer(DeleteLoadBalancerRequest deleteLoadBalancerRequest) {
        try {

            HttpResponseHandler<DeleteLoadBalancerResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteLoadBalancerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteLoadBalancerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteLoadBalancerRequest, DeleteLoadBalancerResponse>()
                            .withOperationName("DeleteLoadBalancer")
                            .withMarshaller(new DeleteLoadBalancerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteLoadBalancerRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified rule.
     * </p>
     *
     * @param deleteRuleRequest
     * @return A Java Future containing the result of the DeleteRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RuleNotFoundException The specified rule does not exist.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DeleteRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DeleteRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteRuleResponse> deleteRule(DeleteRuleRequest deleteRuleRequest) {
        try {

            HttpResponseHandler<DeleteRuleResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteRuleRequest, DeleteRuleResponse>().withOperationName("DeleteRule")
                            .withMarshaller(new DeleteRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteRuleRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified target group.
     * </p>
     * <p>
     * You can delete a target group if it is not referenced by any actions. Deleting a target group also deletes any
     * associated health checks.
     * </p>
     *
     * @param deleteTargetGroupRequest
     * @return A Java Future containing the result of the DeleteTargetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException A specified resource is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DeleteTargetGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DeleteTargetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTargetGroupResponse> deleteTargetGroup(DeleteTargetGroupRequest deleteTargetGroupRequest) {
        try {

            HttpResponseHandler<DeleteTargetGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteTargetGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteTargetGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTargetGroupRequest, DeleteTargetGroupResponse>()
                            .withOperationName("DeleteTargetGroup")
                            .withMarshaller(new DeleteTargetGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteTargetGroupRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deregisters the specified targets from the specified target group. After the targets are deregistered, they no
     * longer receive traffic from the load balancer.
     * </p>
     *
     * @param deregisterTargetsRequest
     * @return A Java Future containing the result of the DeregisterTargets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>InvalidTargetException The specified target does not exist, is not in the same VPC as the target
     *         group, or has an unsupported instance type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DeregisterTargets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DeregisterTargets"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeregisterTargetsResponse> deregisterTargets(DeregisterTargetsRequest deregisterTargetsRequest) {
        try {

            HttpResponseHandler<DeregisterTargetsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeregisterTargetsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeregisterTargetsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeregisterTargetsRequest, DeregisterTargetsResponse>()
                            .withOperationName("DeregisterTargets")
                            .withMarshaller(new DeregisterTargetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deregisterTargetsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the current Elastic Load Balancing resource limits for your AWS account.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-limits.html">Limits for
     * Your Application Load Balancers</a> in the <i>Application Load Balancer Guide</i> or <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-limits.html">Limits for Your
     * Network Load Balancers</a> in the <i>Network Load Balancers Guide</i>.
     * </p>
     *
     * @param describeAccountLimitsRequest
     * @return A Java Future containing the result of the DescribeAccountLimits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeAccountLimits
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAccountLimitsResponse> describeAccountLimits(
            DescribeAccountLimitsRequest describeAccountLimitsRequest) {
        try {

            HttpResponseHandler<DescribeAccountLimitsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeAccountLimitsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeAccountLimitsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAccountLimitsRequest, DescribeAccountLimitsResponse>()
                            .withOperationName("DescribeAccountLimits")
                            .withMarshaller(new DescribeAccountLimitsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeAccountLimitsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the default certificate and the certificate list for the specified HTTPS or TLS listener.
     * </p>
     * <p>
     * If the default certificate is also in the certificate list, it appears twice in the results (once with
     * <code>IsDefault</code> set to true and once with <code>IsDefault</code> set to false).
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#https-listener-certificates"
     * >SSL Certificates</a> in the <i>Application Load Balancers Guide</i>.
     * </p>
     *
     * @param describeListenerCertificatesRequest
     * @return A Java Future containing the result of the DescribeListenerCertificates operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ListenerNotFoundException The specified listener does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeListenerCertificates
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeListenerCertificates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeListenerCertificatesResponse> describeListenerCertificates(
            DescribeListenerCertificatesRequest describeListenerCertificatesRequest) {
        try {

            HttpResponseHandler<DescribeListenerCertificatesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeListenerCertificatesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeListenerCertificatesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeListenerCertificatesRequest, DescribeListenerCertificatesResponse>()
                            .withOperationName("DescribeListenerCertificates")
                            .withMarshaller(new DescribeListenerCertificatesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeListenerCertificatesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the specified listeners or the listeners for the specified Application Load Balancer or Network Load
     * Balancer. You must specify either a load balancer or one or more listeners.
     * </p>
     * <p>
     * For an HTTPS or TLS listener, the output includes the default certificate for the listener. To describe the
     * certificate list for the listener, use <a>DescribeListenerCertificates</a>.
     * </p>
     *
     * @param describeListenersRequest
     * @return A Java Future containing the result of the DescribeListeners operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ListenerNotFoundException The specified listener does not exist.</li>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>UnsupportedProtocolException The specified protocol is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeListeners
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeListeners"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeListenersResponse> describeListeners(DescribeListenersRequest describeListenersRequest) {
        try {

            HttpResponseHandler<DescribeListenersResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeListenersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeListenersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeListenersRequest, DescribeListenersResponse>()
                            .withOperationName("DescribeListeners")
                            .withMarshaller(new DescribeListenersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeListenersRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the specified listeners or the listeners for the specified Application Load Balancer or Network Load
     * Balancer. You must specify either a load balancer or one or more listeners.
     * </p>
     * <p>
     * For an HTTPS or TLS listener, the output includes the default certificate for the listener. To describe the
     * certificate list for the listener, use <a>DescribeListenerCertificates</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeListeners(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeListenersPublisher publisher = client.describeListenersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeListenersPublisher publisher = client.describeListenersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeListeners(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeListenersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ListenerNotFoundException The specified listener does not exist.</li>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>UnsupportedProtocolException The specified protocol is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeListeners
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeListeners"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeListenersPublisher describeListenersPaginator(DescribeListenersRequest describeListenersRequest) {
        return new DescribeListenersPublisher(this, applyPaginatorUserAgent(describeListenersRequest));
    }

    /**
     * <p>
     * Describes the attributes for the specified Application Load Balancer or Network Load Balancer.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/application/application-load-balancers.html#load-balancer-attributes"
     * >Load Balancer Attributes</a> in the <i>Application Load Balancers Guide</i> or <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html#load-balancer-attributes"
     * >Load Balancer Attributes</a> in the <i>Network Load Balancers Guide</i>.
     * </p>
     *
     * @param describeLoadBalancerAttributesRequest
     * @return A Java Future containing the result of the DescribeLoadBalancerAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeLoadBalancerAttributes
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeLoadBalancerAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeLoadBalancerAttributesResponse> describeLoadBalancerAttributes(
            DescribeLoadBalancerAttributesRequest describeLoadBalancerAttributesRequest) {
        try {

            HttpResponseHandler<DescribeLoadBalancerAttributesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeLoadBalancerAttributesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeLoadBalancerAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeLoadBalancerAttributesRequest, DescribeLoadBalancerAttributesResponse>()
                            .withOperationName("DescribeLoadBalancerAttributes")
                            .withMarshaller(new DescribeLoadBalancerAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeLoadBalancerAttributesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the specified load balancers or all of your load balancers.
     * </p>
     * <p>
     * To describe the listeners for a load balancer, use <a>DescribeListeners</a>. To describe the attributes for a
     * load balancer, use <a>DescribeLoadBalancerAttributes</a>.
     * </p>
     *
     * @param describeLoadBalancersRequest
     * @return A Java Future containing the result of the DescribeLoadBalancers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeLoadBalancers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeLoadBalancers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeLoadBalancersResponse> describeLoadBalancers(
            DescribeLoadBalancersRequest describeLoadBalancersRequest) {
        try {

            HttpResponseHandler<DescribeLoadBalancersResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeLoadBalancersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeLoadBalancersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeLoadBalancersRequest, DescribeLoadBalancersResponse>()
                            .withOperationName("DescribeLoadBalancers")
                            .withMarshaller(new DescribeLoadBalancersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeLoadBalancersRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the specified load balancers or all of your load balancers.
     * </p>
     * <p>
     * To describe the listeners for a load balancer, use <a>DescribeListeners</a>. To describe the attributes for a
     * load balancer, use <a>DescribeLoadBalancerAttributes</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeLoadBalancers(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeLoadBalancersPublisher publisher = client.describeLoadBalancersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeLoadBalancersPublisher publisher = client.describeLoadBalancersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeLoadBalancers(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeLoadBalancersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeLoadBalancers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeLoadBalancers"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeLoadBalancersPublisher describeLoadBalancersPaginator(DescribeLoadBalancersRequest describeLoadBalancersRequest) {
        return new DescribeLoadBalancersPublisher(this, applyPaginatorUserAgent(describeLoadBalancersRequest));
    }

    /**
     * <p>
     * Describes the specified rules or the rules for the specified listener. You must specify either a listener or one
     * or more rules.
     * </p>
     *
     * @param describeRulesRequest
     * @return A Java Future containing the result of the DescribeRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ListenerNotFoundException The specified listener does not exist.</li>
     *         <li>RuleNotFoundException The specified rule does not exist.</li>
     *         <li>UnsupportedProtocolException The specified protocol is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeRules
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeRules"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeRulesResponse> describeRules(DescribeRulesRequest describeRulesRequest) {
        try {

            HttpResponseHandler<DescribeRulesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeRulesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeRulesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeRulesRequest, DescribeRulesResponse>()
                            .withOperationName("DescribeRules")
                            .withMarshaller(new DescribeRulesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeRulesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the specified policies or all policies used for SSL negotiation.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#describe-ssl-policies"
     * >Security Policies</a> in the <i>Application Load Balancers Guide</i>.
     * </p>
     *
     * @param describeSslPoliciesRequest
     * @return A Java Future containing the result of the DescribeSSLPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SslPolicyNotFoundException The specified SSL policy does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeSSLPolicies
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeSSLPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeSslPoliciesResponse> describeSSLPolicies(
            DescribeSslPoliciesRequest describeSslPoliciesRequest) {
        try {

            HttpResponseHandler<DescribeSslPoliciesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeSslPoliciesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeSslPoliciesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeSslPoliciesRequest, DescribeSslPoliciesResponse>()
                            .withOperationName("DescribeSSLPolicies")
                            .withMarshaller(new DescribeSslPoliciesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeSslPoliciesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the tags for the specified resources. You can describe the tags for one or more Application Load
     * Balancers, Network Load Balancers, and target groups.
     * </p>
     *
     * @param describeTagsRequest
     * @return A Java Future containing the result of the DescribeTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>ListenerNotFoundException The specified listener does not exist.</li>
     *         <li>RuleNotFoundException The specified rule does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTags"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeTagsResponse> describeTags(DescribeTagsRequest describeTagsRequest) {
        try {

            HttpResponseHandler<DescribeTagsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeTagsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeTagsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeTagsRequest, DescribeTagsResponse>()
                            .withOperationName("DescribeTags").withMarshaller(new DescribeTagsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeTagsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the attributes for the specified target group.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html#target-group-attributes"
     * >Target Group Attributes</a> in the <i>Application Load Balancers Guide</i> or <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#target-group-attributes"
     * >Target Group Attributes</a> in the <i>Network Load Balancers Guide</i>.
     * </p>
     *
     * @param describeTargetGroupAttributesRequest
     * @return A Java Future containing the result of the DescribeTargetGroupAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeTargetGroupAttributes
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTargetGroupAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeTargetGroupAttributesResponse> describeTargetGroupAttributes(
            DescribeTargetGroupAttributesRequest describeTargetGroupAttributesRequest) {
        try {

            HttpResponseHandler<DescribeTargetGroupAttributesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeTargetGroupAttributesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeTargetGroupAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeTargetGroupAttributesRequest, DescribeTargetGroupAttributesResponse>()
                            .withOperationName("DescribeTargetGroupAttributes")
                            .withMarshaller(new DescribeTargetGroupAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeTargetGroupAttributesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the specified target groups or all of your target groups. By default, all target groups are described.
     * Alternatively, you can specify one of the following to filter the results: the ARN of the load balancer, the
     * names of one or more target groups, or the ARNs of one or more target groups.
     * </p>
     * <p>
     * To describe the targets for a target group, use <a>DescribeTargetHealth</a>. To describe the attributes of a
     * target group, use <a>DescribeTargetGroupAttributes</a>.
     * </p>
     *
     * @param describeTargetGroupsRequest
     * @return A Java Future containing the result of the DescribeTargetGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeTargetGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTargetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeTargetGroupsResponse> describeTargetGroups(
            DescribeTargetGroupsRequest describeTargetGroupsRequest) {
        try {

            HttpResponseHandler<DescribeTargetGroupsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeTargetGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeTargetGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeTargetGroupsRequest, DescribeTargetGroupsResponse>()
                            .withOperationName("DescribeTargetGroups")
                            .withMarshaller(new DescribeTargetGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeTargetGroupsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the specified target groups or all of your target groups. By default, all target groups are described.
     * Alternatively, you can specify one of the following to filter the results: the ARN of the load balancer, the
     * names of one or more target groups, or the ARNs of one or more target groups.
     * </p>
     * <p>
     * To describe the targets for a target group, use <a>DescribeTargetHealth</a>. To describe the attributes of a
     * target group, use <a>DescribeTargetGroupAttributes</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeTargetGroups(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeTargetGroupsPublisher publisher = client.describeTargetGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeTargetGroupsPublisher publisher = client.describeTargetGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTargetGroups(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeTargetGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeTargetGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTargetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeTargetGroupsPublisher describeTargetGroupsPaginator(DescribeTargetGroupsRequest describeTargetGroupsRequest) {
        return new DescribeTargetGroupsPublisher(this, applyPaginatorUserAgent(describeTargetGroupsRequest));
    }

    /**
     * <p>
     * Describes the health of the specified targets or all of your targets.
     * </p>
     *
     * @param describeTargetHealthRequest
     * @return A Java Future containing the result of the DescribeTargetHealth operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidTargetException The specified target does not exist, is not in the same VPC as the target
     *         group, or has an unsupported instance type.</li>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>HealthUnavailableException The health of the specified targets could not be retrieved due to an
     *         internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeTargetHealth
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTargetHealth"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeTargetHealthResponse> describeTargetHealth(
            DescribeTargetHealthRequest describeTargetHealthRequest) {
        try {

            HttpResponseHandler<DescribeTargetHealthResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeTargetHealthResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeTargetHealthResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeTargetHealthRequest, DescribeTargetHealthResponse>()
                            .withOperationName("DescribeTargetHealth")
                            .withMarshaller(new DescribeTargetHealthRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeTargetHealthRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Replaces the specified properties of the specified listener. Any properties that you do not specify remain
     * unchanged.
     * </p>
     * <p>
     * Changing the protocol from HTTPS to HTTP, or from TLS to TCP, removes the security policy and default certificate
     * properties. If you change the protocol from HTTP to HTTPS, or from TCP to TLS, you must add the security policy
     * and default certificate properties.
     * </p>
     * <p>
     * To add an item to a list, remove an item from a list, or update an item in a list, you must provide the entire
     * list. For example, to add an action, specify a list with the current actions plus the new action.
     * </p>
     *
     * @param modifyListenerRequest
     * @return A Java Future containing the result of the ModifyListener operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DuplicateListenerException A listener with the specified port already exists.</li>
     *         <li>TooManyListenersException You've reached the limit on the number of listeners per load balancer.</li>
     *         <li>TooManyCertificatesException You've reached the limit on the number of certificates per load
     *         balancer.</li>
     *         <li>ListenerNotFoundException The specified listener does not exist.</li>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>TargetGroupAssociationLimitException You've reached the limit on the number of load balancers per
     *         target group.</li>
     *         <li>IncompatibleProtocolsException The specified configuration is not valid with this protocol.</li>
     *         <li>SslPolicyNotFoundException The specified SSL policy does not exist.</li>
     *         <li>CertificateNotFoundException The specified certificate does not exist.</li>
     *         <li>InvalidConfigurationRequestException The requested configuration is not valid.</li>
     *         <li>UnsupportedProtocolException The specified protocol is not supported.</li>
     *         <li>TooManyRegistrationsForTargetIdException You've reached the limit on the number of times a target can
     *         be registered with a load balancer.</li>
     *         <li>TooManyTargetsException You've reached the limit on the number of targets.</li>
     *         <li>TooManyActionsException You've reached the limit on the number of actions per rule.</li>
     *         <li>InvalidLoadBalancerActionException The requested action is not valid.</li>
     *         <li>TooManyUniqueTargetGroupsPerLoadBalancerException You've reached the limit on the number of unique
     *         target groups per load balancer across all listeners. If a target group is used by multiple actions for a
     *         load balancer, it is counted as only one use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.ModifyListener
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyListener"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyListenerResponse> modifyListener(ModifyListenerRequest modifyListenerRequest) {
        try {

            HttpResponseHandler<ModifyListenerResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyListenerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyListenerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyListenerRequest, ModifyListenerResponse>()
                            .withOperationName("ModifyListener")
                            .withMarshaller(new ModifyListenerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(modifyListenerRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies the specified attributes of the specified Application Load Balancer or Network Load Balancer.
     * </p>
     * <p>
     * If any of the specified attributes can't be modified as requested, the call fails. Any existing attributes that
     * you do not modify retain their current values.
     * </p>
     *
     * @param modifyLoadBalancerAttributesRequest
     * @return A Java Future containing the result of the ModifyLoadBalancerAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>InvalidConfigurationRequestException The requested configuration is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.ModifyLoadBalancerAttributes
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyLoadBalancerAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyLoadBalancerAttributesResponse> modifyLoadBalancerAttributes(
            ModifyLoadBalancerAttributesRequest modifyLoadBalancerAttributesRequest) {
        try {

            HttpResponseHandler<ModifyLoadBalancerAttributesResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyLoadBalancerAttributesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyLoadBalancerAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyLoadBalancerAttributesRequest, ModifyLoadBalancerAttributesResponse>()
                            .withOperationName("ModifyLoadBalancerAttributes")
                            .withMarshaller(new ModifyLoadBalancerAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(modifyLoadBalancerAttributesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Replaces the specified properties of the specified rule. Any properties that you do not specify are unchanged.
     * </p>
     * <p>
     * To add an item to a list, remove an item from a list, or update an item in a list, you must provide the entire
     * list. For example, to add an action, specify a list with the current actions plus the new action.
     * </p>
     * <p>
     * To modify the actions for the default rule, use <a>ModifyListener</a>.
     * </p>
     *
     * @param modifyRuleRequest
     * @return A Java Future containing the result of the ModifyRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TargetGroupAssociationLimitException You've reached the limit on the number of load balancers per
     *         target group.</li>
     *         <li>IncompatibleProtocolsException The specified configuration is not valid with this protocol.</li>
     *         <li>RuleNotFoundException The specified rule does not exist.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>TooManyRegistrationsForTargetIdException You've reached the limit on the number of times a target can
     *         be registered with a load balancer.</li>
     *         <li>TooManyTargetsException You've reached the limit on the number of targets.</li>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>UnsupportedProtocolException The specified protocol is not supported.</li>
     *         <li>TooManyActionsException You've reached the limit on the number of actions per rule.</li>
     *         <li>InvalidLoadBalancerActionException The requested action is not valid.</li>
     *         <li>TooManyUniqueTargetGroupsPerLoadBalancerException You've reached the limit on the number of unique
     *         target groups per load balancer across all listeners. If a target group is used by multiple actions for a
     *         load balancer, it is counted as only one use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.ModifyRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyRuleResponse> modifyRule(ModifyRuleRequest modifyRuleRequest) {
        try {

            HttpResponseHandler<ModifyRuleResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyRuleRequest, ModifyRuleResponse>().withOperationName("ModifyRule")
                            .withMarshaller(new ModifyRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(modifyRuleRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies the health checks used when evaluating the health state of the targets in the specified target group.
     * </p>
     * <p>
     * To monitor the health of the targets, use <a>DescribeTargetHealth</a>.
     * </p>
     *
     * @param modifyTargetGroupRequest
     * @return A Java Future containing the result of the ModifyTargetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>InvalidConfigurationRequestException The requested configuration is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.ModifyTargetGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyTargetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyTargetGroupResponse> modifyTargetGroup(ModifyTargetGroupRequest modifyTargetGroupRequest) {
        try {

            HttpResponseHandler<ModifyTargetGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyTargetGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyTargetGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyTargetGroupRequest, ModifyTargetGroupResponse>()
                            .withOperationName("ModifyTargetGroup")
                            .withMarshaller(new ModifyTargetGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(modifyTargetGroupRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies the specified attributes of the specified target group.
     * </p>
     *
     * @param modifyTargetGroupAttributesRequest
     * @return A Java Future containing the result of the ModifyTargetGroupAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>InvalidConfigurationRequestException The requested configuration is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.ModifyTargetGroupAttributes
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyTargetGroupAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyTargetGroupAttributesResponse> modifyTargetGroupAttributes(
            ModifyTargetGroupAttributesRequest modifyTargetGroupAttributesRequest) {
        try {

            HttpResponseHandler<ModifyTargetGroupAttributesResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyTargetGroupAttributesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyTargetGroupAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyTargetGroupAttributesRequest, ModifyTargetGroupAttributesResponse>()
                            .withOperationName("ModifyTargetGroupAttributes")
                            .withMarshaller(new ModifyTargetGroupAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(modifyTargetGroupAttributesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Registers the specified targets with the specified target group.
     * </p>
     * <p>
     * If the target is an EC2 instance, it must be in the <code>running</code> state when you register it.
     * </p>
     * <p>
     * By default, the load balancer routes requests to registered targets using the protocol and port for the target
     * group. Alternatively, you can override the port for a target when you register it. You can register each EC2
     * instance or IP address with the same target group multiple times using different ports.
     * </p>
     * <p>
     * With a Network Load Balancer, you cannot register instances by instance ID if they have the following instance
     * types: C1, CC1, CC2, CG1, CG2, CR1, CS1, G1, G2, HI1, HS1, M1, M2, M3, and T1. You can register instances of
     * these types by IP address.
     * </p>
     * <p>
     * To remove a target from a target group, use <a>DeregisterTargets</a>.
     * </p>
     *
     * @param registerTargetsRequest
     * @return A Java Future containing the result of the RegisterTargets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>TooManyTargetsException You've reached the limit on the number of targets.</li>
     *         <li>InvalidTargetException The specified target does not exist, is not in the same VPC as the target
     *         group, or has an unsupported instance type.</li>
     *         <li>TooManyRegistrationsForTargetIdException You've reached the limit on the number of times a target can
     *         be registered with a load balancer.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.RegisterTargets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/RegisterTargets"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RegisterTargetsResponse> registerTargets(RegisterTargetsRequest registerTargetsRequest) {
        try {

            HttpResponseHandler<RegisterTargetsResponse> responseHandler = protocolFactory
                    .createResponseHandler(RegisterTargetsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<RegisterTargetsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RegisterTargetsRequest, RegisterTargetsResponse>()
                            .withOperationName("RegisterTargets")
                            .withMarshaller(new RegisterTargetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(registerTargetsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the specified certificate from the certificate list for the specified HTTPS or TLS listener.
     * </p>
     * <p>
     * You can't remove the default certificate for a listener. To replace the default certificate, call
     * <a>ModifyListener</a>.
     * </p>
     * <p>
     * To list the certificates for your listener, use <a>DescribeListenerCertificates</a>.
     * </p>
     *
     * @param removeListenerCertificatesRequest
     * @return A Java Future containing the result of the RemoveListenerCertificates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ListenerNotFoundException The specified listener does not exist.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.RemoveListenerCertificates
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/RemoveListenerCertificates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RemoveListenerCertificatesResponse> removeListenerCertificates(
            RemoveListenerCertificatesRequest removeListenerCertificatesRequest) {
        try {

            HttpResponseHandler<RemoveListenerCertificatesResponse> responseHandler = protocolFactory
                    .createResponseHandler(RemoveListenerCertificatesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<RemoveListenerCertificatesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RemoveListenerCertificatesRequest, RemoveListenerCertificatesResponse>()
                            .withOperationName("RemoveListenerCertificates")
                            .withMarshaller(new RemoveListenerCertificatesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(removeListenerCertificatesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the specified tags from the specified Elastic Load Balancing resource.
     * </p>
     * <p>
     * To list the current tags for your resources, use <a>DescribeTags</a>.
     * </p>
     *
     * @param removeTagsRequest
     * @return A Java Future containing the result of the RemoveTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>ListenerNotFoundException The specified listener does not exist.</li>
     *         <li>RuleNotFoundException The specified rule does not exist.</li>
     *         <li>TooManyTagsException You've reached the limit on the number of tags per load balancer.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.RemoveTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/RemoveTags"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RemoveTagsResponse> removeTags(RemoveTagsRequest removeTagsRequest) {
        try {

            HttpResponseHandler<RemoveTagsResponse> responseHandler = protocolFactory
                    .createResponseHandler(RemoveTagsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<RemoveTagsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RemoveTagsRequest, RemoveTagsResponse>().withOperationName("RemoveTags")
                            .withMarshaller(new RemoveTagsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(removeTagsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sets the type of IP addresses used by the subnets of the specified Application Load Balancer or Network Load
     * Balancer.
     * </p>
     *
     * @param setIpAddressTypeRequest
     * @return A Java Future containing the result of the SetIpAddressType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>InvalidConfigurationRequestException The requested configuration is not valid.</li>
     *         <li>InvalidSubnetException The specified subnet is out of available addresses.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.SetIpAddressType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/SetIpAddressType"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SetIpAddressTypeResponse> setIpAddressType(SetIpAddressTypeRequest setIpAddressTypeRequest) {
        try {

            HttpResponseHandler<SetIpAddressTypeResponse> responseHandler = protocolFactory
                    .createResponseHandler(SetIpAddressTypeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<SetIpAddressTypeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SetIpAddressTypeRequest, SetIpAddressTypeResponse>()
                            .withOperationName("SetIpAddressType")
                            .withMarshaller(new SetIpAddressTypeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(setIpAddressTypeRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sets the priorities of the specified rules.
     * </p>
     * <p>
     * You can reorder the rules as long as there are no priority conflicts in the new order. Any existing rules that
     * you do not specify retain their current priority.
     * </p>
     *
     * @param setRulePrioritiesRequest
     * @return A Java Future containing the result of the SetRulePriorities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RuleNotFoundException The specified rule does not exist.</li>
     *         <li>PriorityInUseException The specified priority is in use.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.SetRulePriorities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/SetRulePriorities"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SetRulePrioritiesResponse> setRulePriorities(SetRulePrioritiesRequest setRulePrioritiesRequest) {
        try {

            HttpResponseHandler<SetRulePrioritiesResponse> responseHandler = protocolFactory
                    .createResponseHandler(SetRulePrioritiesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<SetRulePrioritiesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SetRulePrioritiesRequest, SetRulePrioritiesResponse>()
                            .withOperationName("SetRulePriorities")
                            .withMarshaller(new SetRulePrioritiesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(setRulePrioritiesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates the specified security groups with the specified Application Load Balancer. The specified security
     * groups override the previously associated security groups.
     * </p>
     * <p>
     * You can't specify a security group for a Network Load Balancer.
     * </p>
     *
     * @param setSecurityGroupsRequest
     * @return A Java Future containing the result of the SetSecurityGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>InvalidConfigurationRequestException The requested configuration is not valid.</li>
     *         <li>InvalidSecurityGroupException The specified security group does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.SetSecurityGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/SetSecurityGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SetSecurityGroupsResponse> setSecurityGroups(SetSecurityGroupsRequest setSecurityGroupsRequest) {
        try {

            HttpResponseHandler<SetSecurityGroupsResponse> responseHandler = protocolFactory
                    .createResponseHandler(SetSecurityGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<SetSecurityGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SetSecurityGroupsRequest, SetSecurityGroupsResponse>()
                            .withOperationName("SetSecurityGroups")
                            .withMarshaller(new SetSecurityGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(setSecurityGroupsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables the Availability Zone for the specified public subnets for the specified Application Load Balancer. The
     * specified subnets replace the previously enabled subnets.
     * </p>
     * <p>
     * You can't change the subnets for a Network Load Balancer.
     * </p>
     *
     * @param setSubnetsRequest
     * @return A Java Future containing the result of the SetSubnets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>InvalidConfigurationRequestException The requested configuration is not valid.</li>
     *         <li>SubnetNotFoundException The specified subnet does not exist.</li>
     *         <li>InvalidSubnetException The specified subnet is out of available addresses.</li>
     *         <li>AllocationIdNotFoundException The specified allocation ID does not exist.</li>
     *         <li>AvailabilityZoneNotSupportedException The specified Availability Zone is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.SetSubnets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/SetSubnets"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SetSubnetsResponse> setSubnets(SetSubnetsRequest setSubnetsRequest) {
        try {

            HttpResponseHandler<SetSubnetsResponse> responseHandler = protocolFactory
                    .createResponseHandler(SetSubnetsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<SetSubnetsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SetSubnetsRequest, SetSubnetsResponse>().withOperationName("SetSubnets")
                            .withMarshaller(new SetSubnetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(setSubnetsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private AwsQueryProtocolFactory init() {
        return AwsQueryProtocolFactory
                .builder()
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnsupportedProtocol")
                                .exceptionBuilderSupplier(UnsupportedProtocolException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyUniqueTargetGroupsPerLoadBalancer")
                                .exceptionBuilderSupplier(TooManyUniqueTargetGroupsPerLoadBalancerException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AllocationIdNotFound")
                                .exceptionBuilderSupplier(AllocationIdNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceInUse")
                                .exceptionBuilderSupplier(ResourceInUseException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DuplicateTargetGroupName")
                                .exceptionBuilderSupplier(DuplicateTargetGroupNameException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyRules")
                                .exceptionBuilderSupplier(TooManyRulesException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyCertificates")
                                .exceptionBuilderSupplier(TooManyCertificatesException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LoadBalancerNotFound")
                                .exceptionBuilderSupplier(LoadBalancerNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyTargetGroups")
                                .exceptionBuilderSupplier(TooManyTargetGroupsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyLoadBalancers")
                                .exceptionBuilderSupplier(TooManyLoadBalancersException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidConfigurationRequest")
                                .exceptionBuilderSupplier(InvalidConfigurationRequestException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TargetGroupAssociationLimit")
                                .exceptionBuilderSupplier(TargetGroupAssociationLimitException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidSecurityGroup")
                                .exceptionBuilderSupplier(InvalidSecurityGroupException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IncompatibleProtocols")
                                .exceptionBuilderSupplier(IncompatibleProtocolsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyActions")
                                .exceptionBuilderSupplier(TooManyActionsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyListeners")
                                .exceptionBuilderSupplier(TooManyListenersException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DuplicateLoadBalancerName")
                                .exceptionBuilderSupplier(DuplicateLoadBalancerNameException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OperationNotPermitted")
                                .exceptionBuilderSupplier(OperationNotPermittedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidLoadBalancerAction")
                                .exceptionBuilderSupplier(InvalidLoadBalancerActionException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CertificateNotFound")
                                .exceptionBuilderSupplier(CertificateNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DuplicateTagKeys")
                                .exceptionBuilderSupplier(DuplicateTagKeysException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyTags")
                                .exceptionBuilderSupplier(TooManyTagsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TargetGroupNotFound")
                                .exceptionBuilderSupplier(TargetGroupNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyRegistrationsForTargetId")
                                .exceptionBuilderSupplier(TooManyRegistrationsForTargetIdException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ListenerNotFound")
                                .exceptionBuilderSupplier(ListenerNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PriorityInUse")
                                .exceptionBuilderSupplier(PriorityInUseException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidTarget")
                                .exceptionBuilderSupplier(InvalidTargetException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SubnetNotFound")
                                .exceptionBuilderSupplier(SubnetNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AvailabilityZoneNotSupported")
                                .exceptionBuilderSupplier(AvailabilityZoneNotSupportedException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RuleNotFound")
                                .exceptionBuilderSupplier(RuleNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SSLPolicyNotFound")
                                .exceptionBuilderSupplier(SslPolicyNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DuplicateListener")
                                .exceptionBuilderSupplier(DuplicateListenerException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidScheme")
                                .exceptionBuilderSupplier(InvalidSchemeException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("HealthUnavailable")
                                .exceptionBuilderSupplier(HealthUnavailableException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidSubnet")
                                .exceptionBuilderSupplier(InvalidSubnetException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyTargets")
                                .exceptionBuilderSupplier(TooManyTargetsException::builder).httpStatusCode(400).build())
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(ElasticLoadBalancingV2Exception::builder).build();
    }

    private <T extends ElasticLoadBalancingV2Request> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }
}
