/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Request parameters when using an identity provider (IdP) that is compliant with OpenID Connect (OIDC) to authenticate
 * users.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuthenticateOidcActionConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<AuthenticateOidcActionConfig.Builder, AuthenticateOidcActionConfig> {
    private static final SdkField<String> ISSUER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AuthenticateOidcActionConfig::issuer)).setter(setter(Builder::issuer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Issuer").build()).build();

    private static final SdkField<String> AUTHORIZATION_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AuthenticateOidcActionConfig::authorizationEndpoint)).setter(setter(Builder::authorizationEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizationEndpoint").build())
            .build();

    private static final SdkField<String> TOKEN_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AuthenticateOidcActionConfig::tokenEndpoint)).setter(setter(Builder::tokenEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenEndpoint").build()).build();

    private static final SdkField<String> USER_INFO_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AuthenticateOidcActionConfig::userInfoEndpoint)).setter(setter(Builder::userInfoEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserInfoEndpoint").build()).build();

    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AuthenticateOidcActionConfig::clientId)).setter(setter(Builder::clientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId").build()).build();

    private static final SdkField<String> CLIENT_SECRET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AuthenticateOidcActionConfig::clientSecret)).setter(setter(Builder::clientSecret))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientSecret").build()).build();

    private static final SdkField<String> SESSION_COOKIE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AuthenticateOidcActionConfig::sessionCookieName)).setter(setter(Builder::sessionCookieName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionCookieName").build()).build();

    private static final SdkField<String> SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AuthenticateOidcActionConfig::scope)).setter(setter(Builder::scope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build()).build();

    private static final SdkField<Long> SESSION_TIMEOUT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(AuthenticateOidcActionConfig::sessionTimeout)).setter(setter(Builder::sessionTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionTimeout").build()).build();

    private static final SdkField<Map<String, String>> AUTHENTICATION_REQUEST_EXTRA_PARAMS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(AuthenticateOidcActionConfig::authenticationRequestExtraParams))
            .setter(setter(Builder::authenticationRequestExtraParams))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationRequestExtraParams")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> ON_UNAUTHENTICATED_REQUEST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AuthenticateOidcActionConfig::onUnauthenticatedRequestAsString))
            .setter(setter(Builder::onUnauthenticatedRequest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnUnauthenticatedRequest").build())
            .build();

    private static final SdkField<Boolean> USE_EXISTING_CLIENT_SECRET_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(AuthenticateOidcActionConfig::useExistingClientSecret))
            .setter(setter(Builder::useExistingClientSecret))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseExistingClientSecret").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ISSUER_FIELD,
            AUTHORIZATION_ENDPOINT_FIELD, TOKEN_ENDPOINT_FIELD, USER_INFO_ENDPOINT_FIELD, CLIENT_ID_FIELD, CLIENT_SECRET_FIELD,
            SESSION_COOKIE_NAME_FIELD, SCOPE_FIELD, SESSION_TIMEOUT_FIELD, AUTHENTICATION_REQUEST_EXTRA_PARAMS_FIELD,
            ON_UNAUTHENTICATED_REQUEST_FIELD, USE_EXISTING_CLIENT_SECRET_FIELD));

    private static final long serialVersionUID = 1L;

    private final String issuer;

    private final String authorizationEndpoint;

    private final String tokenEndpoint;

    private final String userInfoEndpoint;

    private final String clientId;

    private final String clientSecret;

    private final String sessionCookieName;

    private final String scope;

    private final Long sessionTimeout;

    private final Map<String, String> authenticationRequestExtraParams;

    private final String onUnauthenticatedRequest;

    private final Boolean useExistingClientSecret;

    private AuthenticateOidcActionConfig(BuilderImpl builder) {
        this.issuer = builder.issuer;
        this.authorizationEndpoint = builder.authorizationEndpoint;
        this.tokenEndpoint = builder.tokenEndpoint;
        this.userInfoEndpoint = builder.userInfoEndpoint;
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.sessionCookieName = builder.sessionCookieName;
        this.scope = builder.scope;
        this.sessionTimeout = builder.sessionTimeout;
        this.authenticationRequestExtraParams = builder.authenticationRequestExtraParams;
        this.onUnauthenticatedRequest = builder.onUnauthenticatedRequest;
        this.useExistingClientSecret = builder.useExistingClientSecret;
    }

    /**
     * <p>
     * The OIDC issuer identifier of the IdP. This must be a full URL, including the HTTPS protocol, the domain, and the
     * path.
     * </p>
     * 
     * @return The OIDC issuer identifier of the IdP. This must be a full URL, including the HTTPS protocol, the domain,
     *         and the path.
     */
    public String issuer() {
        return issuer;
    }

    /**
     * <p>
     * The authorization endpoint of the IdP. This must be a full URL, including the HTTPS protocol, the domain, and the
     * path.
     * </p>
     * 
     * @return The authorization endpoint of the IdP. This must be a full URL, including the HTTPS protocol, the domain,
     *         and the path.
     */
    public String authorizationEndpoint() {
        return authorizationEndpoint;
    }

    /**
     * <p>
     * The token endpoint of the IdP. This must be a full URL, including the HTTPS protocol, the domain, and the path.
     * </p>
     * 
     * @return The token endpoint of the IdP. This must be a full URL, including the HTTPS protocol, the domain, and the
     *         path.
     */
    public String tokenEndpoint() {
        return tokenEndpoint;
    }

    /**
     * <p>
     * The user info endpoint of the IdP. This must be a full URL, including the HTTPS protocol, the domain, and the
     * path.
     * </p>
     * 
     * @return The user info endpoint of the IdP. This must be a full URL, including the HTTPS protocol, the domain, and
     *         the path.
     */
    public String userInfoEndpoint() {
        return userInfoEndpoint;
    }

    /**
     * <p>
     * The OAuth 2.0 client identifier.
     * </p>
     * 
     * @return The OAuth 2.0 client identifier.
     */
    public String clientId() {
        return clientId;
    }

    /**
     * <p>
     * The OAuth 2.0 client secret. This parameter is required if you are creating a rule. If you are modifying a rule,
     * you can omit this parameter if you set <code>UseExistingClientSecret</code> to true.
     * </p>
     * 
     * @return The OAuth 2.0 client secret. This parameter is required if you are creating a rule. If you are modifying
     *         a rule, you can omit this parameter if you set <code>UseExistingClientSecret</code> to true.
     */
    public String clientSecret() {
        return clientSecret;
    }

    /**
     * <p>
     * The name of the cookie used to maintain session information. The default is AWSELBAuthSessionCookie.
     * </p>
     * 
     * @return The name of the cookie used to maintain session information. The default is AWSELBAuthSessionCookie.
     */
    public String sessionCookieName() {
        return sessionCookieName;
    }

    /**
     * <p>
     * The set of user claims to be requested from the IdP. The default is <code>openid</code>.
     * </p>
     * <p>
     * To verify which scope values your IdP supports and how to separate multiple values, see the documentation for
     * your IdP.
     * </p>
     * 
     * @return The set of user claims to be requested from the IdP. The default is <code>openid</code>.</p>
     *         <p>
     *         To verify which scope values your IdP supports and how to separate multiple values, see the documentation
     *         for your IdP.
     */
    public String scope() {
        return scope;
    }

    /**
     * <p>
     * The maximum duration of the authentication session, in seconds. The default is 604800 seconds (7 days).
     * </p>
     * 
     * @return The maximum duration of the authentication session, in seconds. The default is 604800 seconds (7 days).
     */
    public Long sessionTimeout() {
        return sessionTimeout;
    }

    /**
     * <p>
     * The query parameters (up to 10) to include in the redirect request to the authorization endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The query parameters (up to 10) to include in the redirect request to the authorization endpoint.
     */
    public Map<String, String> authenticationRequestExtraParams() {
        return authenticationRequestExtraParams;
    }

    /**
     * <p>
     * The behavior if the user is not authenticated. The following are possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * deny<code/> - Return an HTTP 401 Unauthorized error.
     * </p>
     * </li>
     * <li>
     * <p>
     * allow<code/> - Allow the request to be forwarded to the target.
     * </p>
     * </li>
     * <li>
     * <p>
     * authenticate<code/> - Redirect the request to the IdP authorization endpoint. This is the default value.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #onUnauthenticatedRequest} will return
     * {@link AuthenticateOidcActionConditionalBehaviorEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #onUnauthenticatedRequestAsString}.
     * </p>
     * 
     * @return The behavior if the user is not authenticated. The following are possible values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         deny<code/> - Return an HTTP 401 Unauthorized error.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         allow<code/> - Allow the request to be forwarded to the target.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         authenticate<code/> - Redirect the request to the IdP authorization endpoint. This is the default value.
     *         </p>
     *         </li>
     * @see AuthenticateOidcActionConditionalBehaviorEnum
     */
    public AuthenticateOidcActionConditionalBehaviorEnum onUnauthenticatedRequest() {
        return AuthenticateOidcActionConditionalBehaviorEnum.fromValue(onUnauthenticatedRequest);
    }

    /**
     * <p>
     * The behavior if the user is not authenticated. The following are possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * deny<code/> - Return an HTTP 401 Unauthorized error.
     * </p>
     * </li>
     * <li>
     * <p>
     * allow<code/> - Allow the request to be forwarded to the target.
     * </p>
     * </li>
     * <li>
     * <p>
     * authenticate<code/> - Redirect the request to the IdP authorization endpoint. This is the default value.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #onUnauthenticatedRequest} will return
     * {@link AuthenticateOidcActionConditionalBehaviorEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #onUnauthenticatedRequestAsString}.
     * </p>
     * 
     * @return The behavior if the user is not authenticated. The following are possible values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         deny<code/> - Return an HTTP 401 Unauthorized error.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         allow<code/> - Allow the request to be forwarded to the target.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         authenticate<code/> - Redirect the request to the IdP authorization endpoint. This is the default value.
     *         </p>
     *         </li>
     * @see AuthenticateOidcActionConditionalBehaviorEnum
     */
    public String onUnauthenticatedRequestAsString() {
        return onUnauthenticatedRequest;
    }

    /**
     * <p>
     * Indicates whether to use the existing client secret when modifying a rule. If you are creating a rule, you can
     * omit this parameter or set it to false.
     * </p>
     * 
     * @return Indicates whether to use the existing client secret when modifying a rule. If you are creating a rule,
     *         you can omit this parameter or set it to false.
     */
    public Boolean useExistingClientSecret() {
        return useExistingClientSecret;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(issuer());
        hashCode = 31 * hashCode + Objects.hashCode(authorizationEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(tokenEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(userInfoEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(clientId());
        hashCode = 31 * hashCode + Objects.hashCode(clientSecret());
        hashCode = 31 * hashCode + Objects.hashCode(sessionCookieName());
        hashCode = 31 * hashCode + Objects.hashCode(scope());
        hashCode = 31 * hashCode + Objects.hashCode(sessionTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(authenticationRequestExtraParams());
        hashCode = 31 * hashCode + Objects.hashCode(onUnauthenticatedRequestAsString());
        hashCode = 31 * hashCode + Objects.hashCode(useExistingClientSecret());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthenticateOidcActionConfig)) {
            return false;
        }
        AuthenticateOidcActionConfig other = (AuthenticateOidcActionConfig) obj;
        return Objects.equals(issuer(), other.issuer()) && Objects.equals(authorizationEndpoint(), other.authorizationEndpoint())
                && Objects.equals(tokenEndpoint(), other.tokenEndpoint())
                && Objects.equals(userInfoEndpoint(), other.userInfoEndpoint()) && Objects.equals(clientId(), other.clientId())
                && Objects.equals(clientSecret(), other.clientSecret())
                && Objects.equals(sessionCookieName(), other.sessionCookieName()) && Objects.equals(scope(), other.scope())
                && Objects.equals(sessionTimeout(), other.sessionTimeout())
                && Objects.equals(authenticationRequestExtraParams(), other.authenticationRequestExtraParams())
                && Objects.equals(onUnauthenticatedRequestAsString(), other.onUnauthenticatedRequestAsString())
                && Objects.equals(useExistingClientSecret(), other.useExistingClientSecret());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AuthenticateOidcActionConfig").add("Issuer", issuer())
                .add("AuthorizationEndpoint", authorizationEndpoint()).add("TokenEndpoint", tokenEndpoint())
                .add("UserInfoEndpoint", userInfoEndpoint()).add("ClientId", clientId()).add("ClientSecret", clientSecret())
                .add("SessionCookieName", sessionCookieName()).add("Scope", scope()).add("SessionTimeout", sessionTimeout())
                .add("AuthenticationRequestExtraParams", authenticationRequestExtraParams())
                .add("OnUnauthenticatedRequest", onUnauthenticatedRequestAsString())
                .add("UseExistingClientSecret", useExistingClientSecret()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Issuer":
            return Optional.ofNullable(clazz.cast(issuer()));
        case "AuthorizationEndpoint":
            return Optional.ofNullable(clazz.cast(authorizationEndpoint()));
        case "TokenEndpoint":
            return Optional.ofNullable(clazz.cast(tokenEndpoint()));
        case "UserInfoEndpoint":
            return Optional.ofNullable(clazz.cast(userInfoEndpoint()));
        case "ClientId":
            return Optional.ofNullable(clazz.cast(clientId()));
        case "ClientSecret":
            return Optional.ofNullable(clazz.cast(clientSecret()));
        case "SessionCookieName":
            return Optional.ofNullable(clazz.cast(sessionCookieName()));
        case "Scope":
            return Optional.ofNullable(clazz.cast(scope()));
        case "SessionTimeout":
            return Optional.ofNullable(clazz.cast(sessionTimeout()));
        case "AuthenticationRequestExtraParams":
            return Optional.ofNullable(clazz.cast(authenticationRequestExtraParams()));
        case "OnUnauthenticatedRequest":
            return Optional.ofNullable(clazz.cast(onUnauthenticatedRequestAsString()));
        case "UseExistingClientSecret":
            return Optional.ofNullable(clazz.cast(useExistingClientSecret()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AuthenticateOidcActionConfig, T> g) {
        return obj -> g.apply((AuthenticateOidcActionConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuthenticateOidcActionConfig> {
        /**
         * <p>
         * The OIDC issuer identifier of the IdP. This must be a full URL, including the HTTPS protocol, the domain, and
         * the path.
         * </p>
         * 
         * @param issuer
         *        The OIDC issuer identifier of the IdP. This must be a full URL, including the HTTPS protocol, the
         *        domain, and the path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issuer(String issuer);

        /**
         * <p>
         * The authorization endpoint of the IdP. This must be a full URL, including the HTTPS protocol, the domain, and
         * the path.
         * </p>
         * 
         * @param authorizationEndpoint
         *        The authorization endpoint of the IdP. This must be a full URL, including the HTTPS protocol, the
         *        domain, and the path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizationEndpoint(String authorizationEndpoint);

        /**
         * <p>
         * The token endpoint of the IdP. This must be a full URL, including the HTTPS protocol, the domain, and the
         * path.
         * </p>
         * 
         * @param tokenEndpoint
         *        The token endpoint of the IdP. This must be a full URL, including the HTTPS protocol, the domain, and
         *        the path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenEndpoint(String tokenEndpoint);

        /**
         * <p>
         * The user info endpoint of the IdP. This must be a full URL, including the HTTPS protocol, the domain, and the
         * path.
         * </p>
         * 
         * @param userInfoEndpoint
         *        The user info endpoint of the IdP. This must be a full URL, including the HTTPS protocol, the domain,
         *        and the path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userInfoEndpoint(String userInfoEndpoint);

        /**
         * <p>
         * The OAuth 2.0 client identifier.
         * </p>
         * 
         * @param clientId
         *        The OAuth 2.0 client identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientId(String clientId);

        /**
         * <p>
         * The OAuth 2.0 client secret. This parameter is required if you are creating a rule. If you are modifying a
         * rule, you can omit this parameter if you set <code>UseExistingClientSecret</code> to true.
         * </p>
         * 
         * @param clientSecret
         *        The OAuth 2.0 client secret. This parameter is required if you are creating a rule. If you are
         *        modifying a rule, you can omit this parameter if you set <code>UseExistingClientSecret</code> to true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientSecret(String clientSecret);

        /**
         * <p>
         * The name of the cookie used to maintain session information. The default is AWSELBAuthSessionCookie.
         * </p>
         * 
         * @param sessionCookieName
         *        The name of the cookie used to maintain session information. The default is AWSELBAuthSessionCookie.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionCookieName(String sessionCookieName);

        /**
         * <p>
         * The set of user claims to be requested from the IdP. The default is <code>openid</code>.
         * </p>
         * <p>
         * To verify which scope values your IdP supports and how to separate multiple values, see the documentation for
         * your IdP.
         * </p>
         * 
         * @param scope
         *        The set of user claims to be requested from the IdP. The default is <code>openid</code>.</p>
         *        <p>
         *        To verify which scope values your IdP supports and how to separate multiple values, see the
         *        documentation for your IdP.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scope(String scope);

        /**
         * <p>
         * The maximum duration of the authentication session, in seconds. The default is 604800 seconds (7 days).
         * </p>
         * 
         * @param sessionTimeout
         *        The maximum duration of the authentication session, in seconds. The default is 604800 seconds (7
         *        days).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionTimeout(Long sessionTimeout);

        /**
         * <p>
         * The query parameters (up to 10) to include in the redirect request to the authorization endpoint.
         * </p>
         * 
         * @param authenticationRequestExtraParams
         *        The query parameters (up to 10) to include in the redirect request to the authorization endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationRequestExtraParams(Map<String, String> authenticationRequestExtraParams);

        /**
         * <p>
         * The behavior if the user is not authenticated. The following are possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * deny<code/> - Return an HTTP 401 Unauthorized error.
         * </p>
         * </li>
         * <li>
         * <p>
         * allow<code/> - Allow the request to be forwarded to the target.
         * </p>
         * </li>
         * <li>
         * <p>
         * authenticate<code/> - Redirect the request to the IdP authorization endpoint. This is the default value.
         * </p>
         * </li>
         * </ul>
         * 
         * @param onUnauthenticatedRequest
         *        The behavior if the user is not authenticated. The following are possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        deny<code/> - Return an HTTP 401 Unauthorized error.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        allow<code/> - Allow the request to be forwarded to the target.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        authenticate
         *        <code/> - Redirect the request to the IdP authorization endpoint. This is the default value.
         *        </p>
         *        </li>
         * @see AuthenticateOidcActionConditionalBehaviorEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticateOidcActionConditionalBehaviorEnum
         */
        Builder onUnauthenticatedRequest(String onUnauthenticatedRequest);

        /**
         * <p>
         * The behavior if the user is not authenticated. The following are possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * deny<code/> - Return an HTTP 401 Unauthorized error.
         * </p>
         * </li>
         * <li>
         * <p>
         * allow<code/> - Allow the request to be forwarded to the target.
         * </p>
         * </li>
         * <li>
         * <p>
         * authenticate<code/> - Redirect the request to the IdP authorization endpoint. This is the default value.
         * </p>
         * </li>
         * </ul>
         * 
         * @param onUnauthenticatedRequest
         *        The behavior if the user is not authenticated. The following are possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        deny<code/> - Return an HTTP 401 Unauthorized error.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        allow<code/> - Allow the request to be forwarded to the target.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        authenticate
         *        <code/> - Redirect the request to the IdP authorization endpoint. This is the default value.
         *        </p>
         *        </li>
         * @see AuthenticateOidcActionConditionalBehaviorEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticateOidcActionConditionalBehaviorEnum
         */
        Builder onUnauthenticatedRequest(AuthenticateOidcActionConditionalBehaviorEnum onUnauthenticatedRequest);

        /**
         * <p>
         * Indicates whether to use the existing client secret when modifying a rule. If you are creating a rule, you
         * can omit this parameter or set it to false.
         * </p>
         * 
         * @param useExistingClientSecret
         *        Indicates whether to use the existing client secret when modifying a rule. If you are creating a rule,
         *        you can omit this parameter or set it to false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useExistingClientSecret(Boolean useExistingClientSecret);
    }

    static final class BuilderImpl implements Builder {
        private String issuer;

        private String authorizationEndpoint;

        private String tokenEndpoint;

        private String userInfoEndpoint;

        private String clientId;

        private String clientSecret;

        private String sessionCookieName;

        private String scope;

        private Long sessionTimeout;

        private Map<String, String> authenticationRequestExtraParams = DefaultSdkAutoConstructMap.getInstance();

        private String onUnauthenticatedRequest;

        private Boolean useExistingClientSecret;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthenticateOidcActionConfig model) {
            issuer(model.issuer);
            authorizationEndpoint(model.authorizationEndpoint);
            tokenEndpoint(model.tokenEndpoint);
            userInfoEndpoint(model.userInfoEndpoint);
            clientId(model.clientId);
            clientSecret(model.clientSecret);
            sessionCookieName(model.sessionCookieName);
            scope(model.scope);
            sessionTimeout(model.sessionTimeout);
            authenticationRequestExtraParams(model.authenticationRequestExtraParams);
            onUnauthenticatedRequest(model.onUnauthenticatedRequest);
            useExistingClientSecret(model.useExistingClientSecret);
        }

        public final String getIssuer() {
            return issuer;
        }

        @Override
        public final Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public final void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        public final String getAuthorizationEndpoint() {
            return authorizationEndpoint;
        }

        @Override
        public final Builder authorizationEndpoint(String authorizationEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
            return this;
        }

        public final void setAuthorizationEndpoint(String authorizationEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
        }

        public final String getTokenEndpoint() {
            return tokenEndpoint;
        }

        @Override
        public final Builder tokenEndpoint(String tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint;
            return this;
        }

        public final void setTokenEndpoint(String tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint;
        }

        public final String getUserInfoEndpoint() {
            return userInfoEndpoint;
        }

        @Override
        public final Builder userInfoEndpoint(String userInfoEndpoint) {
            this.userInfoEndpoint = userInfoEndpoint;
            return this;
        }

        public final void setUserInfoEndpoint(String userInfoEndpoint) {
            this.userInfoEndpoint = userInfoEndpoint;
        }

        public final String getClientId() {
            return clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public final String getClientSecret() {
            return clientSecret;
        }

        @Override
        public final Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public final void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        public final String getSessionCookieName() {
            return sessionCookieName;
        }

        @Override
        public final Builder sessionCookieName(String sessionCookieName) {
            this.sessionCookieName = sessionCookieName;
            return this;
        }

        public final void setSessionCookieName(String sessionCookieName) {
            this.sessionCookieName = sessionCookieName;
        }

        public final String getScope() {
            return scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        public final Long getSessionTimeout() {
            return sessionTimeout;
        }

        @Override
        public final Builder sessionTimeout(Long sessionTimeout) {
            this.sessionTimeout = sessionTimeout;
            return this;
        }

        public final void setSessionTimeout(Long sessionTimeout) {
            this.sessionTimeout = sessionTimeout;
        }

        public final Map<String, String> getAuthenticationRequestExtraParams() {
            return authenticationRequestExtraParams;
        }

        @Override
        public final Builder authenticationRequestExtraParams(Map<String, String> authenticationRequestExtraParams) {
            this.authenticationRequestExtraParams = AuthenticateOidcActionAuthenticationRequestExtraParamsCopier
                    .copy(authenticationRequestExtraParams);
            return this;
        }

        public final void setAuthenticationRequestExtraParams(Map<String, String> authenticationRequestExtraParams) {
            this.authenticationRequestExtraParams = AuthenticateOidcActionAuthenticationRequestExtraParamsCopier
                    .copy(authenticationRequestExtraParams);
        }

        public final String getOnUnauthenticatedRequestAsString() {
            return onUnauthenticatedRequest;
        }

        @Override
        public final Builder onUnauthenticatedRequest(String onUnauthenticatedRequest) {
            this.onUnauthenticatedRequest = onUnauthenticatedRequest;
            return this;
        }

        @Override
        public final Builder onUnauthenticatedRequest(AuthenticateOidcActionConditionalBehaviorEnum onUnauthenticatedRequest) {
            this.onUnauthenticatedRequest(onUnauthenticatedRequest == null ? null : onUnauthenticatedRequest.toString());
            return this;
        }

        public final void setOnUnauthenticatedRequest(String onUnauthenticatedRequest) {
            this.onUnauthenticatedRequest = onUnauthenticatedRequest;
        }

        public final Boolean getUseExistingClientSecret() {
            return useExistingClientSecret;
        }

        @Override
        public final Builder useExistingClientSecret(Boolean useExistingClientSecret) {
            this.useExistingClientSecret = useExistingClientSecret;
            return this;
        }

        public final void setUseExistingClientSecret(Boolean useExistingClientSecret) {
            this.useExistingClientSecret = useExistingClientSecret;
        }

        @Override
        public AuthenticateOidcActionConfig build() {
            return new AuthenticateOidcActionConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
