/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyTargetGroupRequest extends ElasticLoadBalancingV2Request implements
        ToCopyableBuilder<ModifyTargetGroupRequest.Builder, ModifyTargetGroupRequest> {
    private static final SdkField<String> TARGET_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyTargetGroupRequest::targetGroupArn)).setter(setter(Builder::targetGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetGroupArn").build()).build();

    private static final SdkField<String> HEALTH_CHECK_PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyTargetGroupRequest::healthCheckProtocolAsString)).setter(setter(Builder::healthCheckProtocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckProtocol").build())
            .build();

    private static final SdkField<String> HEALTH_CHECK_PORT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyTargetGroupRequest::healthCheckPort)).setter(setter(Builder::healthCheckPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckPort").build()).build();

    private static final SdkField<String> HEALTH_CHECK_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyTargetGroupRequest::healthCheckPath)).setter(setter(Builder::healthCheckPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckPath").build()).build();

    private static final SdkField<Boolean> HEALTH_CHECK_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ModifyTargetGroupRequest::healthCheckEnabled)).setter(setter(Builder::healthCheckEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckEnabled").build())
            .build();

    private static final SdkField<Integer> HEALTH_CHECK_INTERVAL_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ModifyTargetGroupRequest::healthCheckIntervalSeconds))
            .setter(setter(Builder::healthCheckIntervalSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckIntervalSeconds").build())
            .build();

    private static final SdkField<Integer> HEALTH_CHECK_TIMEOUT_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).getter(getter(ModifyTargetGroupRequest::healthCheckTimeoutSeconds))
            .setter(setter(Builder::healthCheckTimeoutSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckTimeoutSeconds").build())
            .build();

    private static final SdkField<Integer> HEALTHY_THRESHOLD_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ModifyTargetGroupRequest::healthyThresholdCount)).setter(setter(Builder::healthyThresholdCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthyThresholdCount").build())
            .build();

    private static final SdkField<Integer> UNHEALTHY_THRESHOLD_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ModifyTargetGroupRequest::unhealthyThresholdCount)).setter(setter(Builder::unhealthyThresholdCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnhealthyThresholdCount").build())
            .build();

    private static final SdkField<Matcher> MATCHER_FIELD = SdkField.<Matcher> builder(MarshallingType.SDK_POJO)
            .getter(getter(ModifyTargetGroupRequest::matcher)).setter(setter(Builder::matcher)).constructor(Matcher::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Matcher").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_GROUP_ARN_FIELD,
            HEALTH_CHECK_PROTOCOL_FIELD, HEALTH_CHECK_PORT_FIELD, HEALTH_CHECK_PATH_FIELD, HEALTH_CHECK_ENABLED_FIELD,
            HEALTH_CHECK_INTERVAL_SECONDS_FIELD, HEALTH_CHECK_TIMEOUT_SECONDS_FIELD, HEALTHY_THRESHOLD_COUNT_FIELD,
            UNHEALTHY_THRESHOLD_COUNT_FIELD, MATCHER_FIELD));

    private final String targetGroupArn;

    private final String healthCheckProtocol;

    private final String healthCheckPort;

    private final String healthCheckPath;

    private final Boolean healthCheckEnabled;

    private final Integer healthCheckIntervalSeconds;

    private final Integer healthCheckTimeoutSeconds;

    private final Integer healthyThresholdCount;

    private final Integer unhealthyThresholdCount;

    private final Matcher matcher;

    private ModifyTargetGroupRequest(BuilderImpl builder) {
        super(builder);
        this.targetGroupArn = builder.targetGroupArn;
        this.healthCheckProtocol = builder.healthCheckProtocol;
        this.healthCheckPort = builder.healthCheckPort;
        this.healthCheckPath = builder.healthCheckPath;
        this.healthCheckEnabled = builder.healthCheckEnabled;
        this.healthCheckIntervalSeconds = builder.healthCheckIntervalSeconds;
        this.healthCheckTimeoutSeconds = builder.healthCheckTimeoutSeconds;
        this.healthyThresholdCount = builder.healthyThresholdCount;
        this.unhealthyThresholdCount = builder.unhealthyThresholdCount;
        this.matcher = builder.matcher;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the target group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the target group.
     */
    public String targetGroupArn() {
        return targetGroupArn;
    }

    /**
     * <p>
     * The protocol the load balancer uses when performing health checks on targets. The TCP protocol is supported for
     * health checks only if the protocol of the target group is TCP, TLS, UDP, or TCP_UDP. The TLS, UDP, and TCP_UDP
     * protocols are not supported for health checks.
     * </p>
     * <p>
     * With Network Load Balancers, you can't modify this setting.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #healthCheckProtocol} will return {@link ProtocolEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #healthCheckProtocolAsString}.
     * </p>
     * 
     * @return The protocol the load balancer uses when performing health checks on targets. The TCP protocol is
     *         supported for health checks only if the protocol of the target group is TCP, TLS, UDP, or TCP_UDP. The
     *         TLS, UDP, and TCP_UDP protocols are not supported for health checks.</p>
     *         <p>
     *         With Network Load Balancers, you can't modify this setting.
     * @see ProtocolEnum
     */
    public ProtocolEnum healthCheckProtocol() {
        return ProtocolEnum.fromValue(healthCheckProtocol);
    }

    /**
     * <p>
     * The protocol the load balancer uses when performing health checks on targets. The TCP protocol is supported for
     * health checks only if the protocol of the target group is TCP, TLS, UDP, or TCP_UDP. The TLS, UDP, and TCP_UDP
     * protocols are not supported for health checks.
     * </p>
     * <p>
     * With Network Load Balancers, you can't modify this setting.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #healthCheckProtocol} will return {@link ProtocolEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #healthCheckProtocolAsString}.
     * </p>
     * 
     * @return The protocol the load balancer uses when performing health checks on targets. The TCP protocol is
     *         supported for health checks only if the protocol of the target group is TCP, TLS, UDP, or TCP_UDP. The
     *         TLS, UDP, and TCP_UDP protocols are not supported for health checks.</p>
     *         <p>
     *         With Network Load Balancers, you can't modify this setting.
     * @see ProtocolEnum
     */
    public String healthCheckProtocolAsString() {
        return healthCheckProtocol;
    }

    /**
     * <p>
     * The port the load balancer uses when performing health checks on targets.
     * </p>
     * 
     * @return The port the load balancer uses when performing health checks on targets.
     */
    public String healthCheckPort() {
        return healthCheckPort;
    }

    /**
     * <p>
     * [HTTP/HTTPS health checks] The ping path that is the destination for the health check request.
     * </p>
     * 
     * @return [HTTP/HTTPS health checks] The ping path that is the destination for the health check request.
     */
    public String healthCheckPath() {
        return healthCheckPath;
    }

    /**
     * <p>
     * Indicates whether health checks are enabled.
     * </p>
     * 
     * @return Indicates whether health checks are enabled.
     */
    public Boolean healthCheckEnabled() {
        return healthCheckEnabled;
    }

    /**
     * <p>
     * The approximate amount of time, in seconds, between health checks of an individual target. For Application Load
     * Balancers, the range is 5 to 300 seconds. For Network Load Balancers, the supported values are 10 or 30 seconds.
     * </p>
     * <p>
     * With Network Load Balancers, you can't modify this setting.
     * </p>
     * 
     * @return The approximate amount of time, in seconds, between health checks of an individual target. For
     *         Application Load Balancers, the range is 5 to 300 seconds. For Network Load Balancers, the supported
     *         values are 10 or 30 seconds.</p>
     *         <p>
     *         With Network Load Balancers, you can't modify this setting.
     */
    public Integer healthCheckIntervalSeconds() {
        return healthCheckIntervalSeconds;
    }

    /**
     * <p>
     * [HTTP/HTTPS health checks] The amount of time, in seconds, during which no response means a failed health check.
     * </p>
     * <p>
     * With Network Load Balancers, you can't modify this setting.
     * </p>
     * 
     * @return [HTTP/HTTPS health checks] The amount of time, in seconds, during which no response means a failed health
     *         check.</p>
     *         <p>
     *         With Network Load Balancers, you can't modify this setting.
     */
    public Integer healthCheckTimeoutSeconds() {
        return healthCheckTimeoutSeconds;
    }

    /**
     * <p>
     * The number of consecutive health checks successes required before considering an unhealthy target healthy.
     * </p>
     * 
     * @return The number of consecutive health checks successes required before considering an unhealthy target
     *         healthy.
     */
    public Integer healthyThresholdCount() {
        return healthyThresholdCount;
    }

    /**
     * <p>
     * The number of consecutive health check failures required before considering the target unhealthy. For Network
     * Load Balancers, this value must be the same as the healthy threshold count.
     * </p>
     * 
     * @return The number of consecutive health check failures required before considering the target unhealthy. For
     *         Network Load Balancers, this value must be the same as the healthy threshold count.
     */
    public Integer unhealthyThresholdCount() {
        return unhealthyThresholdCount;
    }

    /**
     * <p>
     * [HTTP/HTTPS health checks] The HTTP codes to use when checking for a successful response from a target.
     * </p>
     * <p>
     * With Network Load Balancers, you can't modify this setting.
     * </p>
     * 
     * @return [HTTP/HTTPS health checks] The HTTP codes to use when checking for a successful response from a
     *         target.</p>
     *         <p>
     *         With Network Load Balancers, you can't modify this setting.
     */
    public Matcher matcher() {
        return matcher;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(targetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckProtocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckPort());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckPath());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckIntervalSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckTimeoutSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(healthyThresholdCount());
        hashCode = 31 * hashCode + Objects.hashCode(unhealthyThresholdCount());
        hashCode = 31 * hashCode + Objects.hashCode(matcher());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyTargetGroupRequest)) {
            return false;
        }
        ModifyTargetGroupRequest other = (ModifyTargetGroupRequest) obj;
        return Objects.equals(targetGroupArn(), other.targetGroupArn())
                && Objects.equals(healthCheckProtocolAsString(), other.healthCheckProtocolAsString())
                && Objects.equals(healthCheckPort(), other.healthCheckPort())
                && Objects.equals(healthCheckPath(), other.healthCheckPath())
                && Objects.equals(healthCheckEnabled(), other.healthCheckEnabled())
                && Objects.equals(healthCheckIntervalSeconds(), other.healthCheckIntervalSeconds())
                && Objects.equals(healthCheckTimeoutSeconds(), other.healthCheckTimeoutSeconds())
                && Objects.equals(healthyThresholdCount(), other.healthyThresholdCount())
                && Objects.equals(unhealthyThresholdCount(), other.unhealthyThresholdCount())
                && Objects.equals(matcher(), other.matcher());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ModifyTargetGroupRequest").add("TargetGroupArn", targetGroupArn())
                .add("HealthCheckProtocol", healthCheckProtocolAsString()).add("HealthCheckPort", healthCheckPort())
                .add("HealthCheckPath", healthCheckPath()).add("HealthCheckEnabled", healthCheckEnabled())
                .add("HealthCheckIntervalSeconds", healthCheckIntervalSeconds())
                .add("HealthCheckTimeoutSeconds", healthCheckTimeoutSeconds())
                .add("HealthyThresholdCount", healthyThresholdCount()).add("UnhealthyThresholdCount", unhealthyThresholdCount())
                .add("Matcher", matcher()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetGroupArn":
            return Optional.ofNullable(clazz.cast(targetGroupArn()));
        case "HealthCheckProtocol":
            return Optional.ofNullable(clazz.cast(healthCheckProtocolAsString()));
        case "HealthCheckPort":
            return Optional.ofNullable(clazz.cast(healthCheckPort()));
        case "HealthCheckPath":
            return Optional.ofNullable(clazz.cast(healthCheckPath()));
        case "HealthCheckEnabled":
            return Optional.ofNullable(clazz.cast(healthCheckEnabled()));
        case "HealthCheckIntervalSeconds":
            return Optional.ofNullable(clazz.cast(healthCheckIntervalSeconds()));
        case "HealthCheckTimeoutSeconds":
            return Optional.ofNullable(clazz.cast(healthCheckTimeoutSeconds()));
        case "HealthyThresholdCount":
            return Optional.ofNullable(clazz.cast(healthyThresholdCount()));
        case "UnhealthyThresholdCount":
            return Optional.ofNullable(clazz.cast(unhealthyThresholdCount()));
        case "Matcher":
            return Optional.ofNullable(clazz.cast(matcher()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyTargetGroupRequest, T> g) {
        return obj -> g.apply((ModifyTargetGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticLoadBalancingV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyTargetGroupRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the target group.
         * </p>
         * 
         * @param targetGroupArn
         *        The Amazon Resource Name (ARN) of the target group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetGroupArn(String targetGroupArn);

        /**
         * <p>
         * The protocol the load balancer uses when performing health checks on targets. The TCP protocol is supported
         * for health checks only if the protocol of the target group is TCP, TLS, UDP, or TCP_UDP. The TLS, UDP, and
         * TCP_UDP protocols are not supported for health checks.
         * </p>
         * <p>
         * With Network Load Balancers, you can't modify this setting.
         * </p>
         * 
         * @param healthCheckProtocol
         *        The protocol the load balancer uses when performing health checks on targets. The TCP protocol is
         *        supported for health checks only if the protocol of the target group is TCP, TLS, UDP, or TCP_UDP. The
         *        TLS, UDP, and TCP_UDP protocols are not supported for health checks.</p>
         *        <p>
         *        With Network Load Balancers, you can't modify this setting.
         * @see ProtocolEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtocolEnum
         */
        Builder healthCheckProtocol(String healthCheckProtocol);

        /**
         * <p>
         * The protocol the load balancer uses when performing health checks on targets. The TCP protocol is supported
         * for health checks only if the protocol of the target group is TCP, TLS, UDP, or TCP_UDP. The TLS, UDP, and
         * TCP_UDP protocols are not supported for health checks.
         * </p>
         * <p>
         * With Network Load Balancers, you can't modify this setting.
         * </p>
         * 
         * @param healthCheckProtocol
         *        The protocol the load balancer uses when performing health checks on targets. The TCP protocol is
         *        supported for health checks only if the protocol of the target group is TCP, TLS, UDP, or TCP_UDP. The
         *        TLS, UDP, and TCP_UDP protocols are not supported for health checks.</p>
         *        <p>
         *        With Network Load Balancers, you can't modify this setting.
         * @see ProtocolEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtocolEnum
         */
        Builder healthCheckProtocol(ProtocolEnum healthCheckProtocol);

        /**
         * <p>
         * The port the load balancer uses when performing health checks on targets.
         * </p>
         * 
         * @param healthCheckPort
         *        The port the load balancer uses when performing health checks on targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckPort(String healthCheckPort);

        /**
         * <p>
         * [HTTP/HTTPS health checks] The ping path that is the destination for the health check request.
         * </p>
         * 
         * @param healthCheckPath
         *        [HTTP/HTTPS health checks] The ping path that is the destination for the health check request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckPath(String healthCheckPath);

        /**
         * <p>
         * Indicates whether health checks are enabled.
         * </p>
         * 
         * @param healthCheckEnabled
         *        Indicates whether health checks are enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckEnabled(Boolean healthCheckEnabled);

        /**
         * <p>
         * The approximate amount of time, in seconds, between health checks of an individual target. For Application
         * Load Balancers, the range is 5 to 300 seconds. For Network Load Balancers, the supported values are 10 or 30
         * seconds.
         * </p>
         * <p>
         * With Network Load Balancers, you can't modify this setting.
         * </p>
         * 
         * @param healthCheckIntervalSeconds
         *        The approximate amount of time, in seconds, between health checks of an individual target. For
         *        Application Load Balancers, the range is 5 to 300 seconds. For Network Load Balancers, the supported
         *        values are 10 or 30 seconds.</p>
         *        <p>
         *        With Network Load Balancers, you can't modify this setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckIntervalSeconds(Integer healthCheckIntervalSeconds);

        /**
         * <p>
         * [HTTP/HTTPS health checks] The amount of time, in seconds, during which no response means a failed health
         * check.
         * </p>
         * <p>
         * With Network Load Balancers, you can't modify this setting.
         * </p>
         * 
         * @param healthCheckTimeoutSeconds
         *        [HTTP/HTTPS health checks] The amount of time, in seconds, during which no response means a failed
         *        health check.</p>
         *        <p>
         *        With Network Load Balancers, you can't modify this setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckTimeoutSeconds(Integer healthCheckTimeoutSeconds);

        /**
         * <p>
         * The number of consecutive health checks successes required before considering an unhealthy target healthy.
         * </p>
         * 
         * @param healthyThresholdCount
         *        The number of consecutive health checks successes required before considering an unhealthy target
         *        healthy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthyThresholdCount(Integer healthyThresholdCount);

        /**
         * <p>
         * The number of consecutive health check failures required before considering the target unhealthy. For Network
         * Load Balancers, this value must be the same as the healthy threshold count.
         * </p>
         * 
         * @param unhealthyThresholdCount
         *        The number of consecutive health check failures required before considering the target unhealthy. For
         *        Network Load Balancers, this value must be the same as the healthy threshold count.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unhealthyThresholdCount(Integer unhealthyThresholdCount);

        /**
         * <p>
         * [HTTP/HTTPS health checks] The HTTP codes to use when checking for a successful response from a target.
         * </p>
         * <p>
         * With Network Load Balancers, you can't modify this setting.
         * </p>
         * 
         * @param matcher
         *        [HTTP/HTTPS health checks] The HTTP codes to use when checking for a successful response from a
         *        target.</p>
         *        <p>
         *        With Network Load Balancers, you can't modify this setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matcher(Matcher matcher);

        /**
         * <p>
         * [HTTP/HTTPS health checks] The HTTP codes to use when checking for a successful response from a target.
         * </p>
         * <p>
         * With Network Load Balancers, you can't modify this setting.
         * </p>
         * This is a convenience that creates an instance of the {@link Matcher.Builder} avoiding the need to create one
         * manually via {@link Matcher#builder()}.
         *
         * When the {@link Consumer} completes, {@link Matcher.Builder#build()} is called immediately and its result is
         * passed to {@link #matcher(Matcher)}.
         * 
         * @param matcher
         *        a consumer that will call methods on {@link Matcher.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #matcher(Matcher)
         */
        default Builder matcher(Consumer<Matcher.Builder> matcher) {
            return matcher(Matcher.builder().applyMutation(matcher).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticLoadBalancingV2Request.BuilderImpl implements Builder {
        private String targetGroupArn;

        private String healthCheckProtocol;

        private String healthCheckPort;

        private String healthCheckPath;

        private Boolean healthCheckEnabled;

        private Integer healthCheckIntervalSeconds;

        private Integer healthCheckTimeoutSeconds;

        private Integer healthyThresholdCount;

        private Integer unhealthyThresholdCount;

        private Matcher matcher;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyTargetGroupRequest model) {
            super(model);
            targetGroupArn(model.targetGroupArn);
            healthCheckProtocol(model.healthCheckProtocol);
            healthCheckPort(model.healthCheckPort);
            healthCheckPath(model.healthCheckPath);
            healthCheckEnabled(model.healthCheckEnabled);
            healthCheckIntervalSeconds(model.healthCheckIntervalSeconds);
            healthCheckTimeoutSeconds(model.healthCheckTimeoutSeconds);
            healthyThresholdCount(model.healthyThresholdCount);
            unhealthyThresholdCount(model.unhealthyThresholdCount);
            matcher(model.matcher);
        }

        public final String getTargetGroupArn() {
            return targetGroupArn;
        }

        @Override
        public final Builder targetGroupArn(String targetGroupArn) {
            this.targetGroupArn = targetGroupArn;
            return this;
        }

        public final void setTargetGroupArn(String targetGroupArn) {
            this.targetGroupArn = targetGroupArn;
        }

        public final String getHealthCheckProtocolAsString() {
            return healthCheckProtocol;
        }

        @Override
        public final Builder healthCheckProtocol(String healthCheckProtocol) {
            this.healthCheckProtocol = healthCheckProtocol;
            return this;
        }

        @Override
        public final Builder healthCheckProtocol(ProtocolEnum healthCheckProtocol) {
            this.healthCheckProtocol(healthCheckProtocol == null ? null : healthCheckProtocol.toString());
            return this;
        }

        public final void setHealthCheckProtocol(String healthCheckProtocol) {
            this.healthCheckProtocol = healthCheckProtocol;
        }

        public final String getHealthCheckPort() {
            return healthCheckPort;
        }

        @Override
        public final Builder healthCheckPort(String healthCheckPort) {
            this.healthCheckPort = healthCheckPort;
            return this;
        }

        public final void setHealthCheckPort(String healthCheckPort) {
            this.healthCheckPort = healthCheckPort;
        }

        public final String getHealthCheckPath() {
            return healthCheckPath;
        }

        @Override
        public final Builder healthCheckPath(String healthCheckPath) {
            this.healthCheckPath = healthCheckPath;
            return this;
        }

        public final void setHealthCheckPath(String healthCheckPath) {
            this.healthCheckPath = healthCheckPath;
        }

        public final Boolean getHealthCheckEnabled() {
            return healthCheckEnabled;
        }

        @Override
        public final Builder healthCheckEnabled(Boolean healthCheckEnabled) {
            this.healthCheckEnabled = healthCheckEnabled;
            return this;
        }

        public final void setHealthCheckEnabled(Boolean healthCheckEnabled) {
            this.healthCheckEnabled = healthCheckEnabled;
        }

        public final Integer getHealthCheckIntervalSeconds() {
            return healthCheckIntervalSeconds;
        }

        @Override
        public final Builder healthCheckIntervalSeconds(Integer healthCheckIntervalSeconds) {
            this.healthCheckIntervalSeconds = healthCheckIntervalSeconds;
            return this;
        }

        public final void setHealthCheckIntervalSeconds(Integer healthCheckIntervalSeconds) {
            this.healthCheckIntervalSeconds = healthCheckIntervalSeconds;
        }

        public final Integer getHealthCheckTimeoutSeconds() {
            return healthCheckTimeoutSeconds;
        }

        @Override
        public final Builder healthCheckTimeoutSeconds(Integer healthCheckTimeoutSeconds) {
            this.healthCheckTimeoutSeconds = healthCheckTimeoutSeconds;
            return this;
        }

        public final void setHealthCheckTimeoutSeconds(Integer healthCheckTimeoutSeconds) {
            this.healthCheckTimeoutSeconds = healthCheckTimeoutSeconds;
        }

        public final Integer getHealthyThresholdCount() {
            return healthyThresholdCount;
        }

        @Override
        public final Builder healthyThresholdCount(Integer healthyThresholdCount) {
            this.healthyThresholdCount = healthyThresholdCount;
            return this;
        }

        public final void setHealthyThresholdCount(Integer healthyThresholdCount) {
            this.healthyThresholdCount = healthyThresholdCount;
        }

        public final Integer getUnhealthyThresholdCount() {
            return unhealthyThresholdCount;
        }

        @Override
        public final Builder unhealthyThresholdCount(Integer unhealthyThresholdCount) {
            this.unhealthyThresholdCount = unhealthyThresholdCount;
            return this;
        }

        public final void setUnhealthyThresholdCount(Integer unhealthyThresholdCount) {
            this.unhealthyThresholdCount = unhealthyThresholdCount;
        }

        public final Matcher.Builder getMatcher() {
            return matcher != null ? matcher.toBuilder() : null;
        }

        @Override
        public final Builder matcher(Matcher matcher) {
            this.matcher = matcher;
            return this;
        }

        public final void setMatcher(Matcher.BuilderImpl matcher) {
            this.matcher = matcher != null ? matcher.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyTargetGroupRequest build() {
            return new ModifyTargetGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
