/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRulesRequest extends ElasticLoadBalancingV2Request implements
        ToCopyableBuilder<DescribeRulesRequest.Builder, DescribeRulesRequest> {
    private static final SdkField<String> LISTENER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ListenerArn").getter(getter(DescribeRulesRequest::listenerArn)).setter(setter(Builder::listenerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListenerArn").build()).build();

    private static final SdkField<List<String>> RULE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RuleArns")
            .getter(getter(DescribeRulesRequest::ruleArns))
            .setter(setter(Builder::ruleArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeRulesRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PageSize").getter(getter(DescribeRulesRequest::pageSize)).setter(setter(Builder::pageSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageSize").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LISTENER_ARN_FIELD,
            RULE_ARNS_FIELD, MARKER_FIELD, PAGE_SIZE_FIELD));

    private final String listenerArn;

    private final List<String> ruleArns;

    private final String marker;

    private final Integer pageSize;

    private DescribeRulesRequest(BuilderImpl builder) {
        super(builder);
        this.listenerArn = builder.listenerArn;
        this.ruleArns = builder.ruleArns;
        this.marker = builder.marker;
        this.pageSize = builder.pageSize;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the listener.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the listener.
     */
    public String listenerArn() {
        return listenerArn;
    }

    /**
     * Returns true if the RuleArns property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasRuleArns() {
        return ruleArns != null && !(ruleArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names (ARN) of the rules.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRuleArns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Amazon Resource Names (ARN) of the rules.
     */
    public List<String> ruleArns() {
        return ruleArns;
    }

    /**
     * <p>
     * The marker for the next set of results. (You received this marker from a previous call.)
     * </p>
     * 
     * @return The marker for the next set of results. (You received this marker from a previous call.)
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * The maximum number of results to return with this call.
     * </p>
     * 
     * @return The maximum number of results to return with this call.
     */
    public Integer pageSize() {
        return pageSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(listenerArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasRuleArns() ? ruleArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(pageSize());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRulesRequest)) {
            return false;
        }
        DescribeRulesRequest other = (DescribeRulesRequest) obj;
        return Objects.equals(listenerArn(), other.listenerArn()) && hasRuleArns() == other.hasRuleArns()
                && Objects.equals(ruleArns(), other.ruleArns()) && Objects.equals(marker(), other.marker())
                && Objects.equals(pageSize(), other.pageSize());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeRulesRequest").add("ListenerArn", listenerArn())
                .add("RuleArns", hasRuleArns() ? ruleArns() : null).add("Marker", marker()).add("PageSize", pageSize()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ListenerArn":
            return Optional.ofNullable(clazz.cast(listenerArn()));
        case "RuleArns":
            return Optional.ofNullable(clazz.cast(ruleArns()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "PageSize":
            return Optional.ofNullable(clazz.cast(pageSize()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRulesRequest, T> g) {
        return obj -> g.apply((DescribeRulesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticLoadBalancingV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeRulesRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the listener.
         * </p>
         * 
         * @param listenerArn
         *        The Amazon Resource Name (ARN) of the listener.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listenerArn(String listenerArn);

        /**
         * <p>
         * The Amazon Resource Names (ARN) of the rules.
         * </p>
         * 
         * @param ruleArns
         *        The Amazon Resource Names (ARN) of the rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleArns(Collection<String> ruleArns);

        /**
         * <p>
         * The Amazon Resource Names (ARN) of the rules.
         * </p>
         * 
         * @param ruleArns
         *        The Amazon Resource Names (ARN) of the rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleArns(String... ruleArns);

        /**
         * <p>
         * The marker for the next set of results. (You received this marker from a previous call.)
         * </p>
         * 
         * @param marker
         *        The marker for the next set of results. (You received this marker from a previous call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The maximum number of results to return with this call.
         * </p>
         * 
         * @param pageSize
         *        The maximum number of results to return with this call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageSize(Integer pageSize);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticLoadBalancingV2Request.BuilderImpl implements Builder {
        private String listenerArn;

        private List<String> ruleArns = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private Integer pageSize;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRulesRequest model) {
            super(model);
            listenerArn(model.listenerArn);
            ruleArns(model.ruleArns);
            marker(model.marker);
            pageSize(model.pageSize);
        }

        public final String getListenerArn() {
            return listenerArn;
        }

        @Override
        public final Builder listenerArn(String listenerArn) {
            this.listenerArn = listenerArn;
            return this;
        }

        public final void setListenerArn(String listenerArn) {
            this.listenerArn = listenerArn;
        }

        public final Collection<String> getRuleArns() {
            if (ruleArns instanceof SdkAutoConstructList) {
                return null;
            }
            return ruleArns;
        }

        @Override
        public final Builder ruleArns(Collection<String> ruleArns) {
            this.ruleArns = RuleArnsCopier.copy(ruleArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleArns(String... ruleArns) {
            ruleArns(Arrays.asList(ruleArns));
            return this;
        }

        public final void setRuleArns(Collection<String> ruleArns) {
            this.ruleArns = RuleArnsCopier.copy(ruleArns);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Integer getPageSize() {
            return pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeRulesRequest build() {
            return new DescribeRulesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
