/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateListenerResponse extends ElasticLoadBalancingV2Response implements
        ToCopyableBuilder<CreateListenerResponse.Builder, CreateListenerResponse> {
    private static final SdkField<List<Listener>> LISTENERS_FIELD = SdkField
            .<List<Listener>> builder(MarshallingType.LIST)
            .memberName("Listeners")
            .getter(getter(CreateListenerResponse::listeners))
            .setter(setter(Builder::listeners))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Listeners").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Listener> builder(MarshallingType.SDK_POJO)
                                            .constructor(Listener::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LISTENERS_FIELD));

    private final List<Listener> listeners;

    private CreateListenerResponse(BuilderImpl builder) {
        super(builder);
        this.listeners = builder.listeners;
    }

    /**
     * Returns true if the Listeners property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasListeners() {
        return listeners != null && !(listeners instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the listener.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasListeners()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the listener.
     */
    public List<Listener> listeners() {
        return listeners;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasListeners() ? listeners() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateListenerResponse)) {
            return false;
        }
        CreateListenerResponse other = (CreateListenerResponse) obj;
        return hasListeners() == other.hasListeners() && Objects.equals(listeners(), other.listeners());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateListenerResponse").add("Listeners", hasListeners() ? listeners() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Listeners":
            return Optional.ofNullable(clazz.cast(listeners()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateListenerResponse, T> g) {
        return obj -> g.apply((CreateListenerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticLoadBalancingV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateListenerResponse> {
        /**
         * <p>
         * Information about the listener.
         * </p>
         * 
         * @param listeners
         *        Information about the listener.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listeners(Collection<Listener> listeners);

        /**
         * <p>
         * Information about the listener.
         * </p>
         * 
         * @param listeners
         *        Information about the listener.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listeners(Listener... listeners);

        /**
         * <p>
         * Information about the listener.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Listener>.Builder} avoiding the need to
         * create one manually via {@link List<Listener>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Listener>.Builder#build()} is called immediately and its
         * result is passed to {@link #listeners(List<Listener>)}.
         * 
         * @param listeners
         *        a consumer that will call methods on {@link List<Listener>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listeners(List<Listener>)
         */
        Builder listeners(Consumer<Listener.Builder>... listeners);
    }

    static final class BuilderImpl extends ElasticLoadBalancingV2Response.BuilderImpl implements Builder {
        private List<Listener> listeners = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateListenerResponse model) {
            super(model);
            listeners(model.listeners);
        }

        public final Collection<Listener.Builder> getListeners() {
            if (listeners instanceof SdkAutoConstructList) {
                return null;
            }
            return listeners != null ? listeners.stream().map(Listener::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder listeners(Collection<Listener> listeners) {
            this.listeners = ListenersCopier.copy(listeners);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listeners(Listener... listeners) {
            listeners(Arrays.asList(listeners));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listeners(Consumer<Listener.Builder>... listeners) {
            listeners(Stream.of(listeners).map(c -> Listener.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setListeners(Collection<Listener.BuilderImpl> listeners) {
            this.listeners = ListenersCopier.copyFromBuilder(listeners);
        }

        @Override
        public CreateListenerResponse build() {
            return new CreateListenerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
