/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTargetGroupRequest extends ElasticLoadBalancingV2Request implements
        ToCopyableBuilder<CreateTargetGroupRequest.Builder, CreateTargetGroupRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateTargetGroupRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Protocol").getter(getter(CreateTargetGroupRequest::protocolAsString)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()).build();

    private static final SdkField<String> PROTOCOL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProtocolVersion").getter(getter(CreateTargetGroupRequest::protocolVersion))
            .setter(setter(Builder::protocolVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtocolVersion").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(CreateTargetGroupRequest::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(CreateTargetGroupRequest::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<String> HEALTH_CHECK_PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HealthCheckProtocol").getter(getter(CreateTargetGroupRequest::healthCheckProtocolAsString))
            .setter(setter(Builder::healthCheckProtocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckProtocol").build())
            .build();

    private static final SdkField<String> HEALTH_CHECK_PORT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HealthCheckPort").getter(getter(CreateTargetGroupRequest::healthCheckPort))
            .setter(setter(Builder::healthCheckPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckPort").build()).build();

    private static final SdkField<Boolean> HEALTH_CHECK_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("HealthCheckEnabled").getter(getter(CreateTargetGroupRequest::healthCheckEnabled))
            .setter(setter(Builder::healthCheckEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckEnabled").build())
            .build();

    private static final SdkField<String> HEALTH_CHECK_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HealthCheckPath").getter(getter(CreateTargetGroupRequest::healthCheckPath))
            .setter(setter(Builder::healthCheckPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckPath").build()).build();

    private static final SdkField<Integer> HEALTH_CHECK_INTERVAL_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("HealthCheckIntervalSeconds")
            .getter(getter(CreateTargetGroupRequest::healthCheckIntervalSeconds))
            .setter(setter(Builder::healthCheckIntervalSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckIntervalSeconds").build())
            .build();

    private static final SdkField<Integer> HEALTH_CHECK_TIMEOUT_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("HealthCheckTimeoutSeconds")
            .getter(getter(CreateTargetGroupRequest::healthCheckTimeoutSeconds))
            .setter(setter(Builder::healthCheckTimeoutSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckTimeoutSeconds").build())
            .build();

    private static final SdkField<Integer> HEALTHY_THRESHOLD_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("HealthyThresholdCount").getter(getter(CreateTargetGroupRequest::healthyThresholdCount))
            .setter(setter(Builder::healthyThresholdCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthyThresholdCount").build())
            .build();

    private static final SdkField<Integer> UNHEALTHY_THRESHOLD_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("UnhealthyThresholdCount").getter(getter(CreateTargetGroupRequest::unhealthyThresholdCount))
            .setter(setter(Builder::unhealthyThresholdCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnhealthyThresholdCount").build())
            .build();

    private static final SdkField<Matcher> MATCHER_FIELD = SdkField.<Matcher> builder(MarshallingType.SDK_POJO)
            .memberName("Matcher").getter(getter(CreateTargetGroupRequest::matcher)).setter(setter(Builder::matcher))
            .constructor(Matcher::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Matcher").build()).build();

    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetType").getter(getter(CreateTargetGroupRequest::targetTypeAsString))
            .setter(setter(Builder::targetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetType").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateTargetGroupRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, PROTOCOL_FIELD,
            PROTOCOL_VERSION_FIELD, PORT_FIELD, VPC_ID_FIELD, HEALTH_CHECK_PROTOCOL_FIELD, HEALTH_CHECK_PORT_FIELD,
            HEALTH_CHECK_ENABLED_FIELD, HEALTH_CHECK_PATH_FIELD, HEALTH_CHECK_INTERVAL_SECONDS_FIELD,
            HEALTH_CHECK_TIMEOUT_SECONDS_FIELD, HEALTHY_THRESHOLD_COUNT_FIELD, UNHEALTHY_THRESHOLD_COUNT_FIELD, MATCHER_FIELD,
            TARGET_TYPE_FIELD, TAGS_FIELD));

    private final String name;

    private final String protocol;

    private final String protocolVersion;

    private final Integer port;

    private final String vpcId;

    private final String healthCheckProtocol;

    private final String healthCheckPort;

    private final Boolean healthCheckEnabled;

    private final String healthCheckPath;

    private final Integer healthCheckIntervalSeconds;

    private final Integer healthCheckTimeoutSeconds;

    private final Integer healthyThresholdCount;

    private final Integer unhealthyThresholdCount;

    private final Matcher matcher;

    private final String targetType;

    private final List<Tag> tags;

    private CreateTargetGroupRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.protocol = builder.protocol;
        this.protocolVersion = builder.protocolVersion;
        this.port = builder.port;
        this.vpcId = builder.vpcId;
        this.healthCheckProtocol = builder.healthCheckProtocol;
        this.healthCheckPort = builder.healthCheckPort;
        this.healthCheckEnabled = builder.healthCheckEnabled;
        this.healthCheckPath = builder.healthCheckPath;
        this.healthCheckIntervalSeconds = builder.healthCheckIntervalSeconds;
        this.healthCheckTimeoutSeconds = builder.healthCheckTimeoutSeconds;
        this.healthyThresholdCount = builder.healthyThresholdCount;
        this.unhealthyThresholdCount = builder.unhealthyThresholdCount;
        this.matcher = builder.matcher;
        this.targetType = builder.targetType;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the target group.
     * </p>
     * <p>
     * This name must be unique per region per account, can have a maximum of 32 characters, must contain only
     * alphanumeric characters or hyphens, and must not begin or end with a hyphen.
     * </p>
     * 
     * @return The name of the target group.</p>
     *         <p>
     *         This name must be unique per region per account, can have a maximum of 32 characters, must contain only
     *         alphanumeric characters or hyphens, and must not begin or end with a hyphen.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The protocol to use for routing traffic to the targets. For Application Load Balancers, the supported protocols
     * are HTTP and HTTPS. For Network Load Balancers, the supported protocols are TCP, TLS, UDP, or TCP_UDP. For
     * Gateway Load Balancers, the supported protocol is GENEVE. A TCP_UDP listener must be associated with a TCP_UDP
     * target group. If the target is a Lambda function, this parameter does not apply.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link ProtocolEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol to use for routing traffic to the targets. For Application Load Balancers, the supported
     *         protocols are HTTP and HTTPS. For Network Load Balancers, the supported protocols are TCP, TLS, UDP, or
     *         TCP_UDP. For Gateway Load Balancers, the supported protocol is GENEVE. A TCP_UDP listener must be
     *         associated with a TCP_UDP target group. If the target is a Lambda function, this parameter does not
     *         apply.
     * @see ProtocolEnum
     */
    public ProtocolEnum protocol() {
        return ProtocolEnum.fromValue(protocol);
    }

    /**
     * <p>
     * The protocol to use for routing traffic to the targets. For Application Load Balancers, the supported protocols
     * are HTTP and HTTPS. For Network Load Balancers, the supported protocols are TCP, TLS, UDP, or TCP_UDP. For
     * Gateway Load Balancers, the supported protocol is GENEVE. A TCP_UDP listener must be associated with a TCP_UDP
     * target group. If the target is a Lambda function, this parameter does not apply.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link ProtocolEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol to use for routing traffic to the targets. For Application Load Balancers, the supported
     *         protocols are HTTP and HTTPS. For Network Load Balancers, the supported protocols are TCP, TLS, UDP, or
     *         TCP_UDP. For Gateway Load Balancers, the supported protocol is GENEVE. A TCP_UDP listener must be
     *         associated with a TCP_UDP target group. If the target is a Lambda function, this parameter does not
     *         apply.
     * @see ProtocolEnum
     */
    public String protocolAsString() {
        return protocol;
    }

    /**
     * <p>
     * [HTTP/HTTPS protocol] The protocol version. Specify <code>GRPC</code> to send requests to targets using gRPC.
     * Specify <code>HTTP2</code> to send requests to targets using HTTP/2. The default is <code>HTTP1</code>, which
     * sends requests to targets using HTTP/1.1.
     * </p>
     * 
     * @return [HTTP/HTTPS protocol] The protocol version. Specify <code>GRPC</code> to send requests to targets using
     *         gRPC. Specify <code>HTTP2</code> to send requests to targets using HTTP/2. The default is
     *         <code>HTTP1</code>, which sends requests to targets using HTTP/1.1.
     */
    public String protocolVersion() {
        return protocolVersion;
    }

    /**
     * <p>
     * The port on which the targets receive traffic. This port is used unless you specify a port override when
     * registering the target. If the target is a Lambda function, this parameter does not apply. If the protocol is
     * GENEVE, the supported port is 6081.
     * </p>
     * 
     * @return The port on which the targets receive traffic. This port is used unless you specify a port override when
     *         registering the target. If the target is a Lambda function, this parameter does not apply. If the
     *         protocol is GENEVE, the supported port is 6081.
     */
    public Integer port() {
        return port;
    }

    /**
     * <p>
     * The identifier of the virtual private cloud (VPC). If the target is a Lambda function, this parameter does not
     * apply. Otherwise, this parameter is required.
     * </p>
     * 
     * @return The identifier of the virtual private cloud (VPC). If the target is a Lambda function, this parameter
     *         does not apply. Otherwise, this parameter is required.
     */
    public String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * The protocol the load balancer uses when performing health checks on targets. For Application Load Balancers, the
     * default is HTTP. For Network Load Balancers and Gateway Load Balancers, the default is TCP. The TCP protocol is
     * not supported for health checks if the protocol of the target group is HTTP or HTTPS. The GENEVE, TLS, UDP, and
     * TCP_UDP protocols are not supported for health checks.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #healthCheckProtocol} will return {@link ProtocolEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #healthCheckProtocolAsString}.
     * </p>
     * 
     * @return The protocol the load balancer uses when performing health checks on targets. For Application Load
     *         Balancers, the default is HTTP. For Network Load Balancers and Gateway Load Balancers, the default is
     *         TCP. The TCP protocol is not supported for health checks if the protocol of the target group is HTTP or
     *         HTTPS. The GENEVE, TLS, UDP, and TCP_UDP protocols are not supported for health checks.
     * @see ProtocolEnum
     */
    public ProtocolEnum healthCheckProtocol() {
        return ProtocolEnum.fromValue(healthCheckProtocol);
    }

    /**
     * <p>
     * The protocol the load balancer uses when performing health checks on targets. For Application Load Balancers, the
     * default is HTTP. For Network Load Balancers and Gateway Load Balancers, the default is TCP. The TCP protocol is
     * not supported for health checks if the protocol of the target group is HTTP or HTTPS. The GENEVE, TLS, UDP, and
     * TCP_UDP protocols are not supported for health checks.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #healthCheckProtocol} will return {@link ProtocolEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #healthCheckProtocolAsString}.
     * </p>
     * 
     * @return The protocol the load balancer uses when performing health checks on targets. For Application Load
     *         Balancers, the default is HTTP. For Network Load Balancers and Gateway Load Balancers, the default is
     *         TCP. The TCP protocol is not supported for health checks if the protocol of the target group is HTTP or
     *         HTTPS. The GENEVE, TLS, UDP, and TCP_UDP protocols are not supported for health checks.
     * @see ProtocolEnum
     */
    public String healthCheckProtocolAsString() {
        return healthCheckProtocol;
    }

    /**
     * <p>
     * The port the load balancer uses when performing health checks on targets. If the protocol is HTTP, HTTPS, TCP,
     * TLS, UDP, or TCP_UDP, the default is <code>traffic-port</code>, which is the port on which each target receives
     * traffic from the load balancer. If the protocol is GENEVE, the default is port 80.
     * </p>
     * 
     * @return The port the load balancer uses when performing health checks on targets. If the protocol is HTTP, HTTPS,
     *         TCP, TLS, UDP, or TCP_UDP, the default is <code>traffic-port</code>, which is the port on which each
     *         target receives traffic from the load balancer. If the protocol is GENEVE, the default is port 80.
     */
    public String healthCheckPort() {
        return healthCheckPort;
    }

    /**
     * <p>
     * Indicates whether health checks are enabled. If the target type is <code>lambda</code>, health checks are
     * disabled by default but can be enabled. If the target type is <code>instance</code> or <code>ip</code>, health
     * checks are always enabled and cannot be disabled.
     * </p>
     * 
     * @return Indicates whether health checks are enabled. If the target type is <code>lambda</code>, health checks are
     *         disabled by default but can be enabled. If the target type is <code>instance</code> or <code>ip</code>,
     *         health checks are always enabled and cannot be disabled.
     */
    public Boolean healthCheckEnabled() {
        return healthCheckEnabled;
    }

    /**
     * <p>
     * [HTTP/HTTPS health checks] The destination for health checks on the targets.
     * </p>
     * <p>
     * [HTTP1 or HTTP2 protocol version] The ping path. The default is /.
     * </p>
     * <p>
     * [GRPC protocol version] The path of a custom health check method with the format /package.service/method. The
     * default is /AWS.ALB/healthcheck.
     * </p>
     * 
     * @return [HTTP/HTTPS health checks] The destination for health checks on the targets.</p>
     *         <p>
     *         [HTTP1 or HTTP2 protocol version] The ping path. The default is /.
     *         </p>
     *         <p>
     *         [GRPC protocol version] The path of a custom health check method with the format /package.service/method.
     *         The default is /AWS.ALB/healthcheck.
     */
    public String healthCheckPath() {
        return healthCheckPath;
    }

    /**
     * <p>
     * The approximate amount of time, in seconds, between health checks of an individual target. For TCP health checks,
     * the supported values are 10 and 30 seconds. If the target type is <code>instance</code> or <code>ip</code>, the
     * default is 30 seconds. If the target group protocol is GENEVE, the default is 10 seconds. If the target type is
     * <code>lambda</code>, the default is 35 seconds.
     * </p>
     * 
     * @return The approximate amount of time, in seconds, between health checks of an individual target. For TCP health
     *         checks, the supported values are 10 and 30 seconds. If the target type is <code>instance</code> or
     *         <code>ip</code>, the default is 30 seconds. If the target group protocol is GENEVE, the default is 10
     *         seconds. If the target type is <code>lambda</code>, the default is 35 seconds.
     */
    public Integer healthCheckIntervalSeconds() {
        return healthCheckIntervalSeconds;
    }

    /**
     * <p>
     * The amount of time, in seconds, during which no response from a target means a failed health check. For target
     * groups with a protocol of HTTP, HTTPS, or GENEVE, the default is 5 seconds. For target groups with a protocol of
     * TCP or TLS, this value must be 6 seconds for HTTP health checks and 10 seconds for TCP and HTTPS health checks.
     * If the target type is <code>lambda</code>, the default is 30 seconds.
     * </p>
     * 
     * @return The amount of time, in seconds, during which no response from a target means a failed health check. For
     *         target groups with a protocol of HTTP, HTTPS, or GENEVE, the default is 5 seconds. For target groups with
     *         a protocol of TCP or TLS, this value must be 6 seconds for HTTP health checks and 10 seconds for TCP and
     *         HTTPS health checks. If the target type is <code>lambda</code>, the default is 30 seconds.
     */
    public Integer healthCheckTimeoutSeconds() {
        return healthCheckTimeoutSeconds;
    }

    /**
     * <p>
     * The number of consecutive health checks successes required before considering an unhealthy target healthy. For
     * target groups with a protocol of HTTP or HTTPS, the default is 5. For target groups with a protocol of TCP, TLS,
     * or GENEVE, the default is 3. If the target type is <code>lambda</code>, the default is 5.
     * </p>
     * 
     * @return The number of consecutive health checks successes required before considering an unhealthy target
     *         healthy. For target groups with a protocol of HTTP or HTTPS, the default is 5. For target groups with a
     *         protocol of TCP, TLS, or GENEVE, the default is 3. If the target type is <code>lambda</code>, the default
     *         is 5.
     */
    public Integer healthyThresholdCount() {
        return healthyThresholdCount;
    }

    /**
     * <p>
     * The number of consecutive health check failures required before considering a target unhealthy. If the target
     * group protocol is HTTP or HTTPS, the default is 2. If the target group protocol is TCP or TLS, this value must be
     * the same as the healthy threshold count. If the target group protocol is GENEVE, the default is 3. If the target
     * type is <code>lambda</code>, the default is 2.
     * </p>
     * 
     * @return The number of consecutive health check failures required before considering a target unhealthy. If the
     *         target group protocol is HTTP or HTTPS, the default is 2. If the target group protocol is TCP or TLS,
     *         this value must be the same as the healthy threshold count. If the target group protocol is GENEVE, the
     *         default is 3. If the target type is <code>lambda</code>, the default is 2.
     */
    public Integer unhealthyThresholdCount() {
        return unhealthyThresholdCount;
    }

    /**
     * <p>
     * [HTTP/HTTPS health checks] The HTTP or gRPC codes to use when checking for a successful response from a target.
     * </p>
     * 
     * @return [HTTP/HTTPS health checks] The HTTP or gRPC codes to use when checking for a successful response from a
     *         target.
     */
    public Matcher matcher() {
        return matcher;
    }

    /**
     * <p>
     * The type of target that you must specify when registering targets with this target group. You can't specify
     * targets for a target group using more than one target type.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>instance</code> - Register targets by instance ID. This is the default value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ip</code> - Register targets by IP address. You can specify IP addresses from the subnets of the virtual
     * private cloud (VPC) for the target group, the RFC 1918 range (10.0.0.0/8, 172.16.0.0/12, and 192.168.0.0/16), and
     * the RFC 6598 range (100.64.0.0/10). You can't specify publicly routable IP addresses.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>lambda</code> - Register a single Lambda function as a target.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetType} will
     * return {@link TargetTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetTypeAsString}.
     * </p>
     * 
     * @return The type of target that you must specify when registering targets with this target group. You can't
     *         specify targets for a target group using more than one target type.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>instance</code> - Register targets by instance ID. This is the default value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ip</code> - Register targets by IP address. You can specify IP addresses from the subnets of the
     *         virtual private cloud (VPC) for the target group, the RFC 1918 range (10.0.0.0/8, 172.16.0.0/12, and
     *         192.168.0.0/16), and the RFC 6598 range (100.64.0.0/10). You can't specify publicly routable IP
     *         addresses.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>lambda</code> - Register a single Lambda function as a target.
     *         </p>
     *         </li>
     * @see TargetTypeEnum
     */
    public TargetTypeEnum targetType() {
        return TargetTypeEnum.fromValue(targetType);
    }

    /**
     * <p>
     * The type of target that you must specify when registering targets with this target group. You can't specify
     * targets for a target group using more than one target type.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>instance</code> - Register targets by instance ID. This is the default value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ip</code> - Register targets by IP address. You can specify IP addresses from the subnets of the virtual
     * private cloud (VPC) for the target group, the RFC 1918 range (10.0.0.0/8, 172.16.0.0/12, and 192.168.0.0/16), and
     * the RFC 6598 range (100.64.0.0/10). You can't specify publicly routable IP addresses.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>lambda</code> - Register a single Lambda function as a target.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetType} will
     * return {@link TargetTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetTypeAsString}.
     * </p>
     * 
     * @return The type of target that you must specify when registering targets with this target group. You can't
     *         specify targets for a target group using more than one target type.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>instance</code> - Register targets by instance ID. This is the default value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ip</code> - Register targets by IP address. You can specify IP addresses from the subnets of the
     *         virtual private cloud (VPC) for the target group, the RFC 1918 range (10.0.0.0/8, 172.16.0.0/12, and
     *         192.168.0.0/16), and the RFC 6598 range (100.64.0.0/10). You can't specify publicly routable IP
     *         addresses.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>lambda</code> - Register a single Lambda function as a target.
     *         </p>
     *         </li>
     * @see TargetTypeEnum
     */
    public String targetTypeAsString() {
        return targetType;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to assign to the target group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags to assign to the target group.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(protocolVersion());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckProtocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckPort());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckPath());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckIntervalSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckTimeoutSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(healthyThresholdCount());
        hashCode = 31 * hashCode + Objects.hashCode(unhealthyThresholdCount());
        hashCode = 31 * hashCode + Objects.hashCode(matcher());
        hashCode = 31 * hashCode + Objects.hashCode(targetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTargetGroupRequest)) {
            return false;
        }
        CreateTargetGroupRequest other = (CreateTargetGroupRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(protocolAsString(), other.protocolAsString())
                && Objects.equals(protocolVersion(), other.protocolVersion()) && Objects.equals(port(), other.port())
                && Objects.equals(vpcId(), other.vpcId())
                && Objects.equals(healthCheckProtocolAsString(), other.healthCheckProtocolAsString())
                && Objects.equals(healthCheckPort(), other.healthCheckPort())
                && Objects.equals(healthCheckEnabled(), other.healthCheckEnabled())
                && Objects.equals(healthCheckPath(), other.healthCheckPath())
                && Objects.equals(healthCheckIntervalSeconds(), other.healthCheckIntervalSeconds())
                && Objects.equals(healthCheckTimeoutSeconds(), other.healthCheckTimeoutSeconds())
                && Objects.equals(healthyThresholdCount(), other.healthyThresholdCount())
                && Objects.equals(unhealthyThresholdCount(), other.unhealthyThresholdCount())
                && Objects.equals(matcher(), other.matcher()) && Objects.equals(targetTypeAsString(), other.targetTypeAsString())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateTargetGroupRequest").add("Name", name()).add("Protocol", protocolAsString())
                .add("ProtocolVersion", protocolVersion()).add("Port", port()).add("VpcId", vpcId())
                .add("HealthCheckProtocol", healthCheckProtocolAsString()).add("HealthCheckPort", healthCheckPort())
                .add("HealthCheckEnabled", healthCheckEnabled()).add("HealthCheckPath", healthCheckPath())
                .add("HealthCheckIntervalSeconds", healthCheckIntervalSeconds())
                .add("HealthCheckTimeoutSeconds", healthCheckTimeoutSeconds())
                .add("HealthyThresholdCount", healthyThresholdCount()).add("UnhealthyThresholdCount", unhealthyThresholdCount())
                .add("Matcher", matcher()).add("TargetType", targetTypeAsString()).add("Tags", hasTags() ? tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        case "ProtocolVersion":
            return Optional.ofNullable(clazz.cast(protocolVersion()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "HealthCheckProtocol":
            return Optional.ofNullable(clazz.cast(healthCheckProtocolAsString()));
        case "HealthCheckPort":
            return Optional.ofNullable(clazz.cast(healthCheckPort()));
        case "HealthCheckEnabled":
            return Optional.ofNullable(clazz.cast(healthCheckEnabled()));
        case "HealthCheckPath":
            return Optional.ofNullable(clazz.cast(healthCheckPath()));
        case "HealthCheckIntervalSeconds":
            return Optional.ofNullable(clazz.cast(healthCheckIntervalSeconds()));
        case "HealthCheckTimeoutSeconds":
            return Optional.ofNullable(clazz.cast(healthCheckTimeoutSeconds()));
        case "HealthyThresholdCount":
            return Optional.ofNullable(clazz.cast(healthyThresholdCount()));
        case "UnhealthyThresholdCount":
            return Optional.ofNullable(clazz.cast(unhealthyThresholdCount()));
        case "Matcher":
            return Optional.ofNullable(clazz.cast(matcher()));
        case "TargetType":
            return Optional.ofNullable(clazz.cast(targetTypeAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTargetGroupRequest, T> g) {
        return obj -> g.apply((CreateTargetGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticLoadBalancingV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateTargetGroupRequest> {
        /**
         * <p>
         * The name of the target group.
         * </p>
         * <p>
         * This name must be unique per region per account, can have a maximum of 32 characters, must contain only
         * alphanumeric characters or hyphens, and must not begin or end with a hyphen.
         * </p>
         * 
         * @param name
         *        The name of the target group.</p>
         *        <p>
         *        This name must be unique per region per account, can have a maximum of 32 characters, must contain
         *        only alphanumeric characters or hyphens, and must not begin or end with a hyphen.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The protocol to use for routing traffic to the targets. For Application Load Balancers, the supported
         * protocols are HTTP and HTTPS. For Network Load Balancers, the supported protocols are TCP, TLS, UDP, or
         * TCP_UDP. For Gateway Load Balancers, the supported protocol is GENEVE. A TCP_UDP listener must be associated
         * with a TCP_UDP target group. If the target is a Lambda function, this parameter does not apply.
         * </p>
         * 
         * @param protocol
         *        The protocol to use for routing traffic to the targets. For Application Load Balancers, the supported
         *        protocols are HTTP and HTTPS. For Network Load Balancers, the supported protocols are TCP, TLS, UDP,
         *        or TCP_UDP. For Gateway Load Balancers, the supported protocol is GENEVE. A TCP_UDP listener must be
         *        associated with a TCP_UDP target group. If the target is a Lambda function, this parameter does not
         *        apply.
         * @see ProtocolEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtocolEnum
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The protocol to use for routing traffic to the targets. For Application Load Balancers, the supported
         * protocols are HTTP and HTTPS. For Network Load Balancers, the supported protocols are TCP, TLS, UDP, or
         * TCP_UDP. For Gateway Load Balancers, the supported protocol is GENEVE. A TCP_UDP listener must be associated
         * with a TCP_UDP target group. If the target is a Lambda function, this parameter does not apply.
         * </p>
         * 
         * @param protocol
         *        The protocol to use for routing traffic to the targets. For Application Load Balancers, the supported
         *        protocols are HTTP and HTTPS. For Network Load Balancers, the supported protocols are TCP, TLS, UDP,
         *        or TCP_UDP. For Gateway Load Balancers, the supported protocol is GENEVE. A TCP_UDP listener must be
         *        associated with a TCP_UDP target group. If the target is a Lambda function, this parameter does not
         *        apply.
         * @see ProtocolEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtocolEnum
         */
        Builder protocol(ProtocolEnum protocol);

        /**
         * <p>
         * [HTTP/HTTPS protocol] The protocol version. Specify <code>GRPC</code> to send requests to targets using gRPC.
         * Specify <code>HTTP2</code> to send requests to targets using HTTP/2. The default is <code>HTTP1</code>, which
         * sends requests to targets using HTTP/1.1.
         * </p>
         * 
         * @param protocolVersion
         *        [HTTP/HTTPS protocol] The protocol version. Specify <code>GRPC</code> to send requests to targets
         *        using gRPC. Specify <code>HTTP2</code> to send requests to targets using HTTP/2. The default is
         *        <code>HTTP1</code>, which sends requests to targets using HTTP/1.1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocolVersion(String protocolVersion);

        /**
         * <p>
         * The port on which the targets receive traffic. This port is used unless you specify a port override when
         * registering the target. If the target is a Lambda function, this parameter does not apply. If the protocol is
         * GENEVE, the supported port is 6081.
         * </p>
         * 
         * @param port
         *        The port on which the targets receive traffic. This port is used unless you specify a port override
         *        when registering the target. If the target is a Lambda function, this parameter does not apply. If the
         *        protocol is GENEVE, the supported port is 6081.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The identifier of the virtual private cloud (VPC). If the target is a Lambda function, this parameter does
         * not apply. Otherwise, this parameter is required.
         * </p>
         * 
         * @param vpcId
         *        The identifier of the virtual private cloud (VPC). If the target is a Lambda function, this parameter
         *        does not apply. Otherwise, this parameter is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The protocol the load balancer uses when performing health checks on targets. For Application Load Balancers,
         * the default is HTTP. For Network Load Balancers and Gateway Load Balancers, the default is TCP. The TCP
         * protocol is not supported for health checks if the protocol of the target group is HTTP or HTTPS. The GENEVE,
         * TLS, UDP, and TCP_UDP protocols are not supported for health checks.
         * </p>
         * 
         * @param healthCheckProtocol
         *        The protocol the load balancer uses when performing health checks on targets. For Application Load
         *        Balancers, the default is HTTP. For Network Load Balancers and Gateway Load Balancers, the default is
         *        TCP. The TCP protocol is not supported for health checks if the protocol of the target group is HTTP
         *        or HTTPS. The GENEVE, TLS, UDP, and TCP_UDP protocols are not supported for health checks.
         * @see ProtocolEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtocolEnum
         */
        Builder healthCheckProtocol(String healthCheckProtocol);

        /**
         * <p>
         * The protocol the load balancer uses when performing health checks on targets. For Application Load Balancers,
         * the default is HTTP. For Network Load Balancers and Gateway Load Balancers, the default is TCP. The TCP
         * protocol is not supported for health checks if the protocol of the target group is HTTP or HTTPS. The GENEVE,
         * TLS, UDP, and TCP_UDP protocols are not supported for health checks.
         * </p>
         * 
         * @param healthCheckProtocol
         *        The protocol the load balancer uses when performing health checks on targets. For Application Load
         *        Balancers, the default is HTTP. For Network Load Balancers and Gateway Load Balancers, the default is
         *        TCP. The TCP protocol is not supported for health checks if the protocol of the target group is HTTP
         *        or HTTPS. The GENEVE, TLS, UDP, and TCP_UDP protocols are not supported for health checks.
         * @see ProtocolEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtocolEnum
         */
        Builder healthCheckProtocol(ProtocolEnum healthCheckProtocol);

        /**
         * <p>
         * The port the load balancer uses when performing health checks on targets. If the protocol is HTTP, HTTPS,
         * TCP, TLS, UDP, or TCP_UDP, the default is <code>traffic-port</code>, which is the port on which each target
         * receives traffic from the load balancer. If the protocol is GENEVE, the default is port 80.
         * </p>
         * 
         * @param healthCheckPort
         *        The port the load balancer uses when performing health checks on targets. If the protocol is HTTP,
         *        HTTPS, TCP, TLS, UDP, or TCP_UDP, the default is <code>traffic-port</code>, which is the port on which
         *        each target receives traffic from the load balancer. If the protocol is GENEVE, the default is port
         *        80.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckPort(String healthCheckPort);

        /**
         * <p>
         * Indicates whether health checks are enabled. If the target type is <code>lambda</code>, health checks are
         * disabled by default but can be enabled. If the target type is <code>instance</code> or <code>ip</code>,
         * health checks are always enabled and cannot be disabled.
         * </p>
         * 
         * @param healthCheckEnabled
         *        Indicates whether health checks are enabled. If the target type is <code>lambda</code>, health checks
         *        are disabled by default but can be enabled. If the target type is <code>instance</code> or
         *        <code>ip</code>, health checks are always enabled and cannot be disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckEnabled(Boolean healthCheckEnabled);

        /**
         * <p>
         * [HTTP/HTTPS health checks] The destination for health checks on the targets.
         * </p>
         * <p>
         * [HTTP1 or HTTP2 protocol version] The ping path. The default is /.
         * </p>
         * <p>
         * [GRPC protocol version] The path of a custom health check method with the format /package.service/method. The
         * default is /AWS.ALB/healthcheck.
         * </p>
         * 
         * @param healthCheckPath
         *        [HTTP/HTTPS health checks] The destination for health checks on the targets.</p>
         *        <p>
         *        [HTTP1 or HTTP2 protocol version] The ping path. The default is /.
         *        </p>
         *        <p>
         *        [GRPC protocol version] The path of a custom health check method with the format
         *        /package.service/method. The default is /AWS.ALB/healthcheck.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckPath(String healthCheckPath);

        /**
         * <p>
         * The approximate amount of time, in seconds, between health checks of an individual target. For TCP health
         * checks, the supported values are 10 and 30 seconds. If the target type is <code>instance</code> or
         * <code>ip</code>, the default is 30 seconds. If the target group protocol is GENEVE, the default is 10
         * seconds. If the target type is <code>lambda</code>, the default is 35 seconds.
         * </p>
         * 
         * @param healthCheckIntervalSeconds
         *        The approximate amount of time, in seconds, between health checks of an individual target. For TCP
         *        health checks, the supported values are 10 and 30 seconds. If the target type is <code>instance</code>
         *        or <code>ip</code>, the default is 30 seconds. If the target group protocol is GENEVE, the default is
         *        10 seconds. If the target type is <code>lambda</code>, the default is 35 seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckIntervalSeconds(Integer healthCheckIntervalSeconds);

        /**
         * <p>
         * The amount of time, in seconds, during which no response from a target means a failed health check. For
         * target groups with a protocol of HTTP, HTTPS, or GENEVE, the default is 5 seconds. For target groups with a
         * protocol of TCP or TLS, this value must be 6 seconds for HTTP health checks and 10 seconds for TCP and HTTPS
         * health checks. If the target type is <code>lambda</code>, the default is 30 seconds.
         * </p>
         * 
         * @param healthCheckTimeoutSeconds
         *        The amount of time, in seconds, during which no response from a target means a failed health check.
         *        For target groups with a protocol of HTTP, HTTPS, or GENEVE, the default is 5 seconds. For target
         *        groups with a protocol of TCP or TLS, this value must be 6 seconds for HTTP health checks and 10
         *        seconds for TCP and HTTPS health checks. If the target type is <code>lambda</code>, the default is 30
         *        seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckTimeoutSeconds(Integer healthCheckTimeoutSeconds);

        /**
         * <p>
         * The number of consecutive health checks successes required before considering an unhealthy target healthy.
         * For target groups with a protocol of HTTP or HTTPS, the default is 5. For target groups with a protocol of
         * TCP, TLS, or GENEVE, the default is 3. If the target type is <code>lambda</code>, the default is 5.
         * </p>
         * 
         * @param healthyThresholdCount
         *        The number of consecutive health checks successes required before considering an unhealthy target
         *        healthy. For target groups with a protocol of HTTP or HTTPS, the default is 5. For target groups with
         *        a protocol of TCP, TLS, or GENEVE, the default is 3. If the target type is <code>lambda</code>, the
         *        default is 5.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthyThresholdCount(Integer healthyThresholdCount);

        /**
         * <p>
         * The number of consecutive health check failures required before considering a target unhealthy. If the target
         * group protocol is HTTP or HTTPS, the default is 2. If the target group protocol is TCP or TLS, this value
         * must be the same as the healthy threshold count. If the target group protocol is GENEVE, the default is 3. If
         * the target type is <code>lambda</code>, the default is 2.
         * </p>
         * 
         * @param unhealthyThresholdCount
         *        The number of consecutive health check failures required before considering a target unhealthy. If the
         *        target group protocol is HTTP or HTTPS, the default is 2. If the target group protocol is TCP or TLS,
         *        this value must be the same as the healthy threshold count. If the target group protocol is GENEVE,
         *        the default is 3. If the target type is <code>lambda</code>, the default is 2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unhealthyThresholdCount(Integer unhealthyThresholdCount);

        /**
         * <p>
         * [HTTP/HTTPS health checks] The HTTP or gRPC codes to use when checking for a successful response from a
         * target.
         * </p>
         * 
         * @param matcher
         *        [HTTP/HTTPS health checks] The HTTP or gRPC codes to use when checking for a successful response from
         *        a target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matcher(Matcher matcher);

        /**
         * <p>
         * [HTTP/HTTPS health checks] The HTTP or gRPC codes to use when checking for a successful response from a
         * target.
         * </p>
         * This is a convenience that creates an instance of the {@link Matcher.Builder} avoiding the need to create one
         * manually via {@link Matcher#builder()}.
         *
         * When the {@link Consumer} completes, {@link Matcher.Builder#build()} is called immediately and its result is
         * passed to {@link #matcher(Matcher)}.
         * 
         * @param matcher
         *        a consumer that will call methods on {@link Matcher.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #matcher(Matcher)
         */
        default Builder matcher(Consumer<Matcher.Builder> matcher) {
            return matcher(Matcher.builder().applyMutation(matcher).build());
        }

        /**
         * <p>
         * The type of target that you must specify when registering targets with this target group. You can't specify
         * targets for a target group using more than one target type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>instance</code> - Register targets by instance ID. This is the default value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip</code> - Register targets by IP address. You can specify IP addresses from the subnets of the
         * virtual private cloud (VPC) for the target group, the RFC 1918 range (10.0.0.0/8, 172.16.0.0/12, and
         * 192.168.0.0/16), and the RFC 6598 range (100.64.0.0/10). You can't specify publicly routable IP addresses.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>lambda</code> - Register a single Lambda function as a target.
         * </p>
         * </li>
         * </ul>
         * 
         * @param targetType
         *        The type of target that you must specify when registering targets with this target group. You can't
         *        specify targets for a target group using more than one target type.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>instance</code> - Register targets by instance ID. This is the default value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip</code> - Register targets by IP address. You can specify IP addresses from the subnets of the
         *        virtual private cloud (VPC) for the target group, the RFC 1918 range (10.0.0.0/8, 172.16.0.0/12, and
         *        192.168.0.0/16), and the RFC 6598 range (100.64.0.0/10). You can't specify publicly routable IP
         *        addresses.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>lambda</code> - Register a single Lambda function as a target.
         *        </p>
         *        </li>
         * @see TargetTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetTypeEnum
         */
        Builder targetType(String targetType);

        /**
         * <p>
         * The type of target that you must specify when registering targets with this target group. You can't specify
         * targets for a target group using more than one target type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>instance</code> - Register targets by instance ID. This is the default value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip</code> - Register targets by IP address. You can specify IP addresses from the subnets of the
         * virtual private cloud (VPC) for the target group, the RFC 1918 range (10.0.0.0/8, 172.16.0.0/12, and
         * 192.168.0.0/16), and the RFC 6598 range (100.64.0.0/10). You can't specify publicly routable IP addresses.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>lambda</code> - Register a single Lambda function as a target.
         * </p>
         * </li>
         * </ul>
         * 
         * @param targetType
         *        The type of target that you must specify when registering targets with this target group. You can't
         *        specify targets for a target group using more than one target type.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>instance</code> - Register targets by instance ID. This is the default value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip</code> - Register targets by IP address. You can specify IP addresses from the subnets of the
         *        virtual private cloud (VPC) for the target group, the RFC 1918 range (10.0.0.0/8, 172.16.0.0/12, and
         *        192.168.0.0/16), and the RFC 6598 range (100.64.0.0/10). You can't specify publicly routable IP
         *        addresses.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>lambda</code> - Register a single Lambda function as a target.
         *        </p>
         *        </li>
         * @see TargetTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetTypeEnum
         */
        Builder targetType(TargetTypeEnum targetType);

        /**
         * <p>
         * The tags to assign to the target group.
         * </p>
         * 
         * @param tags
         *        The tags to assign to the target group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags to assign to the target group.
         * </p>
         * 
         * @param tags
         *        The tags to assign to the target group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags to assign to the target group.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticLoadBalancingV2Request.BuilderImpl implements Builder {
        private String name;

        private String protocol;

        private String protocolVersion;

        private Integer port;

        private String vpcId;

        private String healthCheckProtocol;

        private String healthCheckPort;

        private Boolean healthCheckEnabled;

        private String healthCheckPath;

        private Integer healthCheckIntervalSeconds;

        private Integer healthCheckTimeoutSeconds;

        private Integer healthyThresholdCount;

        private Integer unhealthyThresholdCount;

        private Matcher matcher;

        private String targetType;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTargetGroupRequest model) {
            super(model);
            name(model.name);
            protocol(model.protocol);
            protocolVersion(model.protocolVersion);
            port(model.port);
            vpcId(model.vpcId);
            healthCheckProtocol(model.healthCheckProtocol);
            healthCheckPort(model.healthCheckPort);
            healthCheckEnabled(model.healthCheckEnabled);
            healthCheckPath(model.healthCheckPath);
            healthCheckIntervalSeconds(model.healthCheckIntervalSeconds);
            healthCheckTimeoutSeconds(model.healthCheckTimeoutSeconds);
            healthyThresholdCount(model.healthyThresholdCount);
            unhealthyThresholdCount(model.unhealthyThresholdCount);
            matcher(model.matcher);
            targetType(model.targetType);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getProtocol() {
            return protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(ProtocolEnum protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final String getProtocolVersion() {
            return protocolVersion;
        }

        @Override
        public final Builder protocolVersion(String protocolVersion) {
            this.protocolVersion = protocolVersion;
            return this;
        }

        public final void setProtocolVersion(String protocolVersion) {
            this.protocolVersion = protocolVersion;
        }

        public final Integer getPort() {
            return port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getHealthCheckProtocol() {
            return healthCheckProtocol;
        }

        @Override
        public final Builder healthCheckProtocol(String healthCheckProtocol) {
            this.healthCheckProtocol = healthCheckProtocol;
            return this;
        }

        @Override
        public final Builder healthCheckProtocol(ProtocolEnum healthCheckProtocol) {
            this.healthCheckProtocol(healthCheckProtocol == null ? null : healthCheckProtocol.toString());
            return this;
        }

        public final void setHealthCheckProtocol(String healthCheckProtocol) {
            this.healthCheckProtocol = healthCheckProtocol;
        }

        public final String getHealthCheckPort() {
            return healthCheckPort;
        }

        @Override
        public final Builder healthCheckPort(String healthCheckPort) {
            this.healthCheckPort = healthCheckPort;
            return this;
        }

        public final void setHealthCheckPort(String healthCheckPort) {
            this.healthCheckPort = healthCheckPort;
        }

        public final Boolean getHealthCheckEnabled() {
            return healthCheckEnabled;
        }

        @Override
        public final Builder healthCheckEnabled(Boolean healthCheckEnabled) {
            this.healthCheckEnabled = healthCheckEnabled;
            return this;
        }

        public final void setHealthCheckEnabled(Boolean healthCheckEnabled) {
            this.healthCheckEnabled = healthCheckEnabled;
        }

        public final String getHealthCheckPath() {
            return healthCheckPath;
        }

        @Override
        public final Builder healthCheckPath(String healthCheckPath) {
            this.healthCheckPath = healthCheckPath;
            return this;
        }

        public final void setHealthCheckPath(String healthCheckPath) {
            this.healthCheckPath = healthCheckPath;
        }

        public final Integer getHealthCheckIntervalSeconds() {
            return healthCheckIntervalSeconds;
        }

        @Override
        public final Builder healthCheckIntervalSeconds(Integer healthCheckIntervalSeconds) {
            this.healthCheckIntervalSeconds = healthCheckIntervalSeconds;
            return this;
        }

        public final void setHealthCheckIntervalSeconds(Integer healthCheckIntervalSeconds) {
            this.healthCheckIntervalSeconds = healthCheckIntervalSeconds;
        }

        public final Integer getHealthCheckTimeoutSeconds() {
            return healthCheckTimeoutSeconds;
        }

        @Override
        public final Builder healthCheckTimeoutSeconds(Integer healthCheckTimeoutSeconds) {
            this.healthCheckTimeoutSeconds = healthCheckTimeoutSeconds;
            return this;
        }

        public final void setHealthCheckTimeoutSeconds(Integer healthCheckTimeoutSeconds) {
            this.healthCheckTimeoutSeconds = healthCheckTimeoutSeconds;
        }

        public final Integer getHealthyThresholdCount() {
            return healthyThresholdCount;
        }

        @Override
        public final Builder healthyThresholdCount(Integer healthyThresholdCount) {
            this.healthyThresholdCount = healthyThresholdCount;
            return this;
        }

        public final void setHealthyThresholdCount(Integer healthyThresholdCount) {
            this.healthyThresholdCount = healthyThresholdCount;
        }

        public final Integer getUnhealthyThresholdCount() {
            return unhealthyThresholdCount;
        }

        @Override
        public final Builder unhealthyThresholdCount(Integer unhealthyThresholdCount) {
            this.unhealthyThresholdCount = unhealthyThresholdCount;
            return this;
        }

        public final void setUnhealthyThresholdCount(Integer unhealthyThresholdCount) {
            this.unhealthyThresholdCount = unhealthyThresholdCount;
        }

        public final Matcher.Builder getMatcher() {
            return matcher != null ? matcher.toBuilder() : null;
        }

        @Override
        public final Builder matcher(Matcher matcher) {
            this.matcher = matcher;
            return this;
        }

        public final void setMatcher(Matcher.BuilderImpl matcher) {
            this.matcher = matcher != null ? matcher.build() : null;
        }

        public final String getTargetType() {
            return targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        @Override
        public final Builder targetType(TargetTypeEnum targetType) {
            this.targetType(targetType == null ? null : targetType.toString());
            return this;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        public final Collection<Tag.Builder> getTags() {
            if (tags instanceof SdkAutoConstructList) {
                return null;
            }
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTargetGroupRequest build() {
            return new CreateTargetGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
