/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a subnet mapping.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SubnetMapping implements SdkPojo, Serializable, ToCopyableBuilder<SubnetMapping.Builder, SubnetMapping> {
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubnetId").getter(getter(SubnetMapping::subnetId)).setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()).build();

    private static final SdkField<String> ALLOCATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AllocationId").getter(getter(SubnetMapping::allocationId)).setter(setter(Builder::allocationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationId").build()).build();

    private static final SdkField<String> PRIVATE_IP_V4_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrivateIPv4Address").getter(getter(SubnetMapping::privateIPv4Address))
            .setter(setter(Builder::privateIPv4Address))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIPv4Address").build())
            .build();

    private static final SdkField<String> IP_V6_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IPv6Address").getter(getter(SubnetMapping::iPv6Address)).setter(setter(Builder::iPv6Address))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IPv6Address").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNET_ID_FIELD,
            ALLOCATION_ID_FIELD, PRIVATE_IP_V4_ADDRESS_FIELD, IP_V6_ADDRESS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String subnetId;

    private final String allocationId;

    private final String privateIPv4Address;

    private final String iPv6Address;

    private SubnetMapping(BuilderImpl builder) {
        this.subnetId = builder.subnetId;
        this.allocationId = builder.allocationId;
        this.privateIPv4Address = builder.privateIPv4Address;
        this.iPv6Address = builder.iPv6Address;
    }

    /**
     * <p>
     * The ID of the subnet.
     * </p>
     * 
     * @return The ID of the subnet.
     */
    public final String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * [Network Load Balancers] The allocation ID of the Elastic IP address for an internet-facing load balancer.
     * </p>
     * 
     * @return [Network Load Balancers] The allocation ID of the Elastic IP address for an internet-facing load
     *         balancer.
     */
    public final String allocationId() {
        return allocationId;
    }

    /**
     * <p>
     * [Network Load Balancers] The private IPv4 address for an internal load balancer.
     * </p>
     * 
     * @return [Network Load Balancers] The private IPv4 address for an internal load balancer.
     */
    public final String privateIPv4Address() {
        return privateIPv4Address;
    }

    /**
     * <p>
     * [Network Load Balancers] The IPv6 address.
     * </p>
     * 
     * @return [Network Load Balancers] The IPv6 address.
     */
    public final String iPv6Address() {
        return iPv6Address;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(allocationId());
        hashCode = 31 * hashCode + Objects.hashCode(privateIPv4Address());
        hashCode = 31 * hashCode + Objects.hashCode(iPv6Address());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubnetMapping)) {
            return false;
        }
        SubnetMapping other = (SubnetMapping) obj;
        return Objects.equals(subnetId(), other.subnetId()) && Objects.equals(allocationId(), other.allocationId())
                && Objects.equals(privateIPv4Address(), other.privateIPv4Address())
                && Objects.equals(iPv6Address(), other.iPv6Address());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SubnetMapping").add("SubnetId", subnetId()).add("AllocationId", allocationId())
                .add("PrivateIPv4Address", privateIPv4Address()).add("IPv6Address", iPv6Address()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "AllocationId":
            return Optional.ofNullable(clazz.cast(allocationId()));
        case "PrivateIPv4Address":
            return Optional.ofNullable(clazz.cast(privateIPv4Address()));
        case "IPv6Address":
            return Optional.ofNullable(clazz.cast(iPv6Address()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SubnetMapping, T> g) {
        return obj -> g.apply((SubnetMapping) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SubnetMapping> {
        /**
         * <p>
         * The ID of the subnet.
         * </p>
         * 
         * @param subnetId
         *        The ID of the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * [Network Load Balancers] The allocation ID of the Elastic IP address for an internet-facing load balancer.
         * </p>
         * 
         * @param allocationId
         *        [Network Load Balancers] The allocation ID of the Elastic IP address for an internet-facing load
         *        balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocationId(String allocationId);

        /**
         * <p>
         * [Network Load Balancers] The private IPv4 address for an internal load balancer.
         * </p>
         * 
         * @param privateIPv4Address
         *        [Network Load Balancers] The private IPv4 address for an internal load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIPv4Address(String privateIPv4Address);

        /**
         * <p>
         * [Network Load Balancers] The IPv6 address.
         * </p>
         * 
         * @param iPv6Address
         *        [Network Load Balancers] The IPv6 address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iPv6Address(String iPv6Address);
    }

    static final class BuilderImpl implements Builder {
        private String subnetId;

        private String allocationId;

        private String privateIPv4Address;

        private String iPv6Address;

        private BuilderImpl() {
        }

        private BuilderImpl(SubnetMapping model) {
            subnetId(model.subnetId);
            allocationId(model.allocationId);
            privateIPv4Address(model.privateIPv4Address);
            iPv6Address(model.iPv6Address);
        }

        public final String getSubnetId() {
            return subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getAllocationId() {
            return allocationId;
        }

        @Override
        public final Builder allocationId(String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public final void setAllocationId(String allocationId) {
            this.allocationId = allocationId;
        }

        public final String getPrivateIPv4Address() {
            return privateIPv4Address;
        }

        @Override
        public final Builder privateIPv4Address(String privateIPv4Address) {
            this.privateIPv4Address = privateIPv4Address;
            return this;
        }

        public final void setPrivateIPv4Address(String privateIPv4Address) {
            this.privateIPv4Address = privateIPv4Address;
        }

        public final String getIPv6Address() {
            return iPv6Address;
        }

        @Override
        public final Builder iPv6Address(String iPv6Address) {
            this.iPv6Address = iPv6Address;
            return this;
        }

        public final void setIPv6Address(String iPv6Address) {
            this.iPv6Address = iPv6Address;
        }

        @Override
        public SubnetMapping build() {
            return new SubnetMapping(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
