/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyListenerRequest extends ElasticLoadBalancingV2Request implements
        ToCopyableBuilder<ModifyListenerRequest.Builder, ModifyListenerRequest> {
    private static final SdkField<String> LISTENER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ListenerArn").getter(getter(ModifyListenerRequest::listenerArn)).setter(setter(Builder::listenerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListenerArn").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(ModifyListenerRequest::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Protocol").getter(getter(ModifyListenerRequest::protocolAsString)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()).build();

    private static final SdkField<String> SSL_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SslPolicy").getter(getter(ModifyListenerRequest::sslPolicy)).setter(setter(Builder::sslPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SslPolicy").build()).build();

    private static final SdkField<List<Certificate>> CERTIFICATES_FIELD = SdkField
            .<List<Certificate>> builder(MarshallingType.LIST)
            .memberName("Certificates")
            .getter(getter(ModifyListenerRequest::certificates))
            .setter(setter(Builder::certificates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Certificates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Certificate> builder(MarshallingType.SDK_POJO)
                                            .constructor(Certificate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Action>> DEFAULT_ACTIONS_FIELD = SdkField
            .<List<Action>> builder(MarshallingType.LIST)
            .memberName("DefaultActions")
            .getter(getter(ModifyListenerRequest::defaultActions))
            .setter(setter(Builder::defaultActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Action> builder(MarshallingType.SDK_POJO)
                                            .constructor(Action::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ALPN_POLICY_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AlpnPolicy")
            .getter(getter(ModifyListenerRequest::alpnPolicy))
            .setter(setter(Builder::alpnPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlpnPolicy").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LISTENER_ARN_FIELD,
            PORT_FIELD, PROTOCOL_FIELD, SSL_POLICY_FIELD, CERTIFICATES_FIELD, DEFAULT_ACTIONS_FIELD, ALPN_POLICY_FIELD));

    private final String listenerArn;

    private final Integer port;

    private final String protocol;

    private final String sslPolicy;

    private final List<Certificate> certificates;

    private final List<Action> defaultActions;

    private final List<String> alpnPolicy;

    private ModifyListenerRequest(BuilderImpl builder) {
        super(builder);
        this.listenerArn = builder.listenerArn;
        this.port = builder.port;
        this.protocol = builder.protocol;
        this.sslPolicy = builder.sslPolicy;
        this.certificates = builder.certificates;
        this.defaultActions = builder.defaultActions;
        this.alpnPolicy = builder.alpnPolicy;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the listener.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the listener.
     */
    public final String listenerArn() {
        return listenerArn;
    }

    /**
     * <p>
     * The port for connections from clients to the load balancer. You cannot specify a port for a Gateway Load
     * Balancer.
     * </p>
     * 
     * @return The port for connections from clients to the load balancer. You cannot specify a port for a Gateway Load
     *         Balancer.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The protocol for connections from clients to the load balancer. Application Load Balancers support the HTTP and
     * HTTPS protocols. Network Load Balancers support the TCP, TLS, UDP, and TCP_UDP protocols. You can’t change the
     * protocol to UDP or TCP_UDP if dual-stack mode is enabled. You cannot specify a protocol for a Gateway Load
     * Balancer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link ProtocolEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol for connections from clients to the load balancer. Application Load Balancers support the
     *         HTTP and HTTPS protocols. Network Load Balancers support the TCP, TLS, UDP, and TCP_UDP protocols. You
     *         can’t change the protocol to UDP or TCP_UDP if dual-stack mode is enabled. You cannot specify a protocol
     *         for a Gateway Load Balancer.
     * @see ProtocolEnum
     */
    public final ProtocolEnum protocol() {
        return ProtocolEnum.fromValue(protocol);
    }

    /**
     * <p>
     * The protocol for connections from clients to the load balancer. Application Load Balancers support the HTTP and
     * HTTPS protocols. Network Load Balancers support the TCP, TLS, UDP, and TCP_UDP protocols. You can’t change the
     * protocol to UDP or TCP_UDP if dual-stack mode is enabled. You cannot specify a protocol for a Gateway Load
     * Balancer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link ProtocolEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol for connections from clients to the load balancer. Application Load Balancers support the
     *         HTTP and HTTPS protocols. Network Load Balancers support the TCP, TLS, UDP, and TCP_UDP protocols. You
     *         can’t change the protocol to UDP or TCP_UDP if dual-stack mode is enabled. You cannot specify a protocol
     *         for a Gateway Load Balancer.
     * @see ProtocolEnum
     */
    public final String protocolAsString() {
        return protocol;
    }

    /**
     * <p>
     * [HTTPS and TLS listeners] The security policy that defines which protocols and ciphers are supported.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#describe-ssl-policies"
     * >Security policies</a> in the <i>Application Load Balancers Guide</i> or <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#describe-ssl-policies"
     * >Security policies</a> in the <i>Network Load Balancers Guide</i>.
     * </p>
     * 
     * @return [HTTPS and TLS listeners] The security policy that defines which protocols and ciphers are supported.</p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#describe-ssl-policies"
     *         >Security policies</a> in the <i>Application Load Balancers Guide</i> or <a href=
     *         "https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#describe-ssl-policies"
     *         >Security policies</a> in the <i>Network Load Balancers Guide</i>.
     */
    public final String sslPolicy() {
        return sslPolicy;
    }

    /**
     * Returns true if the Certificates property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasCertificates() {
        return certificates != null && !(certificates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * [HTTPS and TLS listeners] The default certificate for the listener. You must provide exactly one certificate. Set
     * <code>CertificateArn</code> to the certificate ARN but do not set <code>IsDefault</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCertificates()} to see if a value was sent in this field.
     * </p>
     * 
     * @return [HTTPS and TLS listeners] The default certificate for the listener. You must provide exactly one
     *         certificate. Set <code>CertificateArn</code> to the certificate ARN but do not set <code>IsDefault</code>
     *         .
     */
    public final List<Certificate> certificates() {
        return certificates;
    }

    /**
     * Returns true if the DefaultActions property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasDefaultActions() {
        return defaultActions != null && !(defaultActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The actions for the default rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDefaultActions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The actions for the default rule.
     */
    public final List<Action> defaultActions() {
        return defaultActions;
    }

    /**
     * Returns true if the AlpnPolicy property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAlpnPolicy() {
        return alpnPolicy != null && !(alpnPolicy instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * [TLS listeners] The name of the Application-Layer Protocol Negotiation (ALPN) policy. You can specify one policy
     * name. The following are the possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>HTTP1Only</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HTTP2Only</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HTTP2Optional</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HTTP2Preferred</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>None</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#alpn-policies"
     * >ALPN policies</a> in the <i>Network Load Balancers Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAlpnPolicy()} to see if a value was sent in this field.
     * </p>
     * 
     * @return [TLS listeners] The name of the Application-Layer Protocol Negotiation (ALPN) policy. You can specify one
     *         policy name. The following are the possible values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>HTTP1Only</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HTTP2Only</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HTTP2Optional</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HTTP2Preferred</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>None</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#alpn-policies"
     *         >ALPN policies</a> in the <i>Network Load Balancers Guide</i>.
     */
    public final List<String> alpnPolicy() {
        return alpnPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(listenerArn());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sslPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(hasCertificates() ? certificates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDefaultActions() ? defaultActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAlpnPolicy() ? alpnPolicy() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyListenerRequest)) {
            return false;
        }
        ModifyListenerRequest other = (ModifyListenerRequest) obj;
        return Objects.equals(listenerArn(), other.listenerArn()) && Objects.equals(port(), other.port())
                && Objects.equals(protocolAsString(), other.protocolAsString()) && Objects.equals(sslPolicy(), other.sslPolicy())
                && hasCertificates() == other.hasCertificates() && Objects.equals(certificates(), other.certificates())
                && hasDefaultActions() == other.hasDefaultActions() && Objects.equals(defaultActions(), other.defaultActions())
                && hasAlpnPolicy() == other.hasAlpnPolicy() && Objects.equals(alpnPolicy(), other.alpnPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyListenerRequest").add("ListenerArn", listenerArn()).add("Port", port())
                .add("Protocol", protocolAsString()).add("SslPolicy", sslPolicy())
                .add("Certificates", hasCertificates() ? certificates() : null)
                .add("DefaultActions", hasDefaultActions() ? defaultActions() : null)
                .add("AlpnPolicy", hasAlpnPolicy() ? alpnPolicy() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ListenerArn":
            return Optional.ofNullable(clazz.cast(listenerArn()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        case "SslPolicy":
            return Optional.ofNullable(clazz.cast(sslPolicy()));
        case "Certificates":
            return Optional.ofNullable(clazz.cast(certificates()));
        case "DefaultActions":
            return Optional.ofNullable(clazz.cast(defaultActions()));
        case "AlpnPolicy":
            return Optional.ofNullable(clazz.cast(alpnPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyListenerRequest, T> g) {
        return obj -> g.apply((ModifyListenerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticLoadBalancingV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyListenerRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the listener.
         * </p>
         * 
         * @param listenerArn
         *        The Amazon Resource Name (ARN) of the listener.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listenerArn(String listenerArn);

        /**
         * <p>
         * The port for connections from clients to the load balancer. You cannot specify a port for a Gateway Load
         * Balancer.
         * </p>
         * 
         * @param port
         *        The port for connections from clients to the load balancer. You cannot specify a port for a Gateway
         *        Load Balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The protocol for connections from clients to the load balancer. Application Load Balancers support the HTTP
         * and HTTPS protocols. Network Load Balancers support the TCP, TLS, UDP, and TCP_UDP protocols. You can’t
         * change the protocol to UDP or TCP_UDP if dual-stack mode is enabled. You cannot specify a protocol for a
         * Gateway Load Balancer.
         * </p>
         * 
         * @param protocol
         *        The protocol for connections from clients to the load balancer. Application Load Balancers support the
         *        HTTP and HTTPS protocols. Network Load Balancers support the TCP, TLS, UDP, and TCP_UDP protocols. You
         *        can’t change the protocol to UDP or TCP_UDP if dual-stack mode is enabled. You cannot specify a
         *        protocol for a Gateway Load Balancer.
         * @see ProtocolEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtocolEnum
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The protocol for connections from clients to the load balancer. Application Load Balancers support the HTTP
         * and HTTPS protocols. Network Load Balancers support the TCP, TLS, UDP, and TCP_UDP protocols. You can’t
         * change the protocol to UDP or TCP_UDP if dual-stack mode is enabled. You cannot specify a protocol for a
         * Gateway Load Balancer.
         * </p>
         * 
         * @param protocol
         *        The protocol for connections from clients to the load balancer. Application Load Balancers support the
         *        HTTP and HTTPS protocols. Network Load Balancers support the TCP, TLS, UDP, and TCP_UDP protocols. You
         *        can’t change the protocol to UDP or TCP_UDP if dual-stack mode is enabled. You cannot specify a
         *        protocol for a Gateway Load Balancer.
         * @see ProtocolEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtocolEnum
         */
        Builder protocol(ProtocolEnum protocol);

        /**
         * <p>
         * [HTTPS and TLS listeners] The security policy that defines which protocols and ciphers are supported.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#describe-ssl-policies"
         * >Security policies</a> in the <i>Application Load Balancers Guide</i> or <a href=
         * "https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#describe-ssl-policies"
         * >Security policies</a> in the <i>Network Load Balancers Guide</i>.
         * </p>
         * 
         * @param sslPolicy
         *        [HTTPS and TLS listeners] The security policy that defines which protocols and ciphers are
         *        supported.</p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#describe-ssl-policies"
         *        >Security policies</a> in the <i>Application Load Balancers Guide</i> or <a href=
         *        "https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#describe-ssl-policies"
         *        >Security policies</a> in the <i>Network Load Balancers Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sslPolicy(String sslPolicy);

        /**
         * <p>
         * [HTTPS and TLS listeners] The default certificate for the listener. You must provide exactly one certificate.
         * Set <code>CertificateArn</code> to the certificate ARN but do not set <code>IsDefault</code>.
         * </p>
         * 
         * @param certificates
         *        [HTTPS and TLS listeners] The default certificate for the listener. You must provide exactly one
         *        certificate. Set <code>CertificateArn</code> to the certificate ARN but do not set
         *        <code>IsDefault</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificates(Collection<Certificate> certificates);

        /**
         * <p>
         * [HTTPS and TLS listeners] The default certificate for the listener. You must provide exactly one certificate.
         * Set <code>CertificateArn</code> to the certificate ARN but do not set <code>IsDefault</code>.
         * </p>
         * 
         * @param certificates
         *        [HTTPS and TLS listeners] The default certificate for the listener. You must provide exactly one
         *        certificate. Set <code>CertificateArn</code> to the certificate ARN but do not set
         *        <code>IsDefault</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificates(Certificate... certificates);

        /**
         * <p>
         * [HTTPS and TLS listeners] The default certificate for the listener. You must provide exactly one certificate.
         * Set <code>CertificateArn</code> to the certificate ARN but do not set <code>IsDefault</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Certificate>.Builder} avoiding the need to
         * create one manually via {@link List<Certificate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Certificate>.Builder#build()} is called immediately and its
         * result is passed to {@link #certificates(List<Certificate>)}.
         * 
         * @param certificates
         *        a consumer that will call methods on {@link List<Certificate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #certificates(List<Certificate>)
         */
        Builder certificates(Consumer<Certificate.Builder>... certificates);

        /**
         * <p>
         * The actions for the default rule.
         * </p>
         * 
         * @param defaultActions
         *        The actions for the default rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultActions(Collection<Action> defaultActions);

        /**
         * <p>
         * The actions for the default rule.
         * </p>
         * 
         * @param defaultActions
         *        The actions for the default rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultActions(Action... defaultActions);

        /**
         * <p>
         * The actions for the default rule.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Action>.Builder} avoiding the need to
         * create one manually via {@link List<Action>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Action>.Builder#build()} is called immediately and its
         * result is passed to {@link #defaultActions(List<Action>)}.
         * 
         * @param defaultActions
         *        a consumer that will call methods on {@link List<Action>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultActions(List<Action>)
         */
        Builder defaultActions(Consumer<Action.Builder>... defaultActions);

        /**
         * <p>
         * [TLS listeners] The name of the Application-Layer Protocol Negotiation (ALPN) policy. You can specify one
         * policy name. The following are the possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>HTTP1Only</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HTTP2Only</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HTTP2Optional</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HTTP2Preferred</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>None</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#alpn-policies">ALPN
         * policies</a> in the <i>Network Load Balancers Guide</i>.
         * </p>
         * 
         * @param alpnPolicy
         *        [TLS listeners] The name of the Application-Layer Protocol Negotiation (ALPN) policy. You can specify
         *        one policy name. The following are the possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>HTTP1Only</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HTTP2Only</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HTTP2Optional</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HTTP2Preferred</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>None</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#alpn-policies"
         *        >ALPN policies</a> in the <i>Network Load Balancers Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alpnPolicy(Collection<String> alpnPolicy);

        /**
         * <p>
         * [TLS listeners] The name of the Application-Layer Protocol Negotiation (ALPN) policy. You can specify one
         * policy name. The following are the possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>HTTP1Only</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HTTP2Only</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HTTP2Optional</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HTTP2Preferred</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>None</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#alpn-policies">ALPN
         * policies</a> in the <i>Network Load Balancers Guide</i>.
         * </p>
         * 
         * @param alpnPolicy
         *        [TLS listeners] The name of the Application-Layer Protocol Negotiation (ALPN) policy. You can specify
         *        one policy name. The following are the possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>HTTP1Only</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HTTP2Only</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HTTP2Optional</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HTTP2Preferred</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>None</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#alpn-policies"
         *        >ALPN policies</a> in the <i>Network Load Balancers Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alpnPolicy(String... alpnPolicy);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticLoadBalancingV2Request.BuilderImpl implements Builder {
        private String listenerArn;

        private Integer port;

        private String protocol;

        private String sslPolicy;

        private List<Certificate> certificates = DefaultSdkAutoConstructList.getInstance();

        private List<Action> defaultActions = DefaultSdkAutoConstructList.getInstance();

        private List<String> alpnPolicy = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyListenerRequest model) {
            super(model);
            listenerArn(model.listenerArn);
            port(model.port);
            protocol(model.protocol);
            sslPolicy(model.sslPolicy);
            certificates(model.certificates);
            defaultActions(model.defaultActions);
            alpnPolicy(model.alpnPolicy);
        }

        public final String getListenerArn() {
            return listenerArn;
        }

        @Override
        public final Builder listenerArn(String listenerArn) {
            this.listenerArn = listenerArn;
            return this;
        }

        public final void setListenerArn(String listenerArn) {
            this.listenerArn = listenerArn;
        }

        public final Integer getPort() {
            return port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getProtocol() {
            return protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(ProtocolEnum protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final String getSslPolicy() {
            return sslPolicy;
        }

        @Override
        public final Builder sslPolicy(String sslPolicy) {
            this.sslPolicy = sslPolicy;
            return this;
        }

        public final void setSslPolicy(String sslPolicy) {
            this.sslPolicy = sslPolicy;
        }

        public final List<Certificate.Builder> getCertificates() {
            List<Certificate.Builder> result = CertificateListCopier.copyToBuilder(this.certificates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder certificates(Collection<Certificate> certificates) {
            this.certificates = CertificateListCopier.copy(certificates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificates(Certificate... certificates) {
            certificates(Arrays.asList(certificates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificates(Consumer<Certificate.Builder>... certificates) {
            certificates(Stream.of(certificates).map(c -> Certificate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setCertificates(Collection<Certificate.BuilderImpl> certificates) {
            this.certificates = CertificateListCopier.copyFromBuilder(certificates);
        }

        public final List<Action.Builder> getDefaultActions() {
            List<Action.Builder> result = ActionsCopier.copyToBuilder(this.defaultActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder defaultActions(Collection<Action> defaultActions) {
            this.defaultActions = ActionsCopier.copy(defaultActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultActions(Action... defaultActions) {
            defaultActions(Arrays.asList(defaultActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultActions(Consumer<Action.Builder>... defaultActions) {
            defaultActions(Stream.of(defaultActions).map(c -> Action.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDefaultActions(Collection<Action.BuilderImpl> defaultActions) {
            this.defaultActions = ActionsCopier.copyFromBuilder(defaultActions);
        }

        public final Collection<String> getAlpnPolicy() {
            if (alpnPolicy instanceof SdkAutoConstructList) {
                return null;
            }
            return alpnPolicy;
        }

        @Override
        public final Builder alpnPolicy(Collection<String> alpnPolicy) {
            this.alpnPolicy = AlpnPolicyNameCopier.copy(alpnPolicy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alpnPolicy(String... alpnPolicy) {
            alpnPolicy(Arrays.asList(alpnPolicy));
            return this;
        }

        public final void setAlpnPolicy(Collection<String> alpnPolicy) {
            this.alpnPolicy = AlpnPolicyNameCopier.copy(alpnPolicy);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyListenerRequest build() {
            return new ModifyListenerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
