/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a listener.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Listener implements SdkPojo, Serializable, ToCopyableBuilder<Listener.Builder, Listener> {
    private static final SdkField<String> LISTENER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ListenerArn").getter(getter(Listener::listenerArn)).setter(setter(Builder::listenerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListenerArn").build()).build();

    private static final SdkField<String> LOAD_BALANCER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LoadBalancerArn").getter(getter(Listener::loadBalancerArn)).setter(setter(Builder::loadBalancerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerArn").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(Listener::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Protocol").getter(getter(Listener::protocolAsString)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()).build();

    private static final SdkField<List<Certificate>> CERTIFICATES_FIELD = SdkField
            .<List<Certificate>> builder(MarshallingType.LIST)
            .memberName("Certificates")
            .getter(getter(Listener::certificates))
            .setter(setter(Builder::certificates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Certificates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Certificate> builder(MarshallingType.SDK_POJO)
                                            .constructor(Certificate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SSL_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SslPolicy").getter(getter(Listener::sslPolicy)).setter(setter(Builder::sslPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SslPolicy").build()).build();

    private static final SdkField<List<Action>> DEFAULT_ACTIONS_FIELD = SdkField
            .<List<Action>> builder(MarshallingType.LIST)
            .memberName("DefaultActions")
            .getter(getter(Listener::defaultActions))
            .setter(setter(Builder::defaultActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Action> builder(MarshallingType.SDK_POJO)
                                            .constructor(Action::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ALPN_POLICY_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AlpnPolicy")
            .getter(getter(Listener::alpnPolicy))
            .setter(setter(Builder::alpnPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlpnPolicy").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LISTENER_ARN_FIELD,
            LOAD_BALANCER_ARN_FIELD, PORT_FIELD, PROTOCOL_FIELD, CERTIFICATES_FIELD, SSL_POLICY_FIELD, DEFAULT_ACTIONS_FIELD,
            ALPN_POLICY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String listenerArn;

    private final String loadBalancerArn;

    private final Integer port;

    private final String protocol;

    private final List<Certificate> certificates;

    private final String sslPolicy;

    private final List<Action> defaultActions;

    private final List<String> alpnPolicy;

    private Listener(BuilderImpl builder) {
        this.listenerArn = builder.listenerArn;
        this.loadBalancerArn = builder.loadBalancerArn;
        this.port = builder.port;
        this.protocol = builder.protocol;
        this.certificates = builder.certificates;
        this.sslPolicy = builder.sslPolicy;
        this.defaultActions = builder.defaultActions;
        this.alpnPolicy = builder.alpnPolicy;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the listener.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the listener.
     */
    public final String listenerArn() {
        return listenerArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the load balancer.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the load balancer.
     */
    public final String loadBalancerArn() {
        return loadBalancerArn;
    }

    /**
     * <p>
     * The port on which the load balancer is listening.
     * </p>
     * 
     * @return The port on which the load balancer is listening.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The protocol for connections from clients to the load balancer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link ProtocolEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol for connections from clients to the load balancer.
     * @see ProtocolEnum
     */
    public final ProtocolEnum protocol() {
        return ProtocolEnum.fromValue(protocol);
    }

    /**
     * <p>
     * The protocol for connections from clients to the load balancer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link ProtocolEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol for connections from clients to the load balancer.
     * @see ProtocolEnum
     */
    public final String protocolAsString() {
        return protocol;
    }

    /**
     * Returns true if the Certificates property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasCertificates() {
        return certificates != null && !(certificates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * [HTTPS or TLS listener] The default certificate for the listener.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCertificates()} to see if a value was sent in this field.
     * </p>
     * 
     * @return [HTTPS or TLS listener] The default certificate for the listener.
     */
    public final List<Certificate> certificates() {
        return certificates;
    }

    /**
     * <p>
     * [HTTPS or TLS listener] The security policy that defines which protocols and ciphers are supported.
     * </p>
     * 
     * @return [HTTPS or TLS listener] The security policy that defines which protocols and ciphers are supported.
     */
    public final String sslPolicy() {
        return sslPolicy;
    }

    /**
     * Returns true if the DefaultActions property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasDefaultActions() {
        return defaultActions != null && !(defaultActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The default actions for the listener.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDefaultActions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The default actions for the listener.
     */
    public final List<Action> defaultActions() {
        return defaultActions;
    }

    /**
     * Returns true if the AlpnPolicy property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAlpnPolicy() {
        return alpnPolicy != null && !(alpnPolicy instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * [TLS listener] The name of the Application-Layer Protocol Negotiation (ALPN) policy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAlpnPolicy()} to see if a value was sent in this field.
     * </p>
     * 
     * @return [TLS listener] The name of the Application-Layer Protocol Negotiation (ALPN) policy.
     */
    public final List<String> alpnPolicy() {
        return alpnPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(listenerArn());
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerArn());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasCertificates() ? certificates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sslPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(hasDefaultActions() ? defaultActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAlpnPolicy() ? alpnPolicy() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Listener)) {
            return false;
        }
        Listener other = (Listener) obj;
        return Objects.equals(listenerArn(), other.listenerArn()) && Objects.equals(loadBalancerArn(), other.loadBalancerArn())
                && Objects.equals(port(), other.port()) && Objects.equals(protocolAsString(), other.protocolAsString())
                && hasCertificates() == other.hasCertificates() && Objects.equals(certificates(), other.certificates())
                && Objects.equals(sslPolicy(), other.sslPolicy()) && hasDefaultActions() == other.hasDefaultActions()
                && Objects.equals(defaultActions(), other.defaultActions()) && hasAlpnPolicy() == other.hasAlpnPolicy()
                && Objects.equals(alpnPolicy(), other.alpnPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Listener").add("ListenerArn", listenerArn()).add("LoadBalancerArn", loadBalancerArn())
                .add("Port", port()).add("Protocol", protocolAsString())
                .add("Certificates", hasCertificates() ? certificates() : null).add("SslPolicy", sslPolicy())
                .add("DefaultActions", hasDefaultActions() ? defaultActions() : null)
                .add("AlpnPolicy", hasAlpnPolicy() ? alpnPolicy() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ListenerArn":
            return Optional.ofNullable(clazz.cast(listenerArn()));
        case "LoadBalancerArn":
            return Optional.ofNullable(clazz.cast(loadBalancerArn()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        case "Certificates":
            return Optional.ofNullable(clazz.cast(certificates()));
        case "SslPolicy":
            return Optional.ofNullable(clazz.cast(sslPolicy()));
        case "DefaultActions":
            return Optional.ofNullable(clazz.cast(defaultActions()));
        case "AlpnPolicy":
            return Optional.ofNullable(clazz.cast(alpnPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Listener, T> g) {
        return obj -> g.apply((Listener) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Listener> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the listener.
         * </p>
         * 
         * @param listenerArn
         *        The Amazon Resource Name (ARN) of the listener.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listenerArn(String listenerArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the load balancer.
         * </p>
         * 
         * @param loadBalancerArn
         *        The Amazon Resource Name (ARN) of the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerArn(String loadBalancerArn);

        /**
         * <p>
         * The port on which the load balancer is listening.
         * </p>
         * 
         * @param port
         *        The port on which the load balancer is listening.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The protocol for connections from clients to the load balancer.
         * </p>
         * 
         * @param protocol
         *        The protocol for connections from clients to the load balancer.
         * @see ProtocolEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtocolEnum
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The protocol for connections from clients to the load balancer.
         * </p>
         * 
         * @param protocol
         *        The protocol for connections from clients to the load balancer.
         * @see ProtocolEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtocolEnum
         */
        Builder protocol(ProtocolEnum protocol);

        /**
         * <p>
         * [HTTPS or TLS listener] The default certificate for the listener.
         * </p>
         * 
         * @param certificates
         *        [HTTPS or TLS listener] The default certificate for the listener.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificates(Collection<Certificate> certificates);

        /**
         * <p>
         * [HTTPS or TLS listener] The default certificate for the listener.
         * </p>
         * 
         * @param certificates
         *        [HTTPS or TLS listener] The default certificate for the listener.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificates(Certificate... certificates);

        /**
         * <p>
         * [HTTPS or TLS listener] The default certificate for the listener.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Certificate>.Builder} avoiding the need to
         * create one manually via {@link List<Certificate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Certificate>.Builder#build()} is called immediately and its
         * result is passed to {@link #certificates(List<Certificate>)}.
         * 
         * @param certificates
         *        a consumer that will call methods on {@link List<Certificate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #certificates(List<Certificate>)
         */
        Builder certificates(Consumer<Certificate.Builder>... certificates);

        /**
         * <p>
         * [HTTPS or TLS listener] The security policy that defines which protocols and ciphers are supported.
         * </p>
         * 
         * @param sslPolicy
         *        [HTTPS or TLS listener] The security policy that defines which protocols and ciphers are supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sslPolicy(String sslPolicy);

        /**
         * <p>
         * The default actions for the listener.
         * </p>
         * 
         * @param defaultActions
         *        The default actions for the listener.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultActions(Collection<Action> defaultActions);

        /**
         * <p>
         * The default actions for the listener.
         * </p>
         * 
         * @param defaultActions
         *        The default actions for the listener.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultActions(Action... defaultActions);

        /**
         * <p>
         * The default actions for the listener.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Action>.Builder} avoiding the need to
         * create one manually via {@link List<Action>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Action>.Builder#build()} is called immediately and its
         * result is passed to {@link #defaultActions(List<Action>)}.
         * 
         * @param defaultActions
         *        a consumer that will call methods on {@link List<Action>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultActions(List<Action>)
         */
        Builder defaultActions(Consumer<Action.Builder>... defaultActions);

        /**
         * <p>
         * [TLS listener] The name of the Application-Layer Protocol Negotiation (ALPN) policy.
         * </p>
         * 
         * @param alpnPolicy
         *        [TLS listener] The name of the Application-Layer Protocol Negotiation (ALPN) policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alpnPolicy(Collection<String> alpnPolicy);

        /**
         * <p>
         * [TLS listener] The name of the Application-Layer Protocol Negotiation (ALPN) policy.
         * </p>
         * 
         * @param alpnPolicy
         *        [TLS listener] The name of the Application-Layer Protocol Negotiation (ALPN) policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alpnPolicy(String... alpnPolicy);
    }

    static final class BuilderImpl implements Builder {
        private String listenerArn;

        private String loadBalancerArn;

        private Integer port;

        private String protocol;

        private List<Certificate> certificates = DefaultSdkAutoConstructList.getInstance();

        private String sslPolicy;

        private List<Action> defaultActions = DefaultSdkAutoConstructList.getInstance();

        private List<String> alpnPolicy = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Listener model) {
            listenerArn(model.listenerArn);
            loadBalancerArn(model.loadBalancerArn);
            port(model.port);
            protocol(model.protocol);
            certificates(model.certificates);
            sslPolicy(model.sslPolicy);
            defaultActions(model.defaultActions);
            alpnPolicy(model.alpnPolicy);
        }

        public final String getListenerArn() {
            return listenerArn;
        }

        @Override
        public final Builder listenerArn(String listenerArn) {
            this.listenerArn = listenerArn;
            return this;
        }

        public final void setListenerArn(String listenerArn) {
            this.listenerArn = listenerArn;
        }

        public final String getLoadBalancerArn() {
            return loadBalancerArn;
        }

        @Override
        public final Builder loadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
            return this;
        }

        public final void setLoadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
        }

        public final Integer getPort() {
            return port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getProtocol() {
            return protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(ProtocolEnum protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final List<Certificate.Builder> getCertificates() {
            List<Certificate.Builder> result = CertificateListCopier.copyToBuilder(this.certificates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder certificates(Collection<Certificate> certificates) {
            this.certificates = CertificateListCopier.copy(certificates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificates(Certificate... certificates) {
            certificates(Arrays.asList(certificates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificates(Consumer<Certificate.Builder>... certificates) {
            certificates(Stream.of(certificates).map(c -> Certificate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setCertificates(Collection<Certificate.BuilderImpl> certificates) {
            this.certificates = CertificateListCopier.copyFromBuilder(certificates);
        }

        public final String getSslPolicy() {
            return sslPolicy;
        }

        @Override
        public final Builder sslPolicy(String sslPolicy) {
            this.sslPolicy = sslPolicy;
            return this;
        }

        public final void setSslPolicy(String sslPolicy) {
            this.sslPolicy = sslPolicy;
        }

        public final List<Action.Builder> getDefaultActions() {
            List<Action.Builder> result = ActionsCopier.copyToBuilder(this.defaultActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder defaultActions(Collection<Action> defaultActions) {
            this.defaultActions = ActionsCopier.copy(defaultActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultActions(Action... defaultActions) {
            defaultActions(Arrays.asList(defaultActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultActions(Consumer<Action.Builder>... defaultActions) {
            defaultActions(Stream.of(defaultActions).map(c -> Action.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDefaultActions(Collection<Action.BuilderImpl> defaultActions) {
            this.defaultActions = ActionsCopier.copyFromBuilder(defaultActions);
        }

        public final Collection<String> getAlpnPolicy() {
            if (alpnPolicy instanceof SdkAutoConstructList) {
                return null;
            }
            return alpnPolicy;
        }

        @Override
        public final Builder alpnPolicy(Collection<String> alpnPolicy) {
            this.alpnPolicy = AlpnPolicyNameCopier.copy(alpnPolicy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alpnPolicy(String... alpnPolicy) {
            alpnPolicy(Arrays.asList(alpnPolicy));
            return this;
        }

        public final void setAlpnPolicy(Collection<String> alpnPolicy) {
            this.alpnPolicy = AlpnPolicyNameCopier.copy(alpnPolicy);
        }

        @Override
        public Listener build() {
            return new Listener(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
