/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Rule implements SdkPojo, Serializable, ToCopyableBuilder<Rule.Builder, Rule> {
    private static final SdkField<String> RULE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleArn").getter(getter(Rule::ruleArn)).setter(setter(Builder::ruleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleArn").build()).build();

    private static final SdkField<String> PRIORITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Priority").getter(getter(Rule::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()).build();

    private static final SdkField<List<RuleCondition>> CONDITIONS_FIELD = SdkField
            .<List<RuleCondition>> builder(MarshallingType.LIST)
            .memberName("Conditions")
            .getter(getter(Rule::conditions))
            .setter(setter(Builder::conditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Conditions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RuleCondition> builder(MarshallingType.SDK_POJO)
                                            .constructor(RuleCondition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Action>> ACTIONS_FIELD = SdkField
            .<List<Action>> builder(MarshallingType.LIST)
            .memberName("Actions")
            .getter(getter(Rule::actions))
            .setter(setter(Builder::actions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Action> builder(MarshallingType.SDK_POJO)
                                            .constructor(Action::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> IS_DEFAULT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsDefault").getter(getter(Rule::isDefault)).setter(setter(Builder::isDefault))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsDefault").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_ARN_FIELD,
            PRIORITY_FIELD, CONDITIONS_FIELD, ACTIONS_FIELD, IS_DEFAULT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ruleArn;

    private final String priority;

    private final List<RuleCondition> conditions;

    private final List<Action> actions;

    private final Boolean isDefault;

    private Rule(BuilderImpl builder) {
        this.ruleArn = builder.ruleArn;
        this.priority = builder.priority;
        this.conditions = builder.conditions;
        this.actions = builder.actions;
        this.isDefault = builder.isDefault;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the rule.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the rule.
     */
    public final String ruleArn() {
        return ruleArn;
    }

    /**
     * <p>
     * The priority.
     * </p>
     * 
     * @return The priority.
     */
    public final String priority() {
        return priority;
    }

    /**
     * For responses, this returns true if the service returned a value for the Conditions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasConditions() {
        return conditions != null && !(conditions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The conditions. Each rule can include zero or one of the following conditions: <code>http-request-method</code>,
     * <code>host-header</code>, <code>path-pattern</code>, and <code>source-ip</code>, and zero or more of the
     * following conditions: <code>http-header</code> and <code>query-string</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConditions} method.
     * </p>
     * 
     * @return The conditions. Each rule can include zero or one of the following conditions:
     *         <code>http-request-method</code>, <code>host-header</code>, <code>path-pattern</code>, and
     *         <code>source-ip</code>, and zero or more of the following conditions: <code>http-header</code> and
     *         <code>query-string</code>.
     */
    public final List<RuleCondition> conditions() {
        return conditions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Actions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasActions() {
        return actions != null && !(actions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The actions. Each rule must include exactly one of the following types of actions: <code>forward</code>,
     * <code>redirect</code>, or <code>fixed-response</code>, and it must be the last action to be performed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActions} method.
     * </p>
     * 
     * @return The actions. Each rule must include exactly one of the following types of actions: <code>forward</code>,
     *         <code>redirect</code>, or <code>fixed-response</code>, and it must be the last action to be performed.
     */
    public final List<Action> actions() {
        return actions;
    }

    /**
     * <p>
     * Indicates whether this is the default rule.
     * </p>
     * 
     * @return Indicates whether this is the default rule.
     */
    public final Boolean isDefault() {
        return isDefault;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ruleArn());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(hasConditions() ? conditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasActions() ? actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(isDefault());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Rule)) {
            return false;
        }
        Rule other = (Rule) obj;
        return Objects.equals(ruleArn(), other.ruleArn()) && Objects.equals(priority(), other.priority())
                && hasConditions() == other.hasConditions() && Objects.equals(conditions(), other.conditions())
                && hasActions() == other.hasActions() && Objects.equals(actions(), other.actions())
                && Objects.equals(isDefault(), other.isDefault());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Rule").add("RuleArn", ruleArn()).add("Priority", priority())
                .add("Conditions", hasConditions() ? conditions() : null).add("Actions", hasActions() ? actions() : null)
                .add("IsDefault", isDefault()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleArn":
            return Optional.ofNullable(clazz.cast(ruleArn()));
        case "Priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "Conditions":
            return Optional.ofNullable(clazz.cast(conditions()));
        case "Actions":
            return Optional.ofNullable(clazz.cast(actions()));
        case "IsDefault":
            return Optional.ofNullable(clazz.cast(isDefault()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Rule, T> g) {
        return obj -> g.apply((Rule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Rule> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the rule.
         * </p>
         * 
         * @param ruleArn
         *        The Amazon Resource Name (ARN) of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleArn(String ruleArn);

        /**
         * <p>
         * The priority.
         * </p>
         * 
         * @param priority
         *        The priority.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(String priority);

        /**
         * <p>
         * The conditions. Each rule can include zero or one of the following conditions:
         * <code>http-request-method</code>, <code>host-header</code>, <code>path-pattern</code>, and
         * <code>source-ip</code>, and zero or more of the following conditions: <code>http-header</code> and
         * <code>query-string</code>.
         * </p>
         * 
         * @param conditions
         *        The conditions. Each rule can include zero or one of the following conditions:
         *        <code>http-request-method</code>, <code>host-header</code>, <code>path-pattern</code>, and
         *        <code>source-ip</code>, and zero or more of the following conditions: <code>http-header</code> and
         *        <code>query-string</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditions(Collection<RuleCondition> conditions);

        /**
         * <p>
         * The conditions. Each rule can include zero or one of the following conditions:
         * <code>http-request-method</code>, <code>host-header</code>, <code>path-pattern</code>, and
         * <code>source-ip</code>, and zero or more of the following conditions: <code>http-header</code> and
         * <code>query-string</code>.
         * </p>
         * 
         * @param conditions
         *        The conditions. Each rule can include zero or one of the following conditions:
         *        <code>http-request-method</code>, <code>host-header</code>, <code>path-pattern</code>, and
         *        <code>source-ip</code>, and zero or more of the following conditions: <code>http-header</code> and
         *        <code>query-string</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditions(RuleCondition... conditions);

        /**
         * <p>
         * The conditions. Each rule can include zero or one of the following conditions:
         * <code>http-request-method</code>, <code>host-header</code>, <code>path-pattern</code>, and
         * <code>source-ip</code>, and zero or more of the following conditions: <code>http-header</code> and
         * <code>query-string</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<RuleCondition>.Builder} avoiding the
         * need to create one manually via {@link List<RuleCondition>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RuleCondition>.Builder#build()} is called immediately and
         * its result is passed to {@link #conditions(List<RuleCondition>)}.
         * 
         * @param conditions
         *        a consumer that will call methods on {@link List<RuleCondition>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conditions(List<RuleCondition>)
         */
        Builder conditions(Consumer<RuleCondition.Builder>... conditions);

        /**
         * <p>
         * The actions. Each rule must include exactly one of the following types of actions: <code>forward</code>,
         * <code>redirect</code>, or <code>fixed-response</code>, and it must be the last action to be performed.
         * </p>
         * 
         * @param actions
         *        The actions. Each rule must include exactly one of the following types of actions:
         *        <code>forward</code>, <code>redirect</code>, or <code>fixed-response</code>, and it must be the last
         *        action to be performed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Collection<Action> actions);

        /**
         * <p>
         * The actions. Each rule must include exactly one of the following types of actions: <code>forward</code>,
         * <code>redirect</code>, or <code>fixed-response</code>, and it must be the last action to be performed.
         * </p>
         * 
         * @param actions
         *        The actions. Each rule must include exactly one of the following types of actions:
         *        <code>forward</code>, <code>redirect</code>, or <code>fixed-response</code>, and it must be the last
         *        action to be performed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Action... actions);

        /**
         * <p>
         * The actions. Each rule must include exactly one of the following types of actions: <code>forward</code>,
         * <code>redirect</code>, or <code>fixed-response</code>, and it must be the last action to be performed.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Action>.Builder} avoiding the need
         * to create one manually via {@link List<Action>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Action>.Builder#build()} is called immediately and its
         * result is passed to {@link #actions(List<Action>)}.
         * 
         * @param actions
         *        a consumer that will call methods on {@link List<Action>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actions(List<Action>)
         */
        Builder actions(Consumer<Action.Builder>... actions);

        /**
         * <p>
         * Indicates whether this is the default rule.
         * </p>
         * 
         * @param isDefault
         *        Indicates whether this is the default rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isDefault(Boolean isDefault);
    }

    static final class BuilderImpl implements Builder {
        private String ruleArn;

        private String priority;

        private List<RuleCondition> conditions = DefaultSdkAutoConstructList.getInstance();

        private List<Action> actions = DefaultSdkAutoConstructList.getInstance();

        private Boolean isDefault;

        private BuilderImpl() {
        }

        private BuilderImpl(Rule model) {
            ruleArn(model.ruleArn);
            priority(model.priority);
            conditions(model.conditions);
            actions(model.actions);
            isDefault(model.isDefault);
        }

        public final String getRuleArn() {
            return ruleArn;
        }

        public final void setRuleArn(String ruleArn) {
            this.ruleArn = ruleArn;
        }

        @Override
        public final Builder ruleArn(String ruleArn) {
            this.ruleArn = ruleArn;
            return this;
        }

        public final String getPriority() {
            return priority;
        }

        public final void setPriority(String priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(String priority) {
            this.priority = priority;
            return this;
        }

        public final List<RuleCondition.Builder> getConditions() {
            List<RuleCondition.Builder> result = RuleConditionListCopier.copyToBuilder(this.conditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConditions(Collection<RuleCondition.BuilderImpl> conditions) {
            this.conditions = RuleConditionListCopier.copyFromBuilder(conditions);
        }

        @Override
        public final Builder conditions(Collection<RuleCondition> conditions) {
            this.conditions = RuleConditionListCopier.copy(conditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(RuleCondition... conditions) {
            conditions(Arrays.asList(conditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(Consumer<RuleCondition.Builder>... conditions) {
            conditions(Stream.of(conditions).map(c -> RuleCondition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Action.Builder> getActions() {
            List<Action.Builder> result = ActionsCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActions(Collection<Action.BuilderImpl> actions) {
            this.actions = ActionsCopier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actions(Collection<Action> actions) {
            this.actions = ActionsCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Action... actions) {
            actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<Action.Builder>... actions) {
            actions(Stream.of(actions).map(c -> Action.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getIsDefault() {
            return isDefault;
        }

        public final void setIsDefault(Boolean isDefault) {
            this.isDefault = isDefault;
        }

        @Override
        public final Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        @Override
        public Rule build() {
            return new Rule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
