/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the health of a target.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TargetHealthDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<TargetHealthDescription.Builder, TargetHealthDescription> {
    private static final SdkField<TargetDescription> TARGET_FIELD = SdkField
            .<TargetDescription> builder(MarshallingType.SDK_POJO).memberName("Target")
            .getter(getter(TargetHealthDescription::target)).setter(setter(Builder::target))
            .constructor(TargetDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()).build();

    private static final SdkField<String> HEALTH_CHECK_PORT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HealthCheckPort").getter(getter(TargetHealthDescription::healthCheckPort))
            .setter(setter(Builder::healthCheckPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckPort").build()).build();

    private static final SdkField<TargetHealth> TARGET_HEALTH_FIELD = SdkField.<TargetHealth> builder(MarshallingType.SDK_POJO)
            .memberName("TargetHealth").getter(getter(TargetHealthDescription::targetHealth))
            .setter(setter(Builder::targetHealth)).constructor(TargetHealth::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetHealth").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_FIELD,
            HEALTH_CHECK_PORT_FIELD, TARGET_HEALTH_FIELD));

    private static final long serialVersionUID = 1L;

    private final TargetDescription target;

    private final String healthCheckPort;

    private final TargetHealth targetHealth;

    private TargetHealthDescription(BuilderImpl builder) {
        this.target = builder.target;
        this.healthCheckPort = builder.healthCheckPort;
        this.targetHealth = builder.targetHealth;
    }

    /**
     * <p>
     * The description of the target.
     * </p>
     * 
     * @return The description of the target.
     */
    public final TargetDescription target() {
        return target;
    }

    /**
     * <p>
     * The port to use to connect with the target.
     * </p>
     * 
     * @return The port to use to connect with the target.
     */
    public final String healthCheckPort() {
        return healthCheckPort;
    }

    /**
     * <p>
     * The health information for the target.
     * </p>
     * 
     * @return The health information for the target.
     */
    public final TargetHealth targetHealth() {
        return targetHealth;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(target());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckPort());
        hashCode = 31 * hashCode + Objects.hashCode(targetHealth());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetHealthDescription)) {
            return false;
        }
        TargetHealthDescription other = (TargetHealthDescription) obj;
        return Objects.equals(target(), other.target()) && Objects.equals(healthCheckPort(), other.healthCheckPort())
                && Objects.equals(targetHealth(), other.targetHealth());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TargetHealthDescription").add("Target", target()).add("HealthCheckPort", healthCheckPort())
                .add("TargetHealth", targetHealth()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Target":
            return Optional.ofNullable(clazz.cast(target()));
        case "HealthCheckPort":
            return Optional.ofNullable(clazz.cast(healthCheckPort()));
        case "TargetHealth":
            return Optional.ofNullable(clazz.cast(targetHealth()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TargetHealthDescription, T> g) {
        return obj -> g.apply((TargetHealthDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TargetHealthDescription> {
        /**
         * <p>
         * The description of the target.
         * </p>
         * 
         * @param target
         *        The description of the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(TargetDescription target);

        /**
         * <p>
         * The description of the target.
         * </p>
         * This is a convenience method that creates an instance of the {@link TargetDescription.Builder} avoiding the
         * need to create one manually via {@link TargetDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link TargetDescription.Builder#build()} is called immediately and its
         * result is passed to {@link #target(TargetDescription)}.
         * 
         * @param target
         *        a consumer that will call methods on {@link TargetDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #target(TargetDescription)
         */
        default Builder target(Consumer<TargetDescription.Builder> target) {
            return target(TargetDescription.builder().applyMutation(target).build());
        }

        /**
         * <p>
         * The port to use to connect with the target.
         * </p>
         * 
         * @param healthCheckPort
         *        The port to use to connect with the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckPort(String healthCheckPort);

        /**
         * <p>
         * The health information for the target.
         * </p>
         * 
         * @param targetHealth
         *        The health information for the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetHealth(TargetHealth targetHealth);

        /**
         * <p>
         * The health information for the target.
         * </p>
         * This is a convenience method that creates an instance of the {@link TargetHealth.Builder} avoiding the need
         * to create one manually via {@link TargetHealth#builder()}.
         *
         * When the {@link Consumer} completes, {@link TargetHealth.Builder#build()} is called immediately and its
         * result is passed to {@link #targetHealth(TargetHealth)}.
         * 
         * @param targetHealth
         *        a consumer that will call methods on {@link TargetHealth.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetHealth(TargetHealth)
         */
        default Builder targetHealth(Consumer<TargetHealth.Builder> targetHealth) {
            return targetHealth(TargetHealth.builder().applyMutation(targetHealth).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TargetDescription target;

        private String healthCheckPort;

        private TargetHealth targetHealth;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetHealthDescription model) {
            target(model.target);
            healthCheckPort(model.healthCheckPort);
            targetHealth(model.targetHealth);
        }

        public final TargetDescription.Builder getTarget() {
            return target != null ? target.toBuilder() : null;
        }

        public final void setTarget(TargetDescription.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        @Override
        public final Builder target(TargetDescription target) {
            this.target = target;
            return this;
        }

        public final String getHealthCheckPort() {
            return healthCheckPort;
        }

        public final void setHealthCheckPort(String healthCheckPort) {
            this.healthCheckPort = healthCheckPort;
        }

        @Override
        public final Builder healthCheckPort(String healthCheckPort) {
            this.healthCheckPort = healthCheckPort;
            return this;
        }

        public final TargetHealth.Builder getTargetHealth() {
            return targetHealth != null ? targetHealth.toBuilder() : null;
        }

        public final void setTargetHealth(TargetHealth.BuilderImpl targetHealth) {
            this.targetHealth = targetHealth != null ? targetHealth.build() : null;
        }

        @Override
        public final Builder targetHealth(TargetHealth targetHealth) {
            this.targetHealth = targetHealth;
            return this;
        }

        @Override
        public TargetHealthDescription build() {
            return new TargetHealthDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
