/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeListenersRequest extends ElasticLoadBalancingV2Request implements
        ToCopyableBuilder<DescribeListenersRequest.Builder, DescribeListenersRequest> {
    private static final SdkField<String> LOAD_BALANCER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LoadBalancerArn").getter(getter(DescribeListenersRequest::loadBalancerArn))
            .setter(setter(Builder::loadBalancerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerArn").build()).build();

    private static final SdkField<List<String>> LISTENER_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ListenerArns")
            .getter(getter(DescribeListenersRequest::listenerArns))
            .setter(setter(Builder::listenerArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListenerArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeListenersRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PageSize").getter(getter(DescribeListenersRequest::pageSize)).setter(setter(Builder::pageSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageSize").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_BALANCER_ARN_FIELD,
            LISTENER_ARNS_FIELD, MARKER_FIELD, PAGE_SIZE_FIELD));

    private final String loadBalancerArn;

    private final List<String> listenerArns;

    private final String marker;

    private final Integer pageSize;

    private DescribeListenersRequest(BuilderImpl builder) {
        super(builder);
        this.loadBalancerArn = builder.loadBalancerArn;
        this.listenerArns = builder.listenerArns;
        this.marker = builder.marker;
        this.pageSize = builder.pageSize;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the load balancer.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the load balancer.
     */
    public final String loadBalancerArn() {
        return loadBalancerArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the ListenerArns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasListenerArns() {
        return listenerArns != null && !(listenerArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names (ARN) of the listeners.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasListenerArns} method.
     * </p>
     * 
     * @return The Amazon Resource Names (ARN) of the listeners.
     */
    public final List<String> listenerArns() {
        return listenerArns;
    }

    /**
     * <p>
     * The marker for the next set of results. (You received this marker from a previous call.)
     * </p>
     * 
     * @return The marker for the next set of results. (You received this marker from a previous call.)
     */
    public final String marker() {
        return marker;
    }

    /**
     * <p>
     * The maximum number of results to return with this call.
     * </p>
     * 
     * @return The maximum number of results to return with this call.
     */
    public final Integer pageSize() {
        return pageSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasListenerArns() ? listenerArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(pageSize());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeListenersRequest)) {
            return false;
        }
        DescribeListenersRequest other = (DescribeListenersRequest) obj;
        return Objects.equals(loadBalancerArn(), other.loadBalancerArn()) && hasListenerArns() == other.hasListenerArns()
                && Objects.equals(listenerArns(), other.listenerArns()) && Objects.equals(marker(), other.marker())
                && Objects.equals(pageSize(), other.pageSize());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeListenersRequest").add("LoadBalancerArn", loadBalancerArn())
                .add("ListenerArns", hasListenerArns() ? listenerArns() : null).add("Marker", marker())
                .add("PageSize", pageSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LoadBalancerArn":
            return Optional.ofNullable(clazz.cast(loadBalancerArn()));
        case "ListenerArns":
            return Optional.ofNullable(clazz.cast(listenerArns()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "PageSize":
            return Optional.ofNullable(clazz.cast(pageSize()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeListenersRequest, T> g) {
        return obj -> g.apply((DescribeListenersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticLoadBalancingV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeListenersRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the load balancer.
         * </p>
         * 
         * @param loadBalancerArn
         *        The Amazon Resource Name (ARN) of the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerArn(String loadBalancerArn);

        /**
         * <p>
         * The Amazon Resource Names (ARN) of the listeners.
         * </p>
         * 
         * @param listenerArns
         *        The Amazon Resource Names (ARN) of the listeners.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listenerArns(Collection<String> listenerArns);

        /**
         * <p>
         * The Amazon Resource Names (ARN) of the listeners.
         * </p>
         * 
         * @param listenerArns
         *        The Amazon Resource Names (ARN) of the listeners.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listenerArns(String... listenerArns);

        /**
         * <p>
         * The marker for the next set of results. (You received this marker from a previous call.)
         * </p>
         * 
         * @param marker
         *        The marker for the next set of results. (You received this marker from a previous call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The maximum number of results to return with this call.
         * </p>
         * 
         * @param pageSize
         *        The maximum number of results to return with this call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageSize(Integer pageSize);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticLoadBalancingV2Request.BuilderImpl implements Builder {
        private String loadBalancerArn;

        private List<String> listenerArns = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private Integer pageSize;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeListenersRequest model) {
            super(model);
            loadBalancerArn(model.loadBalancerArn);
            listenerArns(model.listenerArns);
            marker(model.marker);
            pageSize(model.pageSize);
        }

        public final String getLoadBalancerArn() {
            return loadBalancerArn;
        }

        public final void setLoadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
        }

        @Override
        public final Builder loadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
            return this;
        }

        public final Collection<String> getListenerArns() {
            if (listenerArns instanceof SdkAutoConstructList) {
                return null;
            }
            return listenerArns;
        }

        public final void setListenerArns(Collection<String> listenerArns) {
            this.listenerArns = ListenerArnsCopier.copy(listenerArns);
        }

        @Override
        public final Builder listenerArns(Collection<String> listenerArns) {
            this.listenerArns = ListenerArnsCopier.copy(listenerArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listenerArns(String... listenerArns) {
            listenerArns(Arrays.asList(listenerArns));
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final Integer getPageSize() {
            return pageSize;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeListenersRequest build() {
            return new DescribeListenersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
