/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetSubnetsRequest extends ElasticLoadBalancingV2Request implements
        ToCopyableBuilder<SetSubnetsRequest.Builder, SetSubnetsRequest> {
    private static final SdkField<String> LOAD_BALANCER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LoadBalancerArn").getter(getter(SetSubnetsRequest::loadBalancerArn))
            .setter(setter(Builder::loadBalancerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerArn").build()).build();

    private static final SdkField<List<String>> SUBNETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Subnets")
            .getter(getter(SetSubnetsRequest::subnets))
            .setter(setter(Builder::subnets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subnets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SubnetMapping>> SUBNET_MAPPINGS_FIELD = SdkField
            .<List<SubnetMapping>> builder(MarshallingType.LIST)
            .memberName("SubnetMappings")
            .getter(getter(SetSubnetsRequest::subnetMappings))
            .setter(setter(Builder::subnetMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SubnetMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(SubnetMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IpAddressType").getter(getter(SetSubnetsRequest::ipAddressTypeAsString))
            .setter(setter(Builder::ipAddressType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddressType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_BALANCER_ARN_FIELD,
            SUBNETS_FIELD, SUBNET_MAPPINGS_FIELD, IP_ADDRESS_TYPE_FIELD));

    private final String loadBalancerArn;

    private final List<String> subnets;

    private final List<SubnetMapping> subnetMappings;

    private final String ipAddressType;

    private SetSubnetsRequest(BuilderImpl builder) {
        super(builder);
        this.loadBalancerArn = builder.loadBalancerArn;
        this.subnets = builder.subnets;
        this.subnetMappings = builder.subnetMappings;
        this.ipAddressType = builder.ipAddressType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the load balancer.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the load balancer.
     */
    public final String loadBalancerArn() {
        return loadBalancerArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Subnets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnets() {
        return subnets != null && !(subnets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the public subnets. You can specify only one subnet per Availability Zone. You must specify either
     * subnets or subnet mappings.
     * </p>
     * <p>
     * [Application Load Balancers] You must specify subnets from at least two Availability Zones.
     * </p>
     * <p>
     * [Application Load Balancers on Outposts] You must specify one Outpost subnet.
     * </p>
     * <p>
     * [Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones.
     * </p>
     * <p>
     * [Network Load Balancers] You can specify subnets from one or more Availability Zones.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnets} method.
     * </p>
     * 
     * @return The IDs of the public subnets. You can specify only one subnet per Availability Zone. You must specify
     *         either subnets or subnet mappings.</p>
     *         <p>
     *         [Application Load Balancers] You must specify subnets from at least two Availability Zones.
     *         </p>
     *         <p>
     *         [Application Load Balancers on Outposts] You must specify one Outpost subnet.
     *         </p>
     *         <p>
     *         [Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones.
     *         </p>
     *         <p>
     *         [Network Load Balancers] You can specify subnets from one or more Availability Zones.
     */
    public final List<String> subnets() {
        return subnets;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubnetMappings property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSubnetMappings() {
        return subnetMappings != null && !(subnetMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the public subnets. You can specify only one subnet per Availability Zone. You must specify either
     * subnets or subnet mappings.
     * </p>
     * <p>
     * [Application Load Balancers] You must specify subnets from at least two Availability Zones. You cannot specify
     * Elastic IP addresses for your subnets.
     * </p>
     * <p>
     * [Application Load Balancers on Outposts] You must specify one Outpost subnet.
     * </p>
     * <p>
     * [Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones.
     * </p>
     * <p>
     * [Network Load Balancers] You can specify subnets from one or more Availability Zones. You can specify one Elastic
     * IP address per subnet if you need static IP addresses for your internet-facing load balancer. For internal load
     * balancers, you can specify one private IP address per subnet from the IPv4 range of the subnet. For
     * internet-facing load balancer, you can specify one IPv6 address per subnet.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnetMappings} method.
     * </p>
     * 
     * @return The IDs of the public subnets. You can specify only one subnet per Availability Zone. You must specify
     *         either subnets or subnet mappings.</p>
     *         <p>
     *         [Application Load Balancers] You must specify subnets from at least two Availability Zones. You cannot
     *         specify Elastic IP addresses for your subnets.
     *         </p>
     *         <p>
     *         [Application Load Balancers on Outposts] You must specify one Outpost subnet.
     *         </p>
     *         <p>
     *         [Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones.
     *         </p>
     *         <p>
     *         [Network Load Balancers] You can specify subnets from one or more Availability Zones. You can specify one
     *         Elastic IP address per subnet if you need static IP addresses for your internet-facing load balancer. For
     *         internal load balancers, you can specify one private IP address per subnet from the IPv4 range of the
     *         subnet. For internet-facing load balancer, you can specify one IPv6 address per subnet.
     */
    public final List<SubnetMapping> subnetMappings() {
        return subnetMappings;
    }

    /**
     * <p>
     * [Network Load Balancers] The type of IP addresses used by the subnets for your load balancer. The possible values
     * are <code>ipv4</code> (for IPv4 addresses) and <code>dualstack</code> (for IPv4 and IPv6 addresses). You can’t
     * specify <code>dualstack</code> for a load balancer with a UDP or TCP_UDP listener. Internal load balancers must
     * use <code>ipv4</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressType}
     * will return {@link IpAddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipAddressTypeAsString}.
     * </p>
     * 
     * @return [Network Load Balancers] The type of IP addresses used by the subnets for your load balancer. The
     *         possible values are <code>ipv4</code> (for IPv4 addresses) and <code>dualstack</code> (for IPv4 and IPv6
     *         addresses). You can’t specify <code>dualstack</code> for a load balancer with a UDP or TCP_UDP listener.
     *         Internal load balancers must use <code>ipv4</code>.
     * @see IpAddressType
     */
    public final IpAddressType ipAddressType() {
        return IpAddressType.fromValue(ipAddressType);
    }

    /**
     * <p>
     * [Network Load Balancers] The type of IP addresses used by the subnets for your load balancer. The possible values
     * are <code>ipv4</code> (for IPv4 addresses) and <code>dualstack</code> (for IPv4 and IPv6 addresses). You can’t
     * specify <code>dualstack</code> for a load balancer with a UDP or TCP_UDP listener. Internal load balancers must
     * use <code>ipv4</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressType}
     * will return {@link IpAddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipAddressTypeAsString}.
     * </p>
     * 
     * @return [Network Load Balancers] The type of IP addresses used by the subnets for your load balancer. The
     *         possible values are <code>ipv4</code> (for IPv4 addresses) and <code>dualstack</code> (for IPv4 and IPv6
     *         addresses). You can’t specify <code>dualstack</code> for a load balancer with a UDP or TCP_UDP listener.
     *         Internal load balancers must use <code>ipv4</code>.
     * @see IpAddressType
     */
    public final String ipAddressTypeAsString() {
        return ipAddressType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnets() ? subnets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetMappings() ? subnetMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ipAddressTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetSubnetsRequest)) {
            return false;
        }
        SetSubnetsRequest other = (SetSubnetsRequest) obj;
        return Objects.equals(loadBalancerArn(), other.loadBalancerArn()) && hasSubnets() == other.hasSubnets()
                && Objects.equals(subnets(), other.subnets()) && hasSubnetMappings() == other.hasSubnetMappings()
                && Objects.equals(subnetMappings(), other.subnetMappings())
                && Objects.equals(ipAddressTypeAsString(), other.ipAddressTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SetSubnetsRequest").add("LoadBalancerArn", loadBalancerArn())
                .add("Subnets", hasSubnets() ? subnets() : null)
                .add("SubnetMappings", hasSubnetMappings() ? subnetMappings() : null)
                .add("IpAddressType", ipAddressTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LoadBalancerArn":
            return Optional.ofNullable(clazz.cast(loadBalancerArn()));
        case "Subnets":
            return Optional.ofNullable(clazz.cast(subnets()));
        case "SubnetMappings":
            return Optional.ofNullable(clazz.cast(subnetMappings()));
        case "IpAddressType":
            return Optional.ofNullable(clazz.cast(ipAddressTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SetSubnetsRequest, T> g) {
        return obj -> g.apply((SetSubnetsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticLoadBalancingV2Request.Builder, SdkPojo, CopyableBuilder<Builder, SetSubnetsRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the load balancer.
         * </p>
         * 
         * @param loadBalancerArn
         *        The Amazon Resource Name (ARN) of the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerArn(String loadBalancerArn);

        /**
         * <p>
         * The IDs of the public subnets. You can specify only one subnet per Availability Zone. You must specify either
         * subnets or subnet mappings.
         * </p>
         * <p>
         * [Application Load Balancers] You must specify subnets from at least two Availability Zones.
         * </p>
         * <p>
         * [Application Load Balancers on Outposts] You must specify one Outpost subnet.
         * </p>
         * <p>
         * [Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones.
         * </p>
         * <p>
         * [Network Load Balancers] You can specify subnets from one or more Availability Zones.
         * </p>
         * 
         * @param subnets
         *        The IDs of the public subnets. You can specify only one subnet per Availability Zone. You must specify
         *        either subnets or subnet mappings.</p>
         *        <p>
         *        [Application Load Balancers] You must specify subnets from at least two Availability Zones.
         *        </p>
         *        <p>
         *        [Application Load Balancers on Outposts] You must specify one Outpost subnet.
         *        </p>
         *        <p>
         *        [Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones.
         *        </p>
         *        <p>
         *        [Network Load Balancers] You can specify subnets from one or more Availability Zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnets(Collection<String> subnets);

        /**
         * <p>
         * The IDs of the public subnets. You can specify only one subnet per Availability Zone. You must specify either
         * subnets or subnet mappings.
         * </p>
         * <p>
         * [Application Load Balancers] You must specify subnets from at least two Availability Zones.
         * </p>
         * <p>
         * [Application Load Balancers on Outposts] You must specify one Outpost subnet.
         * </p>
         * <p>
         * [Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones.
         * </p>
         * <p>
         * [Network Load Balancers] You can specify subnets from one or more Availability Zones.
         * </p>
         * 
         * @param subnets
         *        The IDs of the public subnets. You can specify only one subnet per Availability Zone. You must specify
         *        either subnets or subnet mappings.</p>
         *        <p>
         *        [Application Load Balancers] You must specify subnets from at least two Availability Zones.
         *        </p>
         *        <p>
         *        [Application Load Balancers on Outposts] You must specify one Outpost subnet.
         *        </p>
         *        <p>
         *        [Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones.
         *        </p>
         *        <p>
         *        [Network Load Balancers] You can specify subnets from one or more Availability Zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnets(String... subnets);

        /**
         * <p>
         * The IDs of the public subnets. You can specify only one subnet per Availability Zone. You must specify either
         * subnets or subnet mappings.
         * </p>
         * <p>
         * [Application Load Balancers] You must specify subnets from at least two Availability Zones. You cannot
         * specify Elastic IP addresses for your subnets.
         * </p>
         * <p>
         * [Application Load Balancers on Outposts] You must specify one Outpost subnet.
         * </p>
         * <p>
         * [Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones.
         * </p>
         * <p>
         * [Network Load Balancers] You can specify subnets from one or more Availability Zones. You can specify one
         * Elastic IP address per subnet if you need static IP addresses for your internet-facing load balancer. For
         * internal load balancers, you can specify one private IP address per subnet from the IPv4 range of the subnet.
         * For internet-facing load balancer, you can specify one IPv6 address per subnet.
         * </p>
         * 
         * @param subnetMappings
         *        The IDs of the public subnets. You can specify only one subnet per Availability Zone. You must specify
         *        either subnets or subnet mappings.</p>
         *        <p>
         *        [Application Load Balancers] You must specify subnets from at least two Availability Zones. You cannot
         *        specify Elastic IP addresses for your subnets.
         *        </p>
         *        <p>
         *        [Application Load Balancers on Outposts] You must specify one Outpost subnet.
         *        </p>
         *        <p>
         *        [Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones.
         *        </p>
         *        <p>
         *        [Network Load Balancers] You can specify subnets from one or more Availability Zones. You can specify
         *        one Elastic IP address per subnet if you need static IP addresses for your internet-facing load
         *        balancer. For internal load balancers, you can specify one private IP address per subnet from the IPv4
         *        range of the subnet. For internet-facing load balancer, you can specify one IPv6 address per subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetMappings(Collection<SubnetMapping> subnetMappings);

        /**
         * <p>
         * The IDs of the public subnets. You can specify only one subnet per Availability Zone. You must specify either
         * subnets or subnet mappings.
         * </p>
         * <p>
         * [Application Load Balancers] You must specify subnets from at least two Availability Zones. You cannot
         * specify Elastic IP addresses for your subnets.
         * </p>
         * <p>
         * [Application Load Balancers on Outposts] You must specify one Outpost subnet.
         * </p>
         * <p>
         * [Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones.
         * </p>
         * <p>
         * [Network Load Balancers] You can specify subnets from one or more Availability Zones. You can specify one
         * Elastic IP address per subnet if you need static IP addresses for your internet-facing load balancer. For
         * internal load balancers, you can specify one private IP address per subnet from the IPv4 range of the subnet.
         * For internet-facing load balancer, you can specify one IPv6 address per subnet.
         * </p>
         * 
         * @param subnetMappings
         *        The IDs of the public subnets. You can specify only one subnet per Availability Zone. You must specify
         *        either subnets or subnet mappings.</p>
         *        <p>
         *        [Application Load Balancers] You must specify subnets from at least two Availability Zones. You cannot
         *        specify Elastic IP addresses for your subnets.
         *        </p>
         *        <p>
         *        [Application Load Balancers on Outposts] You must specify one Outpost subnet.
         *        </p>
         *        <p>
         *        [Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones.
         *        </p>
         *        <p>
         *        [Network Load Balancers] You can specify subnets from one or more Availability Zones. You can specify
         *        one Elastic IP address per subnet if you need static IP addresses for your internet-facing load
         *        balancer. For internal load balancers, you can specify one private IP address per subnet from the IPv4
         *        range of the subnet. For internet-facing load balancer, you can specify one IPv6 address per subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetMappings(SubnetMapping... subnetMappings);

        /**
         * <p>
         * The IDs of the public subnets. You can specify only one subnet per Availability Zone. You must specify either
         * subnets or subnet mappings.
         * </p>
         * <p>
         * [Application Load Balancers] You must specify subnets from at least two Availability Zones. You cannot
         * specify Elastic IP addresses for your subnets.
         * </p>
         * <p>
         * [Application Load Balancers on Outposts] You must specify one Outpost subnet.
         * </p>
         * <p>
         * [Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones.
         * </p>
         * <p>
         * [Network Load Balancers] You can specify subnets from one or more Availability Zones. You can specify one
         * Elastic IP address per subnet if you need static IP addresses for your internet-facing load balancer. For
         * internal load balancers, you can specify one private IP address per subnet from the IPv4 range of the subnet.
         * For internet-facing load balancer, you can specify one IPv6 address per subnet.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SubnetMapping>.Builder} avoiding the need
         * to create one manually via {@link List<SubnetMapping>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SubnetMapping>.Builder#build()} is called immediately and
         * its result is passed to {@link #subnetMappings(List<SubnetMapping>)}.
         * 
         * @param subnetMappings
         *        a consumer that will call methods on {@link List<SubnetMapping>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subnetMappings(List<SubnetMapping>)
         */
        Builder subnetMappings(Consumer<SubnetMapping.Builder>... subnetMappings);

        /**
         * <p>
         * [Network Load Balancers] The type of IP addresses used by the subnets for your load balancer. The possible
         * values are <code>ipv4</code> (for IPv4 addresses) and <code>dualstack</code> (for IPv4 and IPv6 addresses).
         * You can’t specify <code>dualstack</code> for a load balancer with a UDP or TCP_UDP listener. Internal load
         * balancers must use <code>ipv4</code>.
         * </p>
         * 
         * @param ipAddressType
         *        [Network Load Balancers] The type of IP addresses used by the subnets for your load balancer. The
         *        possible values are <code>ipv4</code> (for IPv4 addresses) and <code>dualstack</code> (for IPv4 and
         *        IPv6 addresses). You can’t specify <code>dualstack</code> for a load balancer with a UDP or TCP_UDP
         *        listener. Internal load balancers must use <code>ipv4</code>.
         * @see IpAddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpAddressType
         */
        Builder ipAddressType(String ipAddressType);

        /**
         * <p>
         * [Network Load Balancers] The type of IP addresses used by the subnets for your load balancer. The possible
         * values are <code>ipv4</code> (for IPv4 addresses) and <code>dualstack</code> (for IPv4 and IPv6 addresses).
         * You can’t specify <code>dualstack</code> for a load balancer with a UDP or TCP_UDP listener. Internal load
         * balancers must use <code>ipv4</code>.
         * </p>
         * 
         * @param ipAddressType
         *        [Network Load Balancers] The type of IP addresses used by the subnets for your load balancer. The
         *        possible values are <code>ipv4</code> (for IPv4 addresses) and <code>dualstack</code> (for IPv4 and
         *        IPv6 addresses). You can’t specify <code>dualstack</code> for a load balancer with a UDP or TCP_UDP
         *        listener. Internal load balancers must use <code>ipv4</code>.
         * @see IpAddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpAddressType
         */
        Builder ipAddressType(IpAddressType ipAddressType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticLoadBalancingV2Request.BuilderImpl implements Builder {
        private String loadBalancerArn;

        private List<String> subnets = DefaultSdkAutoConstructList.getInstance();

        private List<SubnetMapping> subnetMappings = DefaultSdkAutoConstructList.getInstance();

        private String ipAddressType;

        private BuilderImpl() {
        }

        private BuilderImpl(SetSubnetsRequest model) {
            super(model);
            loadBalancerArn(model.loadBalancerArn);
            subnets(model.subnets);
            subnetMappings(model.subnetMappings);
            ipAddressType(model.ipAddressType);
        }

        public final String getLoadBalancerArn() {
            return loadBalancerArn;
        }

        public final void setLoadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
        }

        @Override
        @Transient
        public final Builder loadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
            return this;
        }

        public final Collection<String> getSubnets() {
            if (subnets instanceof SdkAutoConstructList) {
                return null;
            }
            return subnets;
        }

        public final void setSubnets(Collection<String> subnets) {
            this.subnets = SubnetsCopier.copy(subnets);
        }

        @Override
        @Transient
        public final Builder subnets(Collection<String> subnets) {
            this.subnets = SubnetsCopier.copy(subnets);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder subnets(String... subnets) {
            subnets(Arrays.asList(subnets));
            return this;
        }

        public final List<SubnetMapping.Builder> getSubnetMappings() {
            List<SubnetMapping.Builder> result = SubnetMappingsCopier.copyToBuilder(this.subnetMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubnetMappings(Collection<SubnetMapping.BuilderImpl> subnetMappings) {
            this.subnetMappings = SubnetMappingsCopier.copyFromBuilder(subnetMappings);
        }

        @Override
        @Transient
        public final Builder subnetMappings(Collection<SubnetMapping> subnetMappings) {
            this.subnetMappings = SubnetMappingsCopier.copy(subnetMappings);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder subnetMappings(SubnetMapping... subnetMappings) {
            subnetMappings(Arrays.asList(subnetMappings));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder subnetMappings(Consumer<SubnetMapping.Builder>... subnetMappings) {
            subnetMappings(Stream.of(subnetMappings).map(c -> SubnetMapping.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getIpAddressType() {
            return ipAddressType;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        @Override
        @Transient
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        @Override
        @Transient
        public final Builder ipAddressType(IpAddressType ipAddressType) {
            this.ipAddressType(ipAddressType == null ? null : ipAddressType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetSubnetsRequest build() {
            return new SetSubnetsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
