/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeLoadBalancerAttributesResponse extends ElasticLoadBalancingV2Response implements
        ToCopyableBuilder<DescribeLoadBalancerAttributesResponse.Builder, DescribeLoadBalancerAttributesResponse> {
    private static final SdkField<List<LoadBalancerAttribute>> ATTRIBUTES_FIELD = SdkField
            .<List<LoadBalancerAttribute>> builder(MarshallingType.LIST)
            .memberName("Attributes")
            .getter(getter(DescribeLoadBalancerAttributesResponse::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LoadBalancerAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(LoadBalancerAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTES_FIELD));

    private final List<LoadBalancerAttribute> attributes;

    private DescribeLoadBalancerAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.attributes = builder.attributes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attributes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the load balancer attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributes} method.
     * </p>
     * 
     * @return Information about the load balancer attributes.
     */
    public final List<LoadBalancerAttribute> attributes() {
        return attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLoadBalancerAttributesResponse)) {
            return false;
        }
        DescribeLoadBalancerAttributesResponse other = (DescribeLoadBalancerAttributesResponse) obj;
        return hasAttributes() == other.hasAttributes() && Objects.equals(attributes(), other.attributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeLoadBalancerAttributesResponse")
                .add("Attributes", hasAttributes() ? attributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLoadBalancerAttributesResponse, T> g) {
        return obj -> g.apply((DescribeLoadBalancerAttributesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticLoadBalancingV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeLoadBalancerAttributesResponse> {
        /**
         * <p>
         * Information about the load balancer attributes.
         * </p>
         * 
         * @param attributes
         *        Information about the load balancer attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Collection<LoadBalancerAttribute> attributes);

        /**
         * <p>
         * Information about the load balancer attributes.
         * </p>
         * 
         * @param attributes
         *        Information about the load balancer attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(LoadBalancerAttribute... attributes);

        /**
         * <p>
         * Information about the load balancer attributes.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LoadBalancerAttribute>.Builder} avoiding
         * the need to create one manually via {@link List<LoadBalancerAttribute>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LoadBalancerAttribute>.Builder#build()} is called
         * immediately and its result is passed to {@link #attributes(List<LoadBalancerAttribute>)}.
         * 
         * @param attributes
         *        a consumer that will call methods on {@link List<LoadBalancerAttribute>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributes(List<LoadBalancerAttribute>)
         */
        Builder attributes(Consumer<LoadBalancerAttribute.Builder>... attributes);
    }

    static final class BuilderImpl extends ElasticLoadBalancingV2Response.BuilderImpl implements Builder {
        private List<LoadBalancerAttribute> attributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLoadBalancerAttributesResponse model) {
            super(model);
            attributes(model.attributes);
        }

        public final List<LoadBalancerAttribute.Builder> getAttributes() {
            List<LoadBalancerAttribute.Builder> result = LoadBalancerAttributesCopier.copyToBuilder(this.attributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributes(Collection<LoadBalancerAttribute.BuilderImpl> attributes) {
            this.attributes = LoadBalancerAttributesCopier.copyFromBuilder(attributes);
        }

        @Override
        @Transient
        public final Builder attributes(Collection<LoadBalancerAttribute> attributes) {
            this.attributes = LoadBalancerAttributesCopier.copy(attributes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder attributes(LoadBalancerAttribute... attributes) {
            attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder attributes(Consumer<LoadBalancerAttribute.Builder>... attributes) {
            attributes(Stream.of(attributes).map(c -> LoadBalancerAttribute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeLoadBalancerAttributesResponse build() {
            return new DescribeLoadBalancerAttributesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
