/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum TargetHealthReasonEnum {
    ELB_REGISTRATION_IN_PROGRESS("Elb.RegistrationInProgress"),

    ELB_INITIAL_HEALTH_CHECKING("Elb.InitialHealthChecking"),

    TARGET_RESPONSE_CODE_MISMATCH("Target.ResponseCodeMismatch"),

    TARGET_TIMEOUT("Target.Timeout"),

    TARGET_FAILED_HEALTH_CHECKS("Target.FailedHealthChecks"),

    TARGET_NOT_REGISTERED("Target.NotRegistered"),

    TARGET_NOT_IN_USE("Target.NotInUse"),

    TARGET_DEREGISTRATION_IN_PROGRESS("Target.DeregistrationInProgress"),

    TARGET_INVALID_STATE("Target.InvalidState"),

    TARGET_IP_UNUSABLE("Target.IpUnusable"),

    TARGET_HEALTH_CHECK_DISABLED("Target.HealthCheckDisabled"),

    ELB_INTERNAL_ERROR("Elb.InternalError"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TargetHealthReasonEnum> VALUE_MAP = EnumUtils.uniqueIndex(TargetHealthReasonEnum.class,
            TargetHealthReasonEnum::toString);

    private final String value;

    private TargetHealthReasonEnum(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return TargetHealthReasonEnum corresponding to the value
     */
    public static TargetHealthReasonEnum fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link TargetHealthReasonEnum}s
     */
    public static Set<TargetHealthReasonEnum> knownValues() {
        Set<TargetHealthReasonEnum> knownValues = EnumSet.allOf(TargetHealthReasonEnum.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
