/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LoadBalancerStateEnum {
    ACTIVE("active"),
    PROVISIONING("provisioning"),
    ACTIVE_IMPAIRED("active_impaired"),
    FAILED("failed"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LoadBalancerStateEnum> VALUE_MAP;
    private final String value;

    private LoadBalancerStateEnum(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LoadBalancerStateEnum fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LoadBalancerStateEnum> knownValues() {
        EnumSet<LoadBalancerStateEnum> knownValues = EnumSet.allOf(LoadBalancerStateEnum.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LoadBalancerStateEnum.class, LoadBalancerStateEnum::toString);
    }
}

