/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the mutual authentication attributes of a listener.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MutualAuthenticationAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<MutualAuthenticationAttributes.Builder, MutualAuthenticationAttributes> {
    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Mode")
            .getter(getter(MutualAuthenticationAttributes::mode)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()).build();

    private static final SdkField<String> TRUST_STORE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrustStoreArn").getter(getter(MutualAuthenticationAttributes::trustStoreArn))
            .setter(setter(Builder::trustStoreArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustStoreArn").build()).build();

    private static final SdkField<Boolean> IGNORE_CLIENT_CERTIFICATE_EXPIRY_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IgnoreClientCertificateExpiry")
            .getter(getter(MutualAuthenticationAttributes::ignoreClientCertificateExpiry))
            .setter(setter(Builder::ignoreClientCertificateExpiry))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IgnoreClientCertificateExpiry")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODE_FIELD,
            TRUST_STORE_ARN_FIELD, IGNORE_CLIENT_CERTIFICATE_EXPIRY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String mode;

    private final String trustStoreArn;

    private final Boolean ignoreClientCertificateExpiry;

    private MutualAuthenticationAttributes(BuilderImpl builder) {
        this.mode = builder.mode;
        this.trustStoreArn = builder.trustStoreArn;
        this.ignoreClientCertificateExpiry = builder.ignoreClientCertificateExpiry;
    }

    /**
     * <p>
     * The client certificate handling method. Options are <code>off</code>, <code>passthrough</code> or
     * <code>verify</code>. The default value is <code>off</code>.
     * </p>
     * 
     * @return The client certificate handling method. Options are <code>off</code>, <code>passthrough</code> or
     *         <code>verify</code>. The default value is <code>off</code>.
     */
    public final String mode() {
        return mode;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the trust store.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the trust store.
     */
    public final String trustStoreArn() {
        return trustStoreArn;
    }

    /**
     * <p>
     * Indicates whether expired client certificates are ignored.
     * </p>
     * 
     * @return Indicates whether expired client certificates are ignored.
     */
    public final Boolean ignoreClientCertificateExpiry() {
        return ignoreClientCertificateExpiry;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mode());
        hashCode = 31 * hashCode + Objects.hashCode(trustStoreArn());
        hashCode = 31 * hashCode + Objects.hashCode(ignoreClientCertificateExpiry());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MutualAuthenticationAttributes)) {
            return false;
        }
        MutualAuthenticationAttributes other = (MutualAuthenticationAttributes) obj;
        return Objects.equals(mode(), other.mode()) && Objects.equals(trustStoreArn(), other.trustStoreArn())
                && Objects.equals(ignoreClientCertificateExpiry(), other.ignoreClientCertificateExpiry());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MutualAuthenticationAttributes").add("Mode", mode()).add("TrustStoreArn", trustStoreArn())
                .add("IgnoreClientCertificateExpiry", ignoreClientCertificateExpiry()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Mode":
            return Optional.ofNullable(clazz.cast(mode()));
        case "TrustStoreArn":
            return Optional.ofNullable(clazz.cast(trustStoreArn()));
        case "IgnoreClientCertificateExpiry":
            return Optional.ofNullable(clazz.cast(ignoreClientCertificateExpiry()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MutualAuthenticationAttributes, T> g) {
        return obj -> g.apply((MutualAuthenticationAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MutualAuthenticationAttributes> {
        /**
         * <p>
         * The client certificate handling method. Options are <code>off</code>, <code>passthrough</code> or
         * <code>verify</code>. The default value is <code>off</code>.
         * </p>
         * 
         * @param mode
         *        The client certificate handling method. Options are <code>off</code>, <code>passthrough</code> or
         *        <code>verify</code>. The default value is <code>off</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mode(String mode);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the trust store.
         * </p>
         * 
         * @param trustStoreArn
         *        The Amazon Resource Name (ARN) of the trust store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustStoreArn(String trustStoreArn);

        /**
         * <p>
         * Indicates whether expired client certificates are ignored.
         * </p>
         * 
         * @param ignoreClientCertificateExpiry
         *        Indicates whether expired client certificates are ignored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ignoreClientCertificateExpiry(Boolean ignoreClientCertificateExpiry);
    }

    static final class BuilderImpl implements Builder {
        private String mode;

        private String trustStoreArn;

        private Boolean ignoreClientCertificateExpiry;

        private BuilderImpl() {
        }

        private BuilderImpl(MutualAuthenticationAttributes model) {
            mode(model.mode);
            trustStoreArn(model.trustStoreArn);
            ignoreClientCertificateExpiry(model.ignoreClientCertificateExpiry);
        }

        public final String getMode() {
            return mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        public final String getTrustStoreArn() {
            return trustStoreArn;
        }

        public final void setTrustStoreArn(String trustStoreArn) {
            this.trustStoreArn = trustStoreArn;
        }

        @Override
        public final Builder trustStoreArn(String trustStoreArn) {
            this.trustStoreArn = trustStoreArn;
            return this;
        }

        public final Boolean getIgnoreClientCertificateExpiry() {
            return ignoreClientCertificateExpiry;
        }

        public final void setIgnoreClientCertificateExpiry(Boolean ignoreClientCertificateExpiry) {
            this.ignoreClientCertificateExpiry = ignoreClientCertificateExpiry;
        }

        @Override
        public final Builder ignoreClientCertificateExpiry(Boolean ignoreClientCertificateExpiry) {
            this.ignoreClientCertificateExpiry = ignoreClientCertificateExpiry;
            return this;
        }

        @Override
        public MutualAuthenticationAttributes build() {
            return new MutualAuthenticationAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
