/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a target group attribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TargetGroupAttribute implements SdkPojo, Serializable,
        ToCopyableBuilder<TargetGroupAttribute.Builder, TargetGroupAttribute> {
    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Key")
            .getter(getter(TargetGroupAttribute::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(TargetGroupAttribute::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String key;

    private final String value;

    private TargetGroupAttribute(BuilderImpl builder) {
        this.key = builder.key;
        this.value = builder.value;
    }

    /**
     * <p>
     * The name of the attribute.
     * </p>
     * <p>
     * The following attributes are supported by all load balancers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>deregistration_delay.timeout_seconds</code> - The amount of time, in seconds, for Elastic Load Balancing to
     * wait before changing the state of a deregistering target from <code>draining</code> to <code>unused</code>. The
     * range is 0-3600 seconds. The default value is 300 seconds. If the target is a Lambda function, this attribute is
     * not supported.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>stickiness.enabled</code> - Indicates whether target stickiness is enabled. The value is <code>true</code>
     * or <code>false</code>. The default is <code>false</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>stickiness.type</code> - Indicates the type of stickiness. The possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>lb_cookie</code> and <code>app_cookie</code> for Application Load Balancers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>source_ip</code> for Network Load Balancers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>source_ip_dest_ip</code> and <code>source_ip_dest_ip_proto</code> for Gateway Load Balancers.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * The following attributes are supported by Application Load Balancers and Network Load Balancers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>load_balancing.cross_zone.enabled</code> - Indicates whether cross zone load balancing is enabled. The
     * value is <code>true</code>, <code>false</code> or <code>use_load_balancer_configuration</code>. The default is
     * <code>use_load_balancer_configuration</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>target_group_health.dns_failover.minimum_healthy_targets.count</code> - The minimum number of targets that
     * must be healthy. If the number of healthy targets is below this value, mark the zone as unhealthy in DNS, so that
     * traffic is routed only to healthy zones. The possible values are <code>off</code> or an integer from 1 to the
     * maximum number of targets. The default is <code>off</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>target_group_health.dns_failover.minimum_healthy_targets.percentage</code> - The minimum percentage of
     * targets that must be healthy. If the percentage of healthy targets is below this value, mark the zone as
     * unhealthy in DNS, so that traffic is routed only to healthy zones. The possible values are <code>off</code> or an
     * integer from 1 to 100. The default is <code>off</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>target_group_health.unhealthy_state_routing.minimum_healthy_targets.count</code> - The minimum number of
     * targets that must be healthy. If the number of healthy targets is below this value, send traffic to all targets,
     * including unhealthy targets. The possible values are 1 to the maximum number of targets. The default is 1.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>target_group_health.unhealthy_state_routing.minimum_healthy_targets.percentage</code> - The minimum
     * percentage of targets that must be healthy. If the percentage of healthy targets is below this value, send
     * traffic to all targets, including unhealthy targets. The possible values are <code>off</code> or an integer from
     * 1 to 100. The default is <code>off</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following attributes are supported only if the load balancer is an Application Load Balancer and the target
     * is an instance or an IP address:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>load_balancing.algorithm.type</code> - The load balancing algorithm determines how the load balancer
     * selects targets when routing requests. The value is <code>round_robin</code>,
     * <code>least_outstanding_requests</code>, or <code>weighted_random</code>. The default is <code>round_robin</code>
     * .
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>load_balancing.algorithm.anomaly_mitigation</code> - Only available when
     * <code>load_balancing.algorithm.type</code> is <code>weighted_random</code>. Indicates whether anomaly mitigation
     * is enabled. The value is <code>on</code> or <code>off</code>. The default is <code>off</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>slow_start.duration_seconds</code> - The time period, in seconds, during which a newly registered target
     * receives an increasing share of the traffic to the target group. After this time period ends, the target receives
     * its full share of traffic. The range is 30-900 seconds (15 minutes). The default is 0 seconds (disabled).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>stickiness.app_cookie.cookie_name</code> - Indicates the name of the application-based cookie. Names that
     * start with the following prefixes are not allowed: <code>AWSALB</code>, <code>AWSALBAPP</code>, and
     * <code>AWSALBTG</code>; they're reserved for use by the load balancer.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>stickiness.app_cookie.duration_seconds</code> - The time period, in seconds, during which requests from a
     * client should be routed to the same target. After this time period expires, the application-based cookie is
     * considered stale. The range is 1 second to 1 week (604800 seconds). The default value is 1 day (86400 seconds).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>stickiness.lb_cookie.duration_seconds</code> - The time period, in seconds, during which requests from a
     * client should be routed to the same target. After this time period expires, the load balancer-generated cookie is
     * considered stale. The range is 1 second to 1 week (604800 seconds). The default value is 1 day (86400 seconds).
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following attribute is supported only if the load balancer is an Application Load Balancer and the target is
     * a Lambda function:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>lambda.multi_value_headers.enabled</code> - Indicates whether the request and response headers that are
     * exchanged between the load balancer and the Lambda function include arrays of values or strings. The value is
     * <code>true</code> or <code>false</code>. The default is <code>false</code>. If the value is <code>false</code>
     * and the request contains a duplicate header field name or query parameter key, the load balancer uses the last
     * value sent by the client.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following attributes are supported only by Network Load Balancers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>deregistration_delay.connection_termination.enabled</code> - Indicates whether the load balancer terminates
     * connections at the end of the deregistration timeout. The value is <code>true</code> or <code>false</code>. For
     * new UDP/TCP_UDP target groups the default is <code>true</code>. Otherwise, the default is <code>false</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>preserve_client_ip.enabled</code> - Indicates whether client IP preservation is enabled. The value is
     * <code>true</code> or <code>false</code>. The default is disabled if the target group type is IP address and the
     * target group protocol is TCP or TLS. Otherwise, the default is enabled. Client IP preservation cannot be disabled
     * for UDP and TCP_UDP target groups.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>proxy_protocol_v2.enabled</code> - Indicates whether Proxy Protocol version 2 is enabled. The value is
     * <code>true</code> or <code>false</code>. The default is <code>false</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>target_health_state.unhealthy.connection_termination.enabled</code> - Indicates whether the load balancer
     * terminates connections to unhealthy targets. The value is <code>true</code> or <code>false</code>. The default is
     * <code>true</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>target_health_state.unhealthy.draining_interval_seconds</code> - The amount of time for Elastic Load
     * Balancing to wait before changing the state of an unhealthy target from <code>unhealthy.draining</code> to
     * <code>unhealthy</code>. The range is 0-360000 seconds. The default value is 0 seconds.
     * </p>
     * <p>
     * Note: This attribute can only be configured when
     * <code>target_health_state.unhealthy.connection_termination.enabled</code> is <code>false</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following attributes are supported only by Gateway Load Balancers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>target_failover.on_deregistration</code> - Indicates how the Gateway Load Balancer handles existing flows
     * when a target is deregistered. The possible values are <code>rebalance</code> and <code>no_rebalance</code>. The
     * default is <code>no_rebalance</code>. The two attributes (<code>target_failover.on_deregistration</code> and
     * <code>target_failover.on_unhealthy</code>) can't be set independently. The value you set for both attributes must
     * be the same.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>target_failover.on_unhealthy</code> - Indicates how the Gateway Load Balancer handles existing flows when a
     * target is unhealthy. The possible values are <code>rebalance</code> and <code>no_rebalance</code>. The default is
     * <code>no_rebalance</code>. The two attributes (<code>target_failover.on_deregistration</code> and
     * <code>target_failover.on_unhealthy</code>) cannot be set independently. The value you set for both attributes
     * must be the same.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the attribute.</p>
     *         <p>
     *         The following attributes are supported by all load balancers:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>deregistration_delay.timeout_seconds</code> - The amount of time, in seconds, for Elastic Load
     *         Balancing to wait before changing the state of a deregistering target from <code>draining</code> to
     *         <code>unused</code>. The range is 0-3600 seconds. The default value is 300 seconds. If the target is a
     *         Lambda function, this attribute is not supported.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>stickiness.enabled</code> - Indicates whether target stickiness is enabled. The value is
     *         <code>true</code> or <code>false</code>. The default is <code>false</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>stickiness.type</code> - Indicates the type of stickiness. The possible values are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>lb_cookie</code> and <code>app_cookie</code> for Application Load Balancers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>source_ip</code> for Network Load Balancers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>source_ip_dest_ip</code> and <code>source_ip_dest_ip_proto</code> for Gateway Load Balancers.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         <p>
     *         The following attributes are supported by Application Load Balancers and Network Load Balancers:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>load_balancing.cross_zone.enabled</code> - Indicates whether cross zone load balancing is enabled.
     *         The value is <code>true</code>, <code>false</code> or <code>use_load_balancer_configuration</code>. The
     *         default is <code>use_load_balancer_configuration</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>target_group_health.dns_failover.minimum_healthy_targets.count</code> - The minimum number of
     *         targets that must be healthy. If the number of healthy targets is below this value, mark the zone as
     *         unhealthy in DNS, so that traffic is routed only to healthy zones. The possible values are
     *         <code>off</code> or an integer from 1 to the maximum number of targets. The default is <code>off</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>target_group_health.dns_failover.minimum_healthy_targets.percentage</code> - The minimum percentage
     *         of targets that must be healthy. If the percentage of healthy targets is below this value, mark the zone
     *         as unhealthy in DNS, so that traffic is routed only to healthy zones. The possible values are
     *         <code>off</code> or an integer from 1 to 100. The default is <code>off</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>target_group_health.unhealthy_state_routing.minimum_healthy_targets.count</code> - The minimum
     *         number of targets that must be healthy. If the number of healthy targets is below this value, send
     *         traffic to all targets, including unhealthy targets. The possible values are 1 to the maximum number of
     *         targets. The default is 1.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>target_group_health.unhealthy_state_routing.minimum_healthy_targets.percentage</code> - The minimum
     *         percentage of targets that must be healthy. If the percentage of healthy targets is below this value,
     *         send traffic to all targets, including unhealthy targets. The possible values are <code>off</code> or an
     *         integer from 1 to 100. The default is <code>off</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The following attributes are supported only if the load balancer is an Application Load Balancer and the
     *         target is an instance or an IP address:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>load_balancing.algorithm.type</code> - The load balancing algorithm determines how the load
     *         balancer selects targets when routing requests. The value is <code>round_robin</code>,
     *         <code>least_outstanding_requests</code>, or <code>weighted_random</code>. The default is
     *         <code>round_robin</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>load_balancing.algorithm.anomaly_mitigation</code> - Only available when
     *         <code>load_balancing.algorithm.type</code> is <code>weighted_random</code>. Indicates whether anomaly
     *         mitigation is enabled. The value is <code>on</code> or <code>off</code>. The default is <code>off</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>slow_start.duration_seconds</code> - The time period, in seconds, during which a newly registered
     *         target receives an increasing share of the traffic to the target group. After this time period ends, the
     *         target receives its full share of traffic. The range is 30-900 seconds (15 minutes). The default is 0
     *         seconds (disabled).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>stickiness.app_cookie.cookie_name</code> - Indicates the name of the application-based cookie.
     *         Names that start with the following prefixes are not allowed: <code>AWSALB</code>, <code>AWSALBAPP</code>
     *         , and <code>AWSALBTG</code>; they're reserved for use by the load balancer.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>stickiness.app_cookie.duration_seconds</code> - The time period, in seconds, during which requests
     *         from a client should be routed to the same target. After this time period expires, the application-based
     *         cookie is considered stale. The range is 1 second to 1 week (604800 seconds). The default value is 1 day
     *         (86400 seconds).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>stickiness.lb_cookie.duration_seconds</code> - The time period, in seconds, during which requests
     *         from a client should be routed to the same target. After this time period expires, the load
     *         balancer-generated cookie is considered stale. The range is 1 second to 1 week (604800 seconds). The
     *         default value is 1 day (86400 seconds).
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The following attribute is supported only if the load balancer is an Application Load Balancer and the
     *         target is a Lambda function:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>lambda.multi_value_headers.enabled</code> - Indicates whether the request and response headers that
     *         are exchanged between the load balancer and the Lambda function include arrays of values or strings. The
     *         value is <code>true</code> or <code>false</code>. The default is <code>false</code>. If the value is
     *         <code>false</code> and the request contains a duplicate header field name or query parameter key, the
     *         load balancer uses the last value sent by the client.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The following attributes are supported only by Network Load Balancers:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>deregistration_delay.connection_termination.enabled</code> - Indicates whether the load balancer
     *         terminates connections at the end of the deregistration timeout. The value is <code>true</code> or
     *         <code>false</code>. For new UDP/TCP_UDP target groups the default is <code>true</code>. Otherwise, the
     *         default is <code>false</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>preserve_client_ip.enabled</code> - Indicates whether client IP preservation is enabled. The value
     *         is <code>true</code> or <code>false</code>. The default is disabled if the target group type is IP
     *         address and the target group protocol is TCP or TLS. Otherwise, the default is enabled. Client IP
     *         preservation cannot be disabled for UDP and TCP_UDP target groups.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>proxy_protocol_v2.enabled</code> - Indicates whether Proxy Protocol version 2 is enabled. The value
     *         is <code>true</code> or <code>false</code>. The default is <code>false</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>target_health_state.unhealthy.connection_termination.enabled</code> - Indicates whether the load
     *         balancer terminates connections to unhealthy targets. The value is <code>true</code> or
     *         <code>false</code>. The default is <code>true</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>target_health_state.unhealthy.draining_interval_seconds</code> - The amount of time for Elastic
     *         Load Balancing to wait before changing the state of an unhealthy target from
     *         <code>unhealthy.draining</code> to <code>unhealthy</code>. The range is 0-360000 seconds. The default
     *         value is 0 seconds.
     *         </p>
     *         <p>
     *         Note: This attribute can only be configured when
     *         <code>target_health_state.unhealthy.connection_termination.enabled</code> is <code>false</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The following attributes are supported only by Gateway Load Balancers:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>target_failover.on_deregistration</code> - Indicates how the Gateway Load Balancer handles existing
     *         flows when a target is deregistered. The possible values are <code>rebalance</code> and
     *         <code>no_rebalance</code>. The default is <code>no_rebalance</code>. The two attributes (
     *         <code>target_failover.on_deregistration</code> and <code>target_failover.on_unhealthy</code>) can't be
     *         set independently. The value you set for both attributes must be the same.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>target_failover.on_unhealthy</code> - Indicates how the Gateway Load Balancer handles existing
     *         flows when a target is unhealthy. The possible values are <code>rebalance</code> and
     *         <code>no_rebalance</code>. The default is <code>no_rebalance</code>. The two attributes (
     *         <code>target_failover.on_deregistration</code> and <code>target_failover.on_unhealthy</code>) cannot be
     *         set independently. The value you set for both attributes must be the same.
     *         </p>
     *         </li>
     */
    public final String key() {
        return key;
    }

    /**
     * <p>
     * The value of the attribute.
     * </p>
     * 
     * @return The value of the attribute.
     */
    public final String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetGroupAttribute)) {
            return false;
        }
        TargetGroupAttribute other = (TargetGroupAttribute) obj;
        return Objects.equals(key(), other.key()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TargetGroupAttribute").add("Key", key()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TargetGroupAttribute, T> g) {
        return obj -> g.apply((TargetGroupAttribute) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TargetGroupAttribute> {
        /**
         * <p>
         * The name of the attribute.
         * </p>
         * <p>
         * The following attributes are supported by all load balancers:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>deregistration_delay.timeout_seconds</code> - The amount of time, in seconds, for Elastic Load
         * Balancing to wait before changing the state of a deregistering target from <code>draining</code> to
         * <code>unused</code>. The range is 0-3600 seconds. The default value is 300 seconds. If the target is a Lambda
         * function, this attribute is not supported.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>stickiness.enabled</code> - Indicates whether target stickiness is enabled. The value is
         * <code>true</code> or <code>false</code>. The default is <code>false</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>stickiness.type</code> - Indicates the type of stickiness. The possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>lb_cookie</code> and <code>app_cookie</code> for Application Load Balancers.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>source_ip</code> for Network Load Balancers.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>source_ip_dest_ip</code> and <code>source_ip_dest_ip_proto</code> for Gateway Load Balancers.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * <p>
         * The following attributes are supported by Application Load Balancers and Network Load Balancers:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>load_balancing.cross_zone.enabled</code> - Indicates whether cross zone load balancing is enabled. The
         * value is <code>true</code>, <code>false</code> or <code>use_load_balancer_configuration</code>. The default
         * is <code>use_load_balancer_configuration</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>target_group_health.dns_failover.minimum_healthy_targets.count</code> - The minimum number of targets
         * that must be healthy. If the number of healthy targets is below this value, mark the zone as unhealthy in
         * DNS, so that traffic is routed only to healthy zones. The possible values are <code>off</code> or an integer
         * from 1 to the maximum number of targets. The default is <code>off</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>target_group_health.dns_failover.minimum_healthy_targets.percentage</code> - The minimum percentage of
         * targets that must be healthy. If the percentage of healthy targets is below this value, mark the zone as
         * unhealthy in DNS, so that traffic is routed only to healthy zones. The possible values are <code>off</code>
         * or an integer from 1 to 100. The default is <code>off</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>target_group_health.unhealthy_state_routing.minimum_healthy_targets.count</code> - The minimum number
         * of targets that must be healthy. If the number of healthy targets is below this value, send traffic to all
         * targets, including unhealthy targets. The possible values are 1 to the maximum number of targets. The default
         * is 1.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>target_group_health.unhealthy_state_routing.minimum_healthy_targets.percentage</code> - The minimum
         * percentage of targets that must be healthy. If the percentage of healthy targets is below this value, send
         * traffic to all targets, including unhealthy targets. The possible values are <code>off</code> or an integer
         * from 1 to 100. The default is <code>off</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The following attributes are supported only if the load balancer is an Application Load Balancer and the
         * target is an instance or an IP address:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>load_balancing.algorithm.type</code> - The load balancing algorithm determines how the load balancer
         * selects targets when routing requests. The value is <code>round_robin</code>,
         * <code>least_outstanding_requests</code>, or <code>weighted_random</code>. The default is
         * <code>round_robin</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>load_balancing.algorithm.anomaly_mitigation</code> - Only available when
         * <code>load_balancing.algorithm.type</code> is <code>weighted_random</code>. Indicates whether anomaly
         * mitigation is enabled. The value is <code>on</code> or <code>off</code>. The default is <code>off</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>slow_start.duration_seconds</code> - The time period, in seconds, during which a newly registered
         * target receives an increasing share of the traffic to the target group. After this time period ends, the
         * target receives its full share of traffic. The range is 30-900 seconds (15 minutes). The default is 0 seconds
         * (disabled).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>stickiness.app_cookie.cookie_name</code> - Indicates the name of the application-based cookie. Names
         * that start with the following prefixes are not allowed: <code>AWSALB</code>, <code>AWSALBAPP</code>, and
         * <code>AWSALBTG</code>; they're reserved for use by the load balancer.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>stickiness.app_cookie.duration_seconds</code> - The time period, in seconds, during which requests from
         * a client should be routed to the same target. After this time period expires, the application-based cookie is
         * considered stale. The range is 1 second to 1 week (604800 seconds). The default value is 1 day (86400
         * seconds).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>stickiness.lb_cookie.duration_seconds</code> - The time period, in seconds, during which requests from
         * a client should be routed to the same target. After this time period expires, the load balancer-generated
         * cookie is considered stale. The range is 1 second to 1 week (604800 seconds). The default value is 1 day
         * (86400 seconds).
         * </p>
         * </li>
         * </ul>
         * <p>
         * The following attribute is supported only if the load balancer is an Application Load Balancer and the target
         * is a Lambda function:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>lambda.multi_value_headers.enabled</code> - Indicates whether the request and response headers that are
         * exchanged between the load balancer and the Lambda function include arrays of values or strings. The value is
         * <code>true</code> or <code>false</code>. The default is <code>false</code>. If the value is
         * <code>false</code> and the request contains a duplicate header field name or query parameter key, the load
         * balancer uses the last value sent by the client.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The following attributes are supported only by Network Load Balancers:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>deregistration_delay.connection_termination.enabled</code> - Indicates whether the load balancer
         * terminates connections at the end of the deregistration timeout. The value is <code>true</code> or
         * <code>false</code>. For new UDP/TCP_UDP target groups the default is <code>true</code>. Otherwise, the
         * default is <code>false</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>preserve_client_ip.enabled</code> - Indicates whether client IP preservation is enabled. The value is
         * <code>true</code> or <code>false</code>. The default is disabled if the target group type is IP address and
         * the target group protocol is TCP or TLS. Otherwise, the default is enabled. Client IP preservation cannot be
         * disabled for UDP and TCP_UDP target groups.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>proxy_protocol_v2.enabled</code> - Indicates whether Proxy Protocol version 2 is enabled. The value is
         * <code>true</code> or <code>false</code>. The default is <code>false</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>target_health_state.unhealthy.connection_termination.enabled</code> - Indicates whether the load
         * balancer terminates connections to unhealthy targets. The value is <code>true</code> or <code>false</code>.
         * The default is <code>true</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>target_health_state.unhealthy.draining_interval_seconds</code> - The amount of time for Elastic Load
         * Balancing to wait before changing the state of an unhealthy target from <code>unhealthy.draining</code> to
         * <code>unhealthy</code>. The range is 0-360000 seconds. The default value is 0 seconds.
         * </p>
         * <p>
         * Note: This attribute can only be configured when
         * <code>target_health_state.unhealthy.connection_termination.enabled</code> is <code>false</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The following attributes are supported only by Gateway Load Balancers:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>target_failover.on_deregistration</code> - Indicates how the Gateway Load Balancer handles existing
         * flows when a target is deregistered. The possible values are <code>rebalance</code> and
         * <code>no_rebalance</code>. The default is <code>no_rebalance</code>. The two attributes (
         * <code>target_failover.on_deregistration</code> and <code>target_failover.on_unhealthy</code>) can't be set
         * independently. The value you set for both attributes must be the same.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>target_failover.on_unhealthy</code> - Indicates how the Gateway Load Balancer handles existing flows
         * when a target is unhealthy. The possible values are <code>rebalance</code> and <code>no_rebalance</code>. The
         * default is <code>no_rebalance</code>. The two attributes (<code>target_failover.on_deregistration</code> and
         * <code>target_failover.on_unhealthy</code>) cannot be set independently. The value you set for both attributes
         * must be the same.
         * </p>
         * </li>
         * </ul>
         * 
         * @param key
         *        The name of the attribute.</p>
         *        <p>
         *        The following attributes are supported by all load balancers:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>deregistration_delay.timeout_seconds</code> - The amount of time, in seconds, for Elastic Load
         *        Balancing to wait before changing the state of a deregistering target from <code>draining</code> to
         *        <code>unused</code>. The range is 0-3600 seconds. The default value is 300 seconds. If the target is a
         *        Lambda function, this attribute is not supported.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>stickiness.enabled</code> - Indicates whether target stickiness is enabled. The value is
         *        <code>true</code> or <code>false</code>. The default is <code>false</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>stickiness.type</code> - Indicates the type of stickiness. The possible values are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>lb_cookie</code> and <code>app_cookie</code> for Application Load Balancers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>source_ip</code> for Network Load Balancers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>source_ip_dest_ip</code> and <code>source_ip_dest_ip_proto</code> for Gateway Load Balancers.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        <p>
         *        The following attributes are supported by Application Load Balancers and Network Load Balancers:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>load_balancing.cross_zone.enabled</code> - Indicates whether cross zone load balancing is
         *        enabled. The value is <code>true</code>, <code>false</code> or
         *        <code>use_load_balancer_configuration</code>. The default is
         *        <code>use_load_balancer_configuration</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>target_group_health.dns_failover.minimum_healthy_targets.count</code> - The minimum number of
         *        targets that must be healthy. If the number of healthy targets is below this value, mark the zone as
         *        unhealthy in DNS, so that traffic is routed only to healthy zones. The possible values are
         *        <code>off</code> or an integer from 1 to the maximum number of targets. The default is
         *        <code>off</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>target_group_health.dns_failover.minimum_healthy_targets.percentage</code> - The minimum
         *        percentage of targets that must be healthy. If the percentage of healthy targets is below this value,
         *        mark the zone as unhealthy in DNS, so that traffic is routed only to healthy zones. The possible
         *        values are <code>off</code> or an integer from 1 to 100. The default is <code>off</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>target_group_health.unhealthy_state_routing.minimum_healthy_targets.count</code> - The minimum
         *        number of targets that must be healthy. If the number of healthy targets is below this value, send
         *        traffic to all targets, including unhealthy targets. The possible values are 1 to the maximum number
         *        of targets. The default is 1.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>target_group_health.unhealthy_state_routing.minimum_healthy_targets.percentage</code> - The
         *        minimum percentage of targets that must be healthy. If the percentage of healthy targets is below this
         *        value, send traffic to all targets, including unhealthy targets. The possible values are
         *        <code>off</code> or an integer from 1 to 100. The default is <code>off</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The following attributes are supported only if the load balancer is an Application Load Balancer and
         *        the target is an instance or an IP address:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>load_balancing.algorithm.type</code> - The load balancing algorithm determines how the load
         *        balancer selects targets when routing requests. The value is <code>round_robin</code>,
         *        <code>least_outstanding_requests</code>, or <code>weighted_random</code>. The default is
         *        <code>round_robin</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>load_balancing.algorithm.anomaly_mitigation</code> - Only available when
         *        <code>load_balancing.algorithm.type</code> is <code>weighted_random</code>. Indicates whether anomaly
         *        mitigation is enabled. The value is <code>on</code> or <code>off</code>. The default is
         *        <code>off</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>slow_start.duration_seconds</code> - The time period, in seconds, during which a newly
         *        registered target receives an increasing share of the traffic to the target group. After this time
         *        period ends, the target receives its full share of traffic. The range is 30-900 seconds (15 minutes).
         *        The default is 0 seconds (disabled).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>stickiness.app_cookie.cookie_name</code> - Indicates the name of the application-based cookie.
         *        Names that start with the following prefixes are not allowed: <code>AWSALB</code>,
         *        <code>AWSALBAPP</code>, and <code>AWSALBTG</code>; they're reserved for use by the load balancer.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>stickiness.app_cookie.duration_seconds</code> - The time period, in seconds, during which
         *        requests from a client should be routed to the same target. After this time period expires, the
         *        application-based cookie is considered stale. The range is 1 second to 1 week (604800 seconds). The
         *        default value is 1 day (86400 seconds).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>stickiness.lb_cookie.duration_seconds</code> - The time period, in seconds, during which
         *        requests from a client should be routed to the same target. After this time period expires, the load
         *        balancer-generated cookie is considered stale. The range is 1 second to 1 week (604800 seconds). The
         *        default value is 1 day (86400 seconds).
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The following attribute is supported only if the load balancer is an Application Load Balancer and the
         *        target is a Lambda function:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>lambda.multi_value_headers.enabled</code> - Indicates whether the request and response headers
         *        that are exchanged between the load balancer and the Lambda function include arrays of values or
         *        strings. The value is <code>true</code> or <code>false</code>. The default is <code>false</code>. If
         *        the value is <code>false</code> and the request contains a duplicate header field name or query
         *        parameter key, the load balancer uses the last value sent by the client.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The following attributes are supported only by Network Load Balancers:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>deregistration_delay.connection_termination.enabled</code> - Indicates whether the load balancer
         *        terminates connections at the end of the deregistration timeout. The value is <code>true</code> or
         *        <code>false</code>. For new UDP/TCP_UDP target groups the default is <code>true</code>. Otherwise, the
         *        default is <code>false</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>preserve_client_ip.enabled</code> - Indicates whether client IP preservation is enabled. The
         *        value is <code>true</code> or <code>false</code>. The default is disabled if the target group type is
         *        IP address and the target group protocol is TCP or TLS. Otherwise, the default is enabled. Client IP
         *        preservation cannot be disabled for UDP and TCP_UDP target groups.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>proxy_protocol_v2.enabled</code> - Indicates whether Proxy Protocol version 2 is enabled. The
         *        value is <code>true</code> or <code>false</code>. The default is <code>false</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>target_health_state.unhealthy.connection_termination.enabled</code> - Indicates whether the load
         *        balancer terminates connections to unhealthy targets. The value is <code>true</code> or
         *        <code>false</code>. The default is <code>true</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>target_health_state.unhealthy.draining_interval_seconds</code> - The amount of time for Elastic
         *        Load Balancing to wait before changing the state of an unhealthy target from
         *        <code>unhealthy.draining</code> to <code>unhealthy</code>. The range is 0-360000 seconds. The default
         *        value is 0 seconds.
         *        </p>
         *        <p>
         *        Note: This attribute can only be configured when
         *        <code>target_health_state.unhealthy.connection_termination.enabled</code> is <code>false</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The following attributes are supported only by Gateway Load Balancers:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>target_failover.on_deregistration</code> - Indicates how the Gateway Load Balancer handles
         *        existing flows when a target is deregistered. The possible values are <code>rebalance</code> and
         *        <code>no_rebalance</code>. The default is <code>no_rebalance</code>. The two attributes (
         *        <code>target_failover.on_deregistration</code> and <code>target_failover.on_unhealthy</code>) can't be
         *        set independently. The value you set for both attributes must be the same.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>target_failover.on_unhealthy</code> - Indicates how the Gateway Load Balancer handles existing
         *        flows when a target is unhealthy. The possible values are <code>rebalance</code> and
         *        <code>no_rebalance</code>. The default is <code>no_rebalance</code>. The two attributes (
         *        <code>target_failover.on_deregistration</code> and <code>target_failover.on_unhealthy</code>) cannot
         *        be set independently. The value you set for both attributes must be the same.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * The value of the attribute.
         * </p>
         * 
         * @param value
         *        The value of the attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetGroupAttribute model) {
            key(model.key);
            value(model.value);
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public TargetGroupAttribute build() {
            return new TargetGroupAttribute(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
