/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.core.waiters.WaiterState;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.elasticloadbalancingv2.ElasticLoadBalancingV2Client;
import software.amazon.awssdk.services.elasticloadbalancingv2.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetHealthRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetHealthResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Request;
import software.amazon.awssdk.services.elasticloadbalancingv2.waiters.ElasticLoadBalancingV2Waiter;
import software.amazon.awssdk.services.elasticloadbalancingv2.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
@ThreadSafe
final class DefaultElasticLoadBalancingV2Waiter
implements ElasticLoadBalancingV2Waiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private final ElasticLoadBalancingV2Client client;
    private final AttributeMap managedResources;
    private final Waiter<DescribeLoadBalancersResponse> loadBalancerExistsWaiter;
    private final Waiter<DescribeLoadBalancersResponse> loadBalancerAvailableWaiter;
    private final Waiter<DescribeLoadBalancersResponse> loadBalancersDeletedWaiter;
    private final Waiter<DescribeTargetHealthResponse> targetInServiceWaiter;
    private final Waiter<DescribeTargetHealthResponse> targetDeregisteredWaiter;

    private DefaultElasticLoadBalancingV2Waiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (ElasticLoadBalancingV2Client)ElasticLoadBalancingV2Client.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        this.managedResources = attributeMapBuilder.build();
        this.loadBalancerExistsWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeLoadBalancersResponse.class).acceptors(DefaultElasticLoadBalancingV2Waiter.loadBalancerExistsWaiterAcceptors())).overrideConfiguration(DefaultElasticLoadBalancingV2Waiter.loadBalancerExistsWaiterConfig(builder.overrideConfiguration))).build();
        this.loadBalancerAvailableWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeLoadBalancersResponse.class).acceptors(DefaultElasticLoadBalancingV2Waiter.loadBalancerAvailableWaiterAcceptors())).overrideConfiguration(DefaultElasticLoadBalancingV2Waiter.loadBalancerAvailableWaiterConfig(builder.overrideConfiguration))).build();
        this.loadBalancersDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeLoadBalancersResponse.class).acceptors(DefaultElasticLoadBalancingV2Waiter.loadBalancersDeletedWaiterAcceptors())).overrideConfiguration(DefaultElasticLoadBalancingV2Waiter.loadBalancersDeletedWaiterConfig(builder.overrideConfiguration))).build();
        this.targetInServiceWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeTargetHealthResponse.class).acceptors(DefaultElasticLoadBalancingV2Waiter.targetInServiceWaiterAcceptors())).overrideConfiguration(DefaultElasticLoadBalancingV2Waiter.targetInServiceWaiterConfig(builder.overrideConfiguration))).build();
        this.targetDeregisteredWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeTargetHealthResponse.class).acceptors(DefaultElasticLoadBalancingV2Waiter.targetDeregisteredWaiterAcceptors())).overrideConfiguration(DefaultElasticLoadBalancingV2Waiter.targetDeregisteredWaiterConfig(builder.overrideConfiguration))).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<DescribeLoadBalancersResponse> waitUntilLoadBalancerAvailable(DescribeLoadBalancersRequest describeLoadBalancersRequest) {
        return this.loadBalancerAvailableWaiter.run(() -> this.client.describeLoadBalancers(this.applyWaitersUserAgent(describeLoadBalancersRequest)));
    }

    @Override
    public WaiterResponse<DescribeLoadBalancersResponse> waitUntilLoadBalancerAvailable(DescribeLoadBalancersRequest describeLoadBalancersRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.loadBalancerAvailableWaiter.run(() -> this.client.describeLoadBalancers(this.applyWaitersUserAgent(describeLoadBalancersRequest)), DefaultElasticLoadBalancingV2Waiter.loadBalancerAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeLoadBalancersResponse> waitUntilLoadBalancerExists(DescribeLoadBalancersRequest describeLoadBalancersRequest) {
        return this.loadBalancerExistsWaiter.run(() -> this.client.describeLoadBalancers(this.applyWaitersUserAgent(describeLoadBalancersRequest)));
    }

    @Override
    public WaiterResponse<DescribeLoadBalancersResponse> waitUntilLoadBalancerExists(DescribeLoadBalancersRequest describeLoadBalancersRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.loadBalancerExistsWaiter.run(() -> this.client.describeLoadBalancers(this.applyWaitersUserAgent(describeLoadBalancersRequest)), DefaultElasticLoadBalancingV2Waiter.loadBalancerExistsWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeLoadBalancersResponse> waitUntilLoadBalancersDeleted(DescribeLoadBalancersRequest describeLoadBalancersRequest) {
        return this.loadBalancersDeletedWaiter.run(() -> this.client.describeLoadBalancers(this.applyWaitersUserAgent(describeLoadBalancersRequest)));
    }

    @Override
    public WaiterResponse<DescribeLoadBalancersResponse> waitUntilLoadBalancersDeleted(DescribeLoadBalancersRequest describeLoadBalancersRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.loadBalancersDeletedWaiter.run(() -> this.client.describeLoadBalancers(this.applyWaitersUserAgent(describeLoadBalancersRequest)), DefaultElasticLoadBalancingV2Waiter.loadBalancersDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeTargetHealthResponse> waitUntilTargetDeregistered(DescribeTargetHealthRequest describeTargetHealthRequest) {
        return this.targetDeregisteredWaiter.run(() -> this.client.describeTargetHealth(this.applyWaitersUserAgent(describeTargetHealthRequest)));
    }

    @Override
    public WaiterResponse<DescribeTargetHealthResponse> waitUntilTargetDeregistered(DescribeTargetHealthRequest describeTargetHealthRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.targetDeregisteredWaiter.run(() -> this.client.describeTargetHealth(this.applyWaitersUserAgent(describeTargetHealthRequest)), DefaultElasticLoadBalancingV2Waiter.targetDeregisteredWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeTargetHealthResponse> waitUntilTargetInService(DescribeTargetHealthRequest describeTargetHealthRequest) {
        return this.targetInServiceWaiter.run(() -> this.client.describeTargetHealth(this.applyWaitersUserAgent(describeTargetHealthRequest)));
    }

    @Override
    public WaiterResponse<DescribeTargetHealthResponse> waitUntilTargetInService(DescribeTargetHealthRequest describeTargetHealthRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.targetInServiceWaiter.run(() -> this.client.describeTargetHealth(this.applyWaitersUserAgent(describeTargetHealthRequest)), DefaultElasticLoadBalancingV2Waiter.targetInServiceWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeLoadBalancersResponse>> loadBalancerExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeLoadBalancersResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeLoadBalancersResponse>>();
        result.add(new WaitersRuntime.ResponseStatusAcceptor(200, WaiterState.SUCCESS));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultElasticLoadBalancingV2Waiter.errorCode(error), "LoadBalancerNotFound")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeLoadBalancersResponse>> loadBalancerAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeLoadBalancersResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeLoadBalancersResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("LoadBalancers").flatten().field("State").field("Code").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "active"));
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("LoadBalancers").flatten().field("State").field("Code").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "provisioning"));
        }));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultElasticLoadBalancingV2Waiter.errorCode(error), "LoadBalancerNotFound")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeLoadBalancersResponse>> loadBalancersDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeLoadBalancersResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeLoadBalancersResponse>>();
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("LoadBalancers").flatten().field("State").field("Code").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "active"));
        }));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultElasticLoadBalancingV2Waiter.errorCode(error), "LoadBalancerNotFound")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeTargetHealthResponse>> targetInServiceWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeTargetHealthResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeTargetHealthResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("TargetHealthDescriptions").flatten().field("TargetHealth").field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "healthy"));
        }));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultElasticLoadBalancingV2Waiter.errorCode(error), "InvalidInstance")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeTargetHealthResponse>> targetDeregisteredWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeTargetHealthResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeTargetHealthResponse>>();
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultElasticLoadBalancingV2Waiter.errorCode(error), "InvalidTarget")));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("TargetHealthDescriptions").flatten().field("TargetHealth").field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "unused"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration loadBalancerExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration loadBalancerAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration loadBalancersDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration targetInServiceWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration targetDeregisteredWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static ElasticLoadBalancingV2Waiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends ElasticLoadBalancingV2Request> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((ElasticLoadBalancingV2Request)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements ElasticLoadBalancingV2Waiter.Builder {
        private ElasticLoadBalancingV2Client client;
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public ElasticLoadBalancingV2Waiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public ElasticLoadBalancingV2Waiter.Builder client(ElasticLoadBalancingV2Client client) {
            this.client = client;
            return this;
        }

        @Override
        public ElasticLoadBalancingV2Waiter build() {
            return new DefaultElasticLoadBalancingV2Waiter(this);
        }
    }
}

