/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Action implements SdkPojo, Serializable, ToCopyableBuilder<Action.Builder, Action> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Action::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> TARGET_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Action::targetGroupArn)).setter(setter(Builder::targetGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetGroupArn").build()).build();

    private static final SdkField<AuthenticateOidcActionConfig> AUTHENTICATE_OIDC_CONFIG_FIELD = SdkField
            .<AuthenticateOidcActionConfig> builder(MarshallingType.SDK_POJO).getter(getter(Action::authenticateOidcConfig))
            .setter(setter(Builder::authenticateOidcConfig)).constructor(AuthenticateOidcActionConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticateOidcConfig").build())
            .build();

    private static final SdkField<AuthenticateCognitoActionConfig> AUTHENTICATE_COGNITO_CONFIG_FIELD = SdkField
            .<AuthenticateCognitoActionConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(Action::authenticateCognitoConfig)).setter(setter(Builder::authenticateCognitoConfig))
            .constructor(AuthenticateCognitoActionConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticateCognitoConfig").build())
            .build();

    private static final SdkField<Integer> ORDER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Action::order)).setter(setter(Builder::order))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Order").build()).build();

    private static final SdkField<RedirectActionConfig> REDIRECT_CONFIG_FIELD = SdkField
            .<RedirectActionConfig> builder(MarshallingType.SDK_POJO).getter(getter(Action::redirectConfig))
            .setter(setter(Builder::redirectConfig)).constructor(RedirectActionConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedirectConfig").build()).build();

    private static final SdkField<FixedResponseActionConfig> FIXED_RESPONSE_CONFIG_FIELD = SdkField
            .<FixedResponseActionConfig> builder(MarshallingType.SDK_POJO).getter(getter(Action::fixedResponseConfig))
            .setter(setter(Builder::fixedResponseConfig)).constructor(FixedResponseActionConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FixedResponseConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            TARGET_GROUP_ARN_FIELD, AUTHENTICATE_OIDC_CONFIG_FIELD, AUTHENTICATE_COGNITO_CONFIG_FIELD, ORDER_FIELD,
            REDIRECT_CONFIG_FIELD, FIXED_RESPONSE_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String targetGroupArn;

    private final AuthenticateOidcActionConfig authenticateOidcConfig;

    private final AuthenticateCognitoActionConfig authenticateCognitoConfig;

    private final Integer order;

    private final RedirectActionConfig redirectConfig;

    private final FixedResponseActionConfig fixedResponseConfig;

    private Action(BuilderImpl builder) {
        this.type = builder.type;
        this.targetGroupArn = builder.targetGroupArn;
        this.authenticateOidcConfig = builder.authenticateOidcConfig;
        this.authenticateCognitoConfig = builder.authenticateCognitoConfig;
        this.order = builder.order;
        this.redirectConfig = builder.redirectConfig;
        this.fixedResponseConfig = builder.fixedResponseConfig;
    }

    /**
     * <p>
     * The type of action. Each rule must include exactly one of the following types of actions: <code>forward</code>,
     * <code>fixed-response</code>, or <code>redirect</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ActionTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of action. Each rule must include exactly one of the following types of actions:
     *         <code>forward</code>, <code>fixed-response</code>, or <code>redirect</code>.
     * @see ActionTypeEnum
     */
    public ActionTypeEnum type() {
        return ActionTypeEnum.fromValue(type);
    }

    /**
     * <p>
     * The type of action. Each rule must include exactly one of the following types of actions: <code>forward</code>,
     * <code>fixed-response</code>, or <code>redirect</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ActionTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of action. Each rule must include exactly one of the following types of actions:
     *         <code>forward</code>, <code>fixed-response</code>, or <code>redirect</code>.
     * @see ActionTypeEnum
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the target group. Specify only when <code>Type</code> is <code>forward</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the target group. Specify only when <code>Type</code> is
     *         <code>forward</code>.
     */
    public String targetGroupArn() {
        return targetGroupArn;
    }

    /**
     * <p>
     * [HTTPS listener] Information about an identity provider that is compliant with OpenID Connect (OIDC). Specify
     * only when <code>Type</code> is <code>authenticate-oidc</code>.
     * </p>
     * 
     * @return [HTTPS listener] Information about an identity provider that is compliant with OpenID Connect (OIDC).
     *         Specify only when <code>Type</code> is <code>authenticate-oidc</code>.
     */
    public AuthenticateOidcActionConfig authenticateOidcConfig() {
        return authenticateOidcConfig;
    }

    /**
     * <p>
     * [HTTPS listener] Information for using Amazon Cognito to authenticate users. Specify only when <code>Type</code>
     * is <code>authenticate-cognito</code>.
     * </p>
     * 
     * @return [HTTPS listener] Information for using Amazon Cognito to authenticate users. Specify only when
     *         <code>Type</code> is <code>authenticate-cognito</code>.
     */
    public AuthenticateCognitoActionConfig authenticateCognitoConfig() {
        return authenticateCognitoConfig;
    }

    /**
     * <p>
     * The order for the action. This value is required for rules with multiple actions. The action with the lowest
     * value for order is performed first. The final action to be performed must be a <code>forward</code> or a
     * <code>fixed-response</code> action.
     * </p>
     * 
     * @return The order for the action. This value is required for rules with multiple actions. The action with the
     *         lowest value for order is performed first. The final action to be performed must be a
     *         <code>forward</code> or a <code>fixed-response</code> action.
     */
    public Integer order() {
        return order;
    }

    /**
     * <p>
     * [Application Load Balancer] Information for creating a redirect action. Specify only when <code>Type</code> is
     * <code>redirect</code>.
     * </p>
     * 
     * @return [Application Load Balancer] Information for creating a redirect action. Specify only when
     *         <code>Type</code> is <code>redirect</code>.
     */
    public RedirectActionConfig redirectConfig() {
        return redirectConfig;
    }

    /**
     * <p>
     * [Application Load Balancer] Information for creating an action that returns a custom HTTP response. Specify only
     * when <code>Type</code> is <code>fixed-response</code>.
     * </p>
     * 
     * @return [Application Load Balancer] Information for creating an action that returns a custom HTTP response.
     *         Specify only when <code>Type</code> is <code>fixed-response</code>.
     */
    public FixedResponseActionConfig fixedResponseConfig() {
        return fixedResponseConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(authenticateOidcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(authenticateCognitoConfig());
        hashCode = 31 * hashCode + Objects.hashCode(order());
        hashCode = 31 * hashCode + Objects.hashCode(redirectConfig());
        hashCode = 31 * hashCode + Objects.hashCode(fixedResponseConfig());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Action)) {
            return false;
        }
        Action other = (Action) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(targetGroupArn(), other.targetGroupArn())
                && Objects.equals(authenticateOidcConfig(), other.authenticateOidcConfig())
                && Objects.equals(authenticateCognitoConfig(), other.authenticateCognitoConfig())
                && Objects.equals(order(), other.order()) && Objects.equals(redirectConfig(), other.redirectConfig())
                && Objects.equals(fixedResponseConfig(), other.fixedResponseConfig());
    }

    @Override
    public String toString() {
        return ToString.builder("Action").add("Type", typeAsString()).add("TargetGroupArn", targetGroupArn())
                .add("AuthenticateOidcConfig", authenticateOidcConfig())
                .add("AuthenticateCognitoConfig", authenticateCognitoConfig()).add("Order", order())
                .add("RedirectConfig", redirectConfig()).add("FixedResponseConfig", fixedResponseConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "TargetGroupArn":
            return Optional.ofNullable(clazz.cast(targetGroupArn()));
        case "AuthenticateOidcConfig":
            return Optional.ofNullable(clazz.cast(authenticateOidcConfig()));
        case "AuthenticateCognitoConfig":
            return Optional.ofNullable(clazz.cast(authenticateCognitoConfig()));
        case "Order":
            return Optional.ofNullable(clazz.cast(order()));
        case "RedirectConfig":
            return Optional.ofNullable(clazz.cast(redirectConfig()));
        case "FixedResponseConfig":
            return Optional.ofNullable(clazz.cast(fixedResponseConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Action, T> g) {
        return obj -> g.apply((Action) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Action> {
        /**
         * <p>
         * The type of action. Each rule must include exactly one of the following types of actions:
         * <code>forward</code>, <code>fixed-response</code>, or <code>redirect</code>.
         * </p>
         * 
         * @param type
         *        The type of action. Each rule must include exactly one of the following types of actions:
         *        <code>forward</code>, <code>fixed-response</code>, or <code>redirect</code>.
         * @see ActionTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionTypeEnum
         */
        Builder type(String type);

        /**
         * <p>
         * The type of action. Each rule must include exactly one of the following types of actions:
         * <code>forward</code>, <code>fixed-response</code>, or <code>redirect</code>.
         * </p>
         * 
         * @param type
         *        The type of action. Each rule must include exactly one of the following types of actions:
         *        <code>forward</code>, <code>fixed-response</code>, or <code>redirect</code>.
         * @see ActionTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionTypeEnum
         */
        Builder type(ActionTypeEnum type);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the target group. Specify only when <code>Type</code> is
         * <code>forward</code>.
         * </p>
         * 
         * @param targetGroupArn
         *        The Amazon Resource Name (ARN) of the target group. Specify only when <code>Type</code> is
         *        <code>forward</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetGroupArn(String targetGroupArn);

        /**
         * <p>
         * [HTTPS listener] Information about an identity provider that is compliant with OpenID Connect (OIDC). Specify
         * only when <code>Type</code> is <code>authenticate-oidc</code>.
         * </p>
         * 
         * @param authenticateOidcConfig
         *        [HTTPS listener] Information about an identity provider that is compliant with OpenID Connect (OIDC).
         *        Specify only when <code>Type</code> is <code>authenticate-oidc</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticateOidcConfig(AuthenticateOidcActionConfig authenticateOidcConfig);

        /**
         * <p>
         * [HTTPS listener] Information about an identity provider that is compliant with OpenID Connect (OIDC). Specify
         * only when <code>Type</code> is <code>authenticate-oidc</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link AuthenticateOidcActionConfig.Builder} avoiding
         * the need to create one manually via {@link AuthenticateOidcActionConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link AuthenticateOidcActionConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #authenticateOidcConfig(AuthenticateOidcActionConfig)}.
         * 
         * @param authenticateOidcConfig
         *        a consumer that will call methods on {@link AuthenticateOidcActionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authenticateOidcConfig(AuthenticateOidcActionConfig)
         */
        default Builder authenticateOidcConfig(Consumer<AuthenticateOidcActionConfig.Builder> authenticateOidcConfig) {
            return authenticateOidcConfig(AuthenticateOidcActionConfig.builder().applyMutation(authenticateOidcConfig).build());
        }

        /**
         * <p>
         * [HTTPS listener] Information for using Amazon Cognito to authenticate users. Specify only when
         * <code>Type</code> is <code>authenticate-cognito</code>.
         * </p>
         * 
         * @param authenticateCognitoConfig
         *        [HTTPS listener] Information for using Amazon Cognito to authenticate users. Specify only when
         *        <code>Type</code> is <code>authenticate-cognito</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticateCognitoConfig(AuthenticateCognitoActionConfig authenticateCognitoConfig);

        /**
         * <p>
         * [HTTPS listener] Information for using Amazon Cognito to authenticate users. Specify only when
         * <code>Type</code> is <code>authenticate-cognito</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link AuthenticateCognitoActionConfig.Builder}
         * avoiding the need to create one manually via {@link AuthenticateCognitoActionConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link AuthenticateCognitoActionConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #authenticateCognitoConfig(AuthenticateCognitoActionConfig)}.
         * 
         * @param authenticateCognitoConfig
         *        a consumer that will call methods on {@link AuthenticateCognitoActionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authenticateCognitoConfig(AuthenticateCognitoActionConfig)
         */
        default Builder authenticateCognitoConfig(Consumer<AuthenticateCognitoActionConfig.Builder> authenticateCognitoConfig) {
            return authenticateCognitoConfig(AuthenticateCognitoActionConfig.builder().applyMutation(authenticateCognitoConfig)
                    .build());
        }

        /**
         * <p>
         * The order for the action. This value is required for rules with multiple actions. The action with the lowest
         * value for order is performed first. The final action to be performed must be a <code>forward</code> or a
         * <code>fixed-response</code> action.
         * </p>
         * 
         * @param order
         *        The order for the action. This value is required for rules with multiple actions. The action with the
         *        lowest value for order is performed first. The final action to be performed must be a
         *        <code>forward</code> or a <code>fixed-response</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder order(Integer order);

        /**
         * <p>
         * [Application Load Balancer] Information for creating a redirect action. Specify only when <code>Type</code>
         * is <code>redirect</code>.
         * </p>
         * 
         * @param redirectConfig
         *        [Application Load Balancer] Information for creating a redirect action. Specify only when
         *        <code>Type</code> is <code>redirect</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redirectConfig(RedirectActionConfig redirectConfig);

        /**
         * <p>
         * [Application Load Balancer] Information for creating a redirect action. Specify only when <code>Type</code>
         * is <code>redirect</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link RedirectActionConfig.Builder} avoiding the need
         * to create one manually via {@link RedirectActionConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link RedirectActionConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #redirectConfig(RedirectActionConfig)}.
         * 
         * @param redirectConfig
         *        a consumer that will call methods on {@link RedirectActionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #redirectConfig(RedirectActionConfig)
         */
        default Builder redirectConfig(Consumer<RedirectActionConfig.Builder> redirectConfig) {
            return redirectConfig(RedirectActionConfig.builder().applyMutation(redirectConfig).build());
        }

        /**
         * <p>
         * [Application Load Balancer] Information for creating an action that returns a custom HTTP response. Specify
         * only when <code>Type</code> is <code>fixed-response</code>.
         * </p>
         * 
         * @param fixedResponseConfig
         *        [Application Load Balancer] Information for creating an action that returns a custom HTTP response.
         *        Specify only when <code>Type</code> is <code>fixed-response</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fixedResponseConfig(FixedResponseActionConfig fixedResponseConfig);

        /**
         * <p>
         * [Application Load Balancer] Information for creating an action that returns a custom HTTP response. Specify
         * only when <code>Type</code> is <code>fixed-response</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link FixedResponseActionConfig.Builder} avoiding the
         * need to create one manually via {@link FixedResponseActionConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link FixedResponseActionConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #fixedResponseConfig(FixedResponseActionConfig)}.
         * 
         * @param fixedResponseConfig
         *        a consumer that will call methods on {@link FixedResponseActionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fixedResponseConfig(FixedResponseActionConfig)
         */
        default Builder fixedResponseConfig(Consumer<FixedResponseActionConfig.Builder> fixedResponseConfig) {
            return fixedResponseConfig(FixedResponseActionConfig.builder().applyMutation(fixedResponseConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String targetGroupArn;

        private AuthenticateOidcActionConfig authenticateOidcConfig;

        private AuthenticateCognitoActionConfig authenticateCognitoConfig;

        private Integer order;

        private RedirectActionConfig redirectConfig;

        private FixedResponseActionConfig fixedResponseConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(Action model) {
            type(model.type);
            targetGroupArn(model.targetGroupArn);
            authenticateOidcConfig(model.authenticateOidcConfig);
            authenticateCognitoConfig(model.authenticateCognitoConfig);
            order(model.order);
            redirectConfig(model.redirectConfig);
            fixedResponseConfig(model.fixedResponseConfig);
        }

        public final String getTypeAsString() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ActionTypeEnum type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getTargetGroupArn() {
            return targetGroupArn;
        }

        @Override
        public final Builder targetGroupArn(String targetGroupArn) {
            this.targetGroupArn = targetGroupArn;
            return this;
        }

        public final void setTargetGroupArn(String targetGroupArn) {
            this.targetGroupArn = targetGroupArn;
        }

        public final AuthenticateOidcActionConfig.Builder getAuthenticateOidcConfig() {
            return authenticateOidcConfig != null ? authenticateOidcConfig.toBuilder() : null;
        }

        @Override
        public final Builder authenticateOidcConfig(AuthenticateOidcActionConfig authenticateOidcConfig) {
            this.authenticateOidcConfig = authenticateOidcConfig;
            return this;
        }

        public final void setAuthenticateOidcConfig(AuthenticateOidcActionConfig.BuilderImpl authenticateOidcConfig) {
            this.authenticateOidcConfig = authenticateOidcConfig != null ? authenticateOidcConfig.build() : null;
        }

        public final AuthenticateCognitoActionConfig.Builder getAuthenticateCognitoConfig() {
            return authenticateCognitoConfig != null ? authenticateCognitoConfig.toBuilder() : null;
        }

        @Override
        public final Builder authenticateCognitoConfig(AuthenticateCognitoActionConfig authenticateCognitoConfig) {
            this.authenticateCognitoConfig = authenticateCognitoConfig;
            return this;
        }

        public final void setAuthenticateCognitoConfig(AuthenticateCognitoActionConfig.BuilderImpl authenticateCognitoConfig) {
            this.authenticateCognitoConfig = authenticateCognitoConfig != null ? authenticateCognitoConfig.build() : null;
        }

        public final Integer getOrder() {
            return order;
        }

        @Override
        public final Builder order(Integer order) {
            this.order = order;
            return this;
        }

        public final void setOrder(Integer order) {
            this.order = order;
        }

        public final RedirectActionConfig.Builder getRedirectConfig() {
            return redirectConfig != null ? redirectConfig.toBuilder() : null;
        }

        @Override
        public final Builder redirectConfig(RedirectActionConfig redirectConfig) {
            this.redirectConfig = redirectConfig;
            return this;
        }

        public final void setRedirectConfig(RedirectActionConfig.BuilderImpl redirectConfig) {
            this.redirectConfig = redirectConfig != null ? redirectConfig.build() : null;
        }

        public final FixedResponseActionConfig.Builder getFixedResponseConfig() {
            return fixedResponseConfig != null ? fixedResponseConfig.toBuilder() : null;
        }

        @Override
        public final Builder fixedResponseConfig(FixedResponseActionConfig fixedResponseConfig) {
            this.fixedResponseConfig = fixedResponseConfig;
            return this;
        }

        public final void setFixedResponseConfig(FixedResponseActionConfig.BuilderImpl fixedResponseConfig) {
            this.fixedResponseConfig = fixedResponseConfig != null ? fixedResponseConfig.build() : null;
        }

        @Override
        public Action build() {
            return new Action(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
