/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Request parameters to use when integrating with Amazon Cognito to authenticate users.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuthenticateCognitoActionConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<AuthenticateCognitoActionConfig.Builder, AuthenticateCognitoActionConfig> {
    private static final SdkField<String> USER_POOL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AuthenticateCognitoActionConfig::userPoolArn)).setter(setter(Builder::userPoolArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolArn").build()).build();

    private static final SdkField<String> USER_POOL_CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AuthenticateCognitoActionConfig::userPoolClientId)).setter(setter(Builder::userPoolClientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolClientId").build()).build();

    private static final SdkField<String> USER_POOL_DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AuthenticateCognitoActionConfig::userPoolDomain)).setter(setter(Builder::userPoolDomain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolDomain").build()).build();

    private static final SdkField<String> SESSION_COOKIE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AuthenticateCognitoActionConfig::sessionCookieName)).setter(setter(Builder::sessionCookieName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionCookieName").build()).build();

    private static final SdkField<String> SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AuthenticateCognitoActionConfig::scope)).setter(setter(Builder::scope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build()).build();

    private static final SdkField<Long> SESSION_TIMEOUT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(AuthenticateCognitoActionConfig::sessionTimeout)).setter(setter(Builder::sessionTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionTimeout").build()).build();

    private static final SdkField<Map<String, String>> AUTHENTICATION_REQUEST_EXTRA_PARAMS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(AuthenticateCognitoActionConfig::authenticationRequestExtraParams))
            .setter(setter(Builder::authenticationRequestExtraParams))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationRequestExtraParams")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> ON_UNAUTHENTICATED_REQUEST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AuthenticateCognitoActionConfig::onUnauthenticatedRequestAsString))
            .setter(setter(Builder::onUnauthenticatedRequest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnUnauthenticatedRequest").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ARN_FIELD,
            USER_POOL_CLIENT_ID_FIELD, USER_POOL_DOMAIN_FIELD, SESSION_COOKIE_NAME_FIELD, SCOPE_FIELD, SESSION_TIMEOUT_FIELD,
            AUTHENTICATION_REQUEST_EXTRA_PARAMS_FIELD, ON_UNAUTHENTICATED_REQUEST_FIELD));

    private static final long serialVersionUID = 1L;

    private final String userPoolArn;

    private final String userPoolClientId;

    private final String userPoolDomain;

    private final String sessionCookieName;

    private final String scope;

    private final Long sessionTimeout;

    private final Map<String, String> authenticationRequestExtraParams;

    private final String onUnauthenticatedRequest;

    private AuthenticateCognitoActionConfig(BuilderImpl builder) {
        this.userPoolArn = builder.userPoolArn;
        this.userPoolClientId = builder.userPoolClientId;
        this.userPoolDomain = builder.userPoolDomain;
        this.sessionCookieName = builder.sessionCookieName;
        this.scope = builder.scope;
        this.sessionTimeout = builder.sessionTimeout;
        this.authenticationRequestExtraParams = builder.authenticationRequestExtraParams;
        this.onUnauthenticatedRequest = builder.onUnauthenticatedRequest;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Cognito user pool.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Cognito user pool.
     */
    public String userPoolArn() {
        return userPoolArn;
    }

    /**
     * <p>
     * The ID of the Amazon Cognito user pool client.
     * </p>
     * 
     * @return The ID of the Amazon Cognito user pool client.
     */
    public String userPoolClientId() {
        return userPoolClientId;
    }

    /**
     * <p>
     * The domain prefix or fully-qualified domain name of the Amazon Cognito user pool.
     * </p>
     * 
     * @return The domain prefix or fully-qualified domain name of the Amazon Cognito user pool.
     */
    public String userPoolDomain() {
        return userPoolDomain;
    }

    /**
     * <p>
     * The name of the cookie used to maintain session information. The default is AWSELBAuthSessionCookie.
     * </p>
     * 
     * @return The name of the cookie used to maintain session information. The default is AWSELBAuthSessionCookie.
     */
    public String sessionCookieName() {
        return sessionCookieName;
    }

    /**
     * <p>
     * The set of user claims to be requested from the IdP. The default is <code>openid</code>.
     * </p>
     * <p>
     * To verify which scope values your IdP supports and how to separate multiple values, see the documentation for
     * your IdP.
     * </p>
     * 
     * @return The set of user claims to be requested from the IdP. The default is <code>openid</code>.</p>
     *         <p>
     *         To verify which scope values your IdP supports and how to separate multiple values, see the documentation
     *         for your IdP.
     */
    public String scope() {
        return scope;
    }

    /**
     * <p>
     * The maximum duration of the authentication session, in seconds. The default is 604800 seconds (7 days).
     * </p>
     * 
     * @return The maximum duration of the authentication session, in seconds. The default is 604800 seconds (7 days).
     */
    public Long sessionTimeout() {
        return sessionTimeout;
    }

    /**
     * <p>
     * The query parameters (up to 10) to include in the redirect request to the authorization endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The query parameters (up to 10) to include in the redirect request to the authorization endpoint.
     */
    public Map<String, String> authenticationRequestExtraParams() {
        return authenticationRequestExtraParams;
    }

    /**
     * <p>
     * The behavior if the user is not authenticated. The following are possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * deny<code/> - Return an HTTP 401 Unauthorized error.
     * </p>
     * </li>
     * <li>
     * <p>
     * allow<code/> - Allow the request to be forwarded to the target.
     * </p>
     * </li>
     * <li>
     * <p>
     * authenticate<code/> - Redirect the request to the IdP authorization endpoint. This is the default value.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #onUnauthenticatedRequest} will return
     * {@link AuthenticateCognitoActionConditionalBehaviorEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #onUnauthenticatedRequestAsString}.
     * </p>
     * 
     * @return The behavior if the user is not authenticated. The following are possible values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         deny<code/> - Return an HTTP 401 Unauthorized error.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         allow<code/> - Allow the request to be forwarded to the target.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         authenticate<code/> - Redirect the request to the IdP authorization endpoint. This is the default value.
     *         </p>
     *         </li>
     * @see AuthenticateCognitoActionConditionalBehaviorEnum
     */
    public AuthenticateCognitoActionConditionalBehaviorEnum onUnauthenticatedRequest() {
        return AuthenticateCognitoActionConditionalBehaviorEnum.fromValue(onUnauthenticatedRequest);
    }

    /**
     * <p>
     * The behavior if the user is not authenticated. The following are possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * deny<code/> - Return an HTTP 401 Unauthorized error.
     * </p>
     * </li>
     * <li>
     * <p>
     * allow<code/> - Allow the request to be forwarded to the target.
     * </p>
     * </li>
     * <li>
     * <p>
     * authenticate<code/> - Redirect the request to the IdP authorization endpoint. This is the default value.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #onUnauthenticatedRequest} will return
     * {@link AuthenticateCognitoActionConditionalBehaviorEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #onUnauthenticatedRequestAsString}.
     * </p>
     * 
     * @return The behavior if the user is not authenticated. The following are possible values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         deny<code/> - Return an HTTP 401 Unauthorized error.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         allow<code/> - Allow the request to be forwarded to the target.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         authenticate<code/> - Redirect the request to the IdP authorization endpoint. This is the default value.
     *         </p>
     *         </li>
     * @see AuthenticateCognitoActionConditionalBehaviorEnum
     */
    public String onUnauthenticatedRequestAsString() {
        return onUnauthenticatedRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userPoolArn());
        hashCode = 31 * hashCode + Objects.hashCode(userPoolClientId());
        hashCode = 31 * hashCode + Objects.hashCode(userPoolDomain());
        hashCode = 31 * hashCode + Objects.hashCode(sessionCookieName());
        hashCode = 31 * hashCode + Objects.hashCode(scope());
        hashCode = 31 * hashCode + Objects.hashCode(sessionTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(authenticationRequestExtraParams());
        hashCode = 31 * hashCode + Objects.hashCode(onUnauthenticatedRequestAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthenticateCognitoActionConfig)) {
            return false;
        }
        AuthenticateCognitoActionConfig other = (AuthenticateCognitoActionConfig) obj;
        return Objects.equals(userPoolArn(), other.userPoolArn()) && Objects.equals(userPoolClientId(), other.userPoolClientId())
                && Objects.equals(userPoolDomain(), other.userPoolDomain())
                && Objects.equals(sessionCookieName(), other.sessionCookieName()) && Objects.equals(scope(), other.scope())
                && Objects.equals(sessionTimeout(), other.sessionTimeout())
                && Objects.equals(authenticationRequestExtraParams(), other.authenticationRequestExtraParams())
                && Objects.equals(onUnauthenticatedRequestAsString(), other.onUnauthenticatedRequestAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("AuthenticateCognitoActionConfig").add("UserPoolArn", userPoolArn())
                .add("UserPoolClientId", userPoolClientId()).add("UserPoolDomain", userPoolDomain())
                .add("SessionCookieName", sessionCookieName()).add("Scope", scope()).add("SessionTimeout", sessionTimeout())
                .add("AuthenticationRequestExtraParams", authenticationRequestExtraParams())
                .add("OnUnauthenticatedRequest", onUnauthenticatedRequestAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserPoolArn":
            return Optional.ofNullable(clazz.cast(userPoolArn()));
        case "UserPoolClientId":
            return Optional.ofNullable(clazz.cast(userPoolClientId()));
        case "UserPoolDomain":
            return Optional.ofNullable(clazz.cast(userPoolDomain()));
        case "SessionCookieName":
            return Optional.ofNullable(clazz.cast(sessionCookieName()));
        case "Scope":
            return Optional.ofNullable(clazz.cast(scope()));
        case "SessionTimeout":
            return Optional.ofNullable(clazz.cast(sessionTimeout()));
        case "AuthenticationRequestExtraParams":
            return Optional.ofNullable(clazz.cast(authenticationRequestExtraParams()));
        case "OnUnauthenticatedRequest":
            return Optional.ofNullable(clazz.cast(onUnauthenticatedRequestAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AuthenticateCognitoActionConfig, T> g) {
        return obj -> g.apply((AuthenticateCognitoActionConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuthenticateCognitoActionConfig> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Cognito user pool.
         * </p>
         * 
         * @param userPoolArn
         *        The Amazon Resource Name (ARN) of the Amazon Cognito user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolArn(String userPoolArn);

        /**
         * <p>
         * The ID of the Amazon Cognito user pool client.
         * </p>
         * 
         * @param userPoolClientId
         *        The ID of the Amazon Cognito user pool client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolClientId(String userPoolClientId);

        /**
         * <p>
         * The domain prefix or fully-qualified domain name of the Amazon Cognito user pool.
         * </p>
         * 
         * @param userPoolDomain
         *        The domain prefix or fully-qualified domain name of the Amazon Cognito user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolDomain(String userPoolDomain);

        /**
         * <p>
         * The name of the cookie used to maintain session information. The default is AWSELBAuthSessionCookie.
         * </p>
         * 
         * @param sessionCookieName
         *        The name of the cookie used to maintain session information. The default is AWSELBAuthSessionCookie.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionCookieName(String sessionCookieName);

        /**
         * <p>
         * The set of user claims to be requested from the IdP. The default is <code>openid</code>.
         * </p>
         * <p>
         * To verify which scope values your IdP supports and how to separate multiple values, see the documentation for
         * your IdP.
         * </p>
         * 
         * @param scope
         *        The set of user claims to be requested from the IdP. The default is <code>openid</code>.</p>
         *        <p>
         *        To verify which scope values your IdP supports and how to separate multiple values, see the
         *        documentation for your IdP.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scope(String scope);

        /**
         * <p>
         * The maximum duration of the authentication session, in seconds. The default is 604800 seconds (7 days).
         * </p>
         * 
         * @param sessionTimeout
         *        The maximum duration of the authentication session, in seconds. The default is 604800 seconds (7
         *        days).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionTimeout(Long sessionTimeout);

        /**
         * <p>
         * The query parameters (up to 10) to include in the redirect request to the authorization endpoint.
         * </p>
         * 
         * @param authenticationRequestExtraParams
         *        The query parameters (up to 10) to include in the redirect request to the authorization endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationRequestExtraParams(Map<String, String> authenticationRequestExtraParams);

        /**
         * <p>
         * The behavior if the user is not authenticated. The following are possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * deny<code/> - Return an HTTP 401 Unauthorized error.
         * </p>
         * </li>
         * <li>
         * <p>
         * allow<code/> - Allow the request to be forwarded to the target.
         * </p>
         * </li>
         * <li>
         * <p>
         * authenticate<code/> - Redirect the request to the IdP authorization endpoint. This is the default value.
         * </p>
         * </li>
         * </ul>
         * 
         * @param onUnauthenticatedRequest
         *        The behavior if the user is not authenticated. The following are possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        deny<code/> - Return an HTTP 401 Unauthorized error.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        allow<code/> - Allow the request to be forwarded to the target.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        authenticate
         *        <code/> - Redirect the request to the IdP authorization endpoint. This is the default value.
         *        </p>
         *        </li>
         * @see AuthenticateCognitoActionConditionalBehaviorEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticateCognitoActionConditionalBehaviorEnum
         */
        Builder onUnauthenticatedRequest(String onUnauthenticatedRequest);

        /**
         * <p>
         * The behavior if the user is not authenticated. The following are possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * deny<code/> - Return an HTTP 401 Unauthorized error.
         * </p>
         * </li>
         * <li>
         * <p>
         * allow<code/> - Allow the request to be forwarded to the target.
         * </p>
         * </li>
         * <li>
         * <p>
         * authenticate<code/> - Redirect the request to the IdP authorization endpoint. This is the default value.
         * </p>
         * </li>
         * </ul>
         * 
         * @param onUnauthenticatedRequest
         *        The behavior if the user is not authenticated. The following are possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        deny<code/> - Return an HTTP 401 Unauthorized error.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        allow<code/> - Allow the request to be forwarded to the target.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        authenticate
         *        <code/> - Redirect the request to the IdP authorization endpoint. This is the default value.
         *        </p>
         *        </li>
         * @see AuthenticateCognitoActionConditionalBehaviorEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticateCognitoActionConditionalBehaviorEnum
         */
        Builder onUnauthenticatedRequest(AuthenticateCognitoActionConditionalBehaviorEnum onUnauthenticatedRequest);
    }

    static final class BuilderImpl implements Builder {
        private String userPoolArn;

        private String userPoolClientId;

        private String userPoolDomain;

        private String sessionCookieName;

        private String scope;

        private Long sessionTimeout;

        private Map<String, String> authenticationRequestExtraParams = DefaultSdkAutoConstructMap.getInstance();

        private String onUnauthenticatedRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthenticateCognitoActionConfig model) {
            userPoolArn(model.userPoolArn);
            userPoolClientId(model.userPoolClientId);
            userPoolDomain(model.userPoolDomain);
            sessionCookieName(model.sessionCookieName);
            scope(model.scope);
            sessionTimeout(model.sessionTimeout);
            authenticationRequestExtraParams(model.authenticationRequestExtraParams);
            onUnauthenticatedRequest(model.onUnauthenticatedRequest);
        }

        public final String getUserPoolArn() {
            return userPoolArn;
        }

        @Override
        public final Builder userPoolArn(String userPoolArn) {
            this.userPoolArn = userPoolArn;
            return this;
        }

        public final void setUserPoolArn(String userPoolArn) {
            this.userPoolArn = userPoolArn;
        }

        public final String getUserPoolClientId() {
            return userPoolClientId;
        }

        @Override
        public final Builder userPoolClientId(String userPoolClientId) {
            this.userPoolClientId = userPoolClientId;
            return this;
        }

        public final void setUserPoolClientId(String userPoolClientId) {
            this.userPoolClientId = userPoolClientId;
        }

        public final String getUserPoolDomain() {
            return userPoolDomain;
        }

        @Override
        public final Builder userPoolDomain(String userPoolDomain) {
            this.userPoolDomain = userPoolDomain;
            return this;
        }

        public final void setUserPoolDomain(String userPoolDomain) {
            this.userPoolDomain = userPoolDomain;
        }

        public final String getSessionCookieName() {
            return sessionCookieName;
        }

        @Override
        public final Builder sessionCookieName(String sessionCookieName) {
            this.sessionCookieName = sessionCookieName;
            return this;
        }

        public final void setSessionCookieName(String sessionCookieName) {
            this.sessionCookieName = sessionCookieName;
        }

        public final String getScope() {
            return scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        public final Long getSessionTimeout() {
            return sessionTimeout;
        }

        @Override
        public final Builder sessionTimeout(Long sessionTimeout) {
            this.sessionTimeout = sessionTimeout;
            return this;
        }

        public final void setSessionTimeout(Long sessionTimeout) {
            this.sessionTimeout = sessionTimeout;
        }

        public final Map<String, String> getAuthenticationRequestExtraParams() {
            return authenticationRequestExtraParams;
        }

        @Override
        public final Builder authenticationRequestExtraParams(Map<String, String> authenticationRequestExtraParams) {
            this.authenticationRequestExtraParams = AuthenticateCognitoActionAuthenticationRequestExtraParamsCopier
                    .copy(authenticationRequestExtraParams);
            return this;
        }

        public final void setAuthenticationRequestExtraParams(Map<String, String> authenticationRequestExtraParams) {
            this.authenticationRequestExtraParams = AuthenticateCognitoActionAuthenticationRequestExtraParamsCopier
                    .copy(authenticationRequestExtraParams);
        }

        public final String getOnUnauthenticatedRequestAsString() {
            return onUnauthenticatedRequest;
        }

        @Override
        public final Builder onUnauthenticatedRequest(String onUnauthenticatedRequest) {
            this.onUnauthenticatedRequest = onUnauthenticatedRequest;
            return this;
        }

        @Override
        public final Builder onUnauthenticatedRequest(AuthenticateCognitoActionConditionalBehaviorEnum onUnauthenticatedRequest) {
            this.onUnauthenticatedRequest(onUnauthenticatedRequest.toString());
            return this;
        }

        public final void setOnUnauthenticatedRequest(String onUnauthenticatedRequest) {
            this.onUnauthenticatedRequest = onUnauthenticatedRequest;
        }

        @Override
        public AuthenticateCognitoActionConfig build() {
            return new AuthenticateCognitoActionConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
