/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTagsResponse extends ElasticLoadBalancingV2Response implements
        ToCopyableBuilder<DescribeTagsResponse.Builder, DescribeTagsResponse> {
    private static final SdkField<List<TagDescription>> TAG_DESCRIPTIONS_FIELD = SdkField
            .<List<TagDescription>> builder(MarshallingType.LIST)
            .getter(getter(DescribeTagsResponse::tagDescriptions))
            .setter(setter(Builder::tagDescriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagDescriptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TagDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAG_DESCRIPTIONS_FIELD));

    private final List<TagDescription> tagDescriptions;

    private DescribeTagsResponse(BuilderImpl builder) {
        super(builder);
        this.tagDescriptions = builder.tagDescriptions;
    }

    /**
     * <p>
     * Information about the tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the tags.
     */
    public List<TagDescription> tagDescriptions() {
        return tagDescriptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tagDescriptions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTagsResponse)) {
            return false;
        }
        DescribeTagsResponse other = (DescribeTagsResponse) obj;
        return Objects.equals(tagDescriptions(), other.tagDescriptions());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeTagsResponse").add("TagDescriptions", tagDescriptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TagDescriptions":
            return Optional.ofNullable(clazz.cast(tagDescriptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTagsResponse, T> g) {
        return obj -> g.apply((DescribeTagsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticLoadBalancingV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeTagsResponse> {
        /**
         * <p>
         * Information about the tags.
         * </p>
         * 
         * @param tagDescriptions
         *        Information about the tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagDescriptions(Collection<TagDescription> tagDescriptions);

        /**
         * <p>
         * Information about the tags.
         * </p>
         * 
         * @param tagDescriptions
         *        Information about the tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagDescriptions(TagDescription... tagDescriptions);

        /**
         * <p>
         * Information about the tags.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TagDescription>.Builder} avoiding the need
         * to create one manually via {@link List<TagDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TagDescription>.Builder#build()} is called immediately and
         * its result is passed to {@link #tagDescriptions(List<TagDescription>)}.
         * 
         * @param tagDescriptions
         *        a consumer that will call methods on {@link List<TagDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagDescriptions(List<TagDescription>)
         */
        Builder tagDescriptions(Consumer<TagDescription.Builder>... tagDescriptions);
    }

    static final class BuilderImpl extends ElasticLoadBalancingV2Response.BuilderImpl implements Builder {
        private List<TagDescription> tagDescriptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTagsResponse model) {
            super(model);
            tagDescriptions(model.tagDescriptions);
        }

        public final Collection<TagDescription.Builder> getTagDescriptions() {
            return tagDescriptions != null ? tagDescriptions.stream().map(TagDescription::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder tagDescriptions(Collection<TagDescription> tagDescriptions) {
            this.tagDescriptions = TagDescriptionsCopier.copy(tagDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagDescriptions(TagDescription... tagDescriptions) {
            tagDescriptions(Arrays.asList(tagDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagDescriptions(Consumer<TagDescription.Builder>... tagDescriptions) {
            tagDescriptions(Stream.of(tagDescriptions).map(c -> TagDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTagDescriptions(Collection<TagDescription.BuilderImpl> tagDescriptions) {
            this.tagDescriptions = TagDescriptionsCopier.copyFromBuilder(tagDescriptions);
        }

        @Override
        public DescribeTagsResponse build() {
            return new DescribeTagsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
