/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an action that returns a custom HTTP response.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FixedResponseActionConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<FixedResponseActionConfig.Builder, FixedResponseActionConfig> {
    private static final SdkField<String> MESSAGE_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FixedResponseActionConfig::messageBody)).setter(setter(Builder::messageBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageBody").build()).build();

    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FixedResponseActionConfig::statusCode)).setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusCode").build()).build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FixedResponseActionConfig::contentType)).setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_BODY_FIELD,
            STATUS_CODE_FIELD, CONTENT_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String messageBody;

    private final String statusCode;

    private final String contentType;

    private FixedResponseActionConfig(BuilderImpl builder) {
        this.messageBody = builder.messageBody;
        this.statusCode = builder.statusCode;
        this.contentType = builder.contentType;
    }

    /**
     * <p>
     * The message.
     * </p>
     * 
     * @return The message.
     */
    public String messageBody() {
        return messageBody;
    }

    /**
     * <p>
     * The HTTP response code (2XX, 4XX, or 5XX).
     * </p>
     * 
     * @return The HTTP response code (2XX, 4XX, or 5XX).
     */
    public String statusCode() {
        return statusCode;
    }

    /**
     * <p>
     * The content type.
     * </p>
     * <p>
     * Valid Values: text/plain | text/css | text/html | application/javascript | application/json
     * </p>
     * 
     * @return The content type.</p>
     *         <p>
     *         Valid Values: text/plain | text/css | text/html | application/javascript | application/json
     */
    public String contentType() {
        return contentType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(messageBody());
        hashCode = 31 * hashCode + Objects.hashCode(statusCode());
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FixedResponseActionConfig)) {
            return false;
        }
        FixedResponseActionConfig other = (FixedResponseActionConfig) obj;
        return Objects.equals(messageBody(), other.messageBody()) && Objects.equals(statusCode(), other.statusCode())
                && Objects.equals(contentType(), other.contentType());
    }

    @Override
    public String toString() {
        return ToString.builder("FixedResponseActionConfig").add("MessageBody", messageBody()).add("StatusCode", statusCode())
                .add("ContentType", contentType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MessageBody":
            return Optional.ofNullable(clazz.cast(messageBody()));
        case "StatusCode":
            return Optional.ofNullable(clazz.cast(statusCode()));
        case "ContentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FixedResponseActionConfig, T> g) {
        return obj -> g.apply((FixedResponseActionConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FixedResponseActionConfig> {
        /**
         * <p>
         * The message.
         * </p>
         * 
         * @param messageBody
         *        The message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageBody(String messageBody);

        /**
         * <p>
         * The HTTP response code (2XX, 4XX, or 5XX).
         * </p>
         * 
         * @param statusCode
         *        The HTTP response code (2XX, 4XX, or 5XX).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusCode(String statusCode);

        /**
         * <p>
         * The content type.
         * </p>
         * <p>
         * Valid Values: text/plain | text/css | text/html | application/javascript | application/json
         * </p>
         * 
         * @param contentType
         *        The content type.</p>
         *        <p>
         *        Valid Values: text/plain | text/css | text/html | application/javascript | application/json
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);
    }

    static final class BuilderImpl implements Builder {
        private String messageBody;

        private String statusCode;

        private String contentType;

        private BuilderImpl() {
        }

        private BuilderImpl(FixedResponseActionConfig model) {
            messageBody(model.messageBody);
            statusCode(model.statusCode);
            contentType(model.contentType);
        }

        public final String getMessageBody() {
            return messageBody;
        }

        @Override
        public final Builder messageBody(String messageBody) {
            this.messageBody = messageBody;
            return this;
        }

        public final void setMessageBody(String messageBody) {
            this.messageBody = messageBody;
        }

        public final String getStatusCode() {
            return statusCode;
        }

        @Override
        public final Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public final void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        public final String getContentType() {
            return contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public FixedResponseActionConfig build() {
            return new FixedResponseActionConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
