/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a load balancer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoadBalancer implements SdkPojo, Serializable, ToCopyableBuilder<LoadBalancer.Builder, LoadBalancer> {
    private static final SdkField<String> LOAD_BALANCER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LoadBalancer::loadBalancerArn)).setter(setter(Builder::loadBalancerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerArn").build()).build();

    private static final SdkField<String> DNS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LoadBalancer::dnsName)).setter(setter(Builder::dnsName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DNSName").build()).build();

    private static final SdkField<String> CANONICAL_HOSTED_ZONE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LoadBalancer::canonicalHostedZoneId)).setter(setter(Builder::canonicalHostedZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CanonicalHostedZoneId").build())
            .build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(LoadBalancer::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<String> LOAD_BALANCER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LoadBalancer::loadBalancerName)).setter(setter(Builder::loadBalancerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerName").build()).build();

    private static final SdkField<String> SCHEME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LoadBalancer::schemeAsString)).setter(setter(Builder::scheme))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scheme").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LoadBalancer::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<LoadBalancerState> STATE_FIELD = SdkField.<LoadBalancerState> builder(MarshallingType.SDK_POJO)
            .getter(getter(LoadBalancer::state)).setter(setter(Builder::state)).constructor(LoadBalancerState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LoadBalancer::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<List<AvailabilityZone>> AVAILABILITY_ZONES_FIELD = SdkField
            .<List<AvailabilityZone>> builder(MarshallingType.LIST)
            .getter(getter(LoadBalancer::availabilityZones))
            .setter(setter(Builder::availabilityZones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AvailabilityZone> builder(MarshallingType.SDK_POJO)
                                            .constructor(AvailabilityZone::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(LoadBalancer::securityGroups))
            .setter(setter(Builder::securityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LoadBalancer::ipAddressTypeAsString)).setter(setter(Builder::ipAddressType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddressType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_BALANCER_ARN_FIELD,
            DNS_NAME_FIELD, CANONICAL_HOSTED_ZONE_ID_FIELD, CREATED_TIME_FIELD, LOAD_BALANCER_NAME_FIELD, SCHEME_FIELD,
            VPC_ID_FIELD, STATE_FIELD, TYPE_FIELD, AVAILABILITY_ZONES_FIELD, SECURITY_GROUPS_FIELD, IP_ADDRESS_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String loadBalancerArn;

    private final String dnsName;

    private final String canonicalHostedZoneId;

    private final Instant createdTime;

    private final String loadBalancerName;

    private final String scheme;

    private final String vpcId;

    private final LoadBalancerState state;

    private final String type;

    private final List<AvailabilityZone> availabilityZones;

    private final List<String> securityGroups;

    private final String ipAddressType;

    private LoadBalancer(BuilderImpl builder) {
        this.loadBalancerArn = builder.loadBalancerArn;
        this.dnsName = builder.dnsName;
        this.canonicalHostedZoneId = builder.canonicalHostedZoneId;
        this.createdTime = builder.createdTime;
        this.loadBalancerName = builder.loadBalancerName;
        this.scheme = builder.scheme;
        this.vpcId = builder.vpcId;
        this.state = builder.state;
        this.type = builder.type;
        this.availabilityZones = builder.availabilityZones;
        this.securityGroups = builder.securityGroups;
        this.ipAddressType = builder.ipAddressType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the load balancer.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the load balancer.
     */
    public String loadBalancerArn() {
        return loadBalancerArn;
    }

    /**
     * <p>
     * The public DNS name of the load balancer.
     * </p>
     * 
     * @return The public DNS name of the load balancer.
     */
    public String dnsName() {
        return dnsName;
    }

    /**
     * <p>
     * The ID of the Amazon Route 53 hosted zone associated with the load balancer.
     * </p>
     * 
     * @return The ID of the Amazon Route 53 hosted zone associated with the load balancer.
     */
    public String canonicalHostedZoneId() {
        return canonicalHostedZoneId;
    }

    /**
     * <p>
     * The date and time the load balancer was created.
     * </p>
     * 
     * @return The date and time the load balancer was created.
     */
    public Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The name of the load balancer.
     * </p>
     * 
     * @return The name of the load balancer.
     */
    public String loadBalancerName() {
        return loadBalancerName;
    }

    /**
     * <p>
     * The nodes of an Internet-facing load balancer have public IP addresses. The DNS name of an Internet-facing load
     * balancer is publicly resolvable to the public IP addresses of the nodes. Therefore, Internet-facing load
     * balancers can route requests from clients over the internet.
     * </p>
     * <p>
     * The nodes of an internal load balancer have only private IP addresses. The DNS name of an internal load balancer
     * is publicly resolvable to the private IP addresses of the nodes. Therefore, internal load balancers can only
     * route requests from clients with access to the VPC for the load balancer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scheme} will
     * return {@link LoadBalancerSchemeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #schemeAsString}.
     * </p>
     * 
     * @return The nodes of an Internet-facing load balancer have public IP addresses. The DNS name of an
     *         Internet-facing load balancer is publicly resolvable to the public IP addresses of the nodes. Therefore,
     *         Internet-facing load balancers can route requests from clients over the internet.</p>
     *         <p>
     *         The nodes of an internal load balancer have only private IP addresses. The DNS name of an internal load
     *         balancer is publicly resolvable to the private IP addresses of the nodes. Therefore, internal load
     *         balancers can only route requests from clients with access to the VPC for the load balancer.
     * @see LoadBalancerSchemeEnum
     */
    public LoadBalancerSchemeEnum scheme() {
        return LoadBalancerSchemeEnum.fromValue(scheme);
    }

    /**
     * <p>
     * The nodes of an Internet-facing load balancer have public IP addresses. The DNS name of an Internet-facing load
     * balancer is publicly resolvable to the public IP addresses of the nodes. Therefore, Internet-facing load
     * balancers can route requests from clients over the internet.
     * </p>
     * <p>
     * The nodes of an internal load balancer have only private IP addresses. The DNS name of an internal load balancer
     * is publicly resolvable to the private IP addresses of the nodes. Therefore, internal load balancers can only
     * route requests from clients with access to the VPC for the load balancer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scheme} will
     * return {@link LoadBalancerSchemeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #schemeAsString}.
     * </p>
     * 
     * @return The nodes of an Internet-facing load balancer have public IP addresses. The DNS name of an
     *         Internet-facing load balancer is publicly resolvable to the public IP addresses of the nodes. Therefore,
     *         Internet-facing load balancers can route requests from clients over the internet.</p>
     *         <p>
     *         The nodes of an internal load balancer have only private IP addresses. The DNS name of an internal load
     *         balancer is publicly resolvable to the private IP addresses of the nodes. Therefore, internal load
     *         balancers can only route requests from clients with access to the VPC for the load balancer.
     * @see LoadBalancerSchemeEnum
     */
    public String schemeAsString() {
        return scheme;
    }

    /**
     * <p>
     * The ID of the VPC for the load balancer.
     * </p>
     * 
     * @return The ID of the VPC for the load balancer.
     */
    public String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * The state of the load balancer.
     * </p>
     * 
     * @return The state of the load balancer.
     */
    public LoadBalancerState state() {
        return state;
    }

    /**
     * <p>
     * The type of load balancer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link LoadBalancerTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of load balancer.
     * @see LoadBalancerTypeEnum
     */
    public LoadBalancerTypeEnum type() {
        return LoadBalancerTypeEnum.fromValue(type);
    }

    /**
     * <p>
     * The type of load balancer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link LoadBalancerTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of load balancer.
     * @see LoadBalancerTypeEnum
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The Availability Zones for the load balancer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The Availability Zones for the load balancer.
     */
    public List<AvailabilityZone> availabilityZones() {
        return availabilityZones;
    }

    /**
     * <p>
     * The IDs of the security groups for the load balancer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The IDs of the security groups for the load balancer.
     */
    public List<String> securityGroups() {
        return securityGroups;
    }

    /**
     * <p>
     * The type of IP addresses used by the subnets for your load balancer. The possible values are <code>ipv4</code>
     * (for IPv4 addresses) and <code>dualstack</code> (for IPv4 and IPv6 addresses).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressType}
     * will return {@link IpAddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipAddressTypeAsString}.
     * </p>
     * 
     * @return The type of IP addresses used by the subnets for your load balancer. The possible values are
     *         <code>ipv4</code> (for IPv4 addresses) and <code>dualstack</code> (for IPv4 and IPv6 addresses).
     * @see IpAddressType
     */
    public IpAddressType ipAddressType() {
        return IpAddressType.fromValue(ipAddressType);
    }

    /**
     * <p>
     * The type of IP addresses used by the subnets for your load balancer. The possible values are <code>ipv4</code>
     * (for IPv4 addresses) and <code>dualstack</code> (for IPv4 and IPv6 addresses).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressType}
     * will return {@link IpAddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipAddressTypeAsString}.
     * </p>
     * 
     * @return The type of IP addresses used by the subnets for your load balancer. The possible values are
     *         <code>ipv4</code> (for IPv4 addresses) and <code>dualstack</code> (for IPv4 and IPv6 addresses).
     * @see IpAddressType
     */
    public String ipAddressTypeAsString() {
        return ipAddressType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerArn());
        hashCode = 31 * hashCode + Objects.hashCode(dnsName());
        hashCode = 31 * hashCode + Objects.hashCode(canonicalHostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerName());
        hashCode = 31 * hashCode + Objects.hashCode(schemeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZones());
        hashCode = 31 * hashCode + Objects.hashCode(securityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddressTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadBalancer)) {
            return false;
        }
        LoadBalancer other = (LoadBalancer) obj;
        return Objects.equals(loadBalancerArn(), other.loadBalancerArn()) && Objects.equals(dnsName(), other.dnsName())
                && Objects.equals(canonicalHostedZoneId(), other.canonicalHostedZoneId())
                && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(loadBalancerName(), other.loadBalancerName())
                && Objects.equals(schemeAsString(), other.schemeAsString()) && Objects.equals(vpcId(), other.vpcId())
                && Objects.equals(state(), other.state()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(availabilityZones(), other.availabilityZones())
                && Objects.equals(securityGroups(), other.securityGroups())
                && Objects.equals(ipAddressTypeAsString(), other.ipAddressTypeAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("LoadBalancer").add("LoadBalancerArn", loadBalancerArn()).add("DNSName", dnsName())
                .add("CanonicalHostedZoneId", canonicalHostedZoneId()).add("CreatedTime", createdTime())
                .add("LoadBalancerName", loadBalancerName()).add("Scheme", schemeAsString()).add("VpcId", vpcId())
                .add("State", state()).add("Type", typeAsString()).add("AvailabilityZones", availabilityZones())
                .add("SecurityGroups", securityGroups()).add("IpAddressType", ipAddressTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LoadBalancerArn":
            return Optional.ofNullable(clazz.cast(loadBalancerArn()));
        case "DNSName":
            return Optional.ofNullable(clazz.cast(dnsName()));
        case "CanonicalHostedZoneId":
            return Optional.ofNullable(clazz.cast(canonicalHostedZoneId()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "LoadBalancerName":
            return Optional.ofNullable(clazz.cast(loadBalancerName()));
        case "Scheme":
            return Optional.ofNullable(clazz.cast(schemeAsString()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "AvailabilityZones":
            return Optional.ofNullable(clazz.cast(availabilityZones()));
        case "SecurityGroups":
            return Optional.ofNullable(clazz.cast(securityGroups()));
        case "IpAddressType":
            return Optional.ofNullable(clazz.cast(ipAddressTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoadBalancer, T> g) {
        return obj -> g.apply((LoadBalancer) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoadBalancer> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the load balancer.
         * </p>
         * 
         * @param loadBalancerArn
         *        The Amazon Resource Name (ARN) of the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerArn(String loadBalancerArn);

        /**
         * <p>
         * The public DNS name of the load balancer.
         * </p>
         * 
         * @param dnsName
         *        The public DNS name of the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsName(String dnsName);

        /**
         * <p>
         * The ID of the Amazon Route 53 hosted zone associated with the load balancer.
         * </p>
         * 
         * @param canonicalHostedZoneId
         *        The ID of the Amazon Route 53 hosted zone associated with the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder canonicalHostedZoneId(String canonicalHostedZoneId);

        /**
         * <p>
         * The date and time the load balancer was created.
         * </p>
         * 
         * @param createdTime
         *        The date and time the load balancer was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The name of the load balancer.
         * </p>
         * 
         * @param loadBalancerName
         *        The name of the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerName(String loadBalancerName);

        /**
         * <p>
         * The nodes of an Internet-facing load balancer have public IP addresses. The DNS name of an Internet-facing
         * load balancer is publicly resolvable to the public IP addresses of the nodes. Therefore, Internet-facing load
         * balancers can route requests from clients over the internet.
         * </p>
         * <p>
         * The nodes of an internal load balancer have only private IP addresses. The DNS name of an internal load
         * balancer is publicly resolvable to the private IP addresses of the nodes. Therefore, internal load balancers
         * can only route requests from clients with access to the VPC for the load balancer.
         * </p>
         * 
         * @param scheme
         *        The nodes of an Internet-facing load balancer have public IP addresses. The DNS name of an
         *        Internet-facing load balancer is publicly resolvable to the public IP addresses of the nodes.
         *        Therefore, Internet-facing load balancers can route requests from clients over the internet.</p>
         *        <p>
         *        The nodes of an internal load balancer have only private IP addresses. The DNS name of an internal
         *        load balancer is publicly resolvable to the private IP addresses of the nodes. Therefore, internal
         *        load balancers can only route requests from clients with access to the VPC for the load balancer.
         * @see LoadBalancerSchemeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LoadBalancerSchemeEnum
         */
        Builder scheme(String scheme);

        /**
         * <p>
         * The nodes of an Internet-facing load balancer have public IP addresses. The DNS name of an Internet-facing
         * load balancer is publicly resolvable to the public IP addresses of the nodes. Therefore, Internet-facing load
         * balancers can route requests from clients over the internet.
         * </p>
         * <p>
         * The nodes of an internal load balancer have only private IP addresses. The DNS name of an internal load
         * balancer is publicly resolvable to the private IP addresses of the nodes. Therefore, internal load balancers
         * can only route requests from clients with access to the VPC for the load balancer.
         * </p>
         * 
         * @param scheme
         *        The nodes of an Internet-facing load balancer have public IP addresses. The DNS name of an
         *        Internet-facing load balancer is publicly resolvable to the public IP addresses of the nodes.
         *        Therefore, Internet-facing load balancers can route requests from clients over the internet.</p>
         *        <p>
         *        The nodes of an internal load balancer have only private IP addresses. The DNS name of an internal
         *        load balancer is publicly resolvable to the private IP addresses of the nodes. Therefore, internal
         *        load balancers can only route requests from clients with access to the VPC for the load balancer.
         * @see LoadBalancerSchemeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LoadBalancerSchemeEnum
         */
        Builder scheme(LoadBalancerSchemeEnum scheme);

        /**
         * <p>
         * The ID of the VPC for the load balancer.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC for the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The state of the load balancer.
         * </p>
         * 
         * @param state
         *        The state of the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(LoadBalancerState state);

        /**
         * <p>
         * The state of the load balancer.
         * </p>
         * This is a convenience that creates an instance of the {@link LoadBalancerState.Builder} avoiding the need to
         * create one manually via {@link LoadBalancerState#builder()}.
         *
         * When the {@link Consumer} completes, {@link LoadBalancerState.Builder#build()} is called immediately and its
         * result is passed to {@link #state(LoadBalancerState)}.
         * 
         * @param state
         *        a consumer that will call methods on {@link LoadBalancerState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #state(LoadBalancerState)
         */
        default Builder state(Consumer<LoadBalancerState.Builder> state) {
            return state(LoadBalancerState.builder().applyMutation(state).build());
        }

        /**
         * <p>
         * The type of load balancer.
         * </p>
         * 
         * @param type
         *        The type of load balancer.
         * @see LoadBalancerTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LoadBalancerTypeEnum
         */
        Builder type(String type);

        /**
         * <p>
         * The type of load balancer.
         * </p>
         * 
         * @param type
         *        The type of load balancer.
         * @see LoadBalancerTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LoadBalancerTypeEnum
         */
        Builder type(LoadBalancerTypeEnum type);

        /**
         * <p>
         * The Availability Zones for the load balancer.
         * </p>
         * 
         * @param availabilityZones
         *        The Availability Zones for the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(Collection<AvailabilityZone> availabilityZones);

        /**
         * <p>
         * The Availability Zones for the load balancer.
         * </p>
         * 
         * @param availabilityZones
         *        The Availability Zones for the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(AvailabilityZone... availabilityZones);

        /**
         * <p>
         * The Availability Zones for the load balancer.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AvailabilityZone>.Builder} avoiding the
         * need to create one manually via {@link List<AvailabilityZone>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AvailabilityZone>.Builder#build()} is called immediately and
         * its result is passed to {@link #availabilityZones(List<AvailabilityZone>)}.
         * 
         * @param availabilityZones
         *        a consumer that will call methods on {@link List<AvailabilityZone>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #availabilityZones(List<AvailabilityZone>)
         */
        Builder availabilityZones(Consumer<AvailabilityZone.Builder>... availabilityZones);

        /**
         * <p>
         * The IDs of the security groups for the load balancer.
         * </p>
         * 
         * @param securityGroups
         *        The IDs of the security groups for the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<String> securityGroups);

        /**
         * <p>
         * The IDs of the security groups for the load balancer.
         * </p>
         * 
         * @param securityGroups
         *        The IDs of the security groups for the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(String... securityGroups);

        /**
         * <p>
         * The type of IP addresses used by the subnets for your load balancer. The possible values are
         * <code>ipv4</code> (for IPv4 addresses) and <code>dualstack</code> (for IPv4 and IPv6 addresses).
         * </p>
         * 
         * @param ipAddressType
         *        The type of IP addresses used by the subnets for your load balancer. The possible values are
         *        <code>ipv4</code> (for IPv4 addresses) and <code>dualstack</code> (for IPv4 and IPv6 addresses).
         * @see IpAddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpAddressType
         */
        Builder ipAddressType(String ipAddressType);

        /**
         * <p>
         * The type of IP addresses used by the subnets for your load balancer. The possible values are
         * <code>ipv4</code> (for IPv4 addresses) and <code>dualstack</code> (for IPv4 and IPv6 addresses).
         * </p>
         * 
         * @param ipAddressType
         *        The type of IP addresses used by the subnets for your load balancer. The possible values are
         *        <code>ipv4</code> (for IPv4 addresses) and <code>dualstack</code> (for IPv4 and IPv6 addresses).
         * @see IpAddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpAddressType
         */
        Builder ipAddressType(IpAddressType ipAddressType);
    }

    static final class BuilderImpl implements Builder {
        private String loadBalancerArn;

        private String dnsName;

        private String canonicalHostedZoneId;

        private Instant createdTime;

        private String loadBalancerName;

        private String scheme;

        private String vpcId;

        private LoadBalancerState state;

        private String type;

        private List<AvailabilityZone> availabilityZones = DefaultSdkAutoConstructList.getInstance();

        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();

        private String ipAddressType;

        private BuilderImpl() {
        }

        private BuilderImpl(LoadBalancer model) {
            loadBalancerArn(model.loadBalancerArn);
            dnsName(model.dnsName);
            canonicalHostedZoneId(model.canonicalHostedZoneId);
            createdTime(model.createdTime);
            loadBalancerName(model.loadBalancerName);
            scheme(model.scheme);
            vpcId(model.vpcId);
            state(model.state);
            type(model.type);
            availabilityZones(model.availabilityZones);
            securityGroups(model.securityGroups);
            ipAddressType(model.ipAddressType);
        }

        public final String getLoadBalancerArn() {
            return loadBalancerArn;
        }

        @Override
        public final Builder loadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
            return this;
        }

        public final void setLoadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
        }

        public final String getDnsName() {
            return dnsName;
        }

        @Override
        public final Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public final void setDnsName(String dnsName) {
            this.dnsName = dnsName;
        }

        public final String getCanonicalHostedZoneId() {
            return canonicalHostedZoneId;
        }

        @Override
        public final Builder canonicalHostedZoneId(String canonicalHostedZoneId) {
            this.canonicalHostedZoneId = canonicalHostedZoneId;
            return this;
        }

        public final void setCanonicalHostedZoneId(String canonicalHostedZoneId) {
            this.canonicalHostedZoneId = canonicalHostedZoneId;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final String getLoadBalancerName() {
            return loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        public final String getSchemeAsString() {
            return scheme;
        }

        @Override
        public final Builder scheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        @Override
        public final Builder scheme(LoadBalancerSchemeEnum scheme) {
            this.scheme(scheme.toString());
            return this;
        }

        public final void setScheme(String scheme) {
            this.scheme = scheme;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final LoadBalancerState.Builder getState() {
            return state != null ? state.toBuilder() : null;
        }

        @Override
        public final Builder state(LoadBalancerState state) {
            this.state = state;
            return this;
        }

        public final void setState(LoadBalancerState.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        public final String getTypeAsString() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(LoadBalancerTypeEnum type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Collection<AvailabilityZone.Builder> getAvailabilityZones() {
            return availabilityZones != null ? availabilityZones.stream().map(AvailabilityZone::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder availabilityZones(Collection<AvailabilityZone> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(AvailabilityZone... availabilityZones) {
            availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(Consumer<AvailabilityZone.Builder>... availabilityZones) {
            availabilityZones(Stream.of(availabilityZones).map(c -> AvailabilityZone.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAvailabilityZones(Collection<AvailabilityZone.BuilderImpl> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copyFromBuilder(availabilityZones);
        }

        public final Collection<String> getSecurityGroups() {
            return securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
        }

        public final String getIpAddressTypeAsString() {
            return ipAddressType;
        }

        @Override
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        @Override
        public final Builder ipAddressType(IpAddressType ipAddressType) {
            this.ipAddressType(ipAddressType.toString());
            return this;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        @Override
        public LoadBalancer build() {
            return new LoadBalancer(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
