/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyRuleRequest extends ElasticLoadBalancingV2Request implements
        ToCopyableBuilder<ModifyRuleRequest.Builder, ModifyRuleRequest> {
    private static final SdkField<String> RULE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyRuleRequest::ruleArn)).setter(setter(Builder::ruleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleArn").build()).build();

    private static final SdkField<List<RuleCondition>> CONDITIONS_FIELD = SdkField
            .<List<RuleCondition>> builder(MarshallingType.LIST)
            .getter(getter(ModifyRuleRequest::conditions))
            .setter(setter(Builder::conditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Conditions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RuleCondition> builder(MarshallingType.SDK_POJO)
                                            .constructor(RuleCondition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Action>> ACTIONS_FIELD = SdkField
            .<List<Action>> builder(MarshallingType.LIST)
            .getter(getter(ModifyRuleRequest::actions))
            .setter(setter(Builder::actions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Action> builder(MarshallingType.SDK_POJO)
                                            .constructor(Action::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_ARN_FIELD,
            CONDITIONS_FIELD, ACTIONS_FIELD));

    private final String ruleArn;

    private final List<RuleCondition> conditions;

    private final List<Action> actions;

    private ModifyRuleRequest(BuilderImpl builder) {
        super(builder);
        this.ruleArn = builder.ruleArn;
        this.conditions = builder.conditions;
        this.actions = builder.actions;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the rule.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the rule.
     */
    public String ruleArn() {
        return ruleArn;
    }

    /**
     * <p>
     * The conditions. Each condition specifies a field name and a single value.
     * </p>
     * <p>
     * If the field name is <code>host-header</code>, you can specify a single host name (for example, my.example.com).
     * A host name is case insensitive, can be up to 128 characters in length, and can contain any of the following
     * characters. You can include up to three wildcard characters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * A-Z, a-z, 0-9
     * </p>
     * </li>
     * <li>
     * <p>
     * - .
     * </p>
     * </li>
     * <li>
     * <p>
     * * (matches 0 or more characters)
     * </p>
     * </li>
     * <li>
     * <p>
     * ? (matches exactly 1 character)
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the field name is <code>path-pattern</code>, you can specify a single path pattern. A path pattern is
     * case-sensitive, can be up to 128 characters in length, and can contain any of the following characters. You can
     * include up to three wildcard characters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * A-Z, a-z, 0-9
     * </p>
     * </li>
     * <li>
     * <p>
     * _ - . $ / ~ " ' @ : +
     * </p>
     * </li>
     * <li>
     * <p>
     * &amp; (using &amp;amp;)
     * </p>
     * </li>
     * <li>
     * <p>
     * * (matches 0 or more characters)
     * </p>
     * </li>
     * <li>
     * <p>
     * ? (matches exactly 1 character)
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The conditions. Each condition specifies a field name and a single value.</p>
     *         <p>
     *         If the field name is <code>host-header</code>, you can specify a single host name (for example,
     *         my.example.com). A host name is case insensitive, can be up to 128 characters in length, and can contain
     *         any of the following characters. You can include up to three wildcard characters.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A-Z, a-z, 0-9
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         - .
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         * (matches 0 or more characters)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ? (matches exactly 1 character)
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If the field name is <code>path-pattern</code>, you can specify a single path pattern. A path pattern is
     *         case-sensitive, can be up to 128 characters in length, and can contain any of the following characters.
     *         You can include up to three wildcard characters.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A-Z, a-z, 0-9
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         _ - . $ / ~ " ' @ : +
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         &amp; (using &amp;amp;)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         * (matches 0 or more characters)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ? (matches exactly 1 character)
     *         </p>
     *         </li>
     */
    public List<RuleCondition> conditions() {
        return conditions;
    }

    /**
     * <p>
     * The actions.
     * </p>
     * <p>
     * If the action type is <code>forward</code>, you specify a target group. The protocol of the target group must be
     * HTTP or HTTPS for an Application Load Balancer or TCP for a Network Load Balancer.
     * </p>
     * <p>
     * [HTTPS listener] If the action type is <code>authenticate-oidc</code>, you authenticate users through an identity
     * provider that is OpenID Connect (OIDC) compliant.
     * </p>
     * <p>
     * [HTTPS listener] If the action type is <code>authenticate-cognito</code>, you authenticate users through the user
     * pools supported by Amazon Cognito.
     * </p>
     * <p>
     * [Application Load Balancer] If the action type is <code>redirect</code>, you redirect specified client requests
     * from one URL to another.
     * </p>
     * <p>
     * [Application Load Balancer] If the action type is <code>fixed-response</code>, you drop specified client requests
     * and return a custom HTTP response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The actions.</p>
     *         <p>
     *         If the action type is <code>forward</code>, you specify a target group. The protocol of the target group
     *         must be HTTP or HTTPS for an Application Load Balancer or TCP for a Network Load Balancer.
     *         </p>
     *         <p>
     *         [HTTPS listener] If the action type is <code>authenticate-oidc</code>, you authenticate users through an
     *         identity provider that is OpenID Connect (OIDC) compliant.
     *         </p>
     *         <p>
     *         [HTTPS listener] If the action type is <code>authenticate-cognito</code>, you authenticate users through
     *         the user pools supported by Amazon Cognito.
     *         </p>
     *         <p>
     *         [Application Load Balancer] If the action type is <code>redirect</code>, you redirect specified client
     *         requests from one URL to another.
     *         </p>
     *         <p>
     *         [Application Load Balancer] If the action type is <code>fixed-response</code>, you drop specified client
     *         requests and return a custom HTTP response.
     */
    public List<Action> actions() {
        return actions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ruleArn());
        hashCode = 31 * hashCode + Objects.hashCode(conditions());
        hashCode = 31 * hashCode + Objects.hashCode(actions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyRuleRequest)) {
            return false;
        }
        ModifyRuleRequest other = (ModifyRuleRequest) obj;
        return Objects.equals(ruleArn(), other.ruleArn()) && Objects.equals(conditions(), other.conditions())
                && Objects.equals(actions(), other.actions());
    }

    @Override
    public String toString() {
        return ToString.builder("ModifyRuleRequest").add("RuleArn", ruleArn()).add("Conditions", conditions())
                .add("Actions", actions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleArn":
            return Optional.ofNullable(clazz.cast(ruleArn()));
        case "Conditions":
            return Optional.ofNullable(clazz.cast(conditions()));
        case "Actions":
            return Optional.ofNullable(clazz.cast(actions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyRuleRequest, T> g) {
        return obj -> g.apply((ModifyRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticLoadBalancingV2Request.Builder, SdkPojo, CopyableBuilder<Builder, ModifyRuleRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the rule.
         * </p>
         * 
         * @param ruleArn
         *        The Amazon Resource Name (ARN) of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleArn(String ruleArn);

        /**
         * <p>
         * The conditions. Each condition specifies a field name and a single value.
         * </p>
         * <p>
         * If the field name is <code>host-header</code>, you can specify a single host name (for example,
         * my.example.com). A host name is case insensitive, can be up to 128 characters in length, and can contain any
         * of the following characters. You can include up to three wildcard characters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * A-Z, a-z, 0-9
         * </p>
         * </li>
         * <li>
         * <p>
         * - .
         * </p>
         * </li>
         * <li>
         * <p>
         * * (matches 0 or more characters)
         * </p>
         * </li>
         * <li>
         * <p>
         * ? (matches exactly 1 character)
         * </p>
         * </li>
         * </ul>
         * <p>
         * If the field name is <code>path-pattern</code>, you can specify a single path pattern. A path pattern is
         * case-sensitive, can be up to 128 characters in length, and can contain any of the following characters. You
         * can include up to three wildcard characters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * A-Z, a-z, 0-9
         * </p>
         * </li>
         * <li>
         * <p>
         * _ - . $ / ~ " ' @ : +
         * </p>
         * </li>
         * <li>
         * <p>
         * &amp; (using &amp;amp;)
         * </p>
         * </li>
         * <li>
         * <p>
         * * (matches 0 or more characters)
         * </p>
         * </li>
         * <li>
         * <p>
         * ? (matches exactly 1 character)
         * </p>
         * </li>
         * </ul>
         * 
         * @param conditions
         *        The conditions. Each condition specifies a field name and a single value.</p>
         *        <p>
         *        If the field name is <code>host-header</code>, you can specify a single host name (for example,
         *        my.example.com). A host name is case insensitive, can be up to 128 characters in length, and can
         *        contain any of the following characters. You can include up to three wildcard characters.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A-Z, a-z, 0-9
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        - .
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        * (matches 0 or more characters)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ? (matches exactly 1 character)
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If the field name is <code>path-pattern</code>, you can specify a single path pattern. A path pattern
         *        is case-sensitive, can be up to 128 characters in length, and can contain any of the following
         *        characters. You can include up to three wildcard characters.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A-Z, a-z, 0-9
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        _ - . $ / ~ " ' @ : +
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        &amp; (using &amp;amp;)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        * (matches 0 or more characters)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ? (matches exactly 1 character)
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditions(Collection<RuleCondition> conditions);

        /**
         * <p>
         * The conditions. Each condition specifies a field name and a single value.
         * </p>
         * <p>
         * If the field name is <code>host-header</code>, you can specify a single host name (for example,
         * my.example.com). A host name is case insensitive, can be up to 128 characters in length, and can contain any
         * of the following characters. You can include up to three wildcard characters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * A-Z, a-z, 0-9
         * </p>
         * </li>
         * <li>
         * <p>
         * - .
         * </p>
         * </li>
         * <li>
         * <p>
         * * (matches 0 or more characters)
         * </p>
         * </li>
         * <li>
         * <p>
         * ? (matches exactly 1 character)
         * </p>
         * </li>
         * </ul>
         * <p>
         * If the field name is <code>path-pattern</code>, you can specify a single path pattern. A path pattern is
         * case-sensitive, can be up to 128 characters in length, and can contain any of the following characters. You
         * can include up to three wildcard characters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * A-Z, a-z, 0-9
         * </p>
         * </li>
         * <li>
         * <p>
         * _ - . $ / ~ " ' @ : +
         * </p>
         * </li>
         * <li>
         * <p>
         * &amp; (using &amp;amp;)
         * </p>
         * </li>
         * <li>
         * <p>
         * * (matches 0 or more characters)
         * </p>
         * </li>
         * <li>
         * <p>
         * ? (matches exactly 1 character)
         * </p>
         * </li>
         * </ul>
         * 
         * @param conditions
         *        The conditions. Each condition specifies a field name and a single value.</p>
         *        <p>
         *        If the field name is <code>host-header</code>, you can specify a single host name (for example,
         *        my.example.com). A host name is case insensitive, can be up to 128 characters in length, and can
         *        contain any of the following characters. You can include up to three wildcard characters.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A-Z, a-z, 0-9
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        - .
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        * (matches 0 or more characters)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ? (matches exactly 1 character)
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If the field name is <code>path-pattern</code>, you can specify a single path pattern. A path pattern
         *        is case-sensitive, can be up to 128 characters in length, and can contain any of the following
         *        characters. You can include up to three wildcard characters.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A-Z, a-z, 0-9
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        _ - . $ / ~ " ' @ : +
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        &amp; (using &amp;amp;)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        * (matches 0 or more characters)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ? (matches exactly 1 character)
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditions(RuleCondition... conditions);

        /**
         * <p>
         * The conditions. Each condition specifies a field name and a single value.
         * </p>
         * <p>
         * If the field name is <code>host-header</code>, you can specify a single host name (for example,
         * my.example.com). A host name is case insensitive, can be up to 128 characters in length, and can contain any
         * of the following characters. You can include up to three wildcard characters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * A-Z, a-z, 0-9
         * </p>
         * </li>
         * <li>
         * <p>
         * - .
         * </p>
         * </li>
         * <li>
         * <p>
         * * (matches 0 or more characters)
         * </p>
         * </li>
         * <li>
         * <p>
         * ? (matches exactly 1 character)
         * </p>
         * </li>
         * </ul>
         * <p>
         * If the field name is <code>path-pattern</code>, you can specify a single path pattern. A path pattern is
         * case-sensitive, can be up to 128 characters in length, and can contain any of the following characters. You
         * can include up to three wildcard characters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * A-Z, a-z, 0-9
         * </p>
         * </li>
         * <li>
         * <p>
         * _ - . $ / ~ " ' @ : +
         * </p>
         * </li>
         * <li>
         * <p>
         * &amp; (using &amp;amp;)
         * </p>
         * </li>
         * <li>
         * <p>
         * * (matches 0 or more characters)
         * </p>
         * </li>
         * <li>
         * <p>
         * ? (matches exactly 1 character)
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<RuleCondition>.Builder} avoiding the need
         * to create one manually via {@link List<RuleCondition>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RuleCondition>.Builder#build()} is called immediately and
         * its result is passed to {@link #conditions(List<RuleCondition>)}.
         * 
         * @param conditions
         *        a consumer that will call methods on {@link List<RuleCondition>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conditions(List<RuleCondition>)
         */
        Builder conditions(Consumer<RuleCondition.Builder>... conditions);

        /**
         * <p>
         * The actions.
         * </p>
         * <p>
         * If the action type is <code>forward</code>, you specify a target group. The protocol of the target group must
         * be HTTP or HTTPS for an Application Load Balancer or TCP for a Network Load Balancer.
         * </p>
         * <p>
         * [HTTPS listener] If the action type is <code>authenticate-oidc</code>, you authenticate users through an
         * identity provider that is OpenID Connect (OIDC) compliant.
         * </p>
         * <p>
         * [HTTPS listener] If the action type is <code>authenticate-cognito</code>, you authenticate users through the
         * user pools supported by Amazon Cognito.
         * </p>
         * <p>
         * [Application Load Balancer] If the action type is <code>redirect</code>, you redirect specified client
         * requests from one URL to another.
         * </p>
         * <p>
         * [Application Load Balancer] If the action type is <code>fixed-response</code>, you drop specified client
         * requests and return a custom HTTP response.
         * </p>
         * 
         * @param actions
         *        The actions.</p>
         *        <p>
         *        If the action type is <code>forward</code>, you specify a target group. The protocol of the target
         *        group must be HTTP or HTTPS for an Application Load Balancer or TCP for a Network Load Balancer.
         *        </p>
         *        <p>
         *        [HTTPS listener] If the action type is <code>authenticate-oidc</code>, you authenticate users through
         *        an identity provider that is OpenID Connect (OIDC) compliant.
         *        </p>
         *        <p>
         *        [HTTPS listener] If the action type is <code>authenticate-cognito</code>, you authenticate users
         *        through the user pools supported by Amazon Cognito.
         *        </p>
         *        <p>
         *        [Application Load Balancer] If the action type is <code>redirect</code>, you redirect specified client
         *        requests from one URL to another.
         *        </p>
         *        <p>
         *        [Application Load Balancer] If the action type is <code>fixed-response</code>, you drop specified
         *        client requests and return a custom HTTP response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Collection<Action> actions);

        /**
         * <p>
         * The actions.
         * </p>
         * <p>
         * If the action type is <code>forward</code>, you specify a target group. The protocol of the target group must
         * be HTTP or HTTPS for an Application Load Balancer or TCP for a Network Load Balancer.
         * </p>
         * <p>
         * [HTTPS listener] If the action type is <code>authenticate-oidc</code>, you authenticate users through an
         * identity provider that is OpenID Connect (OIDC) compliant.
         * </p>
         * <p>
         * [HTTPS listener] If the action type is <code>authenticate-cognito</code>, you authenticate users through the
         * user pools supported by Amazon Cognito.
         * </p>
         * <p>
         * [Application Load Balancer] If the action type is <code>redirect</code>, you redirect specified client
         * requests from one URL to another.
         * </p>
         * <p>
         * [Application Load Balancer] If the action type is <code>fixed-response</code>, you drop specified client
         * requests and return a custom HTTP response.
         * </p>
         * 
         * @param actions
         *        The actions.</p>
         *        <p>
         *        If the action type is <code>forward</code>, you specify a target group. The protocol of the target
         *        group must be HTTP or HTTPS for an Application Load Balancer or TCP for a Network Load Balancer.
         *        </p>
         *        <p>
         *        [HTTPS listener] If the action type is <code>authenticate-oidc</code>, you authenticate users through
         *        an identity provider that is OpenID Connect (OIDC) compliant.
         *        </p>
         *        <p>
         *        [HTTPS listener] If the action type is <code>authenticate-cognito</code>, you authenticate users
         *        through the user pools supported by Amazon Cognito.
         *        </p>
         *        <p>
         *        [Application Load Balancer] If the action type is <code>redirect</code>, you redirect specified client
         *        requests from one URL to another.
         *        </p>
         *        <p>
         *        [Application Load Balancer] If the action type is <code>fixed-response</code>, you drop specified
         *        client requests and return a custom HTTP response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Action... actions);

        /**
         * <p>
         * The actions.
         * </p>
         * <p>
         * If the action type is <code>forward</code>, you specify a target group. The protocol of the target group must
         * be HTTP or HTTPS for an Application Load Balancer or TCP for a Network Load Balancer.
         * </p>
         * <p>
         * [HTTPS listener] If the action type is <code>authenticate-oidc</code>, you authenticate users through an
         * identity provider that is OpenID Connect (OIDC) compliant.
         * </p>
         * <p>
         * [HTTPS listener] If the action type is <code>authenticate-cognito</code>, you authenticate users through the
         * user pools supported by Amazon Cognito.
         * </p>
         * <p>
         * [Application Load Balancer] If the action type is <code>redirect</code>, you redirect specified client
         * requests from one URL to another.
         * </p>
         * <p>
         * [Application Load Balancer] If the action type is <code>fixed-response</code>, you drop specified client
         * requests and return a custom HTTP response.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Action>.Builder} avoiding the need to
         * create one manually via {@link List<Action>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Action>.Builder#build()} is called immediately and its
         * result is passed to {@link #actions(List<Action>)}.
         * 
         * @param actions
         *        a consumer that will call methods on {@link List<Action>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actions(List<Action>)
         */
        Builder actions(Consumer<Action.Builder>... actions);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticLoadBalancingV2Request.BuilderImpl implements Builder {
        private String ruleArn;

        private List<RuleCondition> conditions = DefaultSdkAutoConstructList.getInstance();

        private List<Action> actions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyRuleRequest model) {
            super(model);
            ruleArn(model.ruleArn);
            conditions(model.conditions);
            actions(model.actions);
        }

        public final String getRuleArn() {
            return ruleArn;
        }

        @Override
        public final Builder ruleArn(String ruleArn) {
            this.ruleArn = ruleArn;
            return this;
        }

        public final void setRuleArn(String ruleArn) {
            this.ruleArn = ruleArn;
        }

        public final Collection<RuleCondition.Builder> getConditions() {
            return conditions != null ? conditions.stream().map(RuleCondition::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder conditions(Collection<RuleCondition> conditions) {
            this.conditions = RuleConditionListCopier.copy(conditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(RuleCondition... conditions) {
            conditions(Arrays.asList(conditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(Consumer<RuleCondition.Builder>... conditions) {
            conditions(Stream.of(conditions).map(c -> RuleCondition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setConditions(Collection<RuleCondition.BuilderImpl> conditions) {
            this.conditions = RuleConditionListCopier.copyFromBuilder(conditions);
        }

        public final Collection<Action.Builder> getActions() {
            return actions != null ? actions.stream().map(Action::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder actions(Collection<Action> actions) {
            this.actions = ActionsCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Action... actions) {
            actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<Action.Builder>... actions) {
            actions(Stream.of(actions).map(c -> Action.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setActions(Collection<Action.BuilderImpl> actions) {
            this.actions = ActionsCopier.copyFromBuilder(actions);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyRuleRequest build() {
            return new ModifyRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
