/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a condition for a rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleCondition implements SdkPojo, Serializable, ToCopyableBuilder<RuleCondition.Builder, RuleCondition> {
    private static final SdkField<String> FIELD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RuleCondition::field)).setter(setter(Builder::field))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Field").build()).build();

    private static final SdkField<List<String>> VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(RuleCondition::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_FIELD, VALUES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String field;

    private final List<String> values;

    private RuleCondition(BuilderImpl builder) {
        this.field = builder.field;
        this.values = builder.values;
    }

    /**
     * <p>
     * The name of the field. The possible values are <code>host-header</code> and <code>path-pattern</code>.
     * </p>
     * 
     * @return The name of the field. The possible values are <code>host-header</code> and <code>path-pattern</code>.
     */
    public String field() {
        return field;
    }

    /**
     * <p>
     * The condition value.
     * </p>
     * <p>
     * If the field name is <code>host-header</code>, you can specify a single host name (for example, my.example.com).
     * A host name is case insensitive, can be up to 128 characters in length, and can contain any of the following
     * characters. You can include up to three wildcard characters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * A-Z, a-z, 0-9
     * </p>
     * </li>
     * <li>
     * <p>
     * - .
     * </p>
     * </li>
     * <li>
     * <p>
     * * (matches 0 or more characters)
     * </p>
     * </li>
     * <li>
     * <p>
     * ? (matches exactly 1 character)
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the field name is <code>path-pattern</code>, you can specify a single path pattern (for example, /img/*). A
     * path pattern is case-sensitive, can be up to 128 characters in length, and can contain any of the following
     * characters. You can include up to three wildcard characters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * A-Z, a-z, 0-9
     * </p>
     * </li>
     * <li>
     * <p>
     * _ - . $ / ~ " ' @ : +
     * </p>
     * </li>
     * <li>
     * <p>
     * &amp; (using &amp;amp;)
     * </p>
     * </li>
     * <li>
     * <p>
     * * (matches 0 or more characters)
     * </p>
     * </li>
     * <li>
     * <p>
     * ? (matches exactly 1 character)
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The condition value.</p>
     *         <p>
     *         If the field name is <code>host-header</code>, you can specify a single host name (for example,
     *         my.example.com). A host name is case insensitive, can be up to 128 characters in length, and can contain
     *         any of the following characters. You can include up to three wildcard characters.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A-Z, a-z, 0-9
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         - .
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         * (matches 0 or more characters)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ? (matches exactly 1 character)
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If the field name is <code>path-pattern</code>, you can specify a single path pattern (for example,
     *         /img/*). A path pattern is case-sensitive, can be up to 128 characters in length, and can contain any of
     *         the following characters. You can include up to three wildcard characters.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A-Z, a-z, 0-9
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         _ - . $ / ~ " ' @ : +
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         &amp; (using &amp;amp;)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         * (matches 0 or more characters)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ? (matches exactly 1 character)
     *         </p>
     *         </li>
     */
    public List<String> values() {
        return values;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(field());
        hashCode = 31 * hashCode + Objects.hashCode(values());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleCondition)) {
            return false;
        }
        RuleCondition other = (RuleCondition) obj;
        return Objects.equals(field(), other.field()) && Objects.equals(values(), other.values());
    }

    @Override
    public String toString() {
        return ToString.builder("RuleCondition").add("Field", field()).add("Values", values()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Field":
            return Optional.ofNullable(clazz.cast(field()));
        case "Values":
            return Optional.ofNullable(clazz.cast(values()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuleCondition, T> g) {
        return obj -> g.apply((RuleCondition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleCondition> {
        /**
         * <p>
         * The name of the field. The possible values are <code>host-header</code> and <code>path-pattern</code>.
         * </p>
         * 
         * @param field
         *        The name of the field. The possible values are <code>host-header</code> and <code>path-pattern</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder field(String field);

        /**
         * <p>
         * The condition value.
         * </p>
         * <p>
         * If the field name is <code>host-header</code>, you can specify a single host name (for example,
         * my.example.com). A host name is case insensitive, can be up to 128 characters in length, and can contain any
         * of the following characters. You can include up to three wildcard characters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * A-Z, a-z, 0-9
         * </p>
         * </li>
         * <li>
         * <p>
         * - .
         * </p>
         * </li>
         * <li>
         * <p>
         * * (matches 0 or more characters)
         * </p>
         * </li>
         * <li>
         * <p>
         * ? (matches exactly 1 character)
         * </p>
         * </li>
         * </ul>
         * <p>
         * If the field name is <code>path-pattern</code>, you can specify a single path pattern (for example, /img/*).
         * A path pattern is case-sensitive, can be up to 128 characters in length, and can contain any of the following
         * characters. You can include up to three wildcard characters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * A-Z, a-z, 0-9
         * </p>
         * </li>
         * <li>
         * <p>
         * _ - . $ / ~ " ' @ : +
         * </p>
         * </li>
         * <li>
         * <p>
         * &amp; (using &amp;amp;)
         * </p>
         * </li>
         * <li>
         * <p>
         * * (matches 0 or more characters)
         * </p>
         * </li>
         * <li>
         * <p>
         * ? (matches exactly 1 character)
         * </p>
         * </li>
         * </ul>
         * 
         * @param values
         *        The condition value.</p>
         *        <p>
         *        If the field name is <code>host-header</code>, you can specify a single host name (for example,
         *        my.example.com). A host name is case insensitive, can be up to 128 characters in length, and can
         *        contain any of the following characters. You can include up to three wildcard characters.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A-Z, a-z, 0-9
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        - .
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        * (matches 0 or more characters)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ? (matches exactly 1 character)
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If the field name is <code>path-pattern</code>, you can specify a single path pattern (for example,
         *        /img/*). A path pattern is case-sensitive, can be up to 128 characters in length, and can contain any
         *        of the following characters. You can include up to three wildcard characters.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A-Z, a-z, 0-9
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        _ - . $ / ~ " ' @ : +
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        &amp; (using &amp;amp;)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        * (matches 0 or more characters)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ? (matches exactly 1 character)
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<String> values);

        /**
         * <p>
         * The condition value.
         * </p>
         * <p>
         * If the field name is <code>host-header</code>, you can specify a single host name (for example,
         * my.example.com). A host name is case insensitive, can be up to 128 characters in length, and can contain any
         * of the following characters. You can include up to three wildcard characters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * A-Z, a-z, 0-9
         * </p>
         * </li>
         * <li>
         * <p>
         * - .
         * </p>
         * </li>
         * <li>
         * <p>
         * * (matches 0 or more characters)
         * </p>
         * </li>
         * <li>
         * <p>
         * ? (matches exactly 1 character)
         * </p>
         * </li>
         * </ul>
         * <p>
         * If the field name is <code>path-pattern</code>, you can specify a single path pattern (for example, /img/*).
         * A path pattern is case-sensitive, can be up to 128 characters in length, and can contain any of the following
         * characters. You can include up to three wildcard characters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * A-Z, a-z, 0-9
         * </p>
         * </li>
         * <li>
         * <p>
         * _ - . $ / ~ " ' @ : +
         * </p>
         * </li>
         * <li>
         * <p>
         * &amp; (using &amp;amp;)
         * </p>
         * </li>
         * <li>
         * <p>
         * * (matches 0 or more characters)
         * </p>
         * </li>
         * <li>
         * <p>
         * ? (matches exactly 1 character)
         * </p>
         * </li>
         * </ul>
         * 
         * @param values
         *        The condition value.</p>
         *        <p>
         *        If the field name is <code>host-header</code>, you can specify a single host name (for example,
         *        my.example.com). A host name is case insensitive, can be up to 128 characters in length, and can
         *        contain any of the following characters. You can include up to three wildcard characters.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A-Z, a-z, 0-9
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        - .
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        * (matches 0 or more characters)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ? (matches exactly 1 character)
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If the field name is <code>path-pattern</code>, you can specify a single path pattern (for example,
         *        /img/*). A path pattern is case-sensitive, can be up to 128 characters in length, and can contain any
         *        of the following characters. You can include up to three wildcard characters.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A-Z, a-z, 0-9
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        _ - . $ / ~ " ' @ : +
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        &amp; (using &amp;amp;)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        * (matches 0 or more characters)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ? (matches exactly 1 character)
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(String... values);
    }

    static final class BuilderImpl implements Builder {
        private String field;

        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RuleCondition model) {
            field(model.field);
            values(model.values);
        }

        public final String getField() {
            return field;
        }

        @Override
        public final Builder field(String field) {
            this.field = field;
            return this;
        }

        public final void setField(String field) {
            this.field = field;
        }

        public final Collection<String> getValues() {
            return values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = ListOfStringCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String... values) {
            values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = ListOfStringCopier.copy(values);
        }

        @Override
        public RuleCondition build() {
            return new RuleCondition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
