/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a target group attribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TargetGroupAttribute implements SdkPojo, Serializable,
        ToCopyableBuilder<TargetGroupAttribute.Builder, TargetGroupAttribute> {
    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TargetGroupAttribute::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TargetGroupAttribute::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String key;

    private final String value;

    private TargetGroupAttribute(BuilderImpl builder) {
        this.key = builder.key;
        this.value = builder.value;
    }

    /**
     * <p>
     * The name of the attribute.
     * </p>
     * <p>
     * The following attribute is supported by both Application Load Balancers and Network Load Balancers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>deregistration_delay.timeout_seconds</code> - The amount of time, in seconds, for Elastic Load Balancing to
     * wait before changing the state of a deregistering target from <code>draining</code> to <code>unused</code>. The
     * range is 0-3600 seconds. The default value is 300 seconds. If the target is a Lambda function, this attribute is
     * not supported.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following attributes are supported by Application Load Balancers if the target is not a Lambda function:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>slow_start.duration_seconds</code> - The time period, in seconds, during which a newly registered target
     * receives a linearly increasing share of the traffic to the target group. After this time period ends, the target
     * receives its full share of traffic. The range is 30-900 seconds (15 minutes). Slow start mode is disabled by
     * default.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>stickiness.enabled</code> - Indicates whether sticky sessions are enabled. The value is <code>true</code>
     * or <code>false</code>. The default is <code>false</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>stickiness.type</code> - The type of sticky sessions. The possible value is <code>lb_cookie</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>stickiness.lb_cookie.duration_seconds</code> - The time period, in seconds, during which requests from a
     * client should be routed to the same target. After this time period expires, the load balancer-generated cookie is
     * considered stale. The range is 1 second to 1 week (604800 seconds). The default value is 1 day (86400 seconds).
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following attribute is supported only if the target is a Lambda function.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>lambda.multi_value_headers.enabled</code> - Indicates whether the request and response headers exchanged
     * between the load balancer and the Lambda function include arrays of values or strings. The value is
     * <code>true</code> or <code>false</code>. The default is <code>false</code>. If the value is <code>false</code>
     * and the request contains a duplicate header field name or query parameter key, the load balancer uses the last
     * value sent by the client.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following attribute is supported only by Network Load Balancers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>proxy_protocol_v2.enabled</code> - Indicates whether Proxy Protocol version 2 is enabled. The value is
     * <code>true</code> or <code>false</code>. The default is <code>false</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the attribute.</p>
     *         <p>
     *         The following attribute is supported by both Application Load Balancers and Network Load Balancers:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>deregistration_delay.timeout_seconds</code> - The amount of time, in seconds, for Elastic Load
     *         Balancing to wait before changing the state of a deregistering target from <code>draining</code> to
     *         <code>unused</code>. The range is 0-3600 seconds. The default value is 300 seconds. If the target is a
     *         Lambda function, this attribute is not supported.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The following attributes are supported by Application Load Balancers if the target is not a Lambda
     *         function:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>slow_start.duration_seconds</code> - The time period, in seconds, during which a newly registered
     *         target receives a linearly increasing share of the traffic to the target group. After this time period
     *         ends, the target receives its full share of traffic. The range is 30-900 seconds (15 minutes). Slow start
     *         mode is disabled by default.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>stickiness.enabled</code> - Indicates whether sticky sessions are enabled. The value is
     *         <code>true</code> or <code>false</code>. The default is <code>false</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>stickiness.type</code> - The type of sticky sessions. The possible value is <code>lb_cookie</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>stickiness.lb_cookie.duration_seconds</code> - The time period, in seconds, during which requests
     *         from a client should be routed to the same target. After this time period expires, the load
     *         balancer-generated cookie is considered stale. The range is 1 second to 1 week (604800 seconds). The
     *         default value is 1 day (86400 seconds).
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The following attribute is supported only if the target is a Lambda function.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>lambda.multi_value_headers.enabled</code> - Indicates whether the request and response headers
     *         exchanged between the load balancer and the Lambda function include arrays of values or strings. The
     *         value is <code>true</code> or <code>false</code>. The default is <code>false</code>. If the value is
     *         <code>false</code> and the request contains a duplicate header field name or query parameter key, the
     *         load balancer uses the last value sent by the client.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The following attribute is supported only by Network Load Balancers:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>proxy_protocol_v2.enabled</code> - Indicates whether Proxy Protocol version 2 is enabled. The value
     *         is <code>true</code> or <code>false</code>. The default is <code>false</code>.
     *         </p>
     *         </li>
     */
    public String key() {
        return key;
    }

    /**
     * <p>
     * The value of the attribute.
     * </p>
     * 
     * @return The value of the attribute.
     */
    public String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetGroupAttribute)) {
            return false;
        }
        TargetGroupAttribute other = (TargetGroupAttribute) obj;
        return Objects.equals(key(), other.key()) && Objects.equals(value(), other.value());
    }

    @Override
    public String toString() {
        return ToString.builder("TargetGroupAttribute").add("Key", key()).add("Value", value()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TargetGroupAttribute, T> g) {
        return obj -> g.apply((TargetGroupAttribute) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TargetGroupAttribute> {
        /**
         * <p>
         * The name of the attribute.
         * </p>
         * <p>
         * The following attribute is supported by both Application Load Balancers and Network Load Balancers:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>deregistration_delay.timeout_seconds</code> - The amount of time, in seconds, for Elastic Load
         * Balancing to wait before changing the state of a deregistering target from <code>draining</code> to
         * <code>unused</code>. The range is 0-3600 seconds. The default value is 300 seconds. If the target is a Lambda
         * function, this attribute is not supported.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The following attributes are supported by Application Load Balancers if the target is not a Lambda function:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>slow_start.duration_seconds</code> - The time period, in seconds, during which a newly registered
         * target receives a linearly increasing share of the traffic to the target group. After this time period ends,
         * the target receives its full share of traffic. The range is 30-900 seconds (15 minutes). Slow start mode is
         * disabled by default.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>stickiness.enabled</code> - Indicates whether sticky sessions are enabled. The value is
         * <code>true</code> or <code>false</code>. The default is <code>false</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>stickiness.type</code> - The type of sticky sessions. The possible value is <code>lb_cookie</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>stickiness.lb_cookie.duration_seconds</code> - The time period, in seconds, during which requests from
         * a client should be routed to the same target. After this time period expires, the load balancer-generated
         * cookie is considered stale. The range is 1 second to 1 week (604800 seconds). The default value is 1 day
         * (86400 seconds).
         * </p>
         * </li>
         * </ul>
         * <p>
         * The following attribute is supported only if the target is a Lambda function.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>lambda.multi_value_headers.enabled</code> - Indicates whether the request and response headers
         * exchanged between the load balancer and the Lambda function include arrays of values or strings. The value is
         * <code>true</code> or <code>false</code>. The default is <code>false</code>. If the value is
         * <code>false</code> and the request contains a duplicate header field name or query parameter key, the load
         * balancer uses the last value sent by the client.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The following attribute is supported only by Network Load Balancers:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>proxy_protocol_v2.enabled</code> - Indicates whether Proxy Protocol version 2 is enabled. The value is
         * <code>true</code> or <code>false</code>. The default is <code>false</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param key
         *        The name of the attribute.</p>
         *        <p>
         *        The following attribute is supported by both Application Load Balancers and Network Load Balancers:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>deregistration_delay.timeout_seconds</code> - The amount of time, in seconds, for Elastic Load
         *        Balancing to wait before changing the state of a deregistering target from <code>draining</code> to
         *        <code>unused</code>. The range is 0-3600 seconds. The default value is 300 seconds. If the target is a
         *        Lambda function, this attribute is not supported.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The following attributes are supported by Application Load Balancers if the target is not a Lambda
         *        function:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>slow_start.duration_seconds</code> - The time period, in seconds, during which a newly
         *        registered target receives a linearly increasing share of the traffic to the target group. After this
         *        time period ends, the target receives its full share of traffic. The range is 30-900 seconds (15
         *        minutes). Slow start mode is disabled by default.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>stickiness.enabled</code> - Indicates whether sticky sessions are enabled. The value is
         *        <code>true</code> or <code>false</code>. The default is <code>false</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>stickiness.type</code> - The type of sticky sessions. The possible value is
         *        <code>lb_cookie</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>stickiness.lb_cookie.duration_seconds</code> - The time period, in seconds, during which
         *        requests from a client should be routed to the same target. After this time period expires, the load
         *        balancer-generated cookie is considered stale. The range is 1 second to 1 week (604800 seconds). The
         *        default value is 1 day (86400 seconds).
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The following attribute is supported only if the target is a Lambda function.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>lambda.multi_value_headers.enabled</code> - Indicates whether the request and response headers
         *        exchanged between the load balancer and the Lambda function include arrays of values or strings. The
         *        value is <code>true</code> or <code>false</code>. The default is <code>false</code>. If the value is
         *        <code>false</code> and the request contains a duplicate header field name or query parameter key, the
         *        load balancer uses the last value sent by the client.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The following attribute is supported only by Network Load Balancers:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>proxy_protocol_v2.enabled</code> - Indicates whether Proxy Protocol version 2 is enabled. The
         *        value is <code>true</code> or <code>false</code>. The default is <code>false</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * The value of the attribute.
         * </p>
         * 
         * @param value
         *        The value of the attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetGroupAttribute model) {
            key(model.key);
            value(model.value);
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public TargetGroupAttribute build() {
            return new TargetGroupAttribute(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
