/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticloadbalancingv2.ElasticLoadBalancingV2Client;
import software.amazon.awssdk.services.elasticloadbalancingv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Certificate;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenerCertificatesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenerCertificatesResponse;

public class DescribeListenerCertificatesIterable
implements SdkIterable<DescribeListenerCertificatesResponse> {
    private final ElasticLoadBalancingV2Client client;
    private final DescribeListenerCertificatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeListenerCertificatesIterable(ElasticLoadBalancingV2Client client, DescribeListenerCertificatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeListenerCertificatesResponseFetcher();
    }

    public Iterator<DescribeListenerCertificatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Certificate> certificates() {
        Function<DescribeListenerCertificatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.certificates() != null) {
                return response.certificates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeListenerCertificatesResponseFetcher
    implements SyncPageFetcher<DescribeListenerCertificatesResponse> {
        private DescribeListenerCertificatesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeListenerCertificatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public DescribeListenerCertificatesResponse nextPage(DescribeListenerCertificatesResponse previousPage) {
            if (previousPage == null) {
                return DescribeListenerCertificatesIterable.this.client.describeListenerCertificates(DescribeListenerCertificatesIterable.this.firstRequest);
            }
            return DescribeListenerCertificatesIterable.this.client.describeListenerCertificates((DescribeListenerCertificatesRequest)((Object)DescribeListenerCertificatesIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

