/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the mutual authentication attributes of a listener.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MutualAuthenticationAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<MutualAuthenticationAttributes.Builder, MutualAuthenticationAttributes> {
    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Mode")
            .getter(getter(MutualAuthenticationAttributes::mode)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()).build();

    private static final SdkField<String> TRUST_STORE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrustStoreArn").getter(getter(MutualAuthenticationAttributes::trustStoreArn))
            .setter(setter(Builder::trustStoreArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustStoreArn").build()).build();

    private static final SdkField<Boolean> IGNORE_CLIENT_CERTIFICATE_EXPIRY_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IgnoreClientCertificateExpiry")
            .getter(getter(MutualAuthenticationAttributes::ignoreClientCertificateExpiry))
            .setter(setter(Builder::ignoreClientCertificateExpiry))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IgnoreClientCertificateExpiry")
                    .build()).build();

    private static final SdkField<String> TRUST_STORE_ASSOCIATION_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TrustStoreAssociationStatus")
            .getter(getter(MutualAuthenticationAttributes::trustStoreAssociationStatusAsString))
            .setter(setter(Builder::trustStoreAssociationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustStoreAssociationStatus")
                    .build()).build();

    private static final SdkField<String> ADVERTISE_TRUST_STORE_CA_NAMES_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AdvertiseTrustStoreCaNames")
            .getter(getter(MutualAuthenticationAttributes::advertiseTrustStoreCaNamesAsString))
            .setter(setter(Builder::advertiseTrustStoreCaNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvertiseTrustStoreCaNames").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODE_FIELD,
            TRUST_STORE_ARN_FIELD, IGNORE_CLIENT_CERTIFICATE_EXPIRY_FIELD, TRUST_STORE_ASSOCIATION_STATUS_FIELD,
            ADVERTISE_TRUST_STORE_CA_NAMES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String mode;

    private final String trustStoreArn;

    private final Boolean ignoreClientCertificateExpiry;

    private final String trustStoreAssociationStatus;

    private final String advertiseTrustStoreCaNames;

    private MutualAuthenticationAttributes(BuilderImpl builder) {
        this.mode = builder.mode;
        this.trustStoreArn = builder.trustStoreArn;
        this.ignoreClientCertificateExpiry = builder.ignoreClientCertificateExpiry;
        this.trustStoreAssociationStatus = builder.trustStoreAssociationStatus;
        this.advertiseTrustStoreCaNames = builder.advertiseTrustStoreCaNames;
    }

    /**
     * <p>
     * The client certificate handling method. Options are <code>off</code>, <code>passthrough</code> or
     * <code>verify</code>. The default value is <code>off</code>.
     * </p>
     * 
     * @return The client certificate handling method. Options are <code>off</code>, <code>passthrough</code> or
     *         <code>verify</code>. The default value is <code>off</code>.
     */
    public final String mode() {
        return mode;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the trust store.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the trust store.
     */
    public final String trustStoreArn() {
        return trustStoreArn;
    }

    /**
     * <p>
     * Indicates whether expired client certificates are ignored.
     * </p>
     * 
     * @return Indicates whether expired client certificates are ignored.
     */
    public final Boolean ignoreClientCertificateExpiry() {
        return ignoreClientCertificateExpiry;
    }

    /**
     * <p>
     * Indicates a shared trust stores association status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #trustStoreAssociationStatus} will return {@link TrustStoreAssociationStatusEnum#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #trustStoreAssociationStatusAsString}.
     * </p>
     * 
     * @return Indicates a shared trust stores association status.
     * @see TrustStoreAssociationStatusEnum
     */
    public final TrustStoreAssociationStatusEnum trustStoreAssociationStatus() {
        return TrustStoreAssociationStatusEnum.fromValue(trustStoreAssociationStatus);
    }

    /**
     * <p>
     * Indicates a shared trust stores association status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #trustStoreAssociationStatus} will return {@link TrustStoreAssociationStatusEnum#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #trustStoreAssociationStatusAsString}.
     * </p>
     * 
     * @return Indicates a shared trust stores association status.
     * @see TrustStoreAssociationStatusEnum
     */
    public final String trustStoreAssociationStatusAsString() {
        return trustStoreAssociationStatus;
    }

    /**
     * <p>
     * Indicates whether trust store CA certificate names are advertised.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #advertiseTrustStoreCaNames} will return {@link AdvertiseTrustStoreCaNamesEnum#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #advertiseTrustStoreCaNamesAsString}.
     * </p>
     * 
     * @return Indicates whether trust store CA certificate names are advertised.
     * @see AdvertiseTrustStoreCaNamesEnum
     */
    public final AdvertiseTrustStoreCaNamesEnum advertiseTrustStoreCaNames() {
        return AdvertiseTrustStoreCaNamesEnum.fromValue(advertiseTrustStoreCaNames);
    }

    /**
     * <p>
     * Indicates whether trust store CA certificate names are advertised.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #advertiseTrustStoreCaNames} will return {@link AdvertiseTrustStoreCaNamesEnum#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #advertiseTrustStoreCaNamesAsString}.
     * </p>
     * 
     * @return Indicates whether trust store CA certificate names are advertised.
     * @see AdvertiseTrustStoreCaNamesEnum
     */
    public final String advertiseTrustStoreCaNamesAsString() {
        return advertiseTrustStoreCaNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mode());
        hashCode = 31 * hashCode + Objects.hashCode(trustStoreArn());
        hashCode = 31 * hashCode + Objects.hashCode(ignoreClientCertificateExpiry());
        hashCode = 31 * hashCode + Objects.hashCode(trustStoreAssociationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(advertiseTrustStoreCaNamesAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MutualAuthenticationAttributes)) {
            return false;
        }
        MutualAuthenticationAttributes other = (MutualAuthenticationAttributes) obj;
        return Objects.equals(mode(), other.mode()) && Objects.equals(trustStoreArn(), other.trustStoreArn())
                && Objects.equals(ignoreClientCertificateExpiry(), other.ignoreClientCertificateExpiry())
                && Objects.equals(trustStoreAssociationStatusAsString(), other.trustStoreAssociationStatusAsString())
                && Objects.equals(advertiseTrustStoreCaNamesAsString(), other.advertiseTrustStoreCaNamesAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MutualAuthenticationAttributes").add("Mode", mode()).add("TrustStoreArn", trustStoreArn())
                .add("IgnoreClientCertificateExpiry", ignoreClientCertificateExpiry())
                .add("TrustStoreAssociationStatus", trustStoreAssociationStatusAsString())
                .add("AdvertiseTrustStoreCaNames", advertiseTrustStoreCaNamesAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Mode":
            return Optional.ofNullable(clazz.cast(mode()));
        case "TrustStoreArn":
            return Optional.ofNullable(clazz.cast(trustStoreArn()));
        case "IgnoreClientCertificateExpiry":
            return Optional.ofNullable(clazz.cast(ignoreClientCertificateExpiry()));
        case "TrustStoreAssociationStatus":
            return Optional.ofNullable(clazz.cast(trustStoreAssociationStatusAsString()));
        case "AdvertiseTrustStoreCaNames":
            return Optional.ofNullable(clazz.cast(advertiseTrustStoreCaNamesAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Mode", MODE_FIELD);
        map.put("TrustStoreArn", TRUST_STORE_ARN_FIELD);
        map.put("IgnoreClientCertificateExpiry", IGNORE_CLIENT_CERTIFICATE_EXPIRY_FIELD);
        map.put("TrustStoreAssociationStatus", TRUST_STORE_ASSOCIATION_STATUS_FIELD);
        map.put("AdvertiseTrustStoreCaNames", ADVERTISE_TRUST_STORE_CA_NAMES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MutualAuthenticationAttributes, T> g) {
        return obj -> g.apply((MutualAuthenticationAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MutualAuthenticationAttributes> {
        /**
         * <p>
         * The client certificate handling method. Options are <code>off</code>, <code>passthrough</code> or
         * <code>verify</code>. The default value is <code>off</code>.
         * </p>
         * 
         * @param mode
         *        The client certificate handling method. Options are <code>off</code>, <code>passthrough</code> or
         *        <code>verify</code>. The default value is <code>off</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mode(String mode);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the trust store.
         * </p>
         * 
         * @param trustStoreArn
         *        The Amazon Resource Name (ARN) of the trust store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustStoreArn(String trustStoreArn);

        /**
         * <p>
         * Indicates whether expired client certificates are ignored.
         * </p>
         * 
         * @param ignoreClientCertificateExpiry
         *        Indicates whether expired client certificates are ignored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ignoreClientCertificateExpiry(Boolean ignoreClientCertificateExpiry);

        /**
         * <p>
         * Indicates a shared trust stores association status.
         * </p>
         * 
         * @param trustStoreAssociationStatus
         *        Indicates a shared trust stores association status.
         * @see TrustStoreAssociationStatusEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrustStoreAssociationStatusEnum
         */
        Builder trustStoreAssociationStatus(String trustStoreAssociationStatus);

        /**
         * <p>
         * Indicates a shared trust stores association status.
         * </p>
         * 
         * @param trustStoreAssociationStatus
         *        Indicates a shared trust stores association status.
         * @see TrustStoreAssociationStatusEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrustStoreAssociationStatusEnum
         */
        Builder trustStoreAssociationStatus(TrustStoreAssociationStatusEnum trustStoreAssociationStatus);

        /**
         * <p>
         * Indicates whether trust store CA certificate names are advertised.
         * </p>
         * 
         * @param advertiseTrustStoreCaNames
         *        Indicates whether trust store CA certificate names are advertised.
         * @see AdvertiseTrustStoreCaNamesEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AdvertiseTrustStoreCaNamesEnum
         */
        Builder advertiseTrustStoreCaNames(String advertiseTrustStoreCaNames);

        /**
         * <p>
         * Indicates whether trust store CA certificate names are advertised.
         * </p>
         * 
         * @param advertiseTrustStoreCaNames
         *        Indicates whether trust store CA certificate names are advertised.
         * @see AdvertiseTrustStoreCaNamesEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AdvertiseTrustStoreCaNamesEnum
         */
        Builder advertiseTrustStoreCaNames(AdvertiseTrustStoreCaNamesEnum advertiseTrustStoreCaNames);
    }

    static final class BuilderImpl implements Builder {
        private String mode;

        private String trustStoreArn;

        private Boolean ignoreClientCertificateExpiry;

        private String trustStoreAssociationStatus;

        private String advertiseTrustStoreCaNames;

        private BuilderImpl() {
        }

        private BuilderImpl(MutualAuthenticationAttributes model) {
            mode(model.mode);
            trustStoreArn(model.trustStoreArn);
            ignoreClientCertificateExpiry(model.ignoreClientCertificateExpiry);
            trustStoreAssociationStatus(model.trustStoreAssociationStatus);
            advertiseTrustStoreCaNames(model.advertiseTrustStoreCaNames);
        }

        public final String getMode() {
            return mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        public final String getTrustStoreArn() {
            return trustStoreArn;
        }

        public final void setTrustStoreArn(String trustStoreArn) {
            this.trustStoreArn = trustStoreArn;
        }

        @Override
        public final Builder trustStoreArn(String trustStoreArn) {
            this.trustStoreArn = trustStoreArn;
            return this;
        }

        public final Boolean getIgnoreClientCertificateExpiry() {
            return ignoreClientCertificateExpiry;
        }

        public final void setIgnoreClientCertificateExpiry(Boolean ignoreClientCertificateExpiry) {
            this.ignoreClientCertificateExpiry = ignoreClientCertificateExpiry;
        }

        @Override
        public final Builder ignoreClientCertificateExpiry(Boolean ignoreClientCertificateExpiry) {
            this.ignoreClientCertificateExpiry = ignoreClientCertificateExpiry;
            return this;
        }

        public final String getTrustStoreAssociationStatus() {
            return trustStoreAssociationStatus;
        }

        public final void setTrustStoreAssociationStatus(String trustStoreAssociationStatus) {
            this.trustStoreAssociationStatus = trustStoreAssociationStatus;
        }

        @Override
        public final Builder trustStoreAssociationStatus(String trustStoreAssociationStatus) {
            this.trustStoreAssociationStatus = trustStoreAssociationStatus;
            return this;
        }

        @Override
        public final Builder trustStoreAssociationStatus(TrustStoreAssociationStatusEnum trustStoreAssociationStatus) {
            this.trustStoreAssociationStatus(trustStoreAssociationStatus == null ? null : trustStoreAssociationStatus.toString());
            return this;
        }

        public final String getAdvertiseTrustStoreCaNames() {
            return advertiseTrustStoreCaNames;
        }

        public final void setAdvertiseTrustStoreCaNames(String advertiseTrustStoreCaNames) {
            this.advertiseTrustStoreCaNames = advertiseTrustStoreCaNames;
        }

        @Override
        public final Builder advertiseTrustStoreCaNames(String advertiseTrustStoreCaNames) {
            this.advertiseTrustStoreCaNames = advertiseTrustStoreCaNames;
            return this;
        }

        @Override
        public final Builder advertiseTrustStoreCaNames(AdvertiseTrustStoreCaNamesEnum advertiseTrustStoreCaNames) {
            this.advertiseTrustStoreCaNames(advertiseTrustStoreCaNames == null ? null : advertiseTrustStoreCaNames.toString());
            return this;
        }

        @Override
        public MutualAuthenticationAttributes build() {
            return new MutualAuthenticationAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
