/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an Elastic Load Balancing resource limit for your AWS account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Limit implements SdkPojo, Serializable, ToCopyableBuilder<Limit.Builder, Limit> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Limit::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> MAX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Limit::max)).setter(setter(Builder::max))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Max").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, MAX_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String max;

    private Limit(BuilderImpl builder) {
        this.name = builder.name;
        this.max = builder.max;
    }

    /**
     * <p>
     * The name of the limit. The possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * application-load-balancers
     * </p>
     * </li>
     * <li>
     * <p>
     * listeners-per-application-load-balancer
     * </p>
     * </li>
     * <li>
     * <p>
     * listeners-per-network-load-balancer
     * </p>
     * </li>
     * <li>
     * <p>
     * network-load-balancers
     * </p>
     * </li>
     * <li>
     * <p>
     * rules-per-application-load-balancer
     * </p>
     * </li>
     * <li>
     * <p>
     * target-groups
     * </p>
     * </li>
     * <li>
     * <p>
     * targets-per-application-load-balancer
     * </p>
     * </li>
     * <li>
     * <p>
     * targets-per-availability-zone-per-network-load-balancer
     * </p>
     * </li>
     * <li>
     * <p>
     * targets-per-network-load-balancer
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the limit. The possible values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         application-load-balancers
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         listeners-per-application-load-balancer
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         listeners-per-network-load-balancer
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         network-load-balancers
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         rules-per-application-load-balancer
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         target-groups
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         targets-per-application-load-balancer
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         targets-per-availability-zone-per-network-load-balancer
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         targets-per-network-load-balancer
     *         </p>
     *         </li>
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The maximum value of the limit.
     * </p>
     * 
     * @return The maximum value of the limit.
     */
    public String max() {
        return max;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(max());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Limit)) {
            return false;
        }
        Limit other = (Limit) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(max(), other.max());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Limit").add("Name", name()).add("Max", max()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Max":
            return Optional.ofNullable(clazz.cast(max()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Limit, T> g) {
        return obj -> g.apply((Limit) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Limit> {
        /**
         * <p>
         * The name of the limit. The possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * application-load-balancers
         * </p>
         * </li>
         * <li>
         * <p>
         * listeners-per-application-load-balancer
         * </p>
         * </li>
         * <li>
         * <p>
         * listeners-per-network-load-balancer
         * </p>
         * </li>
         * <li>
         * <p>
         * network-load-balancers
         * </p>
         * </li>
         * <li>
         * <p>
         * rules-per-application-load-balancer
         * </p>
         * </li>
         * <li>
         * <p>
         * target-groups
         * </p>
         * </li>
         * <li>
         * <p>
         * targets-per-application-load-balancer
         * </p>
         * </li>
         * <li>
         * <p>
         * targets-per-availability-zone-per-network-load-balancer
         * </p>
         * </li>
         * <li>
         * <p>
         * targets-per-network-load-balancer
         * </p>
         * </li>
         * </ul>
         * 
         * @param name
         *        The name of the limit. The possible values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        application-load-balancers
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        listeners-per-application-load-balancer
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        listeners-per-network-load-balancer
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        network-load-balancers
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        rules-per-application-load-balancer
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        target-groups
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        targets-per-application-load-balancer
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        targets-per-availability-zone-per-network-load-balancer
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        targets-per-network-load-balancer
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The maximum value of the limit.
         * </p>
         * 
         * @param max
         *        The maximum value of the limit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder max(String max);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String max;

        private BuilderImpl() {
        }

        private BuilderImpl(Limit model) {
            name(model.name);
            max(model.max);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getMax() {
            return max;
        }

        @Override
        public final Builder max(String max) {
            this.max = max;
            return this;
        }

        public final void setMax(String max) {
            this.max = max;
        }

        @Override
        public Limit build() {
            return new Limit(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
