/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a target group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TargetGroup implements SdkPojo, Serializable, ToCopyableBuilder<TargetGroup.Builder, TargetGroup> {
    private static final SdkField<String> TARGET_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TargetGroup::targetGroupArn)).setter(setter(Builder::targetGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetGroupArn").build()).build();

    private static final SdkField<String> TARGET_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TargetGroup::targetGroupName)).setter(setter(Builder::targetGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetGroupName").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TargetGroup::protocolAsString)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(TargetGroup::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TargetGroup::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<String> HEALTH_CHECK_PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TargetGroup::healthCheckProtocolAsString)).setter(setter(Builder::healthCheckProtocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckProtocol").build())
            .build();

    private static final SdkField<String> HEALTH_CHECK_PORT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TargetGroup::healthCheckPort)).setter(setter(Builder::healthCheckPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckPort").build()).build();

    private static final SdkField<Boolean> HEALTH_CHECK_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(TargetGroup::healthCheckEnabled)).setter(setter(Builder::healthCheckEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckEnabled").build())
            .build();

    private static final SdkField<Integer> HEALTH_CHECK_INTERVAL_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(TargetGroup::healthCheckIntervalSeconds))
            .setter(setter(Builder::healthCheckIntervalSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckIntervalSeconds").build())
            .build();

    private static final SdkField<Integer> HEALTH_CHECK_TIMEOUT_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).getter(getter(TargetGroup::healthCheckTimeoutSeconds))
            .setter(setter(Builder::healthCheckTimeoutSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckTimeoutSeconds").build())
            .build();

    private static final SdkField<Integer> HEALTHY_THRESHOLD_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(TargetGroup::healthyThresholdCount)).setter(setter(Builder::healthyThresholdCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthyThresholdCount").build())
            .build();

    private static final SdkField<Integer> UNHEALTHY_THRESHOLD_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(TargetGroup::unhealthyThresholdCount)).setter(setter(Builder::unhealthyThresholdCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnhealthyThresholdCount").build())
            .build();

    private static final SdkField<String> HEALTH_CHECK_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TargetGroup::healthCheckPath)).setter(setter(Builder::healthCheckPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckPath").build()).build();

    private static final SdkField<Matcher> MATCHER_FIELD = SdkField.<Matcher> builder(MarshallingType.SDK_POJO)
            .getter(getter(TargetGroup::matcher)).setter(setter(Builder::matcher)).constructor(Matcher::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Matcher").build()).build();

    private static final SdkField<List<String>> LOAD_BALANCER_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(TargetGroup::loadBalancerArns))
            .setter(setter(Builder::loadBalancerArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TargetGroup::targetTypeAsString)).setter(setter(Builder::targetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_GROUP_ARN_FIELD,
            TARGET_GROUP_NAME_FIELD, PROTOCOL_FIELD, PORT_FIELD, VPC_ID_FIELD, HEALTH_CHECK_PROTOCOL_FIELD,
            HEALTH_CHECK_PORT_FIELD, HEALTH_CHECK_ENABLED_FIELD, HEALTH_CHECK_INTERVAL_SECONDS_FIELD,
            HEALTH_CHECK_TIMEOUT_SECONDS_FIELD, HEALTHY_THRESHOLD_COUNT_FIELD, UNHEALTHY_THRESHOLD_COUNT_FIELD,
            HEALTH_CHECK_PATH_FIELD, MATCHER_FIELD, LOAD_BALANCER_ARNS_FIELD, TARGET_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String targetGroupArn;

    private final String targetGroupName;

    private final String protocol;

    private final Integer port;

    private final String vpcId;

    private final String healthCheckProtocol;

    private final String healthCheckPort;

    private final Boolean healthCheckEnabled;

    private final Integer healthCheckIntervalSeconds;

    private final Integer healthCheckTimeoutSeconds;

    private final Integer healthyThresholdCount;

    private final Integer unhealthyThresholdCount;

    private final String healthCheckPath;

    private final Matcher matcher;

    private final List<String> loadBalancerArns;

    private final String targetType;

    private TargetGroup(BuilderImpl builder) {
        this.targetGroupArn = builder.targetGroupArn;
        this.targetGroupName = builder.targetGroupName;
        this.protocol = builder.protocol;
        this.port = builder.port;
        this.vpcId = builder.vpcId;
        this.healthCheckProtocol = builder.healthCheckProtocol;
        this.healthCheckPort = builder.healthCheckPort;
        this.healthCheckEnabled = builder.healthCheckEnabled;
        this.healthCheckIntervalSeconds = builder.healthCheckIntervalSeconds;
        this.healthCheckTimeoutSeconds = builder.healthCheckTimeoutSeconds;
        this.healthyThresholdCount = builder.healthyThresholdCount;
        this.unhealthyThresholdCount = builder.unhealthyThresholdCount;
        this.healthCheckPath = builder.healthCheckPath;
        this.matcher = builder.matcher;
        this.loadBalancerArns = builder.loadBalancerArns;
        this.targetType = builder.targetType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the target group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the target group.
     */
    public String targetGroupArn() {
        return targetGroupArn;
    }

    /**
     * <p>
     * The name of the target group.
     * </p>
     * 
     * @return The name of the target group.
     */
    public String targetGroupName() {
        return targetGroupName;
    }

    /**
     * <p>
     * The protocol to use for routing traffic to the targets.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link ProtocolEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol to use for routing traffic to the targets.
     * @see ProtocolEnum
     */
    public ProtocolEnum protocol() {
        return ProtocolEnum.fromValue(protocol);
    }

    /**
     * <p>
     * The protocol to use for routing traffic to the targets.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link ProtocolEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol to use for routing traffic to the targets.
     * @see ProtocolEnum
     */
    public String protocolAsString() {
        return protocol;
    }

    /**
     * <p>
     * The port on which the targets are listening.
     * </p>
     * 
     * @return The port on which the targets are listening.
     */
    public Integer port() {
        return port;
    }

    /**
     * <p>
     * The ID of the VPC for the targets.
     * </p>
     * 
     * @return The ID of the VPC for the targets.
     */
    public String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * The protocol to use to connect with the target.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #healthCheckProtocol} will return {@link ProtocolEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #healthCheckProtocolAsString}.
     * </p>
     * 
     * @return The protocol to use to connect with the target.
     * @see ProtocolEnum
     */
    public ProtocolEnum healthCheckProtocol() {
        return ProtocolEnum.fromValue(healthCheckProtocol);
    }

    /**
     * <p>
     * The protocol to use to connect with the target.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #healthCheckProtocol} will return {@link ProtocolEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #healthCheckProtocolAsString}.
     * </p>
     * 
     * @return The protocol to use to connect with the target.
     * @see ProtocolEnum
     */
    public String healthCheckProtocolAsString() {
        return healthCheckProtocol;
    }

    /**
     * <p>
     * The port to use to connect with the target.
     * </p>
     * 
     * @return The port to use to connect with the target.
     */
    public String healthCheckPort() {
        return healthCheckPort;
    }

    /**
     * <p>
     * Indicates whether health checks are enabled.
     * </p>
     * 
     * @return Indicates whether health checks are enabled.
     */
    public Boolean healthCheckEnabled() {
        return healthCheckEnabled;
    }

    /**
     * <p>
     * The approximate amount of time, in seconds, between health checks of an individual target.
     * </p>
     * 
     * @return The approximate amount of time, in seconds, between health checks of an individual target.
     */
    public Integer healthCheckIntervalSeconds() {
        return healthCheckIntervalSeconds;
    }

    /**
     * <p>
     * The amount of time, in seconds, during which no response means a failed health check.
     * </p>
     * 
     * @return The amount of time, in seconds, during which no response means a failed health check.
     */
    public Integer healthCheckTimeoutSeconds() {
        return healthCheckTimeoutSeconds;
    }

    /**
     * <p>
     * The number of consecutive health checks successes required before considering an unhealthy target healthy.
     * </p>
     * 
     * @return The number of consecutive health checks successes required before considering an unhealthy target
     *         healthy.
     */
    public Integer healthyThresholdCount() {
        return healthyThresholdCount;
    }

    /**
     * <p>
     * The number of consecutive health check failures required before considering the target unhealthy.
     * </p>
     * 
     * @return The number of consecutive health check failures required before considering the target unhealthy.
     */
    public Integer unhealthyThresholdCount() {
        return unhealthyThresholdCount;
    }

    /**
     * <p>
     * The destination for the health check request.
     * </p>
     * 
     * @return The destination for the health check request.
     */
    public String healthCheckPath() {
        return healthCheckPath;
    }

    /**
     * <p>
     * The HTTP codes to use when checking for a successful response from a target.
     * </p>
     * 
     * @return The HTTP codes to use when checking for a successful response from a target.
     */
    public Matcher matcher() {
        return matcher;
    }

    /**
     * <p>
     * The Amazon Resource Names (ARN) of the load balancers that route traffic to this target group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The Amazon Resource Names (ARN) of the load balancers that route traffic to this target group.
     */
    public List<String> loadBalancerArns() {
        return loadBalancerArns;
    }

    /**
     * <p>
     * The type of target that you must specify when registering targets with this target group. The possible values are
     * <code>instance</code> (targets are specified by instance ID) or <code>ip</code> (targets are specified by IP
     * address).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetType} will
     * return {@link TargetTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetTypeAsString}.
     * </p>
     * 
     * @return The type of target that you must specify when registering targets with this target group. The possible
     *         values are <code>instance</code> (targets are specified by instance ID) or <code>ip</code> (targets are
     *         specified by IP address).
     * @see TargetTypeEnum
     */
    public TargetTypeEnum targetType() {
        return TargetTypeEnum.fromValue(targetType);
    }

    /**
     * <p>
     * The type of target that you must specify when registering targets with this target group. The possible values are
     * <code>instance</code> (targets are specified by instance ID) or <code>ip</code> (targets are specified by IP
     * address).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetType} will
     * return {@link TargetTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetTypeAsString}.
     * </p>
     * 
     * @return The type of target that you must specify when registering targets with this target group. The possible
     *         values are <code>instance</code> (targets are specified by instance ID) or <code>ip</code> (targets are
     *         specified by IP address).
     * @see TargetTypeEnum
     */
    public String targetTypeAsString() {
        return targetType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(targetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckProtocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckPort());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckIntervalSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckTimeoutSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(healthyThresholdCount());
        hashCode = 31 * hashCode + Objects.hashCode(unhealthyThresholdCount());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckPath());
        hashCode = 31 * hashCode + Objects.hashCode(matcher());
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerArns());
        hashCode = 31 * hashCode + Objects.hashCode(targetTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetGroup)) {
            return false;
        }
        TargetGroup other = (TargetGroup) obj;
        return Objects.equals(targetGroupArn(), other.targetGroupArn())
                && Objects.equals(targetGroupName(), other.targetGroupName())
                && Objects.equals(protocolAsString(), other.protocolAsString()) && Objects.equals(port(), other.port())
                && Objects.equals(vpcId(), other.vpcId())
                && Objects.equals(healthCheckProtocolAsString(), other.healthCheckProtocolAsString())
                && Objects.equals(healthCheckPort(), other.healthCheckPort())
                && Objects.equals(healthCheckEnabled(), other.healthCheckEnabled())
                && Objects.equals(healthCheckIntervalSeconds(), other.healthCheckIntervalSeconds())
                && Objects.equals(healthCheckTimeoutSeconds(), other.healthCheckTimeoutSeconds())
                && Objects.equals(healthyThresholdCount(), other.healthyThresholdCount())
                && Objects.equals(unhealthyThresholdCount(), other.unhealthyThresholdCount())
                && Objects.equals(healthCheckPath(), other.healthCheckPath()) && Objects.equals(matcher(), other.matcher())
                && Objects.equals(loadBalancerArns(), other.loadBalancerArns())
                && Objects.equals(targetTypeAsString(), other.targetTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TargetGroup").add("TargetGroupArn", targetGroupArn()).add("TargetGroupName", targetGroupName())
                .add("Protocol", protocolAsString()).add("Port", port()).add("VpcId", vpcId())
                .add("HealthCheckProtocol", healthCheckProtocolAsString()).add("HealthCheckPort", healthCheckPort())
                .add("HealthCheckEnabled", healthCheckEnabled()).add("HealthCheckIntervalSeconds", healthCheckIntervalSeconds())
                .add("HealthCheckTimeoutSeconds", healthCheckTimeoutSeconds())
                .add("HealthyThresholdCount", healthyThresholdCount()).add("UnhealthyThresholdCount", unhealthyThresholdCount())
                .add("HealthCheckPath", healthCheckPath()).add("Matcher", matcher()).add("LoadBalancerArns", loadBalancerArns())
                .add("TargetType", targetTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetGroupArn":
            return Optional.ofNullable(clazz.cast(targetGroupArn()));
        case "TargetGroupName":
            return Optional.ofNullable(clazz.cast(targetGroupName()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "HealthCheckProtocol":
            return Optional.ofNullable(clazz.cast(healthCheckProtocolAsString()));
        case "HealthCheckPort":
            return Optional.ofNullable(clazz.cast(healthCheckPort()));
        case "HealthCheckEnabled":
            return Optional.ofNullable(clazz.cast(healthCheckEnabled()));
        case "HealthCheckIntervalSeconds":
            return Optional.ofNullable(clazz.cast(healthCheckIntervalSeconds()));
        case "HealthCheckTimeoutSeconds":
            return Optional.ofNullable(clazz.cast(healthCheckTimeoutSeconds()));
        case "HealthyThresholdCount":
            return Optional.ofNullable(clazz.cast(healthyThresholdCount()));
        case "UnhealthyThresholdCount":
            return Optional.ofNullable(clazz.cast(unhealthyThresholdCount()));
        case "HealthCheckPath":
            return Optional.ofNullable(clazz.cast(healthCheckPath()));
        case "Matcher":
            return Optional.ofNullable(clazz.cast(matcher()));
        case "LoadBalancerArns":
            return Optional.ofNullable(clazz.cast(loadBalancerArns()));
        case "TargetType":
            return Optional.ofNullable(clazz.cast(targetTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TargetGroup, T> g) {
        return obj -> g.apply((TargetGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TargetGroup> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the target group.
         * </p>
         * 
         * @param targetGroupArn
         *        The Amazon Resource Name (ARN) of the target group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetGroupArn(String targetGroupArn);

        /**
         * <p>
         * The name of the target group.
         * </p>
         * 
         * @param targetGroupName
         *        The name of the target group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetGroupName(String targetGroupName);

        /**
         * <p>
         * The protocol to use for routing traffic to the targets.
         * </p>
         * 
         * @param protocol
         *        The protocol to use for routing traffic to the targets.
         * @see ProtocolEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtocolEnum
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The protocol to use for routing traffic to the targets.
         * </p>
         * 
         * @param protocol
         *        The protocol to use for routing traffic to the targets.
         * @see ProtocolEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtocolEnum
         */
        Builder protocol(ProtocolEnum protocol);

        /**
         * <p>
         * The port on which the targets are listening.
         * </p>
         * 
         * @param port
         *        The port on which the targets are listening.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The ID of the VPC for the targets.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC for the targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The protocol to use to connect with the target.
         * </p>
         * 
         * @param healthCheckProtocol
         *        The protocol to use to connect with the target.
         * @see ProtocolEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtocolEnum
         */
        Builder healthCheckProtocol(String healthCheckProtocol);

        /**
         * <p>
         * The protocol to use to connect with the target.
         * </p>
         * 
         * @param healthCheckProtocol
         *        The protocol to use to connect with the target.
         * @see ProtocolEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtocolEnum
         */
        Builder healthCheckProtocol(ProtocolEnum healthCheckProtocol);

        /**
         * <p>
         * The port to use to connect with the target.
         * </p>
         * 
         * @param healthCheckPort
         *        The port to use to connect with the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckPort(String healthCheckPort);

        /**
         * <p>
         * Indicates whether health checks are enabled.
         * </p>
         * 
         * @param healthCheckEnabled
         *        Indicates whether health checks are enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckEnabled(Boolean healthCheckEnabled);

        /**
         * <p>
         * The approximate amount of time, in seconds, between health checks of an individual target.
         * </p>
         * 
         * @param healthCheckIntervalSeconds
         *        The approximate amount of time, in seconds, between health checks of an individual target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckIntervalSeconds(Integer healthCheckIntervalSeconds);

        /**
         * <p>
         * The amount of time, in seconds, during which no response means a failed health check.
         * </p>
         * 
         * @param healthCheckTimeoutSeconds
         *        The amount of time, in seconds, during which no response means a failed health check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckTimeoutSeconds(Integer healthCheckTimeoutSeconds);

        /**
         * <p>
         * The number of consecutive health checks successes required before considering an unhealthy target healthy.
         * </p>
         * 
         * @param healthyThresholdCount
         *        The number of consecutive health checks successes required before considering an unhealthy target
         *        healthy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthyThresholdCount(Integer healthyThresholdCount);

        /**
         * <p>
         * The number of consecutive health check failures required before considering the target unhealthy.
         * </p>
         * 
         * @param unhealthyThresholdCount
         *        The number of consecutive health check failures required before considering the target unhealthy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unhealthyThresholdCount(Integer unhealthyThresholdCount);

        /**
         * <p>
         * The destination for the health check request.
         * </p>
         * 
         * @param healthCheckPath
         *        The destination for the health check request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckPath(String healthCheckPath);

        /**
         * <p>
         * The HTTP codes to use when checking for a successful response from a target.
         * </p>
         * 
         * @param matcher
         *        The HTTP codes to use when checking for a successful response from a target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matcher(Matcher matcher);

        /**
         * <p>
         * The HTTP codes to use when checking for a successful response from a target.
         * </p>
         * This is a convenience that creates an instance of the {@link Matcher.Builder} avoiding the need to create one
         * manually via {@link Matcher#builder()}.
         *
         * When the {@link Consumer} completes, {@link Matcher.Builder#build()} is called immediately and its result is
         * passed to {@link #matcher(Matcher)}.
         * 
         * @param matcher
         *        a consumer that will call methods on {@link Matcher.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #matcher(Matcher)
         */
        default Builder matcher(Consumer<Matcher.Builder> matcher) {
            return matcher(Matcher.builder().applyMutation(matcher).build());
        }

        /**
         * <p>
         * The Amazon Resource Names (ARN) of the load balancers that route traffic to this target group.
         * </p>
         * 
         * @param loadBalancerArns
         *        The Amazon Resource Names (ARN) of the load balancers that route traffic to this target group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerArns(Collection<String> loadBalancerArns);

        /**
         * <p>
         * The Amazon Resource Names (ARN) of the load balancers that route traffic to this target group.
         * </p>
         * 
         * @param loadBalancerArns
         *        The Amazon Resource Names (ARN) of the load balancers that route traffic to this target group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerArns(String... loadBalancerArns);

        /**
         * <p>
         * The type of target that you must specify when registering targets with this target group. The possible values
         * are <code>instance</code> (targets are specified by instance ID) or <code>ip</code> (targets are specified by
         * IP address).
         * </p>
         * 
         * @param targetType
         *        The type of target that you must specify when registering targets with this target group. The possible
         *        values are <code>instance</code> (targets are specified by instance ID) or <code>ip</code> (targets
         *        are specified by IP address).
         * @see TargetTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetTypeEnum
         */
        Builder targetType(String targetType);

        /**
         * <p>
         * The type of target that you must specify when registering targets with this target group. The possible values
         * are <code>instance</code> (targets are specified by instance ID) or <code>ip</code> (targets are specified by
         * IP address).
         * </p>
         * 
         * @param targetType
         *        The type of target that you must specify when registering targets with this target group. The possible
         *        values are <code>instance</code> (targets are specified by instance ID) or <code>ip</code> (targets
         *        are specified by IP address).
         * @see TargetTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetTypeEnum
         */
        Builder targetType(TargetTypeEnum targetType);
    }

    static final class BuilderImpl implements Builder {
        private String targetGroupArn;

        private String targetGroupName;

        private String protocol;

        private Integer port;

        private String vpcId;

        private String healthCheckProtocol;

        private String healthCheckPort;

        private Boolean healthCheckEnabled;

        private Integer healthCheckIntervalSeconds;

        private Integer healthCheckTimeoutSeconds;

        private Integer healthyThresholdCount;

        private Integer unhealthyThresholdCount;

        private String healthCheckPath;

        private Matcher matcher;

        private List<String> loadBalancerArns = DefaultSdkAutoConstructList.getInstance();

        private String targetType;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetGroup model) {
            targetGroupArn(model.targetGroupArn);
            targetGroupName(model.targetGroupName);
            protocol(model.protocol);
            port(model.port);
            vpcId(model.vpcId);
            healthCheckProtocol(model.healthCheckProtocol);
            healthCheckPort(model.healthCheckPort);
            healthCheckEnabled(model.healthCheckEnabled);
            healthCheckIntervalSeconds(model.healthCheckIntervalSeconds);
            healthCheckTimeoutSeconds(model.healthCheckTimeoutSeconds);
            healthyThresholdCount(model.healthyThresholdCount);
            unhealthyThresholdCount(model.unhealthyThresholdCount);
            healthCheckPath(model.healthCheckPath);
            matcher(model.matcher);
            loadBalancerArns(model.loadBalancerArns);
            targetType(model.targetType);
        }

        public final String getTargetGroupArn() {
            return targetGroupArn;
        }

        @Override
        public final Builder targetGroupArn(String targetGroupArn) {
            this.targetGroupArn = targetGroupArn;
            return this;
        }

        public final void setTargetGroupArn(String targetGroupArn) {
            this.targetGroupArn = targetGroupArn;
        }

        public final String getTargetGroupName() {
            return targetGroupName;
        }

        @Override
        public final Builder targetGroupName(String targetGroupName) {
            this.targetGroupName = targetGroupName;
            return this;
        }

        public final void setTargetGroupName(String targetGroupName) {
            this.targetGroupName = targetGroupName;
        }

        public final String getProtocolAsString() {
            return protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(ProtocolEnum protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final Integer getPort() {
            return port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getHealthCheckProtocolAsString() {
            return healthCheckProtocol;
        }

        @Override
        public final Builder healthCheckProtocol(String healthCheckProtocol) {
            this.healthCheckProtocol = healthCheckProtocol;
            return this;
        }

        @Override
        public final Builder healthCheckProtocol(ProtocolEnum healthCheckProtocol) {
            this.healthCheckProtocol(healthCheckProtocol == null ? null : healthCheckProtocol.toString());
            return this;
        }

        public final void setHealthCheckProtocol(String healthCheckProtocol) {
            this.healthCheckProtocol = healthCheckProtocol;
        }

        public final String getHealthCheckPort() {
            return healthCheckPort;
        }

        @Override
        public final Builder healthCheckPort(String healthCheckPort) {
            this.healthCheckPort = healthCheckPort;
            return this;
        }

        public final void setHealthCheckPort(String healthCheckPort) {
            this.healthCheckPort = healthCheckPort;
        }

        public final Boolean getHealthCheckEnabled() {
            return healthCheckEnabled;
        }

        @Override
        public final Builder healthCheckEnabled(Boolean healthCheckEnabled) {
            this.healthCheckEnabled = healthCheckEnabled;
            return this;
        }

        public final void setHealthCheckEnabled(Boolean healthCheckEnabled) {
            this.healthCheckEnabled = healthCheckEnabled;
        }

        public final Integer getHealthCheckIntervalSeconds() {
            return healthCheckIntervalSeconds;
        }

        @Override
        public final Builder healthCheckIntervalSeconds(Integer healthCheckIntervalSeconds) {
            this.healthCheckIntervalSeconds = healthCheckIntervalSeconds;
            return this;
        }

        public final void setHealthCheckIntervalSeconds(Integer healthCheckIntervalSeconds) {
            this.healthCheckIntervalSeconds = healthCheckIntervalSeconds;
        }

        public final Integer getHealthCheckTimeoutSeconds() {
            return healthCheckTimeoutSeconds;
        }

        @Override
        public final Builder healthCheckTimeoutSeconds(Integer healthCheckTimeoutSeconds) {
            this.healthCheckTimeoutSeconds = healthCheckTimeoutSeconds;
            return this;
        }

        public final void setHealthCheckTimeoutSeconds(Integer healthCheckTimeoutSeconds) {
            this.healthCheckTimeoutSeconds = healthCheckTimeoutSeconds;
        }

        public final Integer getHealthyThresholdCount() {
            return healthyThresholdCount;
        }

        @Override
        public final Builder healthyThresholdCount(Integer healthyThresholdCount) {
            this.healthyThresholdCount = healthyThresholdCount;
            return this;
        }

        public final void setHealthyThresholdCount(Integer healthyThresholdCount) {
            this.healthyThresholdCount = healthyThresholdCount;
        }

        public final Integer getUnhealthyThresholdCount() {
            return unhealthyThresholdCount;
        }

        @Override
        public final Builder unhealthyThresholdCount(Integer unhealthyThresholdCount) {
            this.unhealthyThresholdCount = unhealthyThresholdCount;
            return this;
        }

        public final void setUnhealthyThresholdCount(Integer unhealthyThresholdCount) {
            this.unhealthyThresholdCount = unhealthyThresholdCount;
        }

        public final String getHealthCheckPath() {
            return healthCheckPath;
        }

        @Override
        public final Builder healthCheckPath(String healthCheckPath) {
            this.healthCheckPath = healthCheckPath;
            return this;
        }

        public final void setHealthCheckPath(String healthCheckPath) {
            this.healthCheckPath = healthCheckPath;
        }

        public final Matcher.Builder getMatcher() {
            return matcher != null ? matcher.toBuilder() : null;
        }

        @Override
        public final Builder matcher(Matcher matcher) {
            this.matcher = matcher;
            return this;
        }

        public final void setMatcher(Matcher.BuilderImpl matcher) {
            this.matcher = matcher != null ? matcher.build() : null;
        }

        public final Collection<String> getLoadBalancerArns() {
            return loadBalancerArns;
        }

        @Override
        public final Builder loadBalancerArns(Collection<String> loadBalancerArns) {
            this.loadBalancerArns = LoadBalancerArnsCopier.copy(loadBalancerArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerArns(String... loadBalancerArns) {
            loadBalancerArns(Arrays.asList(loadBalancerArns));
            return this;
        }

        public final void setLoadBalancerArns(Collection<String> loadBalancerArns) {
            this.loadBalancerArns = LoadBalancerArnsCopier.copy(loadBalancerArns);
        }

        public final String getTargetTypeAsString() {
            return targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        @Override
        public final Builder targetType(TargetTypeEnum targetType) {
            this.targetType(targetType == null ? null : targetType.toString());
            return this;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        @Override
        public TargetGroup build() {
            return new TargetGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
