/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLoadBalancerResponse extends ElasticLoadBalancingV2Response implements
        ToCopyableBuilder<CreateLoadBalancerResponse.Builder, CreateLoadBalancerResponse> {
    private static final SdkField<List<LoadBalancer>> LOAD_BALANCERS_FIELD = SdkField
            .<List<LoadBalancer>> builder(MarshallingType.LIST)
            .getter(getter(CreateLoadBalancerResponse::loadBalancers))
            .setter(setter(Builder::loadBalancers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LoadBalancer> builder(MarshallingType.SDK_POJO)
                                            .constructor(LoadBalancer::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_BALANCERS_FIELD));

    private final List<LoadBalancer> loadBalancers;

    private CreateLoadBalancerResponse(BuilderImpl builder) {
        super(builder);
        this.loadBalancers = builder.loadBalancers;
    }

    /**
     * <p>
     * Information about the load balancer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the load balancer.
     */
    public List<LoadBalancer> loadBalancers() {
        return loadBalancers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancers());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLoadBalancerResponse)) {
            return false;
        }
        CreateLoadBalancerResponse other = (CreateLoadBalancerResponse) obj;
        return Objects.equals(loadBalancers(), other.loadBalancers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateLoadBalancerResponse").add("LoadBalancers", loadBalancers()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LoadBalancers":
            return Optional.ofNullable(clazz.cast(loadBalancers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLoadBalancerResponse, T> g) {
        return obj -> g.apply((CreateLoadBalancerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticLoadBalancingV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateLoadBalancerResponse> {
        /**
         * <p>
         * Information about the load balancer.
         * </p>
         * 
         * @param loadBalancers
         *        Information about the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancers(Collection<LoadBalancer> loadBalancers);

        /**
         * <p>
         * Information about the load balancer.
         * </p>
         * 
         * @param loadBalancers
         *        Information about the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancers(LoadBalancer... loadBalancers);

        /**
         * <p>
         * Information about the load balancer.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LoadBalancer>.Builder} avoiding the need to
         * create one manually via {@link List<LoadBalancer>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LoadBalancer>.Builder#build()} is called immediately and its
         * result is passed to {@link #loadBalancers(List<LoadBalancer>)}.
         * 
         * @param loadBalancers
         *        a consumer that will call methods on {@link List<LoadBalancer>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loadBalancers(List<LoadBalancer>)
         */
        Builder loadBalancers(Consumer<LoadBalancer.Builder>... loadBalancers);
    }

    static final class BuilderImpl extends ElasticLoadBalancingV2Response.BuilderImpl implements Builder {
        private List<LoadBalancer> loadBalancers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLoadBalancerResponse model) {
            super(model);
            loadBalancers(model.loadBalancers);
        }

        public final Collection<LoadBalancer.Builder> getLoadBalancers() {
            return loadBalancers != null ? loadBalancers.stream().map(LoadBalancer::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder loadBalancers(Collection<LoadBalancer> loadBalancers) {
            this.loadBalancers = LoadBalancersCopier.copy(loadBalancers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancers(LoadBalancer... loadBalancers) {
            loadBalancers(Arrays.asList(loadBalancers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancers(Consumer<LoadBalancer.Builder>... loadBalancers) {
            loadBalancers(Stream.of(loadBalancers).map(c -> LoadBalancer.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setLoadBalancers(Collection<LoadBalancer.BuilderImpl> loadBalancers) {
            this.loadBalancers = LoadBalancersCopier.copyFromBuilder(loadBalancers);
        }

        @Override
        public CreateLoadBalancerResponse build() {
            return new CreateLoadBalancerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
